/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;
import org.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlBatchHandler
extends CustomizingStatementHandler<PreparedBatch> {
    private final SqlBatch sqlBatch;
    private final ChunkSizeFunction batchChunkSize;
    private final Function<PreparedBatch, ResultIterator<?>> batchIntermediate;
    private final ResultReturner magic;

    public SqlBatchHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        if (method.isAnnotationPresent(UseRowReducer.class)) {
            throw new UnsupportedOperationException("Cannot declare @UseRowReducer on a @SqlUpdate method.");
        }
        this.sqlBatch = method.getAnnotation(SqlBatch.class);
        this.batchChunkSize = this.determineBatchChunkSize(sqlObjectType, method);
        GetGeneratedKeys getGeneratedKeys = method.getAnnotation(GetGeneratedKeys.class);
        if (getGeneratedKeys == null) {
            if (!SqlBatchHandler.returnTypeIsValid(method.getReturnType())) {
                throw new UnableToCreateSqlObjectException(SqlBatchHandler.invalidReturnTypeMessage(method));
            }
            Function<PreparedBatch, ResultIterator<?>> modCounts = PreparedBatch::executeAndGetModCount;
            this.batchIntermediate = method.getReturnType().equals(boolean[].class) ? this.mapToBoolean(modCounts) : modCounts;
            this.magic = ResultReturner.forOptionalReturn(sqlObjectType, method);
        } else {
            String[] columnNames = getGeneratedKeys.value();
            this.magic = ResultReturner.forMethod(sqlObjectType, method);
            if (method.isAnnotationPresent(UseRowMapper.class)) {
                RowMapper<?> mapper = SqlBatchHandler.rowMapperFor(method.getAnnotation(UseRowMapper.class));
                this.batchIntermediate = batch -> batch.executeAndReturnGeneratedKeys(columnNames).map(mapper).iterator();
            } else {
                this.batchIntermediate = batch -> batch.executeAndReturnGeneratedKeys(columnNames).mapTo(this.magic.elementType(batch.getConfig())).iterator();
            }
        }
    }

    @Override
    public void warm(ConfigRegistry config) {
        super.warm(config);
        this.magic.warm(config);
    }

    private Function<PreparedBatch, ResultIterator<?>> mapToBoolean(Function<PreparedBatch, ResultIterator<?>> modCounts) {
        return modCounts.andThen(iterator -> new ResultIterator<Boolean>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Boolean next() {
                return (Integer)iterator.next() > 0;
            }

            @Override
            public void close() {
                iterator.close();
            }

            @Override
            public StatementContext getContext() {
                return iterator.getContext();
            }
        });
    }

    private ChunkSizeFunction determineBatchChunkSize(Class<?> sqlObjectType, Method method) {
        int batchChunkSizeParameterIndex = this.indexOfBatchChunkSizeParameter(method);
        if (batchChunkSizeParameterIndex >= 0) {
            return new ParamBasedChunkSizeFunction(batchChunkSizeParameterIndex);
        }
        if (method.isAnnotationPresent(BatchChunkSize.class)) {
            int size = method.getAnnotation(BatchChunkSize.class).value();
            if (size <= 0) {
                throw new IllegalArgumentException("Batch chunk size must be >= 0");
            }
            return new ConstantChunkSizeFunction(size);
        }
        if (sqlObjectType.isAnnotationPresent(BatchChunkSize.class)) {
            int size = sqlObjectType.getAnnotation(BatchChunkSize.class).value();
            return new ConstantChunkSizeFunction(size);
        }
        return new ConstantChunkSizeFunction(Integer.MAX_VALUE);
    }

    private int indexOfBatchChunkSizeParameter(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        return IntStream.range(0, parameterAnnotations.length).filter(i -> Stream.of(parameterAnnotations[i]).anyMatch(BatchChunkSize.class::isInstance)).findFirst().orElse(-1);
    }

    @Override
    PreparedBatch createStatement(Handle handle, String locatedSql) {
        return handle.prepareBatch(locatedSql);
    }

    @Override
    void configureReturner(PreparedBatch stmt, SqlObjectStatementConfiguration cfg) {
    }

    @Override
    Type getParameterType(Parameter parameter) {
        Type type = super.getParameterType(parameter);
        if (!parameter.isAnnotationPresent(SingleValue.class)) {
            Class<?> erasedType = GenericTypes.getErasedType(type);
            if (Iterable.class.isAssignableFrom(erasedType)) {
                return GenericTypes.findGenericParameter(type, Iterable.class).get();
            }
            if (Iterator.class.isAssignableFrom(erasedType)) {
                return GenericTypes.findGenericParameter(type, Iterator.class).get();
            }
            if (GenericTypes.isArray(type)) {
                return ((Class)type).getComponentType();
            }
        }
        return type;
    }

    @Override
    public Object invoke(Object target, Object[] args, HandleSupplier h2) {
        ResultIterator<Object> result;
        final Handle handle = h2.getHandle();
        final String sql = this.locateSql(handle);
        final int chunkSize = this.batchChunkSize.call(args);
        final Iterator<Object[]> batchArgs = this.zipArgs(this.getMethod(), args);
        if (batchArgs.hasNext()) {
            final class BatchChunkIterator
            implements ResultIterator<Object> {
                private ResultIterator<?> batchResult = null;
                private boolean closed = false;

                BatchChunkIterator() {
                    if (batchArgs.hasNext()) {
                        this.batchResult = this.loadChunk();
                    }
                }

                private ResultIterator<?> loadChunk() {
                    ArrayList<Object[]> currArgs = new ArrayList<Object[]>();
                    for (int i = 0; i < chunkSize && batchArgs.hasNext(); ++i) {
                        currArgs.add((Object[])batchArgs.next());
                    }
                    Supplier<PreparedBatch> preparedBatchSupplier = () -> this.createPreparedBatch(handle, sql, currArgs);
                    return SqlBatchHandler.this.executeBatch(handle, preparedBatchSupplier);
                }

                private PreparedBatch createPreparedBatch(Handle handle2, String sql2, List<Object[]> currArgs) {
                    PreparedBatch batch = handle2.prepareBatch(sql2);
                    for (Object[] currArg : currArgs) {
                        SqlBatchHandler.this.applyCustomizers(batch, currArg);
                        batch.add();
                    }
                    return batch;
                }

                @Override
                public boolean hasNext() {
                    if (this.closed) {
                        throw new IllegalStateException("closed");
                    }
                    if (this.batchResult != null) {
                        if (this.batchResult.hasNext()) {
                            return true;
                        }
                        this.batchResult.close();
                    }
                    if (batchArgs.hasNext()) {
                        this.batchResult = this.loadChunk();
                        return this.hasNext();
                    }
                    return false;
                }

                @Override
                public Object next() {
                    if (this.closed) {
                        throw new IllegalStateException("closed");
                    }
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.batchResult.next();
                }

                @Override
                public StatementContext getContext() {
                    return this.batchResult.getContext();
                }

                @Override
                public void close() {
                    this.closed = true;
                    this.batchResult.close();
                }
            }
            result = new BatchChunkIterator();
        } else {
            final PreparedBatch dummy = handle.prepareBatch(sql);
            result = new ResultIterator<Object>(){

                @Override
                public void close() {
                }

                @Override
                public StatementContext getContext() {
                    return dummy.getContext();
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Object next() {
                    throw new NoSuchElementException();
                }
            };
        }
        ResultIterable<Object> iterable = ResultIterable.of(result);
        return this.magic.mappedResult(iterable, result.getContext());
    }

    private Iterator<Object[]> zipArgs(Method method, final Object[] args) {
        boolean foundIterator = false;
        final ArrayList<Iterator<Object>> extras = new ArrayList<Iterator<Object>>();
        for (int paramIdx = 0; paramIdx < method.getParameterCount(); ++paramIdx) {
            boolean singleValue = method.getParameters()[paramIdx].isAnnotationPresent(SingleValue.class);
            Object arg = args[paramIdx];
            if (!singleValue && IterableLike.isIterable(arg)) {
                extras.add(IterableLike.of(arg));
                foundIterator = true;
                continue;
            }
            extras.add(Stream.generate(() -> arg).iterator());
        }
        if (!foundIterator) {
            throw new UnableToCreateStatementException("@SqlBatch method has no Iterable or array parameters, did you mean @SqlQuery?", null, null);
        }
        return new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                for (Iterator extra : extras) {
                    if (extra.hasNext()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Object[] next() {
                Object[] argsArray = new Object[args.length];
                for (int i = 0; i < extras.size(); ++i) {
                    argsArray[i] = ((Iterator)extras.get(i)).next();
                }
                return argsArray;
            }
        };
    }

    private ResultIterator<?> executeBatch(Handle handle, Supplier<PreparedBatch> preparedBatchSupplier) {
        if (!handle.isInTransaction() && this.sqlBatch.transactional()) {
            return handle.inTransaction(c -> this.batchIntermediate.apply((PreparedBatch)preparedBatchSupplier.get()));
        }
        return this.batchIntermediate.apply(preparedBatchSupplier.get());
    }

    private static boolean returnTypeIsValid(Class<?> type) {
        if (type.equals(Void.TYPE)) {
            return true;
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return componentType.equals(Integer.TYPE) || componentType.equals(Boolean.TYPE);
        }
        return false;
    }

    private static String invalidReturnTypeMessage(Method method) {
        return method.getDeclaringClass() + "." + method.getName() + " method is annotated with @SqlBatch so should return void, int[], or boolean[] but is returning: " + method.getReturnType();
    }

    private static interface ChunkSizeFunction {
        public int call(Object[] var1);
    }

    private static class ParamBasedChunkSizeFunction
    implements ChunkSizeFunction {
        private final int index;

        ParamBasedChunkSizeFunction(int index) {
            this.index = index;
        }

        @Override
        public int call(Object[] args) {
            return (Integer)args[this.index];
        }
    }

    private static class ConstantChunkSizeFunction
    implements ChunkSizeFunction {
        private final int value;

        ConstantChunkSizeFunction(int value) {
            this.value = value;
        }

        @Override
        public int call(Object[] args) {
            return this.value;
        }
    }
}

