/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.AsValue;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.internal.InternalPoint2D;
import org.neo4j.driver.internal.InternalPoint3D;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.BytesValue;
import org.neo4j.driver.internal.value.DateTimeValue;
import org.neo4j.driver.internal.value.DateValue;
import org.neo4j.driver.internal.value.DurationValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.LocalDateTimeValue;
import org.neo4j.driver.internal.value.LocalTimeValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.internal.value.PointValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.internal.value.TimeValue;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;

public abstract class Values {
    public static final Value EmptyMap = Values.value(Collections.emptyMap());
    public static final Value NULL = NullValue.NULL;

    private Values() {
        throw new UnsupportedOperationException();
    }

    public static Value value(Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        if (value instanceof AsValue) {
            return ((AsValue)value).asValue();
        }
        if (value instanceof Boolean) {
            return Values.value((boolean)((Boolean)value));
        }
        if (value instanceof String) {
            return Values.value((String)value);
        }
        if (value instanceof Character) {
            return Values.value(((Character)value).charValue());
        }
        if (value instanceof Long) {
            return Values.value((long)((Long)value));
        }
        if (value instanceof Short) {
            return Values.value((int)((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return Values.value((int)((Byte)value).byteValue());
        }
        if (value instanceof Integer) {
            return Values.value((int)((Integer)value));
        }
        if (value instanceof Double) {
            return Values.value((double)((Double)value));
        }
        if (value instanceof Float) {
            return Values.value((double)((Float)value).floatValue());
        }
        if (value instanceof LocalDate) {
            return Values.value((LocalDate)value);
        }
        if (value instanceof OffsetTime) {
            return Values.value((OffsetTime)value);
        }
        if (value instanceof LocalTime) {
            return Values.value((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return Values.value((LocalDateTime)value);
        }
        if (value instanceof OffsetDateTime) {
            return Values.value((OffsetDateTime)value);
        }
        if (value instanceof ZonedDateTime) {
            return Values.value((ZonedDateTime)value);
        }
        if (value instanceof IsoDuration) {
            return Values.value((IsoDuration)value);
        }
        if (value instanceof Period) {
            return Values.value((Period)value);
        }
        if (value instanceof Duration) {
            return Values.value((Duration)value);
        }
        if (value instanceof Point) {
            return Values.value((Point)value);
        }
        if (value instanceof List) {
            return Values.value((List)value);
        }
        if (value instanceof Map) {
            return Values.value((Map)value);
        }
        if (value instanceof Iterable) {
            return Values.value((Iterable)value);
        }
        if (value instanceof Iterator) {
            return Values.value((Iterator)value);
        }
        if (value instanceof Stream) {
            return Values.value((Stream)value);
        }
        if (value instanceof char[]) {
            return Values.value((char[])value);
        }
        if (value instanceof byte[]) {
            return Values.value((byte[])value);
        }
        if (value instanceof boolean[]) {
            return Values.value((boolean[])value);
        }
        if (value instanceof String[]) {
            return Values.value((String[])value);
        }
        if (value instanceof long[]) {
            return Values.value((long[])value);
        }
        if (value instanceof int[]) {
            return Values.value((int[])value);
        }
        if (value instanceof short[]) {
            return Values.value((short[])value);
        }
        if (value instanceof double[]) {
            return Values.value((double[])value);
        }
        if (value instanceof float[]) {
            return Values.value((float[])value);
        }
        if (value instanceof Value[]) {
            return Values.value((Value[])value);
        }
        if (value instanceof Object[]) {
            return Values.value(Arrays.asList((Object[])value));
        }
        throw new ClientException("Unable to convert " + value.getClass().getName() + " to Neo4j Value.");
    }

    public static Value[] values(Object ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return values;
    }

    public static Value value(Value ... input) {
        int size = input.length;
        Value[] values = new Value[size];
        System.arraycopy(input, 0, values, 0, size);
        return new ListValue(values);
    }

    public static BytesValue value(byte ... input) {
        return new BytesValue(input);
    }

    public static Value value(String ... input) {
        Value[] values = new StringValue[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = new StringValue(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(boolean ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(char ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(long ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(short ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value((int)input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(int ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(double ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(float ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value((double)input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(List<Object> vals) {
        Value[] values = new Value[vals.size()];
        int i = 0;
        for (Object val2 : vals) {
            values[i++] = Values.value(val2);
        }
        return new ListValue(values);
    }

    public static Value value(Iterable<Object> val2) {
        return Values.value(val2.iterator());
    }

    public static Value value(Iterator<Object> val2) {
        ArrayList<Value> values = new ArrayList<Value>();
        while (val2.hasNext()) {
            values.add(Values.value(val2.next()));
        }
        return new ListValue(values.toArray(new Value[0]));
    }

    public static Value value(Stream<Object> stream) {
        Value[] values = (Value[])stream.map(Values::value).toArray(Value[]::new);
        return new ListValue(values);
    }

    public static Value value(char val2) {
        return new StringValue(String.valueOf(val2));
    }

    public static Value value(String val2) {
        return new StringValue(val2);
    }

    public static Value value(long val2) {
        return new IntegerValue(val2);
    }

    public static Value value(int val2) {
        return new IntegerValue(val2);
    }

    public static Value value(double val2) {
        return new FloatValue(val2);
    }

    public static Value value(boolean val2) {
        return BooleanValue.fromBoolean(val2);
    }

    public static Value value(Map<String, Object> val2) {
        HashMap<String, Value> asValues = Iterables.newHashMapWithSize(val2.size());
        for (Map.Entry<String, Object> entry : val2.entrySet()) {
            asValues.put(entry.getKey(), Values.value(entry.getValue()));
        }
        return new MapValue(asValues);
    }

    public static Value value(LocalDate localDate) {
        return new DateValue(localDate);
    }

    public static Value value(OffsetTime offsetTime) {
        return new TimeValue(offsetTime);
    }

    public static Value value(LocalTime localTime) {
        return new LocalTimeValue(localTime);
    }

    public static Value value(LocalDateTime localDateTime) {
        return new LocalDateTimeValue(localDateTime);
    }

    public static Value value(OffsetDateTime offsetDateTime) {
        return new DateTimeValue(offsetDateTime.toZonedDateTime());
    }

    public static Value value(ZonedDateTime zonedDateTime) {
        return new DateTimeValue(zonedDateTime);
    }

    public static Value value(Period period) {
        return Values.value(new InternalIsoDuration(period));
    }

    public static Value value(Duration duration) {
        return Values.value(new InternalIsoDuration(duration));
    }

    public static Value isoDuration(long months, long days, long seconds, int nanoseconds) {
        return Values.value(new InternalIsoDuration(months, days, seconds, nanoseconds));
    }

    private static Value value(IsoDuration duration) {
        return new DurationValue(duration);
    }

    public static Value point(int srid, double x, double y) {
        return Values.value(new InternalPoint2D(srid, x, y));
    }

    private static Value value(Point point) {
        return new PointValue(point);
    }

    public static Value point(int srid, double x, double y, double z) {
        return Values.value(new InternalPoint3D(srid, x, y, z));
    }

    public static Value parameters(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new ClientException("Parameters function requires an even number of arguments, alternating key and value. Arguments were: " + Arrays.toString(keysAndValues) + ".");
        }
        HashMap<String, Value> map = Iterables.newHashMapWithSize(keysAndValues.length / 2);
        for (int i = 0; i < keysAndValues.length; i += 2) {
            Object value = keysAndValues[i + 1];
            Extract.assertParameter(value);
            map.put(keysAndValues[i].toString(), Values.value(value));
        }
        return Values.value(map);
    }

    public static Function<Value, Value> ofValue() {
        return val2 -> val2;
    }

    public static Function<Value, Object> ofObject() {
        return Value::asObject;
    }

    public static Function<Value, Number> ofNumber() {
        return Value::asNumber;
    }

    public static Function<Value, String> ofString() {
        return Value::asString;
    }

    public static Function<Value, String> ofToString() {
        return Value::toString;
    }

    public static Function<Value, Integer> ofInteger() {
        return Value::asInt;
    }

    public static Function<Value, Long> ofLong() {
        return Value::asLong;
    }

    public static Function<Value, Float> ofFloat() {
        return Value::asFloat;
    }

    public static Function<Value, Double> ofDouble() {
        return Value::asDouble;
    }

    public static Function<Value, Boolean> ofBoolean() {
        return Value::asBoolean;
    }

    public static Function<Value, Map<String, Object>> ofMap() {
        return MapAccessor::asMap;
    }

    public static <T> Function<Value, Map<String, T>> ofMap(Function<Value, T> valueConverter) {
        return val2 -> val2.asMap(valueConverter);
    }

    public static Function<Value, Entity> ofEntity() {
        return Value::asEntity;
    }

    public static Function<Value, Long> ofEntityId() {
        return val2 -> val2.asEntity().id();
    }

    public static Function<Value, Node> ofNode() {
        return Value::asNode;
    }

    public static Function<Value, Relationship> ofRelationship() {
        return Value::asRelationship;
    }

    public static Function<Value, Path> ofPath() {
        return Value::asPath;
    }

    public static Function<Value, LocalDate> ofLocalDate() {
        return Value::asLocalDate;
    }

    public static Function<Value, OffsetTime> ofOffsetTime() {
        return Value::asOffsetTime;
    }

    public static Function<Value, LocalTime> ofLocalTime() {
        return Value::asLocalTime;
    }

    public static Function<Value, LocalDateTime> ofLocalDateTime() {
        return Value::asLocalDateTime;
    }

    public static Function<Value, OffsetDateTime> ofOffsetDateTime() {
        return Value::asOffsetDateTime;
    }

    public static Function<Value, ZonedDateTime> ofZonedDateTime() {
        return Value::asZonedDateTime;
    }

    public static Function<Value, IsoDuration> ofIsoDuration() {
        return Value::asIsoDuration;
    }

    public static Function<Value, Point> ofPoint() {
        return Value::asPoint;
    }

    public static Function<Value, List<Object>> ofList() {
        return Value::asList;
    }

    public static <T> Function<Value, List<T>> ofList(Function<Value, T> innerMap) {
        return value -> value.asList(innerMap);
    }
}

