/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.MonoFromFluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class MonoReduceSeed<T, R>
extends MonoFromFluxOperator<T, R>
implements Fuseable {
    final Supplier<R> initialSupplier;
    final BiFunction<R, ? super T, R> accumulator;

    MonoReduceSeed(Flux<? extends T> source, Supplier<R> initialSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.initialSupplier = Objects.requireNonNull(initialSupplier, "initialSupplier");
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        R initialValue = Objects.requireNonNull(this.initialSupplier.get(), "The initial value supplied is null");
        return new ReduceSeedSubscriber<T, R>(actual, this.accumulator, initialValue);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class ReduceSeedSubscriber<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final BiFunction<R, ? super T, R> accumulator;
        Subscription s;
        boolean done;

        ReduceSeedSubscriber(CoreSubscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
            super(actual);
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void setValue(R value) {
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            Object v = this.value;
            if (v != null) {
                R accumulated;
                try {
                    accumulated = Objects.requireNonNull(this.accumulator.apply(v, t2), "The accumulator returned a null value");
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this, e, t2, this.actual.currentContext()));
                    return;
                }
                if (STATE.get(this) == 4) {
                    this.discard(accumulated);
                    this.value = null;
                } else {
                    this.value = accumulated;
                }
            } else {
                Operators.onDiscard(t2, this.actual.currentContext());
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                Operators.onErrorDropped(t2, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.discard(this.value);
            this.value = null;
            this.actual.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.complete(this.value);
        }
    }
}

