/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public class LockUtil {
    public static void executeWithLock(Lock lock, Runnable runnable) {
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T executeWithLock(Lock lock, Supplier<T> supplier) {
        lock.lock();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> void executeWithLockAsync(Lock lock, Supplier<CompletionStage<T>> stageSupplier) {
        lock.lock();
        ((CompletableFuture)CompletableFuture.completedFuture(lock).thenCompose(ignored -> (CompletionStage)stageSupplier.get())).whenComplete((ignored, throwable) -> lock.unlock());
    }
}

