/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.Arrays;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ValueAdapter;
import org.neo4j.driver.types.Type;

public class BytesValue
extends ValueAdapter {
    private final byte[] val;

    public BytesValue(byte[] val2) {
        if (val2 == null) {
            throw new IllegalArgumentException("Cannot construct BytesValue from null");
        }
        this.val = val2;
    }

    @Override
    public boolean isEmpty() {
        return this.val.length == 0;
    }

    @Override
    public int size() {
        return this.val.length;
    }

    public byte[] asObject() {
        return this.val;
    }

    @Override
    public byte[] asByteArray() {
        return this.val;
    }

    @Override
    public Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.BYTES();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesValue values = (BytesValue)o;
        return Arrays.equals(this.val, values.val);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.val);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder("#");
        for (byte b : this.val) {
            if (b < 16) {
                s2.append('0');
            }
            s2.append(Integer.toHexString(b));
        }
        return s2.toString();
    }
}

