/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Date;
import java.util.Random;

public class RandomData {
    public static float[][] getRandomFloatArray(int rows, int cols, float min2, float max) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        float[][] data = new float[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextFloatFromTo(min2, max);
            }
        }
        return data;
    }

    public static float[][] getRandomFloatArray(int rows, int cols, float min2, float max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        float[][] data = new float[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextFloatFromTo(min2, max);
            }
        }
        return data;
    }

    public static double[][] getRandomDoubleArray(int rows, int cols, double min2, double max) {
        Uniform rnd = new Uniform(min2, max, (RandomEngine)new MersenneTwister(new Date()));
        double[][] data = new double[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextDoubleFromTo(min2, max);
            }
        }
        return data;
    }

    public static double[][] getRandomDoubleArray(int rows, int cols, double min2, double max, int seed) {
        Uniform rnd = new Uniform(min2, max, (RandomEngine)new MersenneTwister(seed));
        double[][] data = new double[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextDoubleFromTo(min2, max);
            }
        }
        return data;
    }

    public static int[][] getRandomIntArray(int rows, int cols, int min2, int max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        int[][] data = new int[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextIntFromTo(min2, max);
            }
        }
        return data;
    }

    public static long[][] getRandomLongArray(int rows, int cols, long min2, long max) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        long[][] data = new long[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextLongFromTo(min2, max);
            }
        }
        return data;
    }

    public static long[][] getRandomLongArray(int rows, int cols, long min2, long max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        long[][] data = new long[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextLongFromTo(min2, max);
            }
        }
        return data;
    }

    public static short[][] getRandomShortArray(int rows, int cols, short min2, short max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        short[][] data = new short[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = (short)rnd.nextIntFromTo((int)min2, (int)max);
            }
        }
        return data;
    }

    public static byte[][] getRandomByteArray(int rows, int cols, byte min2, byte max) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        byte[][] data = new byte[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = (byte)rnd.nextIntFromTo((int)min2, (int)max);
            }
        }
        return data;
    }

    public static byte[][] getRandomByteArray(int rows, int cols, byte min2, byte max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        byte[][] data = new byte[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = (byte)rnd.nextIntFromTo((int)min2, (int)max);
            }
        }
        return data;
    }

    public static int[] getUniqueRandomIntsA(int N2, int min2, int max) {
        return RandomData.getUniqueRandomIntsA(N2, min2, max, new Random());
    }

    public static int[] getUniqueRandomIntsS(int N2, int min2, int max) {
        return RandomData.getUniqueRandomIntsS(N2, min2, max, new Random());
    }

    public static int[] getUniqueRandomInts(int N2, int min2, int max) {
        return RandomData.getUniqueRandomInts(N2, min2, max, new Random());
    }

    public static int[] getUniqueRandomIntsA(int N2, int min2, int max, Random rnd) {
        int rng = max - min2;
        if (rng < N2) {
            throw new IllegalArgumentException("Cannot generate more random numbers than the range allows");
        }
        TIntArrayList allData = new TIntArrayList(rng);
        for (int i = min2; i < max; ++i) {
            allData.add(i);
        }
        allData.shuffle(rnd);
        int[] data = new int[N2];
        allData.toArray(data, 0, N2);
        return data;
    }

    public static int[] getUniqueRandomIntsS(int N2, int min2, int max, Random rnd) {
        int rng = max - min2;
        if (rng < N2) {
            throw new IllegalArgumentException("Cannot generate more random numbers than the range allows");
        }
        TIntHashSet set = new TIntHashSet(N2);
        for (int i = 0; i < N2; ++i) {
            int r;
            while (set.contains(r = rnd.nextInt(rng) + min2)) {
            }
            set.add(r);
        }
        return set.toArray();
    }

    public static int[] getUniqueRandomInts(int N2, int min2, int max, Random rng) {
        if ((double)N2 / (double)(max - min2) > 0.4) {
            return RandomData.getUniqueRandomIntsA(N2, min2, max, rng);
        }
        return RandomData.getUniqueRandomIntsS(N2, min2, max, rng);
    }

    public static float[] getRandomFloatArray(int length, float min2, float max) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        float[] data = new float[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextFloatFromTo(min2, max);
        }
        return data;
    }

    public static float[] getRandomFloatArray(int length, float min2, float max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        float[] data = new float[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextFloatFromTo(min2, max);
        }
        return data;
    }

    public static double[] getRandomDoubleArray(int length, double min2, double max) {
        Uniform rnd = new Uniform(min2, max, (RandomEngine)new MersenneTwister(new Date()));
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextDoubleFromTo(min2, max);
        }
        return data;
    }

    public static double[] getRandomDoubleArray(int length, double min2, double max, int seed) {
        Uniform rnd = new Uniform(min2, max, (RandomEngine)new MersenneTwister(seed));
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextDoubleFromTo(min2, max);
        }
        return data;
    }

    public static int[] getRandomIntArray(int length, int min2, int max) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextIntFromTo(min2, max);
        }
        return data;
    }

    public static int[] getRandomIntArray(int length, int min2, int max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextIntFromTo(min2, max);
        }
        return data;
    }

    public static long[] getRandomLongArray(int length, long min2, long max) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextLongFromTo(min2, max);
        }
        return data;
    }

    public static long[] getRandomLongArray(int length, long min2, long max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextLongFromTo(min2, max);
        }
        return data;
    }

    public static short[] getRandomShortArray(int length, short min2, short max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        short[] data = new short[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (short)rnd.nextIntFromTo((int)min2, (int)max);
        }
        return data;
    }

    public static byte[] getRandomByteArray(int length, byte min2, byte max) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)rnd.nextIntFromTo((int)min2, (int)max);
        }
        return data;
    }

    public static byte[] getRandomByteArray(int length, byte min2, byte max, int seed) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)new MersenneTwister(seed));
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)rnd.nextIntFromTo((int)min2, (int)max);
        }
        return data;
    }

    public static float[] getRandomFloatArray(int length, float min2, float max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)mt);
        float[] data = new float[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextFloatFromTo(min2, max);
        }
        return data;
    }

    public static double[] getRandomDoubleArray(int length, double min2, double max, MersenneTwister mt) {
        Uniform rnd = new Uniform(min2, max, (RandomEngine)mt);
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextDoubleFromTo(min2, max);
        }
        return data;
    }

    public static int[] getRandomIntArray(int length, int min2, int max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)mt);
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextIntFromTo(min2, max);
        }
        return data;
    }

    public static long[] getRandomLongArray(int length, long min2, long max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)mt);
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextLongFromTo(min2, max);
        }
        return data;
    }

    public static short[] getRandomShortArray(int length, short min2, short max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)mt);
        short[] data = new short[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (short)rnd.nextIntFromTo((int)min2, (int)max);
        }
        return data;
    }

    public static byte[] getRandomByteArray(int length, byte min2, byte max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min2, (double)max, (RandomEngine)mt);
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)rnd.nextIntFromTo((int)min2, (int)max);
        }
        return data;
    }
}

