/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.openimaj.io.FileUtils;
import org.openimaj.io.IOUtils;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.io.InternalReadable;
import org.openimaj.util.pair.IndependentPair;

public class HttpUtils {
    public static final String DEFAULT_USERAGENT = "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)";

    private HttpUtils() {
    }

    public static byte[] readURLAsBytes(URL u) throws IOException {
        return HttpUtils.readURLAsBytes(u, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readURLAsBytes(URL u, boolean followRedirects) throws IOException {
        InputStream stream = HttpUtils.readURLAsStream(u, followRedirects);
        if (stream == null) {
            return null;
        }
        try {
            byte[] byArray = org.apache.commons.io.IOUtils.toByteArray(stream);
            return byArray;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static IndependentPair<HttpEntity, ByteArrayInputStream> readURLAsByteArrayInputStream(URL u, boolean followRedirects) throws IOException {
        return HttpUtils.readURLAsByteArrayInputStream(u, 15000, 15000, (RedirectStrategy)(followRedirects ? new MetaRefreshRedirectStrategy() : null), DEFAULT_USERAGENT);
    }

    public static IndependentPair<HttpEntity, ByteArrayInputStream> readURLAsByteArrayInputStream(URL u, RedirectStrategy strategy) throws IOException {
        return HttpUtils.readURLAsByteArrayInputStream(u, 15000, 15000, strategy, DEFAULT_USERAGENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndependentPair<HttpEntity, ByteArrayInputStream> readURLAsByteArrayInputStream(URL url, int connectionTimeout, int readTimeout, RedirectStrategy redirectStrategy, String userAgent) throws IOException {
        DefaultHttpClient c = null;
        try {
            IndependentPair<HttpEntity, ByteArrayInputStream> toRet;
            int readThisTime;
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
            HttpClientParams.setRedirecting((HttpParams)params, (redirectStrategy != null ? 1 : 0) != 0);
            boolean followRedirects = redirectStrategy != null;
            c = new DefaultHttpClient((HttpParams)params);
            if (followRedirects) {
                c.setRedirectStrategy(redirectStrategy);
            }
            CloseableHttpResponse resp = null;
            try {
                resp = c.execute((HttpUriRequest)new HttpGet(url.toURI()));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            InputStream stream = resp.getEntity().getContent();
            byte[] tempBuffer = new byte[1024];
            while ((readThisTime = stream.read(tempBuffer)) != -1) {
                outStream.write(tempBuffer, 0, readThisTime);
            }
            IndependentPair<HttpEntity, ByteArrayInputStream> independentPair = toRet = IndependentPair.pair(resp.getEntity(), new ByteArrayInputStream(outStream.toByteArray()));
            return independentPair;
        }
        finally {
            if (c != null) {
                c.getConnectionManager().shutdown();
            }
        }
    }

    public static InputStream readURL(URL url) throws IOException {
        return HttpUtils.readURLAsByteArrayInputStream(url, 15000, 15000, (RedirectStrategy)new MetaRefreshRedirectStrategy(), DEFAULT_USERAGENT).getSecondObject();
    }

    public static InputStream readURL(URL url, boolean followRedirects) throws IOException {
        return HttpUtils.readURLAsByteArrayInputStream(url, 15000, 15000, (RedirectStrategy)(followRedirects ? new MetaRefreshRedirectStrategy() : null), DEFAULT_USERAGENT).getSecondObject();
    }

    private static URL searchMetaRefresh(URL base, String html) throws MalformedURLException {
        Document doc = Jsoup.parse(html);
        Elements tags = doc.select("meta[http-equiv=refresh]");
        if (tags != null && tags.size() > 0) {
            String content = tags.first().attr("content");
            Pattern pattern = Pattern.compile("\\d+\\;url\\=(.*)", 2);
            Matcher matcher = pattern.matcher(content);
            if (matcher.find()) {
                String url = matcher.group(1);
                URL toRet = null;
                if (url.contains("://")) {
                    toRet = new URL(url);
                }
                if (!(toRet = new URL(base, url)).equals(base)) {
                    return toRet;
                }
            }
        }
        return null;
    }

    private static URL checkRedirects(URL base, String html) throws IOException {
        URL u = HttpUtils.searchMetaRefresh(base, html);
        return u;
    }

    public static InputStream readURLAsStream(URL url) throws IOException {
        return HttpUtils.readURL(url);
    }

    public static InputStream readURLAsStream(URL url, boolean followRedirects) throws IOException {
        InputStream conn = HttpUtils.readURL(url, followRedirects);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends InternalReadable> T readURL(URL url, T obj) throws IOException {
        try (InputStream stream = HttpUtils.readURLAsStream(url);){
            T t2 = IOUtils.read(stream, obj);
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends InternalReadable> T readURL(URL url, Class<? extends T> clz) throws IOException {
        try (InputStream stream = HttpUtils.readURLAsStream(url);){
            Class<? extends T> clazz = IOUtils.read(stream, clz);
            return (T)clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, Q extends InputStreamObjectReader<T>> T readURL(URL url, Q reader) throws IOException {
        try (InputStream stream = HttpUtils.readURLAsStream(url);){
            Object t2 = reader.read((InputStream)stream);
            return t2;
        }
    }

    public static class MetaRefreshRedirectStrategy
    extends DefaultRedirectStrategy {
        private static final String METAREFRESH_LOCATION = "METAREFRESH_LOCATION";

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            boolean isRedirect = super.isRedirected(request, response, context);
            context.setAttribute(METAREFRESH_LOCATION, null);
            if (!isRedirect) {
                HttpEntity entity = null;
                try {
                    entity = response.getEntity();
                    if (!entity.isRepeatable()) {
                        entity = new BufferedHttpEntity(response.getEntity());
                        response.setEntity(entity);
                    }
                    HttpHost host = (HttpHost)context.getAttribute("http.target_host");
                    URL url = new URL(host.toURI());
                    Header encodingObj = entity.getContentEncoding();
                    String encoding = null;
                    if (encodingObj == null) {
                        encoding = "UTF-8";
                    } else {
                        encoding = encodingObj.getValue();
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                    }
                    URL u = HttpUtils.checkRedirects(url, FileUtils.readall(entity.getContent(), encoding));
                    if (u != null) {
                        context.setAttribute(METAREFRESH_LOCATION, (Object)u);
                        return true;
                    }
                }
                catch (IOException e) {
                    return false;
                }
            }
            return isRedirect;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            URL metarefresh = (URL)context.getAttribute(METAREFRESH_LOCATION);
            if (metarefresh == null) {
                return super.getRedirect(request, response, context);
            }
            String method = request.getRequestLine().getMethod();
            try {
                if (method.equalsIgnoreCase("HEAD")) {
                    return new HttpHead(metarefresh.toURI());
                }
                return new HttpGet(metarefresh.toURI());
            }
            catch (URISyntaxException e) {
                return super.getRedirect(request, response, context);
            }
        }
    }
}

