/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

public class FloatArrayView
implements Cloneable {
    private float[] array;
    private int l;
    private int r;

    public FloatArrayView(float[] array, int l, int r) {
        this.array = array;
        this.l = l;
        this.r = r;
    }

    public FloatArrayView(float[] array) {
        this(array, 0, array.length);
    }

    public FloatArrayView(int n) {
        this(new float[n], 0, n);
    }

    public FloatArrayView subView(int l1, int r1) {
        if (this.l + l1 < 0 || this.l + r1 > this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new FloatArrayView(this.array, this.l + l1, this.l + r1);
    }

    public float get(int i) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[idx];
    }

    public float getFast(int i) {
        return this.array[i + this.l];
    }

    public void set(int i, float v) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[idx] = v;
    }

    public void setFast(int i, float v) {
        this.array[i + this.l] = v;
    }

    public float[] getUnderlyingStorage() {
        return this.array;
    }

    public int size() {
        return this.r - this.l;
    }

    public float[] toArray() {
        float[] a = new float[this.r - this.l];
        System.arraycopy(this.array, this.l, a, 0, this.r - this.l);
        return a;
    }

    public String toString() {
        String s2 = "[";
        for (int i = this.l; i < this.r - 1; ++i) {
            s2 = s2 + this.array[i] + ",";
        }
        s2 = s2 + this.array[this.r - 1] + "]";
        return s2;
    }

    public FloatArrayView clone() {
        return new FloatArrayView(this.toArray());
    }
}

