/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

public class IntArrayView
implements Cloneable {
    private int[] array;
    private int l;
    private int r;

    public IntArrayView(int[] array, int l, int r) {
        this.array = array;
        this.l = l;
        this.r = r;
    }

    public IntArrayView(int[] array) {
        this(array, 0, array.length);
    }

    public IntArrayView(int n) {
        this(new int[n], 0, n);
    }

    public IntArrayView subView(int l1, int r1) {
        if (this.l + l1 < 0 || this.l + r1 > this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new IntArrayView(this.array, this.l + l1, this.l + r1);
    }

    public int get(int i) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[idx];
    }

    public int getFast(int i) {
        return this.array[i + this.l];
    }

    public void set(int i, int v) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[idx] = v;
    }

    public void setFast(int i, int v) {
        this.array[i + this.l] = v;
    }

    public int[] getUnderlyingStorage() {
        return this.array;
    }

    public int size() {
        return this.r - this.l;
    }

    public int[] toArray() {
        int[] a = new int[this.r - this.l];
        System.arraycopy(this.array, this.l, a, 0, this.r - this.l);
        return a;
    }

    public String toString() {
        String s2 = "[";
        for (int i = this.l; i < this.r - 1; ++i) {
            s2 = s2 + this.array[i] + ",";
        }
        s2 = s2 + this.array[this.r - 1] + "]";
        return s2;
    }

    public IntArrayView clone() {
        return new IntArrayView(this.toArray());
    }
}

