/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

public class ShortArrayView
implements Cloneable {
    private short[] array;
    private int l;
    private int r;

    public ShortArrayView(short[] array, int l, int r) {
        this.array = array;
        this.l = l;
        this.r = r;
    }

    public ShortArrayView(short[] array) {
        this(array, 0, array.length);
    }

    public ShortArrayView(int n) {
        this(new short[n], 0, n);
    }

    public ShortArrayView subView(int l1, int r1) {
        if (this.l + l1 < 0 || this.l + r1 > this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new ShortArrayView(this.array, this.l + l1, this.l + r1);
    }

    public short get(int i) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[idx];
    }

    public short getFast(int i) {
        return this.array[i + this.l];
    }

    public void set(int i, short v) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[idx] = v;
    }

    public void setFast(int i, short v) {
        this.array[i + this.l] = v;
    }

    public short[] getUnderlyingStorage() {
        return this.array;
    }

    public int size() {
        return this.r - this.l;
    }

    public short[] toArray() {
        short[] a = new short[this.r - this.l];
        System.arraycopy(this.array, this.l, a, 0, this.r - this.l);
        return a;
    }

    public String toString() {
        String s2 = "[";
        for (int i = this.l; i < this.r - 1; ++i) {
            s2 = s2 + this.array[i] + ",";
        }
        s2 = s2 + this.array[this.r - 1] + "]";
        return s2;
    }

    public ShortArrayView clone() {
        return new ShortArrayView(this.toArray());
    }
}

