/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;
import org.openimaj.util.concatenate.Concatenatable;

public abstract class SparseFloatArray
implements ReadWriteable,
Concatenatable<SparseFloatArray, SparseFloatArray> {
    protected static final int DEFAULT_CAPACITY = 10;
    public int length;

    public abstract float increment(int var1, float var2);

    public abstract int[] indices();

    public abstract float[] values();

    public abstract Iterable<Entry> entries();

    public Iterable<DualEntry> unionEntries(final SparseFloatArray otherArray) {
        return new Iterable<DualEntry>(){

            @Override
            public Iterator<DualEntry> iterator() {
                final TIntHashSet keys = new TIntHashSet(SparseFloatArray.this.indices());
                keys.addAll(otherArray.indices());
                return new Iterator<DualEntry>(){
                    DualEntry entry = new DualEntry();
                    TIntIterator iterator = keys.iterator();

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public DualEntry next() {
                        this.entry.index = this.iterator.next();
                        this.entry.value = SparseFloatArray.this.get(this.entry.index);
                        this.entry.otherValue = otherArray.get(this.entry.index);
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<DualEntry> intersectEntries(final SparseFloatArray otherArray) {
        return new Iterable<DualEntry>(){

            @Override
            public Iterator<DualEntry> iterator() {
                TIntHashSet keys;
                if (SparseFloatArray.this.used() < otherArray.used()) {
                    keys = new TIntHashSet(SparseFloatArray.this.indices());
                    keys.retainAll(otherArray.indices());
                } else {
                    keys = new TIntHashSet(otherArray.indices());
                    keys.retainAll(SparseFloatArray.this.indices());
                }
                return new Iterator<DualEntry>(){
                    DualEntry entry = new DualEntry();
                    TIntIterator iterator = keys.iterator();

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public DualEntry next() {
                        this.entry.index = this.iterator.next();
                        this.entry.value = SparseFloatArray.this.get(this.entry.index);
                        this.entry.otherValue = otherArray.get(this.entry.index);
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public abstract float get(int var1);

    public abstract boolean isUsed(int var1);

    public abstract float set(int var1, float var2);

    public void setLength(int newLength) {
        if (newLength < this.length) {
            throw new IllegalArgumentException("can't make sparse array shorter");
        }
        this.length = newLength;
    }

    public int size() {
        return this.length;
    }

    public int length() {
        return this.length;
    }

    public abstract int used();

    public float density() {
        return (float)this.used() / (float)this.length;
    }

    public abstract void compact();

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.length);
        out.print(" ");
        for (Entry e : this.entries()) {
            out.print(e.index + ":" + e.value + " ");
        }
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        String[] parts;
        this.length = in.nextInt();
        for (String part : parts = in.nextLine().split(" ")) {
            String[] bits = part.split(":");
            this.set(Integer.parseInt(bits[0]), Float.parseFloat(bits[1]));
        }
    }

    @Override
    public String asciiHeader() {
        return "SpFloatA";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.writeInt(this.used());
        for (Entry e : this.entries()) {
            out.writeInt(e.index);
            out.writeFloat(e.value);
        }
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.length = in.readInt();
        int used = in.readInt();
        for (int i = 0; i < used; ++i) {
            this.set(in.readInt(), in.readFloat());
        }
    }

    @Override
    public byte[] binaryHeader() {
        return "SpFloatA".getBytes();
    }

    public abstract SparseFloatArray copy();

    public SparseFloatArray add(SparseFloatArray vector) {
        return this.copy().addInplace(vector);
    }

    public SparseFloatArray addInplace(SparseFloatArray vector) {
        for (Entry e : vector.entries()) {
            this.increment(e.index, e.value);
        }
        return this;
    }

    public SparseFloatArray subtract(SparseFloatArray vector) {
        return this.copy().subtractInplace(vector);
    }

    public SparseFloatArray subtractInplace(SparseFloatArray vector) {
        for (Entry e : vector.entries()) {
            this.increment(e.index, -e.value);
        }
        return this;
    }

    public SparseFloatArray multiply(double value) {
        return this.copy().multiplyInplace(value);
    }

    public SparseFloatArray multiplyInplace(double value) {
        for (Entry e : this.entries()) {
            if (!this.isUsed(e.index)) continue;
            this.set(e.index, (float)(value * (double)e.value));
        }
        return this;
    }

    public double dotProduct(SparseFloatArray vector) {
        int vused;
        double sum = 0.0;
        int tused = this.used();
        SparseFloatArray smaller = tused < (vused = vector.used()) ? this : vector;
        SparseFloatArray larger = tused < vused ? vector : this;
        for (Entry e : smaller.entries()) {
            sum += (double)(e.value * larger.get(e.index));
        }
        return sum;
    }

    public float maxValue() {
        float max = -3.4028235E38f;
        for (Entry e : this.entries()) {
            if (!(e.value > max)) continue;
            max = e.value;
        }
        return max;
    }

    public float minValue() {
        float min2 = Float.MAX_VALUE;
        for (Entry e : this.entries()) {
            if (!(e.value < min2)) continue;
            min2 = e.value;
        }
        return min2;
    }

    public int maxIndex() {
        float max = -3.4028235E38f;
        int index = 0;
        for (Entry e : this.entries()) {
            if (!(e.value > max)) continue;
            max = e.value;
            index = e.index;
        }
        return index;
    }

    public int minIndex() {
        float min2 = Float.MAX_VALUE;
        int index = 0;
        for (Entry e : this.entries()) {
            if (!(e.value < min2)) continue;
            min2 = e.value;
            index = e.index;
        }
        return index;
    }

    public abstract SparseFloatArray reverse();

    public static SparseFloatArray concatenateArrays(SparseFloatArray ... arrays) {
        SparseFloatArray concat = arrays[0].copy();
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i] == null) continue;
            int oldLength = concat.length;
            concat.setLength(oldLength + arrays[i].length);
            for (Entry e : arrays[i].entries()) {
                concat.set(e.index + oldLength, e.value);
            }
        }
        return concat;
    }

    public float sumValues() {
        float sum = 0.0f;
        for (Entry e : this.entries()) {
            sum += e.value;
        }
        return sum;
    }

    public float sumValuesSquared() {
        float sum = 0.0f;
        for (Entry e : this.entries()) {
            sum += e.value * e.value;
        }
        return sum;
    }

    public float[] toArray() {
        float[] array = new float[this.length];
        for (Entry e : this.entries()) {
            array[e.index] = e.value;
        }
        return array;
    }

    public float[] toArray(float[] array) {
        if (array == null || array.length < this.length) {
            array = new float[this.length];
        } else {
            Arrays.fill(array, 0.0f);
        }
        for (Entry e : this.entries()) {
            array[e.index] = e.value;
        }
        return array;
    }

    public SparseFloatArray concatenate(SparseFloatArray ... ins) {
        SparseFloatArray result = this.copy();
        for (int i = 0; i < ins.length; ++i) {
            int oldLength = result.length;
            result.setLength(oldLength + ins[i].length);
            for (Entry e : ins[i].entries()) {
                result.set(e.index + oldLength, e.value);
            }
        }
        return result;
    }

    @Override
    public SparseFloatArray concatenate(List<SparseFloatArray> ins) {
        SparseFloatArray result = this.copy();
        for (int i = 0; i < ins.size(); ++i) {
            int oldLength = result.length;
            result.setLength(oldLength + ins.get((int)i).length);
            for (Entry e : ins.get(i).entries()) {
                result.set(e.index + oldLength, e.value);
            }
        }
        return result;
    }

    public static class DualEntry
    extends Entry {
        public float otherValue;
    }

    public static class Entry {
        public int index;
        public float value;
    }
}

