/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;
import org.openimaj.util.concatenate.Concatenatable;

public abstract class SparseIntArray
implements ReadWriteable,
Concatenatable<SparseIntArray, SparseIntArray> {
    protected static final int DEFAULT_CAPACITY = 10;
    public int length;

    public abstract int increment(int var1, int var2);

    public abstract int[] indices();

    public abstract int[] values();

    public abstract Iterable<Entry> entries();

    public Iterable<DualEntry> unionEntries(final SparseIntArray otherArray) {
        return new Iterable<DualEntry>(){

            @Override
            public Iterator<DualEntry> iterator() {
                final TIntHashSet keys = new TIntHashSet(SparseIntArray.this.indices());
                keys.addAll(otherArray.indices());
                return new Iterator<DualEntry>(){
                    DualEntry entry = new DualEntry();
                    TIntIterator iterator = keys.iterator();

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public DualEntry next() {
                        this.entry.index = this.iterator.next();
                        this.entry.value = SparseIntArray.this.get(this.entry.index);
                        this.entry.otherValue = otherArray.get(this.entry.index);
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<DualEntry> intersectEntries(final SparseIntArray otherArray) {
        return new Iterable<DualEntry>(){

            @Override
            public Iterator<DualEntry> iterator() {
                TIntHashSet keys;
                if (SparseIntArray.this.used() < otherArray.used()) {
                    keys = new TIntHashSet(SparseIntArray.this.indices());
                    keys.retainAll(otherArray.indices());
                } else {
                    keys = new TIntHashSet(otherArray.indices());
                    keys.retainAll(SparseIntArray.this.indices());
                }
                return new Iterator<DualEntry>(){
                    DualEntry entry = new DualEntry();
                    TIntIterator iterator = keys.iterator();

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public DualEntry next() {
                        this.entry.index = this.iterator.next();
                        this.entry.value = SparseIntArray.this.get(this.entry.index);
                        this.entry.otherValue = otherArray.get(this.entry.index);
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public abstract int get(int var1);

    public abstract boolean isUsed(int var1);

    public abstract int set(int var1, int var2);

    public void setLength(int newLength) {
        if (newLength < this.length) {
            throw new IllegalArgumentException("can't make sparse array shorter");
        }
        this.length = newLength;
    }

    public int size() {
        return this.length;
    }

    public int length() {
        return this.length;
    }

    public abstract int used();

    public float density() {
        return (float)this.used() / (float)this.length;
    }

    public abstract void compact();

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.length);
        out.print(" ");
        for (Entry e : this.entries()) {
            out.print(e.index + ":" + e.value + " ");
        }
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        String[] parts;
        this.length = in.nextInt();
        for (String part : parts = in.nextLine().split(" ")) {
            String[] bits = part.split(":");
            this.set(Integer.parseInt(bits[0]), Integer.parseInt(bits[1]));
        }
    }

    @Override
    public String asciiHeader() {
        return "SpIntA";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.writeInt(this.used());
        for (Entry e : this.entries()) {
            out.writeInt(e.index);
            out.writeInt(e.value);
        }
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.length = in.readInt();
        int used = in.readInt();
        for (int i = 0; i < used; ++i) {
            this.set(in.readInt(), in.readInt());
        }
    }

    @Override
    public byte[] binaryHeader() {
        return "SpIntA".getBytes();
    }

    public abstract SparseIntArray copy();

    public SparseIntArray add(SparseIntArray vector) {
        return this.copy().addInplace(vector);
    }

    public SparseIntArray addInplace(SparseIntArray vector) {
        for (Entry e : vector.entries()) {
            this.increment(e.index, e.value);
        }
        return this;
    }

    public SparseIntArray subtract(SparseIntArray vector) {
        return this.copy().subtractInplace(vector);
    }

    public SparseIntArray subtractInplace(SparseIntArray vector) {
        for (Entry e : vector.entries()) {
            this.increment(e.index, -e.value);
        }
        return this;
    }

    public SparseIntArray multiply(double value) {
        return this.copy().multiplyInplace(value);
    }

    public SparseIntArray multiplyInplace(double value) {
        for (Entry e : this.entries()) {
            if (!this.isUsed(e.index)) continue;
            this.set(e.index, (int)(value * (double)e.value));
        }
        return this;
    }

    public double dotProduct(SparseIntArray vector) {
        int vused;
        double sum = 0.0;
        int tused = this.used();
        SparseIntArray smaller = tused < (vused = vector.used()) ? this : vector;
        SparseIntArray larger = tused < vused ? vector : this;
        for (Entry e : smaller.entries()) {
            sum += (double)(e.value * larger.get(e.index));
        }
        return sum;
    }

    public int maxValue() {
        int max = -2147483647;
        for (Entry e : this.entries()) {
            if (e.value <= max) continue;
            max = e.value;
        }
        return max;
    }

    public int minValue() {
        int min2 = Integer.MAX_VALUE;
        for (Entry e : this.entries()) {
            if (e.value >= min2) continue;
            min2 = e.value;
        }
        return min2;
    }

    public int maxIndex() {
        int max = -2147483647;
        int index = 0;
        for (Entry e : this.entries()) {
            if (e.value <= max) continue;
            max = e.value;
            index = e.index;
        }
        return index;
    }

    public int minIndex() {
        int min2 = Integer.MAX_VALUE;
        int index = 0;
        for (Entry e : this.entries()) {
            if (e.value >= min2) continue;
            min2 = e.value;
            index = e.index;
        }
        return index;
    }

    public abstract SparseIntArray reverse();

    public static SparseIntArray concatenateArrays(SparseIntArray ... arrays) {
        SparseIntArray concat = arrays[0].copy();
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i] == null) continue;
            int oldLength = concat.length;
            concat.setLength(oldLength + arrays[i].length);
            for (Entry e : arrays[i].entries()) {
                concat.set(e.index + oldLength, e.value);
            }
        }
        return concat;
    }

    public int sumValues() {
        int sum = 0;
        for (Entry e : this.entries()) {
            sum += e.value;
        }
        return sum;
    }

    public int sumValuesSquared() {
        int sum = 0;
        for (Entry e : this.entries()) {
            sum += e.value * e.value;
        }
        return sum;
    }

    public int[] toArray() {
        int[] array = new int[this.length];
        for (Entry e : this.entries()) {
            array[e.index] = e.value;
        }
        return array;
    }

    public int[] toArray(int[] array) {
        if (array == null || array.length < this.length) {
            array = new int[this.length];
        } else {
            Arrays.fill(array, 0);
        }
        for (Entry e : this.entries()) {
            array[e.index] = e.value;
        }
        return array;
    }

    public SparseIntArray concatenate(SparseIntArray ... ins) {
        SparseIntArray result = this.copy();
        for (int i = 0; i < ins.length; ++i) {
            int oldLength = result.length;
            result.setLength(oldLength + ins[i].length);
            for (Entry e : ins[i].entries()) {
                result.set(e.index + oldLength, e.value);
            }
        }
        return result;
    }

    @Override
    public SparseIntArray concatenate(List<SparseIntArray> ins) {
        SparseIntArray result = this.copy();
        for (int i = 0; i < ins.size(); ++i) {
            int oldLength = result.length;
            result.setLength(oldLength + ins.get((int)i).length);
            for (Entry e : ins.get(i).entries()) {
                result.set(e.index + oldLength, e.value);
            }
        }
        return result;
    }

    public static class DualEntry
    extends Entry {
        public int otherValue;
    }

    public static class Entry {
        public int index;
        public int value;
    }
}

