/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;

public class Context
extends HashMap<String, Object>
implements Cloneable {
    private static final long serialVersionUID = 1888665727867672296L;
    private boolean failfast = false;

    public Context() {
    }

    public Context(Object ... nameval) {
        for (int i = 0; i < nameval.length; i += 2) {
            this.put(nameval[i].toString(), nameval[i + 1]);
        }
    }

    public Context(boolean failfast) {
        this.failfast = failfast;
    }

    public <T> T getTyped(String key) {
        Object retUntyped = this.get(key);
        if (retUntyped == null) {
            if (this.failfast) {
                throw new RuntimeException(new NoSuchElementException("Object not found"));
            }
            return null;
        }
        try {
            Object ret = retUntyped;
            return (T)ret;
        }
        catch (Throwable t2) {
            if (this.failfast) {
                throw new RuntimeException(t2);
            }
            return null;
        }
    }

    @Override
    public Context clone() {
        Context c = new Context();
        for (Map.Entry es : this.entrySet()) {
            c.put(es.getKey(), es.getValue());
        }
        return c;
    }

    public Context combine(Context that, String thisprefix, String thatprefix) {
        Context combined = new Context();
        HashSet sharedKeys = new HashSet(this.keySet());
        sharedKeys.retainAll(that.keySet());
        HashSet thiskeys = new HashSet(this.keySet());
        thiskeys.removeAll(sharedKeys);
        HashSet thatkeys = new HashSet(that.keySet());
        thatkeys.removeAll(sharedKeys);
        if (thisprefix == null) {
            thisprefix = "";
        }
        if (thatprefix == null) {
            thatprefix = "";
        }
        for (String key : sharedKeys) {
            combined.put(thisprefix + key, this.get(key));
            combined.put(thatprefix + key, that.get(key));
        }
        for (String key : thatkeys) {
            combined.put(key, that.get(key));
        }
        for (String key : thiskeys) {
            combined.put(key, this.get(key));
        }
        return combined;
    }
}

