/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.pair;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Comparator;

public class ByteIntPair {
    public static final Comparator<ByteIntPair> FIRST_ITEM_ASCENDING_COMPARATOR = new Comparator<ByteIntPair>(){

        @Override
        public int compare(ByteIntPair o1, ByteIntPair o2) {
            if (o1.first < o2.first) {
                return -1;
            }
            if (o1.first > o2.first) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ByteIntPair> FIRST_ITEM_DESCENDING_COMPARATOR = new Comparator<ByteIntPair>(){

        @Override
        public int compare(ByteIntPair o1, ByteIntPair o2) {
            if (o1.first < o2.first) {
                return 1;
            }
            if (o1.first > o2.first) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<ByteIntPair> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<ByteIntPair>(){

        @Override
        public int compare(ByteIntPair o1, ByteIntPair o2) {
            if (o1.second < o2.second) {
                return -1;
            }
            if (o1.second > o2.second) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ByteIntPair> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<ByteIntPair>(){

        @Override
        public int compare(ByteIntPair o1, ByteIntPair o2) {
            if (o1.second < o2.second) {
                return 1;
            }
            if (o1.second > o2.second) {
                return -1;
            }
            return 0;
        }
    };
    public byte first;
    public int second;

    public ByteIntPair(byte f, int s2) {
        this.first = f;
        this.second = s2;
    }

    public ByteIntPair() {
    }

    public byte getFirst() {
        return this.first;
    }

    public void setFirst(byte first) {
        this.first = first;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public static ByteIntPair pair(byte a, int b) {
        return new ByteIntPair(a, b);
    }

    public static TIntArrayList getSecond(Iterable<ByteIntPair> data) {
        TIntArrayList extracted = new TIntArrayList();
        for (ByteIntPair item : data) {
            extracted.add(item.second);
        }
        return extracted;
    }

    public static TByteArrayList getFirst(Iterable<ByteIntPair> data) {
        TByteArrayList extracted = new TByteArrayList();
        for (ByteIntPair item : data) {
            extracted.add(item.first);
        }
        return extracted;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }
}

