/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.parallel;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import org.openimaj.util.function.Operation;
import org.openimaj.util.parallel.GlobalExecutorPool;
import org.openimaj.util.parallel.partition.GrowingChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;
import org.openimaj.util.parallel.partition.RangePartitioner;

public class Parallel {
    public static void forIndex(int start, int stop, final int incr, final Operation<Integer> op, ThreadPoolExecutor pool) {
        int loops = pool.getMaximumPoolSize();
        int ops = (stop - start) / incr;
        double div = (double)ops / (double)loops;
        int chunksize = (int)div;
        int remainder = (int)((div - (double)chunksize) * (double)loops);
        if (div < 1.0) {
            chunksize = 1;
            remainder = 0;
            loops = ops;
        }
        final CountDownLatch latch = new CountDownLatch(loops);
        int i = start;
        while (i < stop) {
            final int lo = i;
            i += chunksize * incr;
            if (remainder > 0) {
                i += incr;
                --remainder;
            }
            final int hi = Math.min(i, stop);
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = lo; i < hi; i += incr) {
                        op.perform(i);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void forIndex(int start, int stop, int incr, Operation<Integer> op) {
        Parallel.forIndex(start, stop, incr, op, GlobalExecutorPool.getPool());
    }

    public static void forRange(int start, int stop, int incr, Operation<IntRange> op) {
        Parallel.forRange(start, stop, incr, op, GlobalExecutorPool.getPool());
    }

    public static void forRange(int start, int stop, final int incr, final Operation<IntRange> op, ThreadPoolExecutor pool) {
        int loops = pool.getMaximumPoolSize();
        int ops = (stop - start) / incr;
        double div = (double)ops / (double)loops;
        int chunksize = (int)div;
        int remainder = (int)((div - (double)chunksize) * (double)loops);
        if (div < 1.0) {
            chunksize = 1;
            remainder = 0;
            loops = ops;
        }
        final CountDownLatch latch = new CountDownLatch(loops);
        final Thread thread = Thread.currentThread();
        final Throwable[] exception = new Throwable[1];
        int i = start;
        while (i < stop) {
            final int lo = i;
            i += chunksize * incr;
            if (remainder > 0) {
                i += incr;
                --remainder;
            }
            final int hi = Math.min(i, stop);
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        op.perform(new IntRange(lo, hi, incr));
                    }
                    catch (Throwable t2) {
                        exception[0] = t2;
                        thread.interrupt();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            if (exception[0] instanceof Error) {
                throw (Error)exception[0];
            }
            if (exception[0] instanceof RuntimeException) {
                throw (RuntimeException)exception[0];
            }
            throw new RuntimeException(exception[0]);
        }
    }

    public static <T> void forEach(Iterable<T> objects, Operation<T> op, ThreadPoolExecutor pool) {
        Partitioner<T> partitioner = objects instanceof List ? new RangePartitioner((List)objects, pool.getMaximumPoolSize()) : new GrowingChunkPartitioner<T>(objects);
        Parallel.forEach(partitioner, op, pool);
    }

    public static <T> void forEach(Iterable<T> objects, Operation<T> op) {
        Parallel.forEach(objects, op, GlobalExecutorPool.getPool());
    }

    public static <T> void forEach(Partitioner<T> partitioner, Operation<T> op) {
        Parallel.forEach(partitioner, op, GlobalExecutorPool.getPool());
    }

    public static <T> void forEach(Partitioner<T> partitioner, Operation<T> op, ThreadPoolExecutor pool) {
        int i;
        ExecutorCompletionService<Boolean> completion = new ExecutorCompletionService<Boolean>(pool);
        Iterator<Iterator<T>> partitions = partitioner.getPartitions();
        long submitted = 0L;
        for (i = 0; i < pool.getMaximumPoolSize() && partitions.hasNext(); ++i) {
            completion.submit(new Task<T>(partitions.next(), op), true);
            ++submitted;
        }
        while (partitions.hasNext()) {
            try {
                completion.take().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            completion.submit(new Task<T>(partitions.next(), op), true);
        }
        i = 0;
        while ((long)i < submitted) {
            try {
                completion.take().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static <T> void forEachUnpartitioned(Iterator<T> data, Operation<T> op) {
        Parallel.forEachUnpartitioned(data, op, GlobalExecutorPool.getPool());
    }

    public static <T> void forEachUnpartitioned(Iterator<T> data, final Operation<T> op, ThreadPoolExecutor pool) {
        int i;
        ExecutorCompletionService<Boolean> completion = new ExecutorCompletionService<Boolean>(pool);
        long submitted = 0L;
        for (i = 0; i < pool.getMaximumPoolSize() && data.hasNext(); ++i) {
            final T next = data.next();
            completion.submit(new Runnable(){

                @Override
                public void run() {
                    op.perform(next);
                }
            }, true);
            ++submitted;
        }
        while (data.hasNext()) {
            final T next = data.next();
            try {
                completion.take().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            completion.submit(new Runnable(){

                @Override
                public void run() {
                    op.perform(next);
                }
            }, true);
        }
        i = 0;
        while ((long)i < submitted) {
            try {
                completion.take().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static <T> void forEachPartitioned(Partitioner<T> partitioner, Operation<Iterator<T>> op, ThreadPoolExecutor pool) {
        int i;
        ExecutorCompletionService<Boolean> completion = new ExecutorCompletionService<Boolean>(pool);
        Iterator<Iterator<T>> partitions = partitioner.getPartitions();
        long submitted = 0L;
        for (i = 0; i < pool.getMaximumPoolSize() && partitions.hasNext(); ++i) {
            completion.submit(new BatchTask<T>(partitions.next(), op), true);
            ++submitted;
        }
        while (partitions.hasNext()) {
            try {
                completion.take().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            completion.submit(new BatchTask<T>(partitions.next(), op), true);
        }
        i = 0;
        while ((long)i < submitted) {
            try {
                completion.take().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static <T> void forEachPartitioned(Partitioner<T> partitioner, Operation<Iterator<T>> op) {
        Parallel.forEachPartitioned(partitioner, op, GlobalExecutorPool.getPool());
    }

    public static class IntRange {
        public final int start;
        public final int stop;
        public final int incr;

        IntRange(int start, int stop, int incr) {
            this.start = start;
            this.stop = stop;
            this.incr = incr;
        }
    }

    private static class BatchTask<T>
    implements Runnable {
        private Iterator<T> iterator;
        private Operation<Iterator<T>> op;

        public BatchTask(Iterator<T> iterator, Operation<Iterator<T>> op) {
            this.iterator = iterator;
            this.op = op;
        }

        @Override
        public void run() {
            this.op.perform(this.iterator);
        }
    }

    private static class Task<T>
    implements Runnable {
        private Iterator<T> iterator;
        private Operation<T> op;

        public Task(Iterator<T> iterator, Operation<T> op) {
            this.iterator = iterator;
            this.op = op;
        }

        @Override
        public void run() {
            while (this.iterator.hasNext()) {
                this.op.perform(this.iterator.next());
            }
        }
    }
}

