/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.parallel.partition;

import java.util.ArrayList;
import java.util.Iterator;
import org.openimaj.util.parallel.partition.Partitioner;

public class GrowingChunkPartitioner<T>
implements Partitioner<T> {
    private static final int NUM_HW_THREADS = Runtime.getRuntime().availableProcessors();
    private Iterator<T> objects;

    public GrowingChunkPartitioner(Iterable<T> objects) {
        this.objects = objects.iterator();
    }

    @Override
    public Iterator<Iterator<T>> getPartitions() {
        return new Iterator<Iterator<T>>(){
            private int currentIteration = 0;
            private int chunkSize = 2;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Iterator iterator = GrowingChunkPartitioner.this.objects;
                synchronized (iterator) {
                    return GrowingChunkPartitioner.this.objects.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<T> next() {
                Iterator iterator = GrowingChunkPartitioner.this.objects;
                synchronized (iterator) {
                    if (!GrowingChunkPartitioner.this.objects.hasNext()) {
                        return null;
                    }
                    if (this.currentIteration % NUM_HW_THREADS == 0) {
                        this.chunkSize = (int)Math.pow(2.0, this.currentIteration / NUM_HW_THREADS + 1);
                    }
                    ArrayList list = new ArrayList(this.chunkSize);
                    for (int i = 0; GrowingChunkPartitioner.this.objects.hasNext() && i < this.chunkSize; ++i) {
                        list.add(GrowingChunkPartitioner.this.objects.next());
                    }
                    ++this.currentIteration;
                    return list.iterator();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

