/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream;

import org.openimaj.util.concurrent.BlockingDroppingQueue;
import org.openimaj.util.stream.AbstractStream;

public class BlockingDroppingBufferedStream<T>
extends AbstractStream<T> {
    BlockingDroppingQueue<T> buffer;
    private boolean isClosed = false;

    public BlockingDroppingBufferedStream(BlockingDroppingQueue<T> buffer) {
        this.buffer = buffer;
    }

    protected void register(T obj) throws InterruptedException {
        this.buffer.offer(obj);
    }

    @Override
    public boolean hasNext() {
        return !this.isClosed;
    }

    public void close() {
        this.isClosed = true;
    }

    @Override
    public T next() {
        try {
            return this.buffer.take();
        }
        catch (InterruptedException e) {
            return this.next();
        }
    }

    public BlockingDroppingQueue<T> getBuffer() {
        return this.buffer;
    }
}

