/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TObjectFloatProcedure;
import jal.objects.BinaryPredicate;
import jal.objects.Sorting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.array.IntArrayView;
import org.openimaj.util.pair.FloatIntPair;
import org.openimaj.util.pair.IntBytePair;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class ByteKDTree {
    public final KDTreeNode root;
    public final byte[][] data;

    public ByteKDTree(byte[][] data) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), new BBFMedianSplit());
    }

    public ByteKDTree(byte[][] data, SplitChooser split2) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), split2);
    }

    public byte[][] coordinateRangeSearch(byte[] lowerExtreme, byte[] upperExtreme) {
        final ArrayList results = new ArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<byte[]>(){

            public boolean execute(int a, byte[] b) {
                results.add(b);
                return true;
            }
        });
        return (byte[][])results.toArray((T[])new byte[results.size()][]);
    }

    public int[] indexRangeSearch(byte[] lowerExtreme, byte[] upperExtreme) {
        final TIntArrayList results = new TIntArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<byte[]>(){

            public boolean execute(int a, byte[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public int[] indexRadiusSearch(byte[] centre, byte radius) {
        final TIntArrayList results = new TIntArrayList();
        this.radiusSearch(centre, radius, new TIntObjectProcedure<byte[]>(){

            public boolean execute(int a, byte[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public void radiusSearch(final byte[] centre, byte radius, final TIntObjectProcedure<byte[]> proc) {
        byte[] lower = (byte[])centre.clone();
        byte[] upper = (byte[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = (byte)(lower[n] - radius);
            int n2 = i++;
            upper[n2] = (byte)(upper[n2] + radius);
        }
        final float radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<byte[]>(){

            public boolean execute(int idx, byte[] point) {
                float d = ByteKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute(idx, (Object)point);
                }
                return true;
            }
        });
    }

    public void rangeSearch(byte[] lowerExtreme, byte[] upperExtreme, TIntObjectProcedure<byte[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        if (this.root == null) {
            return;
        }
        stack.push(this.root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    byte[] vec = this.data[idx];
                    if (!this.isContained(vec, lowerExtreme, upperExtreme) || proc.execute(idx, (Object)vec)) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.isDisjointFrom(lowerExtreme, upperExtreme)) continue;
            if (tmpNode.isContainedBy(lowerExtreme, upperExtreme)) {
                this.reportSubtree(tmpNode, proc);
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    private final boolean isContained(byte[] point, byte[] lower, byte[] upper) {
        for (int i = 0; i < point.length; ++i) {
            if (point[i] >= lower[i] && point[i] <= upper[i]) continue;
            return false;
        }
        return true;
    }

    private void reportSubtree(KDTreeNode root, TIntObjectProcedure<byte[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    if (proc.execute(idx, (Object)this.data[idx])) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    public List<IntFloatPair> nearestNeighbours(byte[] qu, int n) {
        BoundedPriorityQueue<IntFloatPair> queue = new BoundedPriorityQueue<IntFloatPair>(n, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.toOrderedListDestructive();
    }

    public IntFloatPair nearestNeighbour(byte[] qu) {
        BoundedPriorityQueue<IntFloatPair> queue = new BoundedPriorityQueue<IntFloatPair>(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.peek();
    }

    public byte[][] coordinateRadiusSearch(byte[] centre, byte radius) {
        final ArrayList radiusList = new ArrayList();
        this.coordinateRadiusSearch(centre, radius, new TObjectFloatProcedure<byte[]>(){

            public boolean execute(byte[] a, float b) {
                radiusList.add(a);
                return true;
            }
        });
        return (byte[][])radiusList.toArray((T[])new byte[radiusList.size()][]);
    }

    public void coordinateRadiusSearch(final byte[] centre, byte radius, final TObjectFloatProcedure<byte[]> proc) {
        byte[] lower = (byte[])centre.clone();
        byte[] upper = (byte[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = (byte)(lower[n] - radius);
            int n2 = i++;
            upper[n2] = (byte)(upper[n2] + radius);
        }
        final float radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<byte[]>(){

            public boolean execute(int idx, byte[] point) {
                float d = ByteKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute((Object)point, d);
                }
                return true;
            }
        });
    }

    private void searchSubTree(byte[] qu, KDTreeNode cur, BoundedPriorityQueue<IntFloatPair> queue) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        while (!cur.isLeaf()) {
            stack.push(cur);
            float diff = qu[cur.discriminantDimension] - cur.discriminant;
            if (diff < 0.0f) {
                cur = cur.left;
                continue;
            }
            cur = cur.right;
        }
        for (int i = 0; i < cur.indices.length; ++i) {
            int idx = cur.indices[i];
            byte[] vec = this.data[idx];
            float dist = this.distance(qu, vec);
            queue.add(new IntFloatPair(idx, dist));
        }
        while (!stack.isEmpty()) {
            cur = (KDTreeNode)stack.pop();
            float diff = qu[cur.discriminantDimension] - cur.discriminant;
            float worstDist = queue.peekTail().second;
            if (!(diff * diff <= worstDist) && queue.isFull()) continue;
            if (diff < 0.0f) {
                this.searchSubTree(qu, cur.right, queue);
                continue;
            }
            this.searchSubTree(qu, cur.left, queue);
        }
    }

    private float distance(byte[] qu, byte[] vec) {
        float d = 0.0f;
        for (int i = 0; i < qu.length; ++i) {
            d += (float)((qu[i] - vec[i]) * (qu[i] - vec[i]));
        }
        return d;
    }

    public List<int[]> leafIndices() {
        ArrayList<int[]> leafInds = new ArrayList<int[]>();
        ArrayDeque<KDTreeNode> nodes = new ArrayDeque<KDTreeNode>();
        nodes.push(this.root);
        while (nodes.size() != 0) {
            KDTreeNode node = (KDTreeNode)nodes.pop();
            if (node.isLeaf()) {
                leafInds.add(node.indices);
                continue;
            }
            nodes.push(node.left);
            nodes.push(node.right);
        }
        return leafInds;
    }

    public static class KDTreeNode {
        public KDTreeNode left;
        public KDTreeNode right;
        public byte discriminant;
        public int discriminantDimension;
        public byte[] minBounds;
        public byte[] maxBounds;
        public int[] indices;

        public KDTreeNode(byte[][] pnts, IntArrayView inds, SplitChooser split2) {
            this(pnts, inds, split2, 0, null, true);
        }

        private KDTreeNode(byte[][] pnts, IntArrayView inds, SplitChooser split2, int depth, KDTreeNode parent, boolean isLeft) {
            if (parent == null) {
                this.minBounds = new byte[pnts[0].length];
                this.maxBounds = new byte[pnts[0].length];
                Arrays.fill(this.minBounds, (byte)127);
                Arrays.fill(this.maxBounds, (byte)-127);
                for (int y = 0; y < pnts.length; ++y) {
                    for (int x = 0; x < pnts[0].length; ++x) {
                        if (this.minBounds[x] > pnts[y][x]) {
                            this.minBounds[x] = pnts[y][x];
                        }
                        if (this.maxBounds[x] >= pnts[y][x]) continue;
                        this.maxBounds[x] = pnts[y][x];
                    }
                }
                Arrays.fill(this.minBounds, (byte)-127);
                Arrays.fill(this.maxBounds, (byte)127);
            } else {
                this.minBounds = (byte[])parent.minBounds.clone();
                this.maxBounds = (byte[])parent.maxBounds.clone();
                if (isLeft) {
                    this.maxBounds[parent.discriminantDimension] = parent.discriminant;
                } else {
                    this.minBounds[parent.discriminantDimension] = parent.discriminant;
                }
            }
            IntBytePair spl = split2.chooseSplit(pnts, inds, depth, this.minBounds, this.maxBounds);
            if (spl == null) {
                this.indices = inds.toArray();
            } else {
                this.discriminantDimension = spl.first;
                this.discriminant = spl.second;
                int N2 = inds.size();
                int l = 0;
                int r = N2;
                while (l != r) {
                    if (pnts[inds.getFast(l)][this.discriminantDimension] < this.discriminant) {
                        ++l;
                        continue;
                    }
                    int t2 = inds.getFast(l);
                    inds.setFast(l, inds.getFast(--r));
                    inds.setFast(r, t2);
                }
                if (l == 0 || l == N2) {
                    this.discriminant = 0;
                    this.discriminantDimension = 0;
                    this.indices = inds.toArray();
                } else {
                    this.left = new KDTreeNode(pnts, inds.subView(0, l), split2, depth + 1, this, true);
                    this.right = new KDTreeNode(pnts, inds.subView(l, N2), split2, depth + 1, this, false);
                }
            }
        }

        public boolean isLeaf() {
            return this.indices != null;
        }

        private final boolean inRange(byte value, byte min2, byte max) {
            return value >= min2 && value <= max;
        }

        public boolean isDisjointFrom(byte[] lowerExtreme, byte[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (this.inRange(this.minBounds[i], lowerExtreme[i], upperExtreme[i]) || this.inRange(lowerExtreme[i], this.minBounds[i], this.maxBounds[i])) continue;
                return true;
            }
            return false;
        }

        public boolean isContainedBy(byte[] lowerExtreme, byte[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (this.minBounds[i] >= lowerExtreme[i] && this.maxBounds[i] <= upperExtreme[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class RandomisedBBFMeanSplit
    implements SplitChooser {
        private static final int maxLeafSize = 14;
        private static final int varianceMaxPoints = 128;
        private static final int randomMaxDims = 5;
        private Uniform rng;

        public RandomisedBBFMeanSplit() {
            this.rng = new Uniform((RandomEngine)new MersenneTwister());
        }

        public RandomisedBBFMeanSplit(Uniform uniform) {
            this.rng = uniform;
        }

        public RandomisedBBFMeanSplit(int maxLeafSize, int varianceMaxPoints, int randomMaxDims, Uniform uniform) {
            this.rng = uniform;
        }

        @Override
        public IntBytePair chooseSplit(byte[][] pnts, IntArrayView inds, int depth, byte[] minBounds, byte[] maxBounds) {
            int d;
            if (inds.size() < 14) {
                return null;
            }
            int D = pnts[0].length;
            float[] sumX = new float[D];
            float[] sumXX = new float[D];
            int count = Math.min(inds.size(), 128);
            for (int n = 0; n < count; ++n) {
                for (d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + (float)pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + (float)(pnts[i][d] * pnts[i][d]);
                }
            }
            Object[] varPerDim = new FloatIntPair[D];
            for (d = 0; d < D; ++d) {
                varPerDim[d] = new FloatIntPair();
                varPerDim[d].second = d;
                ((FloatIntPair)varPerDim[d]).first = count <= 1 ? 0.0f : (sumXX[d] - 1.0f / (float)count * sumX[d] * sumX[d]) / (float)(count - 1);
            }
            int nrand = Math.min(5, D);
            Sorting.partial_sort((Object[])varPerDim, (int)0, (int)nrand, (int)varPerDim.length, (BinaryPredicate)new BinaryPredicate(){

                public boolean apply(Object arg0, Object arg1) {
                    FloatIntPair p1 = (FloatIntPair)arg0;
                    FloatIntPair p2 = (FloatIntPair)arg1;
                    if (p1.first > p2.first) {
                        return true;
                    }
                    if (p2.first > p1.first) {
                        return false;
                    }
                    return p1.second > p2.second;
                }
            });
            int randd = ((FloatIntPair)varPerDim[this.rng.nextIntFromTo((int)0, (int)(nrand - 1))]).second;
            return new IntBytePair(randd, (byte)(sumX[randd] / (float)count));
        }
    }

    public static class ApproximateBBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public ApproximateBBFMedianSplit() {
        }

        public ApproximateBBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntBytePair chooseSplit(byte[][] pnts, IntArrayView inds, int depth, byte[] minBounds, byte[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = 0;
            float maxVar = maxBounds[0] - minBounds[0];
            for (int d = 1; d < pnts[0].length; ++d) {
                float var2 = maxBounds[d] - minBounds[d];
                if (!(var2 > maxVar)) continue;
                maxVar = var2;
                dim = d;
            }
            if (maxVar == 0.0f) {
                return null;
            }
            byte[] data = new byte[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            byte median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntBytePair.pair(dim, median);
        }
    }

    public static class BBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BBFMedianSplit() {
        }

        public BBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntBytePair chooseSplit(byte[][] pnts, IntArrayView inds, int depth, byte[] minBounds, byte[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int D = pnts[0].length;
            float[] sumX = new float[D];
            float[] sumXX = new float[D];
            int count = inds.size();
            for (int n = 0; n < count; ++n) {
                for (int d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + (float)pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + (float)(pnts[i][d] * pnts[i][d]);
                }
            }
            int dim = 0;
            float maxVar = (sumXX[0] - 1.0f / (float)count * sumX[0] * sumX[0]) / (float)(count - 1);
            for (int d = 1; d < D; ++d) {
                float var2 = (sumXX[d] - 1.0f / (float)count * sumX[d] * sumX[d]) / (float)(count - 1);
                if (!(var2 > maxVar)) continue;
                maxVar = var2;
                dim = d;
            }
            if (maxVar == 0.0f) {
                return null;
            }
            byte[] data = new byte[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            byte median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntBytePair.pair(dim, median);
        }
    }

    public static class BasicMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BasicMedianSplit() {
        }

        public BasicMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntBytePair chooseSplit(byte[][] pnts, IntArrayView inds, int depth, byte[] minBounds, byte[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = depth % pnts[0].length;
            byte[] data = new byte[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            byte median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntBytePair.pair(dim, median);
        }
    }

    public static interface SplitChooser {
        public IntBytePair chooseSplit(byte[][] var1, IntArrayView var2, int var3, byte[] var4, byte[] var5);
    }
}

