/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TObjectDoubleProcedure;
import jal.objects.BinaryPredicate;
import jal.objects.Sorting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.array.IntArrayView;
import org.openimaj.util.pair.DoubleIntPair;
import org.openimaj.util.pair.IntDoublePair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class DoubleKDTree {
    public final KDTreeNode root;
    public final double[][] data;

    public DoubleKDTree(double[][] data) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), new BBFMedianSplit());
    }

    public DoubleKDTree(double[][] data, SplitChooser split2) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), split2);
    }

    public double[][] coordinateRangeSearch(double[] lowerExtreme, double[] upperExtreme) {
        final ArrayList results = new ArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<double[]>(){

            public boolean execute(int a, double[] b) {
                results.add(b);
                return true;
            }
        });
        return (double[][])results.toArray((T[])new double[results.size()][]);
    }

    public int[] indexRangeSearch(double[] lowerExtreme, double[] upperExtreme) {
        final TIntArrayList results = new TIntArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<double[]>(){

            public boolean execute(int a, double[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public int[] indexRadiusSearch(double[] centre, double radius) {
        final TIntArrayList results = new TIntArrayList();
        this.radiusSearch(centre, radius, new TIntObjectProcedure<double[]>(){

            public boolean execute(int a, double[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public void radiusSearch(final double[] centre, double radius, final TIntObjectProcedure<double[]> proc) {
        double[] lower = (double[])centre.clone();
        double[] upper = (double[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        final double radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<double[]>(){

            public boolean execute(int idx, double[] point) {
                double d = DoubleKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute(idx, (Object)point);
                }
                return true;
            }
        });
    }

    public void rangeSearch(double[] lowerExtreme, double[] upperExtreme, TIntObjectProcedure<double[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        if (this.root == null) {
            return;
        }
        stack.push(this.root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    double[] vec = this.data[idx];
                    if (!this.isContained(vec, lowerExtreme, upperExtreme) || proc.execute(idx, (Object)vec)) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.isDisjointFrom(lowerExtreme, upperExtreme)) continue;
            if (tmpNode.isContainedBy(lowerExtreme, upperExtreme)) {
                this.reportSubtree(tmpNode, proc);
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    private final boolean isContained(double[] point, double[] lower, double[] upper) {
        for (int i = 0; i < point.length; ++i) {
            if (!(point[i] < lower[i]) && !(point[i] > upper[i])) continue;
            return false;
        }
        return true;
    }

    private void reportSubtree(KDTreeNode root, TIntObjectProcedure<double[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    if (proc.execute(idx, (Object)this.data[idx])) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    public List<IntDoublePair> nearestNeighbours(double[] qu, int n) {
        BoundedPriorityQueue<IntDoublePair> queue = new BoundedPriorityQueue<IntDoublePair>(n, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.toOrderedListDestructive();
    }

    public IntDoublePair nearestNeighbour(double[] qu) {
        BoundedPriorityQueue<IntDoublePair> queue = new BoundedPriorityQueue<IntDoublePair>(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.peek();
    }

    public double[][] coordinateRadiusSearch(double[] centre, double radius) {
        final ArrayList radiusList = new ArrayList();
        this.coordinateRadiusSearch(centre, radius, new TObjectDoubleProcedure<double[]>(){

            public boolean execute(double[] a, double b) {
                radiusList.add(a);
                return true;
            }
        });
        return (double[][])radiusList.toArray((T[])new double[radiusList.size()][]);
    }

    public void coordinateRadiusSearch(final double[] centre, double radius, final TObjectDoubleProcedure<double[]> proc) {
        double[] lower = (double[])centre.clone();
        double[] upper = (double[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        final double radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<double[]>(){

            public boolean execute(int idx, double[] point) {
                double d = DoubleKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute((Object)point, d);
                }
                return true;
            }
        });
    }

    private void searchSubTree(double[] qu, KDTreeNode cur, BoundedPriorityQueue<IntDoublePair> queue) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        while (!cur.isLeaf()) {
            stack.push(cur);
            double diff = qu[cur.discriminantDimension] - cur.discriminant;
            if (diff < 0.0) {
                cur = cur.left;
                continue;
            }
            cur = cur.right;
        }
        for (int i = 0; i < cur.indices.length; ++i) {
            int idx = cur.indices[i];
            double[] vec = this.data[idx];
            double dist = this.distance(qu, vec);
            queue.add(new IntDoublePair(idx, dist));
        }
        while (!stack.isEmpty()) {
            cur = (KDTreeNode)stack.pop();
            double diff = qu[cur.discriminantDimension] - cur.discriminant;
            double worstDist = queue.peekTail().second;
            if (!(diff * diff <= worstDist) && queue.isFull()) continue;
            if (diff < 0.0) {
                this.searchSubTree(qu, cur.right, queue);
                continue;
            }
            this.searchSubTree(qu, cur.left, queue);
        }
    }

    private double distance(double[] qu, double[] vec) {
        double d = 0.0;
        for (int i = 0; i < qu.length; ++i) {
            d += (qu[i] - vec[i]) * (qu[i] - vec[i]);
        }
        return d;
    }

    public List<int[]> leafIndices() {
        ArrayList<int[]> leafInds = new ArrayList<int[]>();
        ArrayDeque<KDTreeNode> nodes = new ArrayDeque<KDTreeNode>();
        nodes.push(this.root);
        while (nodes.size() != 0) {
            KDTreeNode node = (KDTreeNode)nodes.pop();
            if (node.isLeaf()) {
                leafInds.add(node.indices);
                continue;
            }
            nodes.push(node.left);
            nodes.push(node.right);
        }
        return leafInds;
    }

    public static class KDTreeNode {
        public KDTreeNode left;
        public KDTreeNode right;
        public double discriminant;
        public int discriminantDimension;
        public double[] minBounds;
        public double[] maxBounds;
        public int[] indices;

        public KDTreeNode(double[][] pnts, IntArrayView inds, SplitChooser split2) {
            this(pnts, inds, split2, 0, null, true);
        }

        private KDTreeNode(double[][] pnts, IntArrayView inds, SplitChooser split2, int depth, KDTreeNode parent, boolean isLeft) {
            if (parent == null) {
                this.minBounds = new double[pnts[0].length];
                this.maxBounds = new double[pnts[0].length];
                Arrays.fill(this.minBounds, Double.MAX_VALUE);
                Arrays.fill(this.maxBounds, -1.7976931348623157E308);
                for (int y = 0; y < pnts.length; ++y) {
                    for (int x = 0; x < pnts[0].length; ++x) {
                        if (this.minBounds[x] > pnts[y][x]) {
                            this.minBounds[x] = pnts[y][x];
                        }
                        if (!(this.maxBounds[x] < pnts[y][x])) continue;
                        this.maxBounds[x] = pnts[y][x];
                    }
                }
                Arrays.fill(this.minBounds, -1.7976931348623157E308);
                Arrays.fill(this.maxBounds, Double.MAX_VALUE);
            } else {
                this.minBounds = (double[])parent.minBounds.clone();
                this.maxBounds = (double[])parent.maxBounds.clone();
                if (isLeft) {
                    this.maxBounds[parent.discriminantDimension] = parent.discriminant;
                } else {
                    this.minBounds[parent.discriminantDimension] = parent.discriminant;
                }
            }
            IntDoublePair spl = split2.chooseSplit(pnts, inds, depth, this.minBounds, this.maxBounds);
            if (spl == null) {
                this.indices = inds.toArray();
            } else {
                this.discriminantDimension = spl.first;
                this.discriminant = spl.second;
                int N2 = inds.size();
                int l = 0;
                int r = N2;
                while (l != r) {
                    if (pnts[inds.getFast(l)][this.discriminantDimension] < this.discriminant) {
                        ++l;
                        continue;
                    }
                    int t2 = inds.getFast(l);
                    inds.setFast(l, inds.getFast(--r));
                    inds.setFast(r, t2);
                }
                if (l == 0 || l == N2) {
                    this.discriminant = 0.0;
                    this.discriminantDimension = 0;
                    this.indices = inds.toArray();
                } else {
                    this.left = new KDTreeNode(pnts, inds.subView(0, l), split2, depth + 1, this, true);
                    this.right = new KDTreeNode(pnts, inds.subView(l, N2), split2, depth + 1, this, false);
                }
            }
        }

        public boolean isLeaf() {
            return this.indices != null;
        }

        private final boolean inRange(double value, double min2, double max) {
            return value >= min2 && value <= max;
        }

        public boolean isDisjointFrom(double[] lowerExtreme, double[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (this.inRange(this.minBounds[i], lowerExtreme[i], upperExtreme[i]) || this.inRange(lowerExtreme[i], this.minBounds[i], this.maxBounds[i])) continue;
                return true;
            }
            return false;
        }

        public boolean isContainedBy(double[] lowerExtreme, double[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (!(this.minBounds[i] < lowerExtreme[i]) && !(this.maxBounds[i] > upperExtreme[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class RandomisedBBFMeanSplit
    implements SplitChooser {
        private static final int maxLeafSize = 14;
        private static final int varianceMaxPoints = 128;
        private static final int randomMaxDims = 5;
        private Uniform rng;

        public RandomisedBBFMeanSplit() {
            this.rng = new Uniform((RandomEngine)new MersenneTwister());
        }

        public RandomisedBBFMeanSplit(Uniform uniform) {
            this.rng = uniform;
        }

        public RandomisedBBFMeanSplit(int maxLeafSize, int varianceMaxPoints, int randomMaxDims, Uniform uniform) {
            this.rng = uniform;
        }

        @Override
        public IntDoublePair chooseSplit(double[][] pnts, IntArrayView inds, int depth, double[] minBounds, double[] maxBounds) {
            int d;
            if (inds.size() < 14) {
                return null;
            }
            int D = pnts[0].length;
            double[] sumX = new double[D];
            double[] sumXX = new double[D];
            int count = Math.min(inds.size(), 128);
            for (int n = 0; n < count; ++n) {
                for (d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + pnts[i][d] * pnts[i][d];
                }
            }
            Object[] varPerDim = new DoubleIntPair[D];
            for (d = 0; d < D; ++d) {
                varPerDim[d] = new DoubleIntPair();
                varPerDim[d].second = d;
                ((DoubleIntPair)varPerDim[d]).first = count <= 1 ? 0.0 : (sumXX[d] - 1.0 / (double)count * sumX[d] * sumX[d]) / (double)(count - 1);
            }
            int nrand = Math.min(5, D);
            Sorting.partial_sort((Object[])varPerDim, (int)0, (int)nrand, (int)varPerDim.length, (BinaryPredicate)new BinaryPredicate(){

                public boolean apply(Object arg0, Object arg1) {
                    DoubleIntPair p1 = (DoubleIntPair)arg0;
                    DoubleIntPair p2 = (DoubleIntPair)arg1;
                    if (p1.first > p2.first) {
                        return true;
                    }
                    if (p2.first > p1.first) {
                        return false;
                    }
                    return p1.second > p2.second;
                }
            });
            int randd = ((DoubleIntPair)varPerDim[this.rng.nextIntFromTo((int)0, (int)(nrand - 1))]).second;
            return new IntDoublePair(randd, sumX[randd] / (double)count);
        }
    }

    public static class ApproximateBBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public ApproximateBBFMedianSplit() {
        }

        public ApproximateBBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntDoublePair chooseSplit(double[][] pnts, IntArrayView inds, int depth, double[] minBounds, double[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = 0;
            double maxVar = maxBounds[0] - minBounds[0];
            for (int d = 1; d < pnts[0].length; ++d) {
                double var2 = maxBounds[d] - minBounds[d];
                if (!(var2 > maxVar)) continue;
                maxVar = var2;
                dim = d;
            }
            if (maxVar == 0.0) {
                return null;
            }
            double[] data = new double[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            double median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntDoublePair.pair(dim, median);
        }
    }

    public static class BBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BBFMedianSplit() {
        }

        public BBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntDoublePair chooseSplit(double[][] pnts, IntArrayView inds, int depth, double[] minBounds, double[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int D = pnts[0].length;
            double[] sumX = new double[D];
            double[] sumXX = new double[D];
            int count = inds.size();
            for (int n = 0; n < count; ++n) {
                for (int d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + pnts[i][d] * pnts[i][d];
                }
            }
            int dim = 0;
            double maxVar = (sumXX[0] - 1.0 / (double)count * sumX[0] * sumX[0]) / (double)(count - 1);
            for (int d = 1; d < D; ++d) {
                double var2 = (sumXX[d] - 1.0 / (double)count * sumX[d] * sumX[d]) / (double)(count - 1);
                if (!(var2 > maxVar)) continue;
                maxVar = var2;
                dim = d;
            }
            if (maxVar == 0.0) {
                return null;
            }
            double[] data = new double[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            double median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntDoublePair.pair(dim, median);
        }
    }

    public static class BasicMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BasicMedianSplit() {
        }

        public BasicMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntDoublePair chooseSplit(double[][] pnts, IntArrayView inds, int depth, double[] minBounds, double[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = depth % pnts[0].length;
            double[] data = new double[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            double median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntDoublePair.pair(dim, median);
        }
    }

    public static interface SplitChooser {
        public IntDoublePair chooseSplit(double[][] var1, IntArrayView var2, int var3, double[] var4, double[] var5);
    }
}

