/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Stack;
import org.openimaj.util.pair.ObjectDoublePair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class IncrementalDoubleKDTree {
    KDNode _root = null;

    public IncrementalDoubleKDTree() {
    }

    public IncrementalDoubleKDTree(Collection<double[]> coords) {
        this.insertAll(coords);
    }

    public IncrementalDoubleKDTree(double[][] coords) {
        this.insertAll(coords);
    }

    public void insertAll(Collection<double[]> coords) {
        for (double[] c : coords) {
            this.insert(c);
        }
    }

    public void insertAll(double[][] coords) {
        for (double[] c : coords) {
            this.insert(c);
        }
    }

    public void insert(double[] point) {
        if (this._root == null) {
            this._root = new KDNode(point, 0);
        } else {
            double ordinate2;
            KDNode tmpNode;
            int discriminate;
            double ordinate1;
            KDNode curNode = this._root;
            do {
                tmpNode = curNode;
            } while ((curNode = (ordinate1 = point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
            if (++discriminate >= point.length) {
                discriminate = 0;
            }
            if (ordinate1 > ordinate2) {
                tmpNode.right = new KDNode(point, discriminate);
            } else {
                tmpNode.left = new KDNode(point, discriminate);
            }
        }
    }

    static final boolean isContained(double[] point, double[] lower, double[] upper) {
        for (int i = 0; i < point.length; ++i) {
            double ordinate1 = point[i];
            double ordinate2 = lower[i];
            double ordinate3 = upper[i];
            if (!(ordinate1 < ordinate2) && !(ordinate1 > ordinate3)) continue;
            return false;
        }
        return true;
    }

    public List<double[]> rangeSearch(double[] lowerExtreme, double[] upperExtreme) {
        ArrayList<double[]> results = new ArrayList<double[]>(1000);
        Stack<KDNode> stack = new Stack<KDNode>();
        if (this._root == null) {
            return results;
        }
        stack.push(this._root);
        while (!stack.empty()) {
            KDNode tmpNode = (KDNode)stack.pop();
            int discriminate = tmpNode.discriminateDim;
            double ordinate1 = tmpNode.point[discriminate];
            double ordinate2 = lowerExtreme[discriminate];
            if (ordinate1 >= ordinate2 && tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (ordinate1 <= (ordinate2 = upperExtreme[discriminate]) && tmpNode.right != null) {
                stack.push(tmpNode.right);
            }
            if (!IncrementalDoubleKDTree.isContained(tmpNode.point, lowerExtreme, upperExtreme)) continue;
            results.add(tmpNode.point);
        }
        return results;
    }

    protected static final double distance(double[] a, double[] b) {
        double s2 = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double fa = a[i];
            double fb = b[i];
            s2 += (fa - fb) * (fa - fb);
        }
        return s2;
    }

    public ObjectDoublePair<double[]> findNearestNeighbour(double[] query) {
        Stack<KDNode> stack = this.walkdown(query);
        ObjectDoublePair<double[]> state = new ObjectDoublePair<double[]>();
        state.first = stack.peek().point;
        state.second = IncrementalDoubleKDTree.distance(query, (double[])state.first);
        if (state.second == 0.0) {
            return state;
        }
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtree(current, query, state);
        }
        return state;
    }

    public List<ObjectDoublePair<double[]>> findNearestNeighbours(double[] query, int k) {
        Stack<KDNode> stack = this.walkdown(query);
        BoundedPriorityQueue<ObjectDoublePair<double[]>> state = new BoundedPriorityQueue<ObjectDoublePair<double[]>>(k, (Comparator<ObjectDoublePair<double[]>>)ObjectDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ObjectDoublePair initialState = new ObjectDoublePair();
        initialState.first = stack.peek().point;
        initialState.second = IncrementalDoubleKDTree.distance(query, (double[])initialState.first);
        state.add(initialState);
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtreeK(current, query, state, k);
        }
        return state.toOrderedListDestructive();
    }

    private void checkSubtree(KDNode node, double[] query, ObjectDoublePair<double[]> state) {
        if (node == null) {
            return;
        }
        double dist = IncrementalDoubleKDTree.distance(query, node.point);
        if (dist < state.second) {
            state.first = node.point;
            state.second = dist;
        }
        if (state.second == 0.0) {
            return;
        }
        double d = node.point[node.discriminateDim] - query[node.discriminateDim];
        if (d * d > state.second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtree(node.right, query, state);
            } else {
                this.checkSubtree(node.left, query, state);
            }
        } else {
            this.checkSubtree(node.left, query, state);
            this.checkSubtree(node.right, query, state);
        }
    }

    private void checkSubtreeK(KDNode node, double[] query, PriorityQueue<ObjectDoublePair<double[]>> state, int k) {
        double d;
        if (node == null) {
            return;
        }
        double dist = IncrementalDoubleKDTree.distance(query, node.point);
        boolean cont = false;
        for (ObjectDoublePair<double[]> s2 : state) {
            if (!((double[])s2.first).equals(node.point)) continue;
            cont = true;
            break;
        }
        if (!cont) {
            ObjectDoublePair<Object> s3;
            if (state.size() < k) {
                s3 = new ObjectDoublePair();
                s3.first = node.point;
                s3.second = dist;
                state.add(s3);
            } else if (dist < state.peek().second) {
                s3 = state.poll();
                s3.first = node.point;
                s3.second = dist;
                state.add(s3);
            }
        }
        if ((d = node.point[node.discriminateDim] - query[node.discriminateDim]) * d > state.peek().second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtreeK(node.right, query, state, k);
            } else {
                this.checkSubtreeK(node.left, query, state, k);
            }
        } else {
            this.checkSubtreeK(node.left, query, state, k);
            this.checkSubtreeK(node.right, query, state, k);
        }
    }

    private Stack<KDNode> walkdown(double[] point) {
        double ordinate2;
        KDNode tmpNode;
        int discriminate;
        double ordinate1;
        if (this._root == null) {
            return null;
        }
        Stack<KDNode> stack = new Stack<KDNode>();
        KDNode curNode = this._root;
        do {
            tmpNode = curNode;
            stack.push(tmpNode);
            if (tmpNode.point != point) continue;
            return stack;
        } while ((curNode = (ordinate1 = point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
        if (++discriminate >= point.length) {
            discriminate = 0;
        }
        return stack;
    }

    public List<double[]> radiusSearch(double[] centre, double radius) {
        double[] lower = (double[])centre.clone();
        double[] upper = (double[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        List<double[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<double[]> radiusList = new ArrayList<double[]>(rangeList.size());
        double radSq = radius * radius;
        for (double[] r : rangeList) {
            if (!(IncrementalDoubleKDTree.distance(centre, r) < radSq)) continue;
            radiusList.add(r);
        }
        return radiusList;
    }

    public List<ObjectDoublePair<double[]>> radiusDistanceSearch(double[] centre, double radius) {
        double[] lower = (double[])centre.clone();
        double[] upper = (double[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        List<double[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<ObjectDoublePair<double[]>> radiusList = new ArrayList<ObjectDoublePair<double[]>>(rangeList.size());
        double radSq = radius * radius;
        for (double[] r : rangeList) {
            double dist = IncrementalDoubleKDTree.distance(centre, r);
            if (!(dist < radSq)) continue;
            radiusList.add(new ObjectDoublePair<double[]>(r, dist));
        }
        return radiusList;
    }

    private static class KDNode {
        int discriminateDim;
        double[] point;
        KDNode left;
        KDNode right;

        KDNode(double[] point, int discriminate) {
            this.point = point;
            this.right = null;
            this.left = null;
            this.discriminateDim = discriminate;
        }
    }
}

