/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Stack;
import org.openimaj.util.pair.ObjectDoublePair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class IncrementalShortKDTree {
    KDNode _root = null;

    public IncrementalShortKDTree() {
    }

    public IncrementalShortKDTree(Collection<short[]> coords) {
        this.insertAll(coords);
    }

    public IncrementalShortKDTree(short[][] coords) {
        this.insertAll(coords);
    }

    public void insertAll(Collection<short[]> coords) {
        for (short[] c : coords) {
            this.insert(c);
        }
    }

    public void insertAll(short[][] coords) {
        for (short[] c : coords) {
            this.insert(c);
        }
    }

    public void insert(short[] point) {
        if (this._root == null) {
            this._root = new KDNode(point, 0);
        } else {
            double ordinate2;
            KDNode tmpNode;
            int discriminate;
            double ordinate1;
            KDNode curNode = this._root;
            do {
                tmpNode = curNode;
            } while ((curNode = (ordinate1 = (double)point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = (double)tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
            if (++discriminate >= point.length) {
                discriminate = 0;
            }
            if (ordinate1 > ordinate2) {
                tmpNode.right = new KDNode(point, discriminate);
            } else {
                tmpNode.left = new KDNode(point, discriminate);
            }
        }
    }

    static final boolean isContained(short[] point, short[] lower, short[] upper) {
        for (int i = 0; i < point.length; ++i) {
            double ordinate1 = point[i];
            double ordinate2 = lower[i];
            double ordinate3 = upper[i];
            if (!(ordinate1 < ordinate2) && !(ordinate1 > ordinate3)) continue;
            return false;
        }
        return true;
    }

    public List<short[]> rangeSearch(short[] lowerExtreme, short[] upperExtreme) {
        ArrayList<short[]> results = new ArrayList<short[]>(1000);
        Stack<KDNode> stack = new Stack<KDNode>();
        if (this._root == null) {
            return results;
        }
        stack.push(this._root);
        while (!stack.empty()) {
            KDNode tmpNode = (KDNode)stack.pop();
            int discriminate = tmpNode.discriminateDim;
            double ordinate1 = tmpNode.point[discriminate];
            double ordinate2 = lowerExtreme[discriminate];
            if (ordinate1 >= ordinate2 && tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (ordinate1 <= (ordinate2 = (double)upperExtreme[discriminate]) && tmpNode.right != null) {
                stack.push(tmpNode.right);
            }
            if (!IncrementalShortKDTree.isContained(tmpNode.point, lowerExtreme, upperExtreme)) continue;
            results.add(tmpNode.point);
        }
        return results;
    }

    protected static final double distance(short[] a, short[] b) {
        double s2 = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double fa = a[i];
            double fb = b[i];
            s2 += (fa - fb) * (fa - fb);
        }
        return s2;
    }

    public ObjectDoublePair<short[]> findNearestNeighbour(short[] query) {
        Stack<KDNode> stack = this.walkdown(query);
        ObjectDoublePair<short[]> state = new ObjectDoublePair<short[]>();
        state.first = stack.peek().point;
        state.second = IncrementalShortKDTree.distance(query, (short[])state.first);
        if (state.second == 0.0) {
            return state;
        }
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtree(current, query, state);
        }
        return state;
    }

    public List<ObjectDoublePair<short[]>> findNearestNeighbours(short[] query, int k) {
        Stack<KDNode> stack = this.walkdown(query);
        BoundedPriorityQueue<ObjectDoublePair<short[]>> state = new BoundedPriorityQueue<ObjectDoublePair<short[]>>(k, (Comparator<ObjectDoublePair<short[]>>)ObjectDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ObjectDoublePair initialState = new ObjectDoublePair();
        initialState.first = stack.peek().point;
        initialState.second = IncrementalShortKDTree.distance(query, (short[])initialState.first);
        state.add(initialState);
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtreeK(current, query, state, k);
        }
        return state.toOrderedListDestructive();
    }

    private void checkSubtree(KDNode node, short[] query, ObjectDoublePair<short[]> state) {
        if (node == null) {
            return;
        }
        double dist = IncrementalShortKDTree.distance(query, node.point);
        if (dist < state.second) {
            state.first = node.point;
            state.second = dist;
        }
        if (state.second == 0.0) {
            return;
        }
        double d = node.point[node.discriminateDim] - query[node.discriminateDim];
        if (d * d > state.second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtree(node.right, query, state);
            } else {
                this.checkSubtree(node.left, query, state);
            }
        } else {
            this.checkSubtree(node.left, query, state);
            this.checkSubtree(node.right, query, state);
        }
    }

    private void checkSubtreeK(KDNode node, short[] query, PriorityQueue<ObjectDoublePair<short[]>> state, int k) {
        double d;
        if (node == null) {
            return;
        }
        double dist = IncrementalShortKDTree.distance(query, node.point);
        boolean cont = false;
        for (ObjectDoublePair<short[]> s2 : state) {
            if (!((short[])s2.first).equals(node.point)) continue;
            cont = true;
            break;
        }
        if (!cont) {
            ObjectDoublePair<Object> s3;
            if (state.size() < k) {
                s3 = new ObjectDoublePair();
                s3.first = node.point;
                s3.second = dist;
                state.add(s3);
            } else if (dist < state.peek().second) {
                s3 = state.poll();
                s3.first = node.point;
                s3.second = dist;
                state.add(s3);
            }
        }
        if ((d = (double)(node.point[node.discriminateDim] - query[node.discriminateDim])) * d > state.peek().second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtreeK(node.right, query, state, k);
            } else {
                this.checkSubtreeK(node.left, query, state, k);
            }
        } else {
            this.checkSubtreeK(node.left, query, state, k);
            this.checkSubtreeK(node.right, query, state, k);
        }
    }

    private Stack<KDNode> walkdown(short[] point) {
        double ordinate2;
        KDNode tmpNode;
        int discriminate;
        double ordinate1;
        if (this._root == null) {
            return null;
        }
        Stack<KDNode> stack = new Stack<KDNode>();
        KDNode curNode = this._root;
        do {
            tmpNode = curNode;
            stack.push(tmpNode);
            if (tmpNode.point != point) continue;
            return stack;
        } while ((curNode = (ordinate1 = (double)point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = (double)tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
        if (++discriminate >= point.length) {
            discriminate = 0;
        }
        return stack;
    }

    public List<short[]> radiusSearch(short[] centre, short radius) {
        short[] lower = (short[])centre.clone();
        short[] upper = (short[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = (short)(lower[n] - radius);
            int n2 = i++;
            upper[n2] = (short)(upper[n2] + radius);
        }
        List<short[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<short[]> radiusList = new ArrayList<short[]>(rangeList.size());
        double radSq = radius * radius;
        for (short[] r : rangeList) {
            if (!(IncrementalShortKDTree.distance(centre, r) < radSq)) continue;
            radiusList.add(r);
        }
        return radiusList;
    }

    public List<ObjectDoublePair<short[]>> radiusDistanceSearch(short[] centre, short radius) {
        short[] lower = (short[])centre.clone();
        short[] upper = (short[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = (short)(lower[n] - radius);
            int n2 = i++;
            upper[n2] = (short)(upper[n2] + radius);
        }
        List<short[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<ObjectDoublePair<short[]>> radiusList = new ArrayList<ObjectDoublePair<short[]>>(rangeList.size());
        double radSq = radius * radius;
        for (short[] r : rangeList) {
            double dist = IncrementalShortKDTree.distance(centre, r);
            if (!(dist < radSq)) continue;
            radiusList.add(new ObjectDoublePair<short[]>(r, dist));
        }
        return radiusList;
    }

    private static class KDNode {
        int discriminateDim;
        short[] point;
        KDNode left;
        KDNode right;

        KDNode(short[] point, int discriminate) {
            this.point = point;
            this.right = null;
            this.left = null;
            this.discriminateDim = discriminate;
        }
    }
}

