/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TObjectDoubleProcedure;
import jal.objects.BinaryPredicate;
import jal.objects.Sorting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.array.IntArrayView;
import org.openimaj.util.pair.DoubleIntPair;
import org.openimaj.util.pair.IntDoublePair;
import org.openimaj.util.pair.IntLongPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class LongKDTree {
    public final KDTreeNode root;
    public final long[][] data;

    public LongKDTree(long[][] data) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), new BBFMedianSplit());
    }

    public LongKDTree(long[][] data, SplitChooser split2) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), split2);
    }

    public long[][] coordinateRangeSearch(long[] lowerExtreme, long[] upperExtreme) {
        final ArrayList results = new ArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<long[]>(){

            public boolean execute(int a, long[] b) {
                results.add(b);
                return true;
            }
        });
        return (long[][])results.toArray((T[])new long[results.size()][]);
    }

    public int[] indexRangeSearch(long[] lowerExtreme, long[] upperExtreme) {
        final TIntArrayList results = new TIntArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<long[]>(){

            public boolean execute(int a, long[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public int[] indexRadiusSearch(long[] centre, long radius) {
        final TIntArrayList results = new TIntArrayList();
        this.radiusSearch(centre, radius, new TIntObjectProcedure<long[]>(){

            public boolean execute(int a, long[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public void radiusSearch(final long[] centre, long radius, final TIntObjectProcedure<long[]> proc) {
        long[] lower = (long[])centre.clone();
        long[] upper = (long[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        final double radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<long[]>(){

            public boolean execute(int idx, long[] point) {
                double d = LongKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute(idx, (Object)point);
                }
                return true;
            }
        });
    }

    public void rangeSearch(long[] lowerExtreme, long[] upperExtreme, TIntObjectProcedure<long[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        if (this.root == null) {
            return;
        }
        stack.push(this.root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    long[] vec = this.data[idx];
                    if (!this.isContained(vec, lowerExtreme, upperExtreme) || proc.execute(idx, (Object)vec)) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.isDisjointFrom(lowerExtreme, upperExtreme)) continue;
            if (tmpNode.isContainedBy(lowerExtreme, upperExtreme)) {
                this.reportSubtree(tmpNode, proc);
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    private final boolean isContained(long[] point, long[] lower, long[] upper) {
        for (int i = 0; i < point.length; ++i) {
            if (point[i] >= lower[i] && point[i] <= upper[i]) continue;
            return false;
        }
        return true;
    }

    private void reportSubtree(KDTreeNode root, TIntObjectProcedure<long[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    if (proc.execute(idx, (Object)this.data[idx])) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    public List<IntDoublePair> nearestNeighbours(long[] qu, int n) {
        BoundedPriorityQueue<IntDoublePair> queue = new BoundedPriorityQueue<IntDoublePair>(n, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.toOrderedListDestructive();
    }

    public IntDoublePair nearestNeighbour(long[] qu) {
        BoundedPriorityQueue<IntDoublePair> queue = new BoundedPriorityQueue<IntDoublePair>(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.peek();
    }

    public long[][] coordinateRadiusSearch(long[] centre, long radius) {
        final ArrayList radiusList = new ArrayList();
        this.coordinateRadiusSearch(centre, radius, new TObjectDoubleProcedure<long[]>(){

            public boolean execute(long[] a, double b) {
                radiusList.add(a);
                return true;
            }
        });
        return (long[][])radiusList.toArray((T[])new long[radiusList.size()][]);
    }

    public void coordinateRadiusSearch(final long[] centre, long radius, final TObjectDoubleProcedure<long[]> proc) {
        long[] lower = (long[])centre.clone();
        long[] upper = (long[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        final double radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<long[]>(){

            public boolean execute(int idx, long[] point) {
                double d = LongKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute((Object)point, d);
                }
                return true;
            }
        });
    }

    private void searchSubTree(long[] qu, KDTreeNode cur, BoundedPriorityQueue<IntDoublePair> queue) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        while (!cur.isLeaf()) {
            stack.push(cur);
            double diff = qu[cur.discriminantDimension] - cur.discriminant;
            if (diff < 0.0) {
                cur = cur.left;
                continue;
            }
            cur = cur.right;
        }
        for (int i = 0; i < cur.indices.length; ++i) {
            int idx = cur.indices[i];
            long[] vec = this.data[idx];
            double dist = this.distance(qu, vec);
            queue.add(new IntDoublePair(idx, dist));
        }
        while (!stack.isEmpty()) {
            cur = (KDTreeNode)stack.pop();
            double diff = qu[cur.discriminantDimension] - cur.discriminant;
            double worstDist = queue.peekTail().second;
            if (!(diff * diff <= worstDist) && queue.isFull()) continue;
            if (diff < 0.0) {
                this.searchSubTree(qu, cur.right, queue);
                continue;
            }
            this.searchSubTree(qu, cur.left, queue);
        }
    }

    private double distance(long[] qu, long[] vec) {
        double d = 0.0;
        for (int i = 0; i < qu.length; ++i) {
            d += (double)((qu[i] - vec[i]) * (qu[i] - vec[i]));
        }
        return d;
    }

    public List<int[]> leafIndices() {
        ArrayList<int[]> leafInds = new ArrayList<int[]>();
        ArrayDeque<KDTreeNode> nodes = new ArrayDeque<KDTreeNode>();
        nodes.push(this.root);
        while (nodes.size() != 0) {
            KDTreeNode node = (KDTreeNode)nodes.pop();
            if (node.isLeaf()) {
                leafInds.add(node.indices);
                continue;
            }
            nodes.push(node.left);
            nodes.push(node.right);
        }
        return leafInds;
    }

    public static class KDTreeNode {
        public KDTreeNode left;
        public KDTreeNode right;
        public long discriminant;
        public int discriminantDimension;
        public long[] minBounds;
        public long[] maxBounds;
        public int[] indices;

        public KDTreeNode(long[][] pnts, IntArrayView inds, SplitChooser split2) {
            this(pnts, inds, split2, 0, null, true);
        }

        private KDTreeNode(long[][] pnts, IntArrayView inds, SplitChooser split2, int depth, KDTreeNode parent, boolean isLeft) {
            if (parent == null) {
                this.minBounds = new long[pnts[0].length];
                this.maxBounds = new long[pnts[0].length];
                Arrays.fill(this.minBounds, Long.MAX_VALUE);
                Arrays.fill(this.maxBounds, -9223372036854775807L);
                for (int y = 0; y < pnts.length; ++y) {
                    for (int x = 0; x < pnts[0].length; ++x) {
                        if (this.minBounds[x] > pnts[y][x]) {
                            this.minBounds[x] = pnts[y][x];
                        }
                        if (this.maxBounds[x] >= pnts[y][x]) continue;
                        this.maxBounds[x] = pnts[y][x];
                    }
                }
                Arrays.fill(this.minBounds, -9223372036854775807L);
                Arrays.fill(this.maxBounds, Long.MAX_VALUE);
            } else {
                this.minBounds = (long[])parent.minBounds.clone();
                this.maxBounds = (long[])parent.maxBounds.clone();
                if (isLeft) {
                    this.maxBounds[parent.discriminantDimension] = parent.discriminant;
                } else {
                    this.minBounds[parent.discriminantDimension] = parent.discriminant;
                }
            }
            IntLongPair spl = split2.chooseSplit(pnts, inds, depth, this.minBounds, this.maxBounds);
            if (spl == null) {
                this.indices = inds.toArray();
            } else {
                this.discriminantDimension = spl.first;
                this.discriminant = spl.second;
                int N2 = inds.size();
                int l = 0;
                int r = N2;
                while (l != r) {
                    if (pnts[inds.getFast(l)][this.discriminantDimension] < this.discriminant) {
                        ++l;
                        continue;
                    }
                    int t2 = inds.getFast(l);
                    inds.setFast(l, inds.getFast(--r));
                    inds.setFast(r, t2);
                }
                if (l == 0 || l == N2) {
                    this.discriminant = 0L;
                    this.discriminantDimension = 0;
                    this.indices = inds.toArray();
                } else {
                    this.left = new KDTreeNode(pnts, inds.subView(0, l), split2, depth + 1, this, true);
                    this.right = new KDTreeNode(pnts, inds.subView(l, N2), split2, depth + 1, this, false);
                }
            }
        }

        public boolean isLeaf() {
            return this.indices != null;
        }

        private final boolean inRange(long value, long min2, long max) {
            return value >= min2 && value <= max;
        }

        public boolean isDisjointFrom(long[] lowerExtreme, long[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (this.inRange(this.minBounds[i], lowerExtreme[i], upperExtreme[i]) || this.inRange(lowerExtreme[i], this.minBounds[i], this.maxBounds[i])) continue;
                return true;
            }
            return false;
        }

        public boolean isContainedBy(long[] lowerExtreme, long[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (this.minBounds[i] >= lowerExtreme[i] && this.maxBounds[i] <= upperExtreme[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class RandomisedBBFMeanSplit
    implements SplitChooser {
        private static final int maxLeafSize = 14;
        private static final int varianceMaxPoints = 128;
        private static final int randomMaxDims = 5;
        private Uniform rng;

        public RandomisedBBFMeanSplit() {
            this.rng = new Uniform((RandomEngine)new MersenneTwister());
        }

        public RandomisedBBFMeanSplit(Uniform uniform) {
            this.rng = uniform;
        }

        public RandomisedBBFMeanSplit(int maxLeafSize, int varianceMaxPoints, int randomMaxDims, Uniform uniform) {
            this.rng = uniform;
        }

        @Override
        public IntLongPair chooseSplit(long[][] pnts, IntArrayView inds, int depth, long[] minBounds, long[] maxBounds) {
            int d;
            if (inds.size() < 14) {
                return null;
            }
            int D = pnts[0].length;
            double[] sumX = new double[D];
            double[] sumXX = new double[D];
            int count = Math.min(inds.size(), 128);
            for (int n = 0; n < count; ++n) {
                for (d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + (double)pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + (double)(pnts[i][d] * pnts[i][d]);
                }
            }
            Object[] varPerDim = new DoubleIntPair[D];
            for (d = 0; d < D; ++d) {
                varPerDim[d] = new DoubleIntPair();
                varPerDim[d].second = d;
                ((DoubleIntPair)varPerDim[d]).first = count <= 1 ? 0.0 : (sumXX[d] - 1.0 / (double)count * sumX[d] * sumX[d]) / (double)(count - 1);
            }
            int nrand = Math.min(5, D);
            Sorting.partial_sort((Object[])varPerDim, (int)0, (int)nrand, (int)varPerDim.length, (BinaryPredicate)new BinaryPredicate(){

                public boolean apply(Object arg0, Object arg1) {
                    DoubleIntPair p1 = (DoubleIntPair)arg0;
                    DoubleIntPair p2 = (DoubleIntPair)arg1;
                    if (p1.first > p2.first) {
                        return true;
                    }
                    if (p2.first > p1.first) {
                        return false;
                    }
                    return p1.second > p2.second;
                }
            });
            int randd = ((DoubleIntPair)varPerDim[this.rng.nextIntFromTo((int)0, (int)(nrand - 1))]).second;
            return new IntLongPair(randd, (long)(sumX[randd] / (double)count));
        }
    }

    public static class ApproximateBBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public ApproximateBBFMedianSplit() {
        }

        public ApproximateBBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntLongPair chooseSplit(long[][] pnts, IntArrayView inds, int depth, long[] minBounds, long[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = 0;
            double maxVar = maxBounds[0] - minBounds[0];
            for (int d = 1; d < pnts[0].length; ++d) {
                double var2 = maxBounds[d] - minBounds[d];
                if (!(var2 > maxVar)) continue;
                maxVar = var2;
                dim = d;
            }
            if (maxVar == 0.0) {
                return null;
            }
            long[] data = new long[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            long median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntLongPair.pair(dim, median);
        }
    }

    public static class BBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BBFMedianSplit() {
        }

        public BBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntLongPair chooseSplit(long[][] pnts, IntArrayView inds, int depth, long[] minBounds, long[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int D = pnts[0].length;
            double[] sumX = new double[D];
            double[] sumXX = new double[D];
            int count = inds.size();
            for (int n = 0; n < count; ++n) {
                for (int d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + (double)pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + (double)(pnts[i][d] * pnts[i][d]);
                }
            }
            int dim = 0;
            double maxVar = (sumXX[0] - 1.0 / (double)count * sumX[0] * sumX[0]) / (double)(count - 1);
            for (int d = 1; d < D; ++d) {
                double var2 = (sumXX[d] - 1.0 / (double)count * sumX[d] * sumX[d]) / (double)(count - 1);
                if (!(var2 > maxVar)) continue;
                maxVar = var2;
                dim = d;
            }
            if (maxVar == 0.0) {
                return null;
            }
            long[] data = new long[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            long median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntLongPair.pair(dim, median);
        }
    }

    public static class BasicMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BasicMedianSplit() {
        }

        public BasicMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntLongPair chooseSplit(long[][] pnts, IntArrayView inds, int depth, long[] minBounds, long[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = depth % pnts[0].length;
            long[] data = new long[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            long median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntLongPair.pair(dim, median);
        }
    }

    public static interface SplitChooser {
        public IntLongPair chooseSplit(long[][] var1, IntArrayView var2, int var3, long[] var4, long[] var5);
    }
}

