/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.time.Duration;
import java.util.function.Function;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class ContextAwareHttpServerMetricsHandler
extends AbstractHttpServerMetricsHandler {
    final ContextAwareHttpServerMetricsRecorder recorder;

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsRecorder recorder, @Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        super(methodTagValue, uriTagValue);
        this.recorder = recorder;
    }

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
    }

    @Override
    protected ContextAwareHttpServerMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordException(HttpServerOperations ops, String path) {
        this.recorder().incrementErrorsCount(ops.currentContext(), ops.remoteSocketAddress(), path);
    }

    @Override
    protected void recordRead(HttpServerOperations ops, String path, String method) {
        Context contextView = ops.currentContext();
        this.recorder().recordDataReceivedTime(contextView, path, method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(contextView, ops.remoteSocketAddress(), path, this.dataReceived);
    }

    @Override
    protected void recordWrite(HttpServerOperations ops, String path, String method, String status) {
        Context contextView = ops.currentContext();
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(contextView, path, method, status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(contextView, path, method, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(contextView, path, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(contextView, ops.remoteSocketAddress(), path, this.dataSent);
    }
}

