/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.persistance;

import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.persistance.BindEngine;
import com.nuix.automate.utils.persistance.EngineMapper;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ConfigurationDao {
    @SqlQuery(value="select 1")
    public int checkConnection();

    @SqlQuery(value="select id from services")
    public List<String> getLegacyIds();

    @SqlUpdate(value="create table engineServerServices (id varchar(256) primary key not null)")
    public void createServicesTable();

    @SqlQuery(value="select id from engineServerServices")
    public List<String> getIds();

    @SqlUpdate(value="delete from engineServerServices where id = :id ")
    public void deleteId(@Bind(value="id") String var1);

    @SqlUpdate(value="insert into engineServerServices (id) values (:id )")
    public void addId(@Bind(value="id") String var1);

    @SqlUpdate(value="create table engines (id varchar(256) primary key not null, serverId varchar(256), name nvarchar(max), nuixLicenceSourceId varchar(256), executionProfileId varchar(256), targetNuixWorkers int, tags nvarchar(max), minNuixWorkers int, priority int, supportedExecutionMode varchar(256))")
    public void createEnginesTableMssql();

    @SqlUpdate(value="create table engines (id varchar(256) primary key not null, serverId varchar(256), name text, nuixLicenceSourceId varchar(256), executionProfileId varchar(256), targetNuixWorkers int, tags text, minNuixWorkers int, priority int, supportedExecutionMode varchar(256))")
    public void createEnginesTableSqlite();

    @SqlQuery(value="select id from engines")
    public List<String> getEngineIds();

    @SqlUpdate(value="alter table engines add minNuixWorkers int")
    public void updateEnginesTable1();

    @SqlUpdate(value="alter table engines add priority int")
    public void updateEnginesTable2();

    @SqlUpdate(value="alter table engines add supportedExecutionMode varchar(256)")
    public void updateEnginesTable3();

    @SqlUpdate(value="alter table engines add executionProfileId varchar(256)")
    public void updateEnginesTable4();

    @SqlUpdate(value="alter table engines add serverId varchar(256)")
    public void updateEnginesTable5();

    @SqlUpdate(value="update engines set serverId = :serverId")
    public int updateEnginesTable5SetServerId(@Bind(value="serverId") String var1);

    @SqlQuery(value="select id, serverId, name, nuixLicenceSourceId, executionProfileId, targetNuixWorkers, minNuixWorkers, priority, tags, supportedExecutionMode from engines")
    @RegisterRowMapper(value=EngineMapper.class)
    public List<EngineModel> getEngines();

    @SqlQuery(value="select id, serverId, name, nuixLicenceSourceId, executionProfileId, targetNuixWorkers, minNuixWorkers, priority, tags, supportedExecutionMode from engines where serverId = :serverId")
    @RegisterRowMapper(value=EngineMapper.class)
    public List<EngineModel> getServerEngines(@Bind(value="serverId") String var1);

    @SqlUpdate(value="insert into engines (id, serverId, name, nuixLicenceSourceId, executionProfileId, targetNuixWorkers, minNuixWorkers, priority, tags, supportedExecutionMode) values (:id, :serverId, :name, :nuixLicenceSourceId, :executionProfileId, :targetNuixWorkers, :minNuixWorkers, :priority, :tags, :supportedExecutionMode)")
    public void addEngine(@BindEngine EngineModel var1);

    @SqlUpdate(value="update engines set serverId = :serverId, name = :name, nuixLicenceSourceId = :nuixLicenceSourceId, executionProfileId = :executionProfileId, targetNuixWorkers = :targetNuixWorkers, minNuixWorkers = :minNuixWorkers, priority = :priority, tags = :tags, supportedExecutionMode = :supportedExecutionMode where id = :id")
    public int updateEngine(@BindEngine EngineModel var1);

    @SqlUpdate(value="delete from engines where id = :id")
    public void deleteEngine(@Bind(value="id") String var1);
}

