/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Path(value="/v1/server/consumption")
@Produces(value={"application/json"})
public class ConsumptionResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConsumptionResource.class);
    private ServerApplication serverApplication;
    private Map<String, Consumption> consumptionsMap;

    public ConsumptionResource(ServerApplication serverApplication) {
        this.serverApplication = serverApplication;
        this.consumptionsMap = new ConcurrentHashMap<String, Consumption>();
    }

    @GET
    public Response getEvents(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        ArrayList<Consumption> events = new ArrayList<Consumption>();
        events.addAll(this.consumptionsMap.values());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(events).build();
    }

    public void addConsumption(Consumption consumption) {
        this.consumptionsMap.put(consumption.getId(), consumption);
    }

    @DELETE
    @Path(value="/{id}")
    public Response removeConsumption(@Auth BearerUser user, @PathParam(value="id") String id) {
        id = new String(Base64.getDecoder().decode(id), StandardCharsets.UTF_8);
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        this.consumptionsMap.remove(id);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("utilizationRemoved")).build();
    }
}

