/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.server.workers.EngineWorker;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizedEnum;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineCommand;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.BootstrappableJob;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

@Path(value="/v1/server/engines")
@Produces(value={"application/json"})
public class EnginesResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EnginesResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private ServerApplication serverApplication;
    private ServerConfiguration serverConfiguration;
    private Map<String, EngineWorker> engineWorkers;
    private boolean closing;
    private static final long INITIALIZING_JOB_COMMAND_TIMEOUT = 3000L;

    public EnginesResource(ServerApplication serverApplication, ServerConfiguration serverConfiguration) {
        this.serverApplication = serverApplication;
        this.serverConfiguration = serverConfiguration;
        this.engineWorkers = new ConcurrentHashMap<String, EngineWorker>();
    }

    public boolean getClosing() {
        return this.closing;
    }

    public void setClosing() {
        this.closing = true;
    }

    public Map<String, EngineWorker> getEngineWorkers() {
        return this.engineWorkers;
    }

    @GET
    public List<EngineModel> listEngines(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return new ArrayList<EngineModel>();
        }
        TreeSet<EngineModel> engines = new TreeSet<EngineModel>();
        for (String engineIds : this.engineWorkers.keySet()) {
            EngineModel engineModel = this.engineWorkers.get(engineIds).getModel();
            engineModel.setServerId(this.serverApplication.getInstanceId());
            engines.add(engineModel);
        }
        ArrayList<EngineModel> enginesList = new ArrayList<EngineModel>();
        enginesList.addAll(engines);
        return enginesList;
    }

    @Path(value="/{engineId}")
    @GET
    public Response getEngine(@Auth BearerUser user, final @PathParam(value="engineId") String engineId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        EngineWorker engineWorker = this.engineWorkers.get(engineId);
        if (engineWorker == null) {
            LOGGER.error("Cannot find engine with ID " + engineId);
            return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                {
                    this.put("engineId", engineId);
                }
            });
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)engineWorker.getModel()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addEngine(@Auth BearerUser user, EngineModel engine) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received request to add a new engine with name " + engine.getName());
        if (engine.getName() == null || engine.getName().trim().length() == 0) {
            LOGGER.error("Invalid engine name " + engine.getName());
            return ExceptionUtils.toResponse((String)"invalidEngineName", (Map)null);
        }
        if (engine.getId() == null) {
            engine.setId(UidUtils.getRandom());
        }
        engine.setServerId(this.serverApplication.getInstanceId());
        engine.setNuixVersion("");
        engine.setJavaVersion("");
        engine.setCurrentExecutionMode(null);
        engine.setStatus(null);
        engine.setError("");
        engine.setEngineVersion("");
        return this.addEngineInternal(engine);
    }

    public void addEnginesFromStore() {
        LOGGER.info("Adding Engines from store");
        List<EngineModel> engineModels = this.serverApplication.getEngineServerConfigurationDao().getServerEngines(this.serverApplication.getInstanceId());
        for (EngineModel engineModel : engineModels) {
            engineModel.setServerId(this.serverApplication.getInstanceId());
            this.initializeEngineWorker(engineModel);
        }
    }

    private EngineWorker initializeEngineWorker(EngineModel engine) {
        EngineWorker engineWorker = new EngineWorker(this.serverApplication, engine);
        this.engineWorkers.put(engine.getId(), engineWorker);
        Timer timer = new Timer(true);
        timer.schedule((TimerTask)engineWorker, 0L, this.serverApplication.getConfiguration().getEnginePingInterval());
        return engineWorker;
    }

    private Response addEngineInternal(EngineModel engine) {
        LOGGER.info("Received request to add " + engine);
        try {
            boolean serverWithNameExists = false;
            for (EngineWorker engineWorker : this.engineWorkers.values()) {
                if (engineWorker.getModel() == null || engineWorker.getModel().getName() == null || !engineWorker.getModel().getName().equals(engine.getName())) continue;
                serverWithNameExists = true;
                break;
            }
            if (serverWithNameExists) {
                LOGGER.error("An engine with name " + engine.getName() + " already exists");
                return ExceptionUtils.toResponse((String)"engineExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            engine.setName(engine.getName().trim());
            if (this.serverApplication.getEngineServerConfigurationDao().updateEngine(engine) == 0) {
                this.serverApplication.getEngineServerConfigurationDao().addEngine(engine);
            }
            this.initializeEngineWorker(engine);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)engine).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot add engine", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotAddEngine", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/command")
    @PUT
    public Response sendEngineCommand(@Auth BearerUser user, @PathParam(value="engineId") String engineId, final EngineCommand engineCommand) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received command " + engineCommand.getCommand() + " for " + engineId);
        EngineWorker engineWorker = this.engineWorkers.get(engineId);
        if (engineWorker == null) {
            LOGGER.error("Cannot send command " + engineCommand + " to missing engine worker");
            return ExceptionUtils.toResponse((String)"cannotSendCommandEngineJob", (Map)new HashMap<String, String>(){
                {
                    this.put("engineCommandModel", "" + engineCommand.getCommand());
                }
            });
        }
        final EngineStatus engineStatus = engineWorker.getModel().getStatus();
        LOGGER.info(engineWorker.getModel() + " run command " + engineCommand.toString());
        JobModel engineJobModel = engineWorker.getJobModel();
        boolean commandForRunningJob = false;
        if (engineJobModel != null && engineJobModel.getId().equals(engineCommand.getJobId())) {
            commandForRunningJob = true;
        }
        try {
            switch (engineCommand.getCommand()) {
                case RUN_BOOTSTRAPPED_JOB: {
                    if (engineStatus != EngineStatus.PENDING) {
                        LOGGER.error("Cannot send command " + engineCommand + " to engine with status " + engineStatus);
                        return ExceptionUtils.toResponse((String)"cannotSendCommandEngineIn", (Map)new HashMap<String, String>(){
                            {
                                this.put("engineCommandModel", "" + engineCommand.getCommand());
                                this.put("engineStatus", "" + engineStatus);
                            }
                        });
                    }
                    engineWorker.runBootstrappedJob();
                    break;
                }
                case SLEEP: {
                    if (engineStatus == EngineStatus.FINISHED) {
                        engineWorker.acknowledgeFinishedStatus();
                        break;
                    }
                    if (engineStatus == EngineStatus.RUNNING && engineWorker.getModel().getWorkerAgentOnly()) {
                        engineWorker.acknowledgeWorkerAgentJobDone();
                        break;
                    }
                    LOGGER.error("Cannot send command " + engineCommand + " to " + engineWorker.getModel());
                    return ExceptionUtils.toResponse((String)"cannotSendCommandEngineIn", (Map)new HashMap<String, String>(){
                        {
                            this.put("engineCommandModel", "" + engineCommand.getCommand());
                            this.put("engineStatus", "" + engineStatus);
                        }
                    });
                }
                case SHUTDOWN: {
                    engineWorker.shutdown(true);
                    break;
                }
                case ABORT: {
                    if (commandForRunningJob || engineJobModel == null) {
                        engineWorker.abort();
                        break;
                    }
                    LOGGER.error("Cannot send command " + engineCommand + " to different job");
                    return ExceptionUtils.toResponse((String)"cannotSendCommandEngineJobRunning", (Map)new HashMap<String, String>(){
                        {
                            this.put("engineCommandModel", "" + engineCommand.getCommand());
                        }
                    });
                }
                case SKIP: {
                    if (commandForRunningJob || engineJobModel == null) {
                        engineWorker.skipOperation(engineCommand.getOperationId());
                        break;
                    }
                    LOGGER.error("Cannot send command " + engineCommand + " to different job");
                    return ExceptionUtils.toResponse((String)"cannotSendCommandEngineJobRunning", (Map)new HashMap<String, String>(){
                        {
                            this.put("engineCommandModel", "" + engineCommand.getCommand());
                        }
                    });
                }
                case STOP: {
                    if (commandForRunningJob) {
                        engineWorker.stop();
                        break;
                    }
                    LOGGER.error("Cannot send command " + engineCommand + " to different job");
                    return ExceptionUtils.toResponse((String)"cannotSendCommandEngineJobRunning", (Map)new HashMap<String, String>(){
                        {
                            this.put("engineCommandModel", "" + engineCommand.getCommand());
                        }
                    });
                }
                case PAUSE: {
                    if (commandForRunningJob) {
                        engineWorker.pause();
                        break;
                    }
                    LOGGER.error("Cannot send command " + engineCommand + " to different job");
                    return ExceptionUtils.toResponse((String)"cannotSendCommandEngineJobRunning", (Map)new HashMap<String, String>(){
                        {
                            this.put("engineCommandModel", "" + engineCommand.getCommand());
                        }
                    });
                }
                default: {
                    return ExceptionUtils.toResponse((String)"unexpectedCommandEngine", (Map)new HashMap<String, String>(){
                        {
                            this.put("engineCommandModel", "" + engineCommand.getCommand());
                        }
                    });
                }
            }
        }
        catch (NullPointerException | RemoteException e) {
            LOGGER.error("Cannot send command", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotSendCommand", (Map)new HashMap<String, String>(){
                {
                    this.put("engineCommandModel", "" + engineCommand.getCommand());
                }
            }, (Exception)e);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)engineWorker.getModel()).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{engineId}")
    @PUT
    public Response updateEngine(@Parameter(hidden=true) @Auth BearerUser user, final @PathParam(value="engineId") String engineId, EngineModel engineModel) {
        EngineWorker originalEngineWorker = this.engineWorkers.get(engineId);
        if (originalEngineWorker == null) {
            return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                {
                    this.put("engineId", engineId);
                }
            });
        }
        EngineModel originalEngineModel = originalEngineWorker.getModel();
        if (engineModel.getName() != null) {
            for (EngineWorker engineWorker : this.engineWorkers.values()) {
                EngineModel existingEngine;
                if (engineWorker == originalEngineWorker || engineWorker == null || (existingEngine = engineWorker.getModel()) == null || !existingEngine.getName().equals(engineModel.getName())) continue;
                return ExceptionUtils.toResponse((String)"engineSameNameExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalEngineModel.setName(engineModel.getName());
        }
        if (engineModel.getSupportedExecutionMode() != null) {
            originalEngineModel.setSupportedExecutionMode(engineModel.getSupportedExecutionMode());
        }
        if (engineModel.getTargetNuixWorkers() != null) {
            originalEngineModel.setTargetNuixWorkers(engineModel.getTargetNuixWorkers());
        }
        if (engineModel.getMinNuixWorkers() != null) {
            originalEngineModel.setMinNuixWorkers(engineModel.getMinNuixWorkers());
        }
        if (engineModel.getPriority() != null) {
            originalEngineModel.setPriority(engineModel.getPriority());
        }
        if (engineModel.getNuixLicenceSourceId() != null) {
            originalEngineModel.setNuixLicenceSourceId(engineModel.getNuixLicenceSourceId());
        }
        originalEngineModel.setExecutionProfileId(engineModel.getExecutionProfileId());
        if (engineModel.getSupportedExecutionMode().equals((Object)ExecutionMode.AUTOMATE_NATIVE)) {
            originalEngineModel.setSupportedExecutionMode(ExecutionMode.AUTOMATE_NATIVE);
            originalEngineModel.setNuixLicenceSourceId(null);
            originalEngineModel.setTargetNuixWorkers(null);
            originalEngineModel.setMinNuixWorkers(null);
        }
        if (this.serverApplication.getEngineServerConfigurationDao().updateEngine(originalEngineModel) == 0) {
            this.serverApplication.getEngineServerConfigurationDao().addEngine(originalEngineModel);
        }
        originalEngineWorker.updateEngine();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)originalEngineModel).build();
    }

    @Path(value="/{engineId}")
    @DELETE
    public Response removeEngine(@Auth BearerUser user, final @PathParam(value="engineId") String engineId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received request to delete engine " + engineId);
        final EngineWorker engineWorker = this.engineWorkers.get(engineId);
        if (engineWorker == null) {
            return ExceptionUtils.toResponse((String)"cannotFindEngine", (Map)new HashMap<String, String>(){
                {
                    this.put("engineId", engineId);
                }
            });
        }
        final EngineStatus engineStatus = engineWorker.getModel().getStatus();
        if (engineStatus == EngineStatus.RUNNING || engineStatus == EngineStatus.FINISHED) {
            return ExceptionUtils.toResponse((String)"cannotDeleteEngineItIn", (Map)new HashMap<String, String>(){
                {
                    this.put("engineWorker", engineWorker.getModel().getName());
                    this.put("engineStatus", "" + engineStatus);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        this.serverApplication.getEngineServerConfigurationDao().deleteEngine(engineId);
        try {
            this.engineWorkers.remove(engineId);
            engineWorker.close();
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("engineDeleted", (Map)new HashMap<String, String>(){
                {
                    this.put("engineWorker", engineWorker.getModel().getName());
                }
            })).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete engine", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotDeleteEngine", (Map)new HashMap<String, String>(){
                {
                    this.put("engineId", engineId);
                }
            }, (Exception)e);
        }
    }

    @DELETE
    public Response removeAllEngines(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received request to delete all engines");
        HashSet<String> engineIds = new HashSet<String>();
        engineIds.addAll(this.engineWorkers.keySet());
        for (String engineId : engineIds) {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            EngineStatus engineStatus = engineWorker.getModel().getStatus();
            if (engineStatus == EngineStatus.RUNNING || engineStatus == EngineStatus.FINISHED) {
                LOGGER.warn("Cannot delete engine " + engineId + " because it is in state " + engineStatus);
                continue;
            }
            this.serverApplication.getEngineServerConfigurationDao().deleteEngine(engineId);
            this.engineWorkers.remove(engineId);
            engineWorker.close();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").build();
    }

    public void removeAllEnginesInternal() {
        HashSet<String> engineIds = new HashSet<String>();
        engineIds.addAll(this.engineWorkers.keySet());
        for (String engineId : engineIds) {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            EngineStatus engineStatus = engineWorker.getModel().getStatus();
            if (engineStatus == EngineStatus.RUNNING || engineStatus == EngineStatus.FINISHED) {
                try {
                    engineWorker.abort();
                }
                catch (RemoteException e) {
                    LOGGER.warn("Cannot remove " + engineWorker, (Throwable)e);
                }
            }
            this.engineWorkers.remove(engineId);
            engineWorker.close();
        }
    }

    @Path(value="/{engineId}/job")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response bootstrapJob(@Auth BearerUser user, final @PathParam(value="engineId") String engineId, BootstrappableJob bootstrappableJob) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        try {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            if (engineWorker == null) {
                return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                    {
                        this.put("engineId", engineId);
                    }
                });
            }
            LOGGER.info("Received request to bootstrap on " + engineWorker.getModel());
            if (engineWorker.getModel().getStatus() != EngineStatus.STANDBY) {
                throw new IllegalStateException(this.iu.getFormattedString("EngineResource.CannotRunJobInState", (Object)new LocalizedEnum("SchedulerText", (Enum)engineWorker.getModel().getStatus()).toString()));
            }
            ExecutionProfileModel executionProfileModel = this.serverApplication.getServerExecutionProfiles().get(bootstrappableJob.getJobModel().getExecutionProfileId());
            bootstrappableJob.setExecutionProfile(executionProfileModel);
            if (bootstrappableJob.getExecutionProfile() == null) {
                throw new IllegalStateException(this.iu.getFormattedString("EngineResource.CannotFindExecutionProfile", (Object)bootstrappableJob.getJobModel().getExecutionProfileId()));
            }
            EngineModel remoteEngine = engineWorker.bootstrapJob(bootstrappableJob);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)remoteEngine).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot run job", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotRunJob", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/remoteJob")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response joinRemoteJob(@Auth BearerUser user, final @PathParam(value="engineId") String engineId, BootstrappableJob bootstrappableJob) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        try {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            if (engineWorker == null) {
                return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                    {
                        this.put("engineId", engineId);
                    }
                });
            }
            LOGGER.info("Received request to bootstrap on " + engineWorker.getModel());
            if (engineWorker.getModel().getStatus() != EngineStatus.STANDBY) {
                throw new IllegalStateException(this.iu.getFormattedString("EngineResource.CannotRunJobInState", (Object)new LocalizedEnum("SchedulerText", (Enum)engineWorker.getModel().getStatus()).toString()));
            }
            ExecutionProfileModel executionProfileModel = this.serverApplication.getServerExecutionProfiles().get(bootstrappableJob.getJobModel().getExecutionProfileId());
            bootstrappableJob.setExecutionProfile(executionProfileModel);
            if (bootstrappableJob.getExecutionProfile() == null) {
                throw new IllegalStateException(this.iu.getFormattedString("EngineResource.CannotFindExecutionProfile", (Object)bootstrappableJob.getJobModel().getExecutionProfileId()));
            }
            EngineModel remoteEngine = engineWorker.joinRemoteJob(bootstrappableJob);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)remoteEngine).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot run job", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotRunJob", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/job")
    @GET
    public Response getJobModel(@Auth BearerUser user, @PathParam(value="engineId") String engineId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        try {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            if (engineWorker == null) {
                return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)null);
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)engineWorker.getJobModel()).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get job info", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotGetJobInfo", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/jobOperations")
    @GET
    public Response getJobOperations(@Auth BearerUser user, final @PathParam(value="engineId") String engineId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        try {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            if (engineWorker == null) {
                return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                    {
                        this.put("engineId", engineId);
                    }
                });
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(engineWorker.getOperations()).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get job info", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotGetJobInfo", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/jobs/{id}/settings")
    @Produces(value={"application/json"})
    @PUT
    public Response updateJobSettings(@Auth BearerUser user, final @PathParam(value="engineId") String engineId, @PathParam(value="id") String workflowId, JobModel newJobModel) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received request to update settings for job id " + workflowId);
        EngineWorker engineWorker = this.engineWorkers.get(engineId);
        if (engineWorker == null) {
            return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                {
                    this.put("engineId", engineId);
                }
            });
        }
        if (engineWorker.getJobModel() == null || !engineWorker.getJobModel().getId().equals(workflowId)) {
            LOGGER.warn("Received command for " + engineWorker.getModel() + " to update settings of workflow with ID " + workflowId + " but engine is currently running " + engineWorker.getJobModel());
            return ExceptionUtils.toResponse((String)"cannotUpdateSettingsEngineCurrently", (Map)null);
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)engineWorker.updateJobModel(newJobModel)).build();
        }
        catch (NullPointerException | RemoteException e) {
            LOGGER.error("Cannot update settings", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotUpdateSettings", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/jobDetails")
    @GET
    public Response getJobDetails(@Auth BearerUser user, final @PathParam(value="engineId") String engineId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        try {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            if (engineWorker == null) {
                return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                    {
                        this.put("engineId", engineId);
                    }
                });
            }
            if (engineWorker.getJobModel() == null) {
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(null).build();
            }
            JobDetailsModel jobDetailsModel = new JobDetailsModel();
            JobModel jobSettings = new JobModel(engineWorker.getJobModel());
            jobSettings.setJobApiBearerToken(null);
            jobDetailsModel.setSettings(jobSettings);
            List<OperationStatus> operations = engineWorker.getOperations();
            jobDetailsModel.setOperations(operations);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)jobDetailsModel).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get job info", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotGetJobInfo", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/operationMimeTypeStats")
    @GET
    public Response getOperationMimeTypeStats(@Auth BearerUser user, final @PathParam(value="engineId") String engineId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        try {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            if (engineWorker == null) {
                return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                    {
                        this.put("engineId", engineId);
                    }
                });
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(engineWorker.getOperationMimeTypeStats()).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get job mime type info", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotGetJobInfo", (Map)null, (Exception)e);
        }
    }

    @Path(value="/{engineId}/runningLog")
    @GET
    public Response getRunningLog(@Auth BearerUser user, final @PathParam(value="engineId") String engineId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        try {
            EngineWorker engineWorker = this.engineWorkers.get(engineId);
            if (engineWorker == null) {
                return ExceptionUtils.toResponse((String)"cannotFindEngineId", (Map)new HashMap<String, String>(){
                    {
                        this.put("engineId", engineId);
                    }
                });
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)engineWorker.getRunningLog()).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get running log", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotGetJobInfo", (Map)null, (Exception)e);
        }
    }

    @Path(value="/users")
    @GET
    public Response getActiveUsers(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        HashSet<String> users = new HashSet<String>();
        try {
            for (EngineWorker engineWorker : this.engineWorkers.values()) {
                String userName;
                JobModel jobModel = engineWorker.getJobModel();
                if (jobModel == null || (userName = jobModel.getSubmittedBy()) == null) continue;
                users.add(userName);
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(users).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get server info", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotGetServerInfo", (Map)null, (Exception)e);
        }
    }
}

