/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

@Path(value="/v1/server/job")
@Produces(value={"application/json"})
public class JobFileResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobFileResource.class);
    private final java.nio.file.Path jobFilesDirectory;

    public JobFileResource(String directory) {
        this.jobFilesDirectory = Paths.get(directory, new String[0]);
        try {
            Files.createDirectories(this.jobFilesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error creating jobFile directories", (Throwable)e);
        }
    }

    public java.nio.file.Path getJobFilesDirectory() {
        return this.jobFilesDirectory;
    }

    @Path(value="/{id}/file/{fileName}")
    @GET
    public Response getFile(@Auth BearerUser user, @PathParam(value="id") String jobId, @PathParam(value="fileName") String fileName) {
        java.nio.file.Path filePath;
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return ExceptionUtils.toResponse((String)"userNotAllowedToUseApi", (Response.Status)Response.Status.UNAUTHORIZED);
        }
        try {
            filePath = FileUtils.safeResolveParent((java.nio.file.Path)this.jobFilesDirectory, (String[])new String[]{jobId, fileName});
            if (!Files.exists(filePath, new LinkOption[0])) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"File not found").build();
            }
        }
        catch (FileTraversalException e) {
            LOGGER.error("Error, detected file traversal attempt: " + fileName, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        LOGGER.info("Uploading file: " + filePath);
        StreamingOutput streamingOutput = outputStream -> {
            long startEpoch = System.currentTimeMillis();
            LOGGER.info("File " + fileName + " upload start epoch " + startEpoch);
            Files.copy(filePath, outputStream);
            outputStream.flush();
            long endEpoch = System.currentTimeMillis();
            long durationSeconds = (endEpoch - startEpoch) / 1000L;
            if (durationSeconds == 0L) {
                durationSeconds = 1L;
            }
            LOGGER.info("File " + fileName + " upload finish epoch " + endEpoch);
            LOGGER.info("File " + fileName + " upload duration " + durationSeconds + " s");
        };
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)streamingOutput, (String)fileName);
    }
}

