/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import com.nuix.automate.utils.models.internal.logging.ServerLogEventsModel;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Path(value="/v1/server/logs")
@Produces(value={"application/json"})
public class LogsResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LogsResource.class);
    private ServerApplication serverApplication;
    private ServerConfiguration serverConfiguration;
    private Map<String, ServerLogEventsModel> logsMap;
    private AtomicInteger logMapLogLines;
    private AtomicInteger totalLogLinesDiscarded;
    private Map<String, ServerLogEventsModel> executionLogsMap;
    private LogHandler logHandler;

    public LogsResource(ServerApplication serverApplication) {
        this.serverApplication = serverApplication;
        this.serverConfiguration = serverApplication.getConfiguration();
        this.logHandler = LogHandler.getInstance();
        this.logsMap = new LinkedHashMap<String, ServerLogEventsModel>();
        this.logMapLogLines = new AtomicInteger();
        this.totalLogLinesDiscarded = new AtomicInteger();
        this.executionLogsMap = new LinkedHashMap<String, ServerLogEventsModel>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response getLogs(@Auth BearerUser user) {
        ArrayList<ServerLogEventsModel> serverLogs;
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        List logs = this.logHandler.removeComponentLogs();
        if (logs.size() > 0) {
            this.addLogs(logs);
        }
        Map<String, ServerLogEventsModel> map = this.logsMap;
        synchronized (map) {
            serverLogs = new ArrayList<ServerLogEventsModel>(this.logsMap.values());
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(serverLogs).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/executionLogs")
    public Response getExecutionLogs(@Auth BearerUser user) {
        ArrayList<ServerLogEventsModel> serverExecutionLogs;
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        Map<String, ServerLogEventsModel> map = this.executionLogsMap;
        synchronized (map) {
            serverExecutionLogs = new ArrayList<ServerLogEventsModel>(this.executionLogsMap.values());
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(serverExecutionLogs).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogs(List<LogEventModel> logs) {
        ServerLogEventsModel model = new ServerLogEventsModel();
        model.setId(UidUtils.getRandom());
        model.setLogs(logs);
        Map<String, ServerLogEventsModel> map = this.logsMap;
        synchronized (map) {
            int newLogLines = model.getLogs().size();
            if (newLogLines > 0) {
                int totalLogLines = this.logMapLogLines.get() + newLogLines;
                if (this.serverConfiguration.getCentralizedLoggingMaxActiveLines() < totalLogLines) {
                    if (this.totalLogLinesDiscarded.get() == 0) {
                        LOGGER.warn("Discarded log lines: " + newLogLines + ". Current log lines in memory: " + this.logMapLogLines.get() + ". Future related messages will be silenced.");
                    }
                    this.totalLogLinesDiscarded.addAndGet(newLogLines);
                } else {
                    this.logMapLogLines.addAndGet(newLogLines);
                    this.logsMap.put(model.getId(), model);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionLogs(List<LogEventModel> executionLogs) {
        ServerLogEventsModel model = new ServerLogEventsModel();
        model.setId(UidUtils.getRandom());
        model.setLogs(executionLogs);
        Map<String, ServerLogEventsModel> map = this.executionLogsMap;
        synchronized (map) {
            this.executionLogsMap.put(model.getId(), model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{id}")
    public Response removeLogs(@Auth BearerUser user, @PathParam(value="id") String id) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        Map<String, ServerLogEventsModel> map = this.logsMap;
        synchronized (map) {
            ServerLogEventsModel removedLogLines = this.logsMap.remove(id);
            if (removedLogLines != null) {
                this.logMapLogLines.addAndGet(-removedLogLines.getLogs().size());
                if (this.totalLogLinesDiscarded.get() > 0) {
                    LOGGER.warn("Memory log lines cleared. Total discarded log lines: " + this.totalLogLinesDiscarded.get());
                    this.totalLogLinesDiscarded.set(0);
                }
            }
        }
        map = this.executionLogsMap;
        synchronized (map) {
            this.executionLogsMap.remove(id);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("logsRemoved")).build();
    }
}

