/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowDynamicUpdate;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Path(value="/v1/server/workflowDynamicUpdate")
@Produces(value={"application/json"})
public class WorkflowDynamicUpdatesResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowDynamicUpdatesResource.class);
    private ServerApplication serverApplication;
    private ServerConfiguration serverConfiguration;
    private Map<String, WorkflowDynamicUpdate> workflowDynamicUpdates;

    public WorkflowDynamicUpdatesResource(ServerApplication serverApplication) {
        this.serverApplication = serverApplication;
        this.workflowDynamicUpdates = new ConcurrentHashMap<String, WorkflowDynamicUpdate>();
    }

    @GET
    public Response getWorkflowDynamicUpdate(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(this.workflowDynamicUpdates).build();
    }

    public void addWorkflowDynamicUpdate(WorkflowDynamicUpdate event) {
        this.workflowDynamicUpdates.put(UidUtils.getRandom(), event);
    }

    @DELETE
    @Path(value="/{id}")
    public Response removeProcessingEvents(@Auth BearerUser user, @PathParam(value="id") String id) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        this.workflowDynamicUpdates.remove(id);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("eventsRemoved")).build();
    }
}

