/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.workers;

import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.server.resources.ConsumptionResource;
import com.nuix.automate.server.resources.LogsResource;
import com.nuix.automate.server.resources.ProcessingEventsResource;
import com.nuix.automate.server.resources.SessionResource;
import com.nuix.automate.server.resources.UtilizationResource;
import com.nuix.automate.server.resources.WorkflowDynamicUpdatesResource;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.general.CommandLineUtils;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.JavaUtils;
import com.nuix.automate.utils.general.OperationMimeTypeStats;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.Type;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.job.JobOperationEvent;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowDynamicUpdate;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.BootstrappableJob;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.logging.RunningLogEventsModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.utilization.OperationUtilizationModel;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.workers.EngineStub;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EngineWorker
extends TimerTask
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private EngineModel model;
    private ServerApplication serverApplication;
    private ServerConfiguration configuration;
    private NuixLicenseSourceModel runTimeNuixLicenceSource;
    private ExecutionProfileModel initializationExecutionProfile;
    private boolean licenseSourceError;
    private Process jvmProcess;
    private EngineStub engineStub;
    private boolean isShuttingDown;
    private boolean isInitializing;
    private Thread readStandardErrorThread;
    private Thread readStandardOutputThread;
    private BootstrappableJob bootstrappableJob;
    private long lastKeepAlivePing;
    private Thread startEngineJavaAppThread;
    private String logLocation;
    private String shortEngineName;
    private String logFolder;
    private String serviceBaseName;
    private boolean serviceStarted;
    private final Object serviceCommandLock = new Object();
    private ExecutionMode executionMode;
    private List<OperationStatus> operations;
    private Semaphore handleEnginePingSemaphore;
    private Semaphore handleEngineSettingsSemaphore;
    private Semaphore handleExecutionLogsSemaphore;
    private Semaphore handleOperationsSemaphore;
    private Semaphore handleJobStatusSemaphore;
    private Semaphore handleJobUtilizationSemaphore;
    private Semaphore handleConsumptionSessionEventsSemaphore;
    private Semaphore handleJobProcessingEventsSemaphore;
    private Semaphore handleWorkflowDynamicUpdatesSemaphore;
    private Semaphore handleEngineLogsSemaphore;
    private long maxEnginePingDuration;
    private long maxEngineSettingsDuration;
    private long maxExecutionLogsDuration;
    private long maxOperationsDuration;
    private long maxJobStatusDuration;
    private long maxJobUtilizationDuration;
    private long maxSessionEventsDuration;
    private long maxJobProcessingEventsDuration;
    private long maxWorkflowDynamicUpdatesDuration;
    private long maxEngineLogsDuration;

    public EngineWorker(ServerApplication serverApplication, EngineModel model) {
        this.serverApplication = serverApplication;
        this.configuration = serverApplication.getConfiguration();
        this.model = model;
        model.setStatus(EngineStatus.NOT_INITIALIZED);
        this.configuration.getLoggingFactory();
        this.isShuttingDown = false;
        this.isInitializing = true;
        this.initSemaphores();
    }

    public EngineModel getModel() {
        return this.model;
    }

    public List<OperationStatus> getOperations() {
        return this.operations;
    }

    private EngineStub getEngineStub() throws InterruptedException {
        return this.getEngineStub(0);
    }

    private EngineStub getEngineStub(int retries) throws InterruptedException {
        for (int i = 0; i < retries + 1 && !this.isShuttingDown; ++i) {
            if (i > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Wait for JVM process to either close or initialize, " + i);
                }
                if (this.jvmProcess != null && this.jvmProcess.isAlive()) {
                    Thread.sleep(1000L);
                } else {
                    Thread.sleep(100L);
                }
            }
            try {
                this.engineStub = (EngineStub)this.serverApplication.getServerWorker().getRegistry().lookup(this.model.getId());
                return this.engineStub;
            }
            catch (NullPointerException | NotBoundException | RemoteException e) {
                if (i <= 0 || !LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Cannot get Engine, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                continue;
            }
        }
        return null;
    }

    private void readOutputStream(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            LOGGER.info(line);
        }
    }

    private void resetMaxDurations() {
        this.maxEnginePingDuration = 100L;
        this.maxEngineSettingsDuration = 100L;
        this.maxExecutionLogsDuration = 100L;
        this.maxOperationsDuration = 100L;
        this.maxJobStatusDuration = 100L;
        this.maxJobUtilizationDuration = 100L;
        this.maxSessionEventsDuration = 100L;
        this.maxJobProcessingEventsDuration = 100L;
        this.maxWorkflowDynamicUpdatesDuration = 100L;
        this.maxEngineLogsDuration = 100L;
    }

    private void readErrorStream(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            boolean maskMessage = false;
            if (line.startsWith("ERROR StatusLogger No Log4j")) {
                maskMessage = true;
            }
            if (line.startsWith("#< CLIXML")) {
                maskMessage = true;
            }
            if (line.startsWith("<Objs Version")) {
                maskMessage = true;
            }
            if (line.toLowerCase().contains("illegal reflective access")) {
                maskMessage = true;
            }
            if (line.contains("Please consider reporting")) {
                maskMessage = true;
            }
            if (line.toLowerCase().contains("illegal reflective access")) {
                maskMessage = true;
            }
            if (line.toLowerCase().contains("illegal access operations")) {
                maskMessage = true;
            }
            if (line.contains("SLF4J: ")) {
                maskMessage = true;
            }
            if (line.startsWith("WARNING:")) {
                maskMessage = true;
            }
            if (maskMessage) {
                LOGGER.warn(line);
                continue;
            }
            LOGGER.error(line);
            this.model.appendErrorLine(line.replaceFirst("^Error: ", ""));
        }
    }

    private void initializeEngine() {
        ExecutionProfileModel executionProfileModel;
        BootstrappableJob emptyBootstrappableJob = new BootstrappableJob();
        if (this.model != null && this.model.getExecutionProfileId() != null && (executionProfileModel = this.serverApplication.getServerExecutionProfiles().get(this.model.getExecutionProfileId())) != null) {
            emptyBootstrappableJob.setExecutionProfile(executionProfileModel);
        }
        this.runEngineJavaApp(emptyBootstrappableJob, this.serverApplication.getServerRampivaLicence(), false);
    }

    public synchronized EngineModel bootstrapJob(BootstrappableJob bootstrappableJob) {
        this.bootstrappableJob = bootstrappableJob;
        this.getModel().setWorkerAgentOnly(false);
        this.runEngineJavaApp(bootstrappableJob, this.serverApplication.getServerRampivaLicence(), false);
        return this.model;
    }

    public synchronized EngineModel joinRemoteJob(BootstrappableJob bootstrappableJob) {
        this.bootstrappableJob = bootstrappableJob;
        this.getModel().setWorkerAgentOnly(true);
        this.runEngineJavaApp(bootstrappableJob, this.serverApplication.getServerRampivaLicence(), true);
        return this.model;
    }

    private void killServiceHandler(String signature) {
        EngineWorker engineWorker = this;
        if (engineWorker.configuration.getOsWindows()) {
            String killCommand = "wmic Path win32_process Where \"CommandLine Like '%" + signature + "%'\" Call Terminate";
            LOGGER.info("Attempting to kill service handler: " + killCommand);
            try {
                Runtime.getRuntime().exec(killCommand).waitFor(this.configuration.getEngineShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.warn("Cannot run Windows kill command", (Throwable)e);
            }
        }
    }

    private void killJavaProcess() {
        EngineWorker engineWorker = this;
        String killCommand = engineWorker.configuration.getOsWindows() ? "wmic Path win32_process Where \"CommandLine Like '%-Dkill.signature=k177" + this.model.getId() + "%'\" Call Terminate" : "pkill -f 'Dkill.signature=k177" + this.model.getId() + "'";
        LOGGER.info("Attempting to kill previously running process: " + killCommand);
        try {
            Runtime.getRuntime().exec(killCommand).waitFor(this.configuration.getEngineShutdownTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Cannot run kill command", (Throwable)e);
        }
        EngineWorker engineWorker2 = this;
        if (engineWorker2.configuration.getOsWindows()) {
            this.stopService(false);
            this.uninstallService(false);
        }
    }

    private void readStandardErrorAsync(Process process) {
        this.readStandardErrorThread = new Thread(() -> {
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                LOGGER.info("Starting stderr redirect");
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
            }
        });
        this.readStandardErrorThread.setName(this.shortEngineName + " stderr");
        this.readStandardErrorThread.start();
    }

    private void readStandardOutputAsync(Process process) {
        this.readStandardOutputThread = new Thread(() -> {
            try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                LOGGER.info("Starting stdout redirect");
                this.readOutputStream(inputReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
            }
        });
        this.readStandardOutputThread.setName(this.shortEngineName + " stdout");
        this.readStandardOutputThread.start();
    }

    private void stopService(boolean logErrors) {
        this.sendServiceCommand("stop", logErrors);
    }

    private void uninstallService(boolean logErrors) {
        this.sendServiceCommand("uninstall", logErrors);
        this.serviceStarted = false;
    }

    private void deleteServiceLogs(boolean logErrors) {
        this.sendServiceCommand("deleteLogs", logErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendServiceCommand(String command, boolean logErrors) {
        Object object = this.serviceCommandLock;
        synchronized (object) {
            block20: {
                File destinationServiceWrapperFile;
                block19: {
                    if (this.logFolder == null) {
                        if (logErrors) {
                            LOGGER.warn("Skipping service cleanup because logFolder is not defined");
                        }
                        return;
                    }
                    if (this.serviceBaseName == null) {
                        if (logErrors) {
                            LOGGER.warn("Skipping service cleanup because serviceBaseName is not defined");
                        }
                        return;
                    }
                    if (command.equals("deleteLogs")) {
                        String[] logFileSuffixes;
                        for (String suffix : logFileSuffixes = new String[]{".err.log", ".out.log", ".wrapper.log", ".xml", ".exe"}) {
                            File deleteFile = new File(this.logFolder + "/" + this.serviceBaseName + suffix);
                            if (!deleteFile.exists() || deleteFile.delete()) continue;
                            LOGGER.warn(this.model + " cannot delete " + deleteFile.getAbsolutePath());
                        }
                        return;
                    }
                    File sourceServiceWrapperFile = new File(System.getenv("ProgramFiles") + "\\Nuix\\Automate\\EngineServer\\Automate Engine Server.exe");
                    destinationServiceWrapperFile = new File(this.logFolder + "/" + this.serviceBaseName + ".exe");
                    try {
                        this.copyFileIfNotDifferent(Paths.get(sourceServiceWrapperFile.getAbsolutePath(), new String[0]), Paths.get(destinationServiceWrapperFile.getAbsolutePath(), new String[0]));
                    }
                    catch (IOException e) {
                        this.killServiceHandler(this.serviceBaseName);
                        if (!logErrors) break block19;
                        LOGGER.warn(this.model + " Cannot copy handler to " + destinationServiceWrapperFile.getAbsolutePath() + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    }
                }
                ArrayList<String> commandLine = new ArrayList<String>();
                commandLine.add(destinationServiceWrapperFile.getAbsolutePath());
                commandLine.add(command);
                if (logErrors) {
                    LOGGER.info(this.model + " " + String.join((CharSequence)" ", commandLine));
                }
                ProcessBuilder builder = new ProcessBuilder(commandLine);
                try {
                    Process serviceHandlerProcess = builder.start();
                    try {
                        serviceHandlerProcess.waitFor(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(this.model + " Cannot wait for process to finish", (Throwable)e);
                    }
                    if (serviceHandlerProcess.exitValue() != 0) {
                        if (logErrors) {
                            LOGGER.warn(this.model + " Stop service exited with code: " + serviceHandlerProcess.exitValue());
                        }
                    } else {
                        LOGGER.info(this.model + " Stopped service");
                    }
                }
                catch (IOException e) {
                    if (!logErrors) break block20;
                    LOGGER.warn(this.model + " Cannot stop service", (Throwable)e);
                }
            }
        }
    }

    private void copyFileIfNotDifferent(Path sourcePath, Path destinationPath) throws IOException {
        byte[] originalBytes = Files.readAllBytes(sourcePath);
        if (Files.exists(destinationPath, new LinkOption[0])) {
            byte[] existingBytes = Files.readAllBytes(destinationPath);
            if (!Arrays.equals(originalBytes, existingBytes)) {
                LOGGER.warn("Existing wrapper " + destinationPath + " is different than expected, deleting");
                Files.delete(destinationPath);
            } else {
                return;
            }
        }
        LOGGER.warn("Creating wrapper " + destinationPath);
        Files.write(destinationPath, originalBytes, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJavaProcess(ExecutionProfileModel executionProfileModel, List<String> commandLine) throws IOException, InterruptedException {
        if (executionProfileModel == null || executionProfileModel.getEngineAccountUsername() == null || executionProfileModel.getEngineAccountUsername().length() == 0) {
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            String engineFolder = this.getEngineFolder(executionProfileModel);
            Path javaBinPath = Paths.get(commandLine.get(0), new String[0]);
            String javaBinFolder = javaBinPath.getParent().toAbsolutePath().toString();
            EngineWorker engineWorker = this;
            if (engineWorker.configuration.getOsWindows()) {
                builder.environment().put("Path", System.getenv("PATH") + ";" + engineFolder + "\\bin;" + engineFolder + "\\bin\\amd64;" + engineFolder + "\\bin\\x86;" + javaBinFolder);
                builder.environment().put("PATH", System.getenv("PATH") + ";" + engineFolder + "\\bin;" + engineFolder + "\\bin\\amd64;" + engineFolder + "\\bin\\x86;" + javaBinFolder);
            } else {
                builder.environment().put("PATH", System.getenv("PATH") + ":" + engineFolder + "/bin:" + engineFolder + "/lib:" + javaBinFolder);
            }
            builder.redirectOutput(CommandLineUtils.NULL_FILE);
            LOGGER.info("Starting " + this.model + ": " + String.join((CharSequence)" ", commandLine));
            this.jvmProcess = builder.start();
            this.readStandardErrorAsync(this.jvmProcess);
        } else {
            EngineWorker engineWorker = this;
            if (!engineWorker.configuration.getOsWindows()) {
                throw new IOException(this.iu.getString("Engine.CannotRunUnderUserInNonWindows"));
            }
            String engineFolder = this.getEngineFolder(executionProfileModel);
            EngineWorker engineWorker2 = this;
            synchronized (engineWorker2) {
                File sourceServiceWrapperFile = new File(System.getenv("ProgramFiles") + "\\Nuix\\Automate\\EngineServer\\Automate Engine Server.exe");
                File destinationServiceWrapperFile = new File(this.logFolder + "/" + this.serviceBaseName + ".exe");
                try {
                    this.copyFileIfNotDifferent(Paths.get(sourceServiceWrapperFile.getAbsolutePath(), new String[0]), Paths.get(destinationServiceWrapperFile.getAbsolutePath(), new String[0]));
                }
                catch (IOException e) {
                    throw new IOException(this.iu.getFormattedString("EngineModel.Init.CannotPrepareService", (Object)this.logFolder) + "\n\n" + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                }
                File serviceConfigurationFile = new File(this.logFolder + "/" + this.serviceBaseName + ".xml");
                StringBuilder serviceArguments = new StringBuilder();
                for (String argument : commandLine.subList(1, commandLine.size())) {
                    if (serviceArguments.length() > 0) {
                        serviceArguments.append(" ");
                    }
                    if (argument.contains(" ") && !argument.contains("\"")) {
                        serviceArguments.append("\"");
                        serviceArguments.append(argument);
                        serviceArguments.append("\"");
                        continue;
                    }
                    serviceArguments.append(argument);
                }
                String bootstrappedJobId = "";
                if (this.bootstrappableJob != null && this.bootstrappableJob.getJobModel() != null) {
                    bootstrappedJobId = " for job ID " + this.bootstrappableJob.getJobModel().getId();
                }
                String serviceConfiguration = "<service>\n  <id>engine." + this.model.getId() + "</id>\n  <name>Automate Engine " + this.model.getName() + "</name>\n  <description>This service runs the Automate Engine " + this.model.getName() + " with ID " + this.model.getId() + bootstrappedJobId + ".</description>\n  <startmode>Manual</startmode>\n  <executable>" + commandLine.get(0) + "</executable>\n  <workingdirectory>" + this.logFolder + "</workingdirectory>\n  <env name=\"PATH\" value=\"" + System.getenv("PATH") + ";" + engineFolder + "\\bin\"/>\n  <arguments>" + FormattingUtils.encodeForXml((String)serviceArguments.toString()) + "</arguments>\n  <log mode=\"reset\"></log>\n</service>";
                try {
                    org.apache.commons.io.FileUtils.writeStringToFile((File)serviceConfigurationFile, (String)serviceConfiguration, (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new IOException(this.iu.getFormattedString("EngineModel.CannotPrepareService", (Object)this.logFolder) + "\n\n" + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                }
                ArrayList<String> runAsCommandLine = new ArrayList<String>();
                runAsCommandLine.add(destinationServiceWrapperFile.getAbsolutePath());
                runAsCommandLine.add("install");
                runAsCommandLine.add("/p");
                LOGGER.info(this.model + " Registering service " + String.join((CharSequence)" ", runAsCommandLine));
                ProcessBuilder builder = new ProcessBuilder(runAsCommandLine);
                Process serviceHandlerProcess = builder.start();
                this.readStandardErrorAsync(serviceHandlerProcess);
                this.readStandardOutputAsync(serviceHandlerProcess);
                OutputStream stdIn = serviceHandlerProcess.getOutputStream();
                stdIn.write(executionProfileModel.getEngineAccountUsername().getBytes(StandardCharsets.UTF_8));
                stdIn.write("\n".getBytes(StandardCharsets.UTF_8));
                stdIn.flush();
                if (executionProfileModel.getEngineAccountPassword() == null) {
                    throw new IOException(this.iu.getFormattedString("ExecutionProfile.ReenterPassword", new Object[0]));
                }
                stdIn.write(executionProfileModel.getEngineAccountPassword().getBytes(StandardCharsets.UTF_8));
                stdIn.write("\n".getBytes(StandardCharsets.UTF_8));
                stdIn.write("n".getBytes(StandardCharsets.UTF_8));
                stdIn.write("\n".getBytes(StandardCharsets.UTF_8));
                stdIn.flush();
                try {
                    serviceHandlerProcess.waitFor(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Cannot wait for process to finish", (Throwable)e);
                    throw e;
                }
                if (serviceHandlerProcess.exitValue() != 0) {
                    block27: {
                        try {
                            this.uninstallService(false);
                        }
                        catch (Exception e) {
                            if (!LOGGER.isDebugEnabled()) break block27;
                            LOGGER.debug("Cannot de-register service", (Throwable)e);
                        }
                    }
                    LOGGER.error(this.model + " Install service exit code " + serviceHandlerProcess.exitValue());
                    throw new IOException(this.iu.getFormattedString("EngineModel.Init.CannotRegisterService", (Object)serviceHandlerProcess.exitValue()));
                }
                runAsCommandLine = new ArrayList();
                runAsCommandLine.add(destinationServiceWrapperFile.getAbsolutePath());
                runAsCommandLine.add("start");
                LOGGER.info(this.model + " Starting service " + String.join((CharSequence)" ", runAsCommandLine));
                builder = new ProcessBuilder(runAsCommandLine);
                serviceHandlerProcess = builder.start();
                this.serviceStarted = true;
                this.readStandardErrorAsync(serviceHandlerProcess);
                this.readStandardOutputAsync(serviceHandlerProcess);
                try {
                    serviceHandlerProcess.waitFor(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Cannot wait for process to finish", (Throwable)e);
                    throw e;
                }
                if (serviceHandlerProcess.exitValue() != 0) {
                    throw new IOException(this.iu.getFormattedString("EngineModel.Init.CannotStartService", (Object)executionProfileModel.getEngineAccountUsername()));
                }
                runAsCommandLine = new ArrayList();
                runAsCommandLine.add(destinationServiceWrapperFile.getAbsolutePath());
                runAsCommandLine.add("uninstall");
                LOGGER.info(this.model + " Queueing Uninstall service " + String.join((CharSequence)" ", runAsCommandLine));
                builder = new ProcessBuilder(runAsCommandLine);
                serviceHandlerProcess = builder.start();
                try {
                    serviceHandlerProcess.waitFor(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Cannot wait for process to finish", (Throwable)e);
                }
            }
        }
    }

    private String getEngineFolder(ExecutionProfileModel executionProfileModel) {
        if (executionProfileModel != null && executionProfileModel.getNuixEngineFolder() != null && executionProfileModel.getNuixEngineFolder().length() > 0) {
            LOGGER.info("Using explicit Nuix Engine Folder: " + executionProfileModel.getNuixEngineFolder());
            return executionProfileModel.getNuixEngineFolder();
        }
        return this.configuration.getNuixEnginePath();
    }

    private String getJavaExecutable(ExecutionProfileModel executionProfileModel) throws IOException {
        String[] javaExecutableRelativePaths = new String[]{"bin\\java.exe", "bin/java", "java.exe", "java"};
        if (executionProfileModel != null && executionProfileModel.getJavaFolder() != null && executionProfileModel.getJavaFolder().length() > 0) {
            LOGGER.info("Using explicit Java Folder: " + executionProfileModel.getJavaFolder());
            Path javaFolderPath = Paths.get(executionProfileModel.getJavaFolder(), new String[0]);
            if (!javaFolderPath.toFile().exists()) {
                throw new IOException(this.iu.getFormattedString("EngineFactory.JavaFolderDoesNotExist", (Object)javaFolderPath.toString()));
            }
            for (String javaExecutableRelativePath : javaExecutableRelativePaths) {
                Path javaExecutablePath = javaFolderPath.resolve(javaExecutableRelativePath);
                if (!javaExecutablePath.toFile().exists()) continue;
                LOGGER.info("Using explicit Java executable: " + javaExecutablePath.toString());
                return javaExecutablePath.toString();
            }
            throw new IOException(this.iu.getFormattedString("EngineFactory.JavaFolderInvalid", (Object)javaFolderPath.toString()));
        }
        Path engineJavaFolderPath = Paths.get(this.getEngineFolder(executionProfileModel), "jre", "bin");
        for (String javaExecutableRelativePath : javaExecutableRelativePaths) {
            Path javaExecutablePath = engineJavaFolderPath.resolve(javaExecutableRelativePath);
            if (!javaExecutablePath.toFile().exists()) continue;
            try {
                JavaUtils.getVersion((String)javaExecutablePath.toString());
                LOGGER.info("Using Engine Java executable: " + javaExecutablePath.toString());
                return javaExecutablePath.toString();
            }
            catch (Exception e) {
                LOGGER.info("Cannot use Engine java " + javaExecutablePath + ", " + e.getMessage());
            }
        }
        EngineWorker engineWorker = this;
        if (engineWorker.configuration.getOsWindows()) {
            Version suppliedJreNuixVersion = new Version("9.4.0");
            String nuixEngineVersionStr = this.getNuixEngineVersion(this.getEngineFolder(executionProfileModel));
            Version nuixEngineVersion = new Version(nuixEngineVersionStr);
            if (nuixEngineVersion.compareTo(suppliedJreNuixVersion) < 0) {
                String rampivaDefaultJre = SystemUtils.getProgramFilesDir() + "\\Nuix\\Automate\\java\\jre11\\bin\\java.exe";
                LOGGER.info("Using Automate Default JRE11 Java executable: " + rampivaDefaultJre);
                return rampivaDefaultJre;
            }
        }
        String platformJava = System.getProperty("java.home") + "/bin/java";
        LOGGER.info("Using Platform Java executable: " + platformJava);
        return platformJava;
    }

    private String getNuixEngineVersion(String engineFolder) {
        File[] files;
        String nuixEngineVersion = null;
        Path engineFolderPath = Paths.get(engineFolder, "lib");
        if (engineFolderPath.toFile().exists() && (files = engineFolderPath.toFile().listFiles()) != null) {
            for (File jarFile : files) {
                if (!jarFile.getName().startsWith("nuix-engine-api-")) continue;
                String[] nameSplit = jarFile.getName().split("-");
                nuixEngineVersion = nameSplit[3].replace(".jar", "").trim();
            }
        }
        return nuixEngineVersion;
    }

    private synchronized void runEngineJavaApp(BootstrappableJob tempBootstrappableJob, AutomateLicenceModel rampivaLicence, boolean remoteEngine) {
        String errorMessage;
        BootstrappableJob bootstrappableJob;
        block15: {
            bootstrappableJob = tempBootstrappableJob;
            if (this.startEngineJavaAppThread != null && this.startEngineJavaAppThread.isAlive()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Another attempt to start the Nuix Engine is in progress");
                }
                return;
            }
            if (rampivaLicence == null || rampivaLicence.getLicenceInfo() == null) {
                return;
            }
            this.resetMaxDurations();
            this.logLocation = null;
            this.isInitializing = true;
            this.isShuttingDown = false;
            errorMessage = null;
            this.model.setWorkerAgentOnly(remoteEngine);
            if (bootstrappableJob.getJobModel() != null && !remoteEngine) {
                this.model.setBootstrappingJobId(bootstrappableJob.getJobModel().getId());
            } else {
                this.model.setBootstrappingJobId(null);
            }
            ServerApplication.getInstance().getLicenceUtils().setLicenceInfo(rampivaLicence.getLicenceInfo());
            try {
                if (this.model.getSupportedExecutionMode().equals((Object)ExecutionMode.AUTOMATE_NATIVE)) {
                    ServerApplication.getInstance().getLicenceUtils().assertModuleLicensed(ModuleType.AUTOMATE_NATIVE_WORKFLOWS, false);
                    break block15;
                }
                ServerApplication.getInstance().getLicenceUtils().assertModuleLicensed(ModuleType.WORKFLOW_ENGINE, false);
                if (this.serverApplication.getServerNuixLicenceSources() != null) {
                    this.runTimeNuixLicenceSource = this.serverApplication.getServerNuixLicenceSources().get(this.model.getNuixLicenceSourceId());
                    if (this.runTimeNuixLicenceSource == null) {
                        errorMessage = this.iu.getFormattedString("EngineModel.NuixLicenceSourceCannotBeResolved", (Object)this.model.getNuixLicenceSourceId());
                    } else if ((this.runTimeNuixLicenceSource.getSourceType().equals((Object)SourceType.NMS) || this.runTimeNuixLicenceSource.getSourceType().equals((Object)SourceType.CLS)) && (this.runTimeNuixLicenceSource.getPassword() == null || this.runTimeNuixLicenceSource.getPassword().length() == 0)) {
                        errorMessage = this.iu.getString("EngineFactory.NuixLicenceSourcePasswordInvalid");
                    }
                    break block15;
                }
                LOGGER.warn("Delaying Engine init because the license information is not yet available");
                this.model.setStatus(EngineStatus.NOT_INITIALIZED);
                return;
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
            }
        }
        if (errorMessage != null) {
            this.model.setError(errorMessage);
            this.model.setStatus(EngineStatus.ERROR);
            this.licenseSourceError = true;
            return;
        }
        if (this.licenseSourceError) {
            this.model.setError(this.iu.getString("Engine.Error.LicenseSourceError"));
            this.model.setStatus(EngineStatus.ERROR);
            this.licenseSourceError = false;
            return;
        }
        LOGGER.info(this.model + " Initializing");
        EngineStatus engineStatus = this.model.getStatus();
        if (engineStatus != EngineStatus.NOT_INITIALIZED && engineStatus != EngineStatus.ERROR && engineStatus != EngineStatus.WARNING && engineStatus != EngineStatus.STANDBY) {
            throw new IllegalStateException(this.iu.getFormattedString("EngineModel.CannotInitializeEngineState", (Object)engineStatus));
        }
        this.model.setStatus(EngineStatus.INITIALIZING);
        this.startEngineJavaAppThread = new Thread(() -> {
            block70: {
                try {
                    this.engineStub = this.getEngineStub();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    this.shutdown();
                }
                catch (Throwable t) {
                    LOGGER.error("Cannot shutdown engine", t);
                }
                if (this.jvmProcess != null && this.jvmProcess.isAlive()) {
                    LOGGER.warn("Cannot start new Java process because one is already running");
                    return;
                }
                this.isShuttingDown = false;
                try {
                    Path engineServerUserDataDirPath;
                    Path chromiumPath;
                    String rampivaJavaOptions;
                    NetworkConfiguration networkConfiguration;
                    String jacocoEnginePathPrefix;
                    String engineAdditionalJavaParameters;
                    File parentFile;
                    boolean redirectStdOut = false;
                    InputStream stream = this.getClass().getResourceAsStream("/templates/engine.yml");
                    String engineTemplate = IOUtils.toString((InputStream)stream, (Charset)Charset.forName("UTF-8"));
                    IOUtils.closeQuietly((InputStream)stream);
                    engineTemplate = engineTemplate.replace("{engine_id}", this.model.getId());
                    engineTemplate = engineTemplate.replace("{server_local_port}", "" + this.configuration.getServerLocalPort());
                    if (bootstrappableJob.getExecutionProfile() != null) {
                        HashMap<String, String> parameterNameValueMap = new HashMap<String, String>();
                        if (bootstrappableJob.getExecutionProfile().getWorkflowParameters() != null && bootstrappableJob.getExecutionProfile().getWorkflowParameters().size() > 0) {
                            parameterNameValueMap.putAll(bootstrappableJob.getExecutionProfile().getWorkflowParameters());
                        }
                        if (bootstrappableJob.getJobModel() != null && bootstrappableJob.getJobModel().getSessionParameters() != null) {
                            for (Parameter param : bootstrappableJob.getJobModel().getSessionParameters()) {
                                if (param.getParameterType() == ParameterType.TEXT_PROTECTED) continue;
                                parameterNameValueMap.put(param.getName(), param.getValue());
                            }
                        }
                        for (Map.Entry entry : parameterNameValueMap.entrySet()) {
                            String updatedValue;
                            if (bootstrappableJob.getExecutionProfile().getEngineLogFolder().contains((CharSequence)entry.getKey())) {
                                updatedValue = bootstrappableJob.getExecutionProfile().getEngineLogFolder().replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                                bootstrappableJob.getExecutionProfile().setEngineLogFolder(updatedValue);
                            }
                            if (bootstrappableJob.getExecutionProfile().getEngineCommandLineParameters().contains((CharSequence)entry.getKey())) {
                                updatedValue = bootstrappableJob.getExecutionProfile().getEngineCommandLineParameters().replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                                bootstrappableJob.getExecutionProfile().setEngineCommandLineParameters(updatedValue);
                            }
                            if (!bootstrappableJob.getExecutionProfile().getNuixEngineFolder().contains((CharSequence)entry.getKey())) continue;
                            updatedValue = bootstrappableJob.getExecutionProfile().getNuixEngineFolder().replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                            bootstrappableJob.getExecutionProfile().setNuixEngineFolder(updatedValue);
                        }
                        ExecutionContext executionContext = new ExecutionContext(null, null, null, null, null, false, null);
                        executionContext.getAllParameters();
                        executionContext.initializeJobParameters(bootstrappableJob.getJobModel(), this.model, bootstrappableJob.getExecutionProfile());
                        String updatedValue = bootstrappableJob.getExecutionProfile().getEngineLogFolder();
                        updatedValue = executionContext.evalParameters(updatedValue, null);
                        bootstrappableJob.getExecutionProfile().setEngineLogFolder(updatedValue);
                        updatedValue = bootstrappableJob.getExecutionProfile().getEngineCommandLineParameters();
                        updatedValue = executionContext.evalParameters(updatedValue, null);
                        bootstrappableJob.getExecutionProfile().setEngineCommandLineParameters(updatedValue);
                        updatedValue = bootstrappableJob.getExecutionProfile().getNuixEngineFolder();
                        updatedValue = executionContext.evalParameters(updatedValue, null);
                        bootstrappableJob.getExecutionProfile().setNuixEngineFolder(updatedValue);
                    }
                    String engineFolder = this.getEngineFolder(bootstrappableJob.getExecutionProfile());
                    engineTemplate = engineTemplate.replace("{nuix_engine_path}", engineFolder);
                    Path engineFolderPath = Paths.get(engineFolder, new String[0]);
                    if (!Files.exists(engineFolderPath, new LinkOption[0])) {
                        throw new IOException(this.iu.getFormattedString("Engine.Error.MissingNuixEngineFolder", (Object)engineFolderPath.toAbsolutePath().toString()));
                    }
                    Path engineFolderLibPath = engineFolderPath.resolve("lib");
                    if (!Files.exists(engineFolderLibPath, new LinkOption[0])) {
                        throw new IOException(this.iu.getFormattedString("Engine.Error.MissingNuixEngineBinaries", (Object)engineFolderPath.toAbsolutePath().toString()));
                    }
                    engineTemplate = engineTemplate.replace("{enable_centralized_logging}", Boolean.toString(this.configuration.getEnableCentralizedLogging()));
                    engineTemplate = engineTemplate.replace("{log4j_configuration_file}", this.configuration.getLog4jConfigurationFile());
                    engineTemplate = engineTemplate.replace("{running_log_max_size}", "" + this.configuration.getJobRunningLogMaxSize());
                    engineTemplate = engineTemplate.replace("{engine_abort_timeout}", "" + this.configuration.getEngineAbortTimeout());
                    engineTemplate = engineTemplate + "\n";
                    if (this.configuration.getWorkerBrokerIP() != null && this.configuration.getWorkerBrokerIP().length() > 0) {
                        engineTemplate = engineTemplate + "workerBrokerIP: " + this.configuration.getWorkerBrokerIP() + "\n";
                    }
                    if (this.configuration.getWorkerBrokerStartPort() != null && this.configuration.getWorkerBrokerStartPort() > 0) {
                        engineTemplate = engineTemplate + "workerBrokerStartPort: " + this.configuration.getWorkerBrokerStartPort() + "\n";
                    }
                    if (this.configuration.getWorkerBrokerEndPort() != null && this.configuration.getWorkerBrokerEndPort() > 0) {
                        engineTemplate = engineTemplate + "workerBrokerEndPort: " + this.configuration.getWorkerBrokerEndPort() + "\n";
                    }
                    String logBaseName = "engine.";
                    this.shortEngineName = UidUtils.getShortId((String)this.model.getId());
                    logBaseName = logBaseName + this.shortEngineName;
                    boolean logIsInit = false;
                    if (bootstrappableJob.getJobModel() != null && bootstrappableJob.getExecutionProfile() != null && bootstrappableJob.getExecutionProfile().getEngineLogFolder() != null) {
                        logBaseName = logBaseName + "-job.";
                        try {
                            logBaseName = logBaseName + UidUtils.getShortId((String)bootstrappableJob.getJobModel().getId());
                            engineTemplate = engineTemplate.replace("{job_id}", bootstrappableJob.getJobModel().getId());
                        }
                        catch (Exception e) {
                            logBaseName = logBaseName + bootstrappableJob.getJobModel().getId();
                        }
                    } else {
                        logBaseName = logBaseName + "-init";
                        engineTemplate = engineTemplate.replace("{job_id}", "~");
                        logIsInit = true;
                    }
                    engineTemplate = engineTemplate.replace("{log_base_name}", logBaseName);
                    String logLayout = "";
                    String enableJsonLogLayout = System.getenv("AUTOMATE_ENGINE_LOG_LAYOUT_JSON");
                    if (Boolean.parseBoolean(enableJsonLogLayout)) {
                        logLayout = "      layout:\n        type: json\n        timestampFormat: \"yyyy-MM-dd'T'HH:mm:ss.SSSZ\"\n        prettyPrint: false\n        appendLineSeparator: true\n        includes: [timestamp, threadName, level, loggerName, message, mdc, exception]\n        customFieldNames:\n          timestamp: \"@timestamp\"\n        additionalFields:\n          service-name: \"engine\"\n        includesMdcKeys: [userId]\n        flattenMdc: true\n        exception:\n          rootFirst: true\n          depth: full\n          evaluators: [org.apache]\n";
                    }
                    engineTemplate = engineTemplate.replace("{log_layout}", logLayout);
                    this.logFolder = bootstrappableJob.getExecutionProfile() != null ? bootstrappableJob.getExecutionProfile().getEngineLogFolder() : this.configuration.getEngineInitLogFolder();
                    engineTemplate = engineTemplate.replace("{log_location}", this.logFolder);
                    File engineConfigFile = new File(this.logFolder + "/" + logBaseName + ".yml");
                    if (engineConfigFile.exists() && !engineConfigFile.isFile()) {
                        engineConfigFile.delete();
                    }
                    if (!(parentFile = engineConfigFile.getParentFile()).exists()) {
                        LOGGER.info("Engine log folder " + parentFile + " does not exist, creating ...");
                        parentFile.mkdirs();
                    }
                    File logFile = new File(this.logFolder + "/" + logBaseName + ".log");
                    this.logLocation = logFile.getAbsolutePath();
                    if (logIsInit) {
                        try {
                            FileUtils.deleteRecursively((Path)Paths.get(this.logLocation, new String[0]));
                        }
                        catch (IOException e) {
                            LOGGER.warn("Cannot delete previous log file " + logFile.toString(), (Throwable)e);
                        }
                    }
                    try {
                        org.apache.commons.io.FileUtils.writeStringToFile((File)engineConfigFile, (String)engineTemplate, (String)"UTF-8");
                    }
                    catch (IOException e) {
                        throw new IOException(this.iu.getFormattedString("EngineModel.InvalidLogFolder", (Object)this.logFolder) + "\n\n" + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    }
                    ArrayList<String> commandLine = new ArrayList<String>();
                    String javaExecutable = this.getJavaExecutable(bootstrappableJob.getExecutionProfile());
                    commandLine.add(javaExecutable);
                    Map<String, String> engineArchAdditionalJavaParameters = this.configuration.getEngineArchAdditionalJavaParameters();
                    if (engineArchAdditionalJavaParameters != null && (engineAdditionalJavaParameters = engineArchAdditionalJavaParameters.get(System.getProperty("os.arch"))) != null) {
                        commandLine.add(engineAdditionalJavaParameters);
                    }
                    if ((jacocoEnginePathPrefix = System.getProperty("jacocoEnginePathPrefix")) != null && jacocoEnginePathPrefix.length() > 0) {
                        commandLine.add("-javaagent:C:/Software/jacoco-0.8.8/lib/jacocoagent.jar=destfile=" + jacocoEnginePathPrefix + this.model.getId() + ".exec,includes=com.nuix.automate.*");
                    }
                    String pathQuotes = ServerConfiguration.getOsWindows() ? "\"" : "";
                    commandLine.add(pathQuotes + "-javaagent:" + CommandLineUtils.getJarFile().getParentFile().getAbsolutePath() + "/jar-utils.jar" + pathQuotes);
                    commandLine.add("-Dkill.signature=k177" + this.model.getId());
                    commandLine.add("-Drampiva.engineId=" + this.model.getId());
                    if (bootstrappableJob.getExecutionProfile() != null && bootstrappableJob.getExecutionProfile().getEngineCommandLineParameters() != null) {
                        String[] executionProfileArguments = FormattingUtils.translateCommandline((String)bootstrappableJob.getExecutionProfile().getEngineCommandLineParameters());
                        commandLine.addAll(Arrays.asList(executionProfileArguments));
                    }
                    if ((networkConfiguration = this.serverApplication.getServerNetworkConfiguration()) != null && networkConfiguration.isProxyConfigured()) {
                        String[] networkConfigCommandline = FormattingUtils.translateCommandline((String)networkConfiguration.toCommandLine());
                        commandLine.addAll(Arrays.asList(networkConfigCommandline));
                    }
                    int javaVersion = JavaUtils.getVersion((String)javaExecutable);
                    if (!this.configuration.getEnableEngineJavaMinidumps()) {
                        commandLine.add(JavaUtils.getDisableCrashDumpString((int)javaVersion));
                    }
                    if (javaVersion > 8 && javaVersion <= 11) {
                        commandLine.add("--add-opens");
                        commandLine.add("jdk.management/com.sun.management.internal=ALL-UNNAMED");
                        commandLine.add("--add-opens");
                        commandLine.add("java.base/jdk.internal.loader=ALL-UNNAMED");
                        commandLine.add("--add-exports");
                        commandLine.add("java.base/jdk.internal.loader=ALL-UNNAMED");
                    }
                    if (javaVersion > 11) {
                        List<String> jvmArgs = Arrays.asList("--add-opens", "java.base/java.io=ALL-UNNAMED", "--add-opens", "java.base/java.lang=ALL-UNNAMED", "--add-opens", "java.base/java.time=ALL-UNNAMED", "--add-opens", "java.base/java.util=ALL-UNNAMED", "--add-opens", "java.base/java.util.concurrent.atomic=ALL-UNNAMED", "--add-opens", "java.base/java.util.regex=ALL-UNNAMED", "--add-opens", "java.base/sun.net.dns=ALL-UNNAMED", "--add-opens", "java.base/sun.net.www.protocol.http=ALL-UNNAMED", "--add-opens", "java.base/sun.nio.fs=ALL-UNNAMED", "--add-opens", "java.base/sun.nio.ch=ALL-UNNAMED", "--add-opens", "java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED", "--add-opens", "java.desktop/javax.swing=ALL-UNNAMED", "--add-opens", "java.desktop/com.sun.java.swing=ALL-UNNAMED", "--add-opens", "java.desktop/com.sun.java.swing.plaf.windows=ALL-UNNAMED", "--add-exports", "java.base/jdk.internal.loader=ALL-UNNAMED", "--add-exports", "java.desktop/com.apple.laf=ALL-UNNAMED", "--add-exports", "java.desktop/com.sun.imageio=ALL-UNNAMED", "--add-exports", "java.desktop/com.sun.imageio.plugins.gif=ALL-UNNAMED", "--add-exports", "java.desktop/com.sun.imageio.plugins.jpeg=ALL-UNNAMED", "--add-exports", "java.desktop/sun.awt=ALL-UNNAMED", "--add-exports", "java.desktop/sun.awt.image=ALL-UNNAMED", "--add-exports", "java.desktop/sun.font=ALL-UNNAMED", "--add-exports", "java.xml/com.sun.xml.internal.stream=ALL-UNNAMED");
                        commandLine.addAll(jvmArgs);
                        commandLine.add("-Dscript.polyglot.useGraal=false");
                        commandLine.add("-Djava.util.logging.config.file=" + Paths.get(engineFolder, "config", "jul.properties").toAbsolutePath());
                    }
                    if ((rampivaJavaOptions = System.getenv("AUTOMATE_JAVA_OPTIONS")) != null) {
                        String[] executionProfileArguments = FormattingUtils.translateCommandline((String)rampivaJavaOptions);
                        commandLine.addAll(Arrays.asList(executionProfileArguments));
                    }
                    if (Files.exists(chromiumPath = Paths.get(engineFolder, "bin", "JxBrowserChromium.framework"), new LinkOption[0])) {
                        LOGGER.info("Setting Chromium path " + chromiumPath);
                        commandLine.add("-Dnuix.chromium.dir=" + chromiumPath.toAbsolutePath() + "");
                    } else {
                        LOGGER.info("Chromium not found at " + chromiumPath);
                    }
                    commandLine.add("-cp");
                    commandLine.add(pathQuotes + CommandLineUtils.getJarFile().getParentFile().getAbsolutePath() + "/*" + pathQuotes);
                    commandLine.add("com.nuix.automate.engine.EngineApplication");
                    commandLine.add("engine");
                    commandLine.add(pathQuotes + engineConfigFile.getAbsolutePath() + pathQuotes);
                    this.serviceBaseName = "engine." + this.shortEngineName + "-service";
                    if (ServerConfiguration.getOsWindows()) {
                        this.stopService(false);
                        this.uninstallService(false);
                    }
                    engineTemplate = (engineServerUserDataDirPath = ServerApplication.getInstance().getUserDataDirResource().getUserDataDirPath()) != null ? engineTemplate.replace("{engineServerUserDataDirPath}", "engineServerUserDataDirPath: " + engineServerUserDataDirPath.toAbsolutePath()) : engineTemplate.replace("{engineServerUserDataDirPath}", "");
                    Path engineServerJobFilesDirectory = ServerApplication.getInstance().getJobFileResource().getJobFilesDirectory();
                    engineTemplate = engineServerJobFilesDirectory != null ? engineTemplate.replace("{engineServerJobFilesDirectory}", "engineServerJobFilesDirectory: " + engineServerJobFilesDirectory.toAbsolutePath()) : engineTemplate.replace("{engineServerJobFilesDirectory}", "");
                    engineTemplate = engineTemplate.replace("{engine_command_line}", ">\n    " + String.join((CharSequence)" ", commandLine).replace("\n", " "));
                    engineTemplate = engineTemplate.replace("{execution_mode}", this.model.getSupportedExecutionMode().name());
                    try {
                        org.apache.commons.io.FileUtils.writeStringToFile((File)engineConfigFile, (String)engineTemplate, (String)"UTF-8");
                    }
                    catch (IOException e) {
                        throw new IOException(this.iu.getFormattedString("EngineModel.InvalidLogFolder", (Object)this.logFolder) + "\n\n" + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    }
                    this.startJavaProcess(bootstrappableJob.getExecutionProfile(), commandLine);
                    int attempts = this.serverApplication.getConfiguration().getEngineInitTimeout();
                    LOGGER.info("Checking if " + this.model + " started (" + attempts + " attempts)");
                    this.engineStub = this.getEngineStub(attempts);
                    if (this.isShuttingDown) {
                        throw new IllegalStateException(this.iu.getString("EngineModel.BootstrappingAborted"));
                    }
                    if (this.engineStub == null) {
                        this.model.setStatus(EngineStatus.NOT_INITIALIZED);
                        throw new IOException(this.iu.getString("EngineModel.NonResponsive"));
                    }
                    try {
                        LOGGER.info("Configuring " + this.model + " " + bootstrappableJob.getJobModel() + " remote=" + remoteEngine);
                        this.model.setLogFile(this.logLocation);
                        EngineModel remoteModel = this.engineStub.configure(this.model, bootstrappableJob, rampivaLicence, this.runTimeNuixLicenceSource, remoteEngine);
                        if (remoteModel != null) {
                            this.model = remoteModel;
                        }
                        this.model.resetJobInitFailureCount();
                    }
                    catch (NullPointerException | RemoteException e) {
                        if (this.isShuttingDown) {
                            throw new IllegalStateException(this.iu.getString("EngineModel.BootstrappingAborted"));
                        }
                        LOGGER.error("Cannot ping " + this.model, (Throwable)e);
                        throw new IOException(this.iu.getString("EngineModel.NonResponsive"));
                    }
                }
                catch (Throwable e) {
                    String currentJobId;
                    if (this.model.getError() != null && this.model.getError().length() > 0) {
                        this.model.setError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e) + "\n\n" + this.model.getError());
                    } else {
                        this.model.setError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    }
                    this.model.setStatus(EngineStatus.ERROR);
                    String string = currentJobId = bootstrappableJob != null && bootstrappableJob.getJobModel() != null ? bootstrappableJob.getJobModel().getId() : null;
                    if (currentJobId != null) {
                        this.model.incrementJobInitFailureCount(currentJobId);
                    }
                    LOGGER.error("Cannot start " + this.model, e);
                    try {
                        this.serverApplication.getServerWorker().getRegistry().unbind(this.model.getId());
                        this.engineStub = null;
                        LOGGER.info("Unbound previous engine");
                    }
                    catch (NullPointerException | RemoteException ex) {
                        LOGGER.warn("Cannot unbind previous engine", (Throwable)ex);
                    }
                    catch (NotBoundException ex) {
                        // empty catch block
                    }
                    try {
                        if (this.jvmProcess != null) {
                            LOGGER.info("Destroying Engine " + this.model.getId() + " process");
                            this.jvmProcess.destroyForcibly();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Cannot destroy Engine " + this.model.getId() + " process", (Throwable)ex);
                    }
                    EngineWorker engineWorker = this;
                    if (!engineWorker.configuration.getOsWindows()) break block70;
                    try {
                        this.stopService(true);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Cannot clean up Engine " + this.model.getId() + " service", (Throwable)ex);
                    }
                }
            }
            if (this.model.getStatus() == EngineStatus.ERROR || this.model.getStatus() == EngineStatus.WARNING) {
                LOGGER.info("Detected engine error status, waiting " + this.serverApplication.getConfiguration().getNuixLicenseSourceTimeout());
                this.shutdown();
                String originalErrorMessage = this.model.getError();
                if (originalErrorMessage == null) {
                    originalErrorMessage = "";
                }
                boolean skipRetryDelay = false;
                if (remoteEngine && originalErrorMessage != null && originalErrorMessage.contains(this.iu.getString("RemoteEngine.Error.LicenseDoesNotSupportOperation"))) {
                    skipRetryDelay = true;
                }
                if (!skipRetryDelay) {
                    int i = 0;
                    while ((long)i < this.serverApplication.getConfiguration().getEngineInitRetryDelay() / 1000L) {
                        int secondsRemaining = (int)this.serverApplication.getConfiguration().getEngineInitRetryDelay() / 1000 - i;
                        if (i % 10 == 0) {
                            this.model.setError(originalErrorMessage + "\n\n" + this.iu.getNumeralString("EngineFactory.Retrying", (long)secondsRemaining));
                            LOGGER.info(this.iu.getNumeralString("EngineFactory.Retrying", (long)secondsRemaining));
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        ++i;
                    }
                }
                this.model.setError(null);
            } else {
                this.isInitializing = false;
            }
        });
        this.startEngineJavaAppThread.setName("Start " + this.model.getId() + "");
        this.startEngineJavaAppThread.start();
    }

    public synchronized void updateEngine() {
        if (this.engineStub != null) {
            NuixLicenseSourceModel licenceSource = null;
            if (this.model.getSupportedExecutionMode().equals((Object)ExecutionMode.AUTOMATE_NUIX) && this.serverApplication.getServerNuixLicenceSources() != null) {
                licenceSource = this.serverApplication.getServerNuixLicenceSources().get(this.model.getNuixLicenceSourceId());
            }
            EngineModel remoteEngineModel = null;
            try {
                this.model.setLogFile(this.logLocation);
                remoteEngineModel = this.engineStub.updateEngine(this.model, licenceSource);
            }
            catch (NullPointerException | RemoteException e) {
                LOGGER.error("Cannot update engine", (Throwable)e);
            }
            if (remoteEngineModel != null) {
                this.model = remoteEngineModel;
            }
        }
    }

    private void initSemaphores() {
        this.handleEnginePingSemaphore = new Semaphore(1);
        this.handleEngineSettingsSemaphore = new Semaphore(1);
        this.handleExecutionLogsSemaphore = new Semaphore(1);
        this.handleOperationsSemaphore = new Semaphore(1);
        this.handleJobStatusSemaphore = new Semaphore(1);
        this.handleJobUtilizationSemaphore = new Semaphore(1);
        this.handleConsumptionSessionEventsSemaphore = new Semaphore(1);
        this.handleJobProcessingEventsSemaphore = new Semaphore(1);
        this.handleWorkflowDynamicUpdatesSemaphore = new Semaphore(1);
        this.handleEngineLogsSemaphore = new Semaphore(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalHandleEngineWork() throws InterruptedException {
        long logStartMillis = DateTime.now().getMillis();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " Start");
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " enginePing acquire");
        this.handleEnginePingSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " enginePing acquired");
        try {
            this.handleEnginePing();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " enginePing finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleEnginePing", (Throwable)e);
        }
        finally {
            this.handleEnginePingSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " engineSettings acquire");
        this.handleEngineSettingsSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " engineSettings acquired");
        try {
            this.handleEngineSettings();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " engineSettings finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleEngineSettings", (Throwable)e);
        }
        finally {
            this.handleEngineSettingsSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " executionLog acquire");
        this.handleExecutionLogsSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " executionLog acquired");
        try {
            this.handleExecutionLogs();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " executionLog finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleExecutionLogs", (Throwable)e);
        }
        finally {
            this.handleExecutionLogsSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " operations acquire");
        this.handleOperationsSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " operations acquired");
        try {
            this.handleOperations();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " operations finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleOperations", (Throwable)e);
        }
        finally {
            this.handleOperationsSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobStatus acquire");
        this.handleJobStatusSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobStatus acquired");
        try {
            this.handleJobStatus();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobStatus finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleJobStatus", (Throwable)e);
        }
        finally {
            this.handleJobStatusSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobUtilization acquire");
        this.handleJobUtilizationSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobUtilization acquired");
        try {
            this.handleJobUtilization();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobUtilization finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleJobUtilization", (Throwable)e);
        }
        finally {
            this.handleJobUtilizationSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " sessionEvents acquire");
        this.handleConsumptionSessionEventsSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " sessionEvents acquired");
        try {
            this.handleSessionEvents();
            this.handleConsumption();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " sessionEvents finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleSessionEvents", (Throwable)e);
        }
        finally {
            this.handleConsumptionSessionEventsSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobProcessingEvents acquire");
        this.handleJobProcessingEventsSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobProcessingEvents acquired");
        try {
            this.handleJobProcessingEvents();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " jobProcessingEvents finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleJobProcessingEvents", (Throwable)e);
        }
        finally {
            this.handleJobProcessingEventsSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " workflowDynamicUpdates acquire");
        this.handleWorkflowDynamicUpdatesSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " workflowDynamicUpdates acquired");
        try {
            this.handleWorkflowDynamicUpdates();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " workflowDynamicUpdates finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleWorkflowDynamicUpdates", (Throwable)e);
        }
        finally {
            this.handleWorkflowDynamicUpdatesSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " engineLog acquire");
        this.handleEngineLogsSemaphore.acquire();
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " engineLog acquired");
        try {
            this.handleEngineLogs();
            LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " engineLog finished");
        }
        catch (Exception e) {
            LOGGER.error(this.model + " handleEngineLogs", (Throwable)e);
        }
        finally {
            this.handleEngineLogsSemaphore.release();
        }
        LOGGER.info(this.model + " timestamp " + (DateTime.now().getMillis() - logStartMillis) + " Finished");
    }

    private void handleEngineWork() {
        boolean lockAvailable = this.handleEnginePingSemaphore.tryAcquire();
        if (lockAvailable) {
            new Thread(() -> {
                try {
                    this.handleEnginePing();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleEnginePing", (Throwable)e);
                }
                finally {
                    this.handleEnginePingSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleEngineSettingsSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleEngineSettings();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleEngineSettings", (Throwable)e);
                }
                finally {
                    this.handleEngineSettingsSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleExecutionLogsSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleExecutionLogs();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleExecutionLogs", (Throwable)e);
                }
                finally {
                    this.handleExecutionLogsSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleOperationsSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleOperations();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleOperations", (Throwable)e);
                }
                finally {
                    this.handleOperationsSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleJobStatusSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleJobStatus();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleJobStatus", (Throwable)e);
                }
                finally {
                    this.handleJobStatusSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleJobUtilizationSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleJobUtilization();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleJobUtilization", (Throwable)e);
                }
                finally {
                    this.handleJobUtilizationSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleConsumptionSessionEventsSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleSessionEvents();
                    this.handleConsumption();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleSessionEvents", (Throwable)e);
                }
                finally {
                    this.handleConsumptionSessionEventsSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleJobProcessingEventsSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleJobProcessingEvents();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleJobProcessingEvents", (Throwable)e);
                }
                finally {
                    this.handleJobProcessingEventsSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleWorkflowDynamicUpdatesSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleWorkflowDynamicUpdates();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleWorkflowDynamicUpdates", (Throwable)e);
                }
                finally {
                    this.handleWorkflowDynamicUpdatesSemaphore.release();
                }
            }).start();
        }
        if (lockAvailable = this.handleEngineLogsSemaphore.tryAcquire()) {
            new Thread(() -> {
                try {
                    this.handleEngineLogs();
                }
                catch (Exception e) {
                    LOGGER.error(this.model + " handleEngineLogs", (Throwable)e);
                }
                finally {
                    this.handleEngineLogsSemaphore.release();
                }
            }).start();
        }
    }

    private void handleOperations() throws RemoteException {
        if (this.engineStub != null) {
            long logStartMillis = DateTime.now().getMillis();
            this.operations = this.engineStub.getOperations();
            long duration = DateTime.now().getMillis() - logStartMillis;
            if (duration > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleOperations duration " + duration + " ms");
            }
        }
    }

    private void handleEnginePing() {
        if (this.engineStub != null) {
            long logStartMillis;
            block8: {
                logStartMillis = DateTime.now().getMillis();
                try {
                    EngineModel remoteEngineModel = this.engineStub.ping();
                    if (remoteEngineModel != null) {
                        if (this.model != null && this.model.getStatus() != null && remoteEngineModel.getStatus() != null && !this.model.getStatus().equals((Object)remoteEngineModel.getStatus())) {
                            LOGGER.info(this.model + " status changed  to " + remoteEngineModel.getStatus());
                        }
                        this.model = remoteEngineModel;
                        this.lastKeepAlivePing = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    }
                }
                catch (NullPointerException | RemoteException e) {
                    if (this.isShuttingDown) {
                        this.model.setError(this.iu.getString("EngineModel.BootstrappingAborted"));
                        this.model.setStatus(EngineStatus.ERROR);
                    }
                    if (this.isInitializing) break block8;
                    if (this.model.getBootstrappingJobId() == null) {
                        this.model.setError(this.iu.getString("EngineModel.NonResponsive"));
                        this.model.setStatus(EngineStatus.ERROR);
                    }
                    this.model.setError(this.iu.getString("EngineModel.NonResponsive"));
                    this.keepAliveCheck();
                    return;
                }
            }
            long duration = DateTime.now().getMillis() - logStartMillis;
            if (duration > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleEnginePing duration " + duration + " ms");
            }
        }
    }

    public void handleJobStatus() throws RemoteException {
        if (this.engineStub != null) {
            long duration;
            JobModel updatedJobModel;
            long logStartMillis = DateTime.now().getMillis();
            if (!this.model.getWorkerAgentOnly() && (this.model.getStatus() == EngineStatus.RUNNING || this.engineStub != null && this.bootstrappableJob != null && this.bootstrappableJob.getJobModel() != null && this.bootstrappableJob.getJobModel().getExecutionState() != null && (this.bootstrappableJob.getJobModel().getExecutionState().equals((Object)ExecutionState.STOPPING) || this.bootstrappableJob.getJobModel().getExecutionState().equals((Object)ExecutionState.DISCONNECTED) || this.bootstrappableJob.getJobModel().getExecutionState().equals((Object)ExecutionState.PAUSING))) && (updatedJobModel = this.engineStub.getRunningJobStatus()) != null) {
                this.bootstrappableJob.setJobModel(updatedJobModel);
            }
            if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleJobStatus duration " + duration + " ms");
            }
        }
    }

    public void handleSessionEvents() throws RemoteException {
        long duration;
        List sessionEvents;
        long logStartMillis = DateTime.now().getMillis();
        SessionResource serverSessionResource = this.serverApplication.getSessionResource();
        if (serverSessionResource != null && this.engineStub != null && (sessionEvents = this.engineStub.removeSessionEventInfos()) != null) {
            for (EventInfo eventInfo : sessionEvents) {
                serverSessionResource.addEvent(eventInfo);
            }
        }
        if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
            this.maxEnginePingDuration = duration;
            LOGGER.info(this.model + " handleSessionEvents duration " + duration + " ms");
        }
    }

    private void handleJobUtilization() throws RemoteException {
        if (this.engineStub != null) {
            long duration;
            long logStartMillis = DateTime.now().getMillis();
            List utilizations = this.engineStub.removeUtilizations();
            if (utilizations != null) {
                UtilizationResource serverUtilizationResource = this.serverApplication.getServerUtilizationResource();
                for (OperationUtilizationModel utilization : utilizations) {
                    serverUtilizationResource.addUtilization(utilization);
                }
            }
            if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleJobUtilization duration " + duration + " ms");
            }
        }
    }

    private void handleConsumption() throws RemoteException {
        if (this.engineStub != null) {
            long duration;
            long logStartMillis = DateTime.now().getMillis();
            List consumptions = this.engineStub.removeConsumptions();
            if (consumptions != null) {
                ConsumptionResource serverConsumptionResource = this.serverApplication.getConsumptionResource();
                for (Consumption consumption : consumptions) {
                    serverConsumptionResource.addConsumption(consumption);
                }
            }
            if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleConsumption duration " + duration + " ms");
            }
        }
    }

    private void handleJobProcessingEvents() throws RemoteException {
        if (this.engineStub != null) {
            long duration;
            long logStartMillis = DateTime.now().getMillis();
            List events = this.engineStub.removeProcessingEvents();
            if (events != null) {
                ProcessingEventsResource processingEventsResource = this.serverApplication.getProcessingEventsResource();
                for (JobOperationEvent event : events) {
                    processingEventsResource.addProcessingEvent(event);
                }
            }
            if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleJobProcessingEvents duration " + duration + " ms");
            }
        }
    }

    private void handleWorkflowDynamicUpdates() throws RemoteException {
        if (this.engineStub != null) {
            long duration;
            long logStartMillis = DateTime.now().getMillis();
            List events = this.engineStub.removeWorkflowDynamicUpdates();
            if (events != null && events.size() > 0) {
                LOGGER.info("Detected workflow change, tracking Dynamic Workflow Update");
                WorkflowDynamicUpdatesResource workflowDynamicUpdatesResource = this.serverApplication.getWorkflowDynamicUpdatesResource();
                for (WorkflowDynamicUpdate event : events) {
                    workflowDynamicUpdatesResource.addWorkflowDynamicUpdate(event);
                }
            }
            if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleWorkflowDynamicUpdates duration " + duration + " ms");
            }
        }
    }

    private void handleEngineLogs() throws RemoteException {
        if (!this.configuration.getEnableCentralizedLogging()) {
            return;
        }
        if (this.engineStub != null) {
            long duration;
            long logStartMillis = DateTime.now().getMillis();
            List logs = this.engineStub.getEngineLogs();
            if (logs != null && logs.size() > 0) {
                LogsResource serverLogsResource = this.serverApplication.getServerLogsResource();
                serverLogsResource.addLogs(logs);
            }
            if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleEngineLogs duration " + duration + " ms");
            }
        }
    }

    private void handleExecutionLogs() throws RemoteException {
        if (this.engineStub != null) {
            long duration;
            long logStartMillis = DateTime.now().getMillis();
            List logs = this.engineStub.getExecutionLogs();
            if (logs != null && logs.size() > 0) {
                LogsResource serverLogsResource = this.serverApplication.getServerLogsResource();
                serverLogsResource.addExecutionLogs(logs);
            }
            if ((duration = DateTime.now().getMillis() - logStartMillis) > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleExecutionLogs duration " + duration + " ms");
            }
        }
    }

    private void handleEngineSettings() throws RemoteException {
        if (this.engineStub != null) {
            long logStartMillis = DateTime.now().getMillis();
            boolean useCentralizedLogging = this.serverApplication.getConfiguration().getEnableCentralizedLogging();
            this.engineStub.updateEngineLogModel(useCentralizedLogging);
            long duration = DateTime.now().getMillis() - logStartMillis;
            if (duration > this.maxEnginePingDuration) {
                this.maxEnginePingDuration = duration;
                LOGGER.info(this.model + " handleEngineSettings duration " + duration + " ms");
            }
        }
    }

    private void initializeEngineJob() throws InterruptedException {
        if (this.model.getStatus() == EngineStatus.ERROR || this.model.getStatus() == EngineStatus.WARNING) {
            long timeSinceLastError = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.model.getErrorTime();
            long sleepDuration = this.serverApplication.getConfiguration().getEngineErrorDelay() - timeSinceLastError;
            if (sleepDuration > 0L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Last error occurred " + timeSinceLastError + " ms ago, sleeping " + sleepDuration + " ms");
                }
                Thread.sleep(sleepDuration);
            }
        }
        if (this.startEngineJavaAppThread != null && this.startEngineJavaAppThread.isAlive()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Another attempt to start the Nuix Engine is in progress");
            }
            return;
        }
        if (this.bootstrappableJob != null && this.bootstrappableJob.getJobModel() != null) {
            ExecutionProfileModel executionProfileModel = null;
            String executionProfileId = this.bootstrappableJob.getJobModel().getExecutionProfileId();
            if (executionProfileId != null) {
                executionProfileModel = this.serverApplication.getServerExecutionProfiles().get(executionProfileId);
                if (executionProfileModel != null) {
                    if (!this.model.getWorkerAgentOnly()) {
                        LOGGER.info("Initializing " + this.model + " for " + this.bootstrappableJob.getJobModel());
                        this.bootstrappableJob.setExecutionProfile(executionProfileModel);
                        this.bootstrapJob(this.bootstrappableJob);
                    } else {
                        LOGGER.info("Initializing " + this.model);
                        this.initializeEngine();
                    }
                } else {
                    this.model.setError(this.iu.getFormattedString("EngineModel.InvalidExecutionProfile", (Object)executionProfileId));
                    this.model.setStatus(EngineStatus.ERROR);
                }
            } else {
                this.model.setError(this.iu.getString("EngineModel.JobNoExecutionProfile"));
                this.model.setStatus(EngineStatus.ERROR);
                this.bootstrappableJob = null;
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing " + this.model + " for configuration update");
            }
            this.initializeEngine();
        }
    }

    private void enforceExecutionPrerequisites() {
        if (this.executionMode == null || !this.executionMode.equals((Object)this.model.getSupportedExecutionMode())) {
            this.executionMode = this.model.getSupportedExecutionMode();
            if (this.model.getStatus().equals((Object)EngineStatus.STANDBY)) {
                this.model.setStatus(EngineStatus.NOT_INITIALIZED);
            }
        }
        if (this.model.getExecutionProfileId() != null && !this.model.getExecutionProfileId().trim().equals("")) {
            if (this.model.getStatus().equals((Object)EngineStatus.STANDBY)) {
                ExecutionProfileModel currentExecutionProfile = this.serverApplication.getServerExecutionProfiles().get(this.model.getExecutionProfileId());
                if (currentExecutionProfile != null) {
                    if (this.initializationExecutionProfile == null) {
                        this.initializationExecutionProfile = currentExecutionProfile;
                        this.model.setStatus(EngineStatus.NOT_INITIALIZED);
                    } else if (!this.initializationExecutionProfile.getId().equals(currentExecutionProfile.getId()) || this.initializationExecutionProfile.getStatus().getLastUpdatedDate() != currentExecutionProfile.getStatus().getLastUpdatedDate()) {
                        this.initializationExecutionProfile = currentExecutionProfile;
                        this.model.setStatus(EngineStatus.NOT_INITIALIZED);
                    }
                } else if (this.initializationExecutionProfile != null) {
                    this.model.setStatus(EngineStatus.NOT_INITIALIZED);
                }
            }
        } else if (this.initializationExecutionProfile != null) {
            this.model.setStatus(EngineStatus.NOT_INITIALIZED);
            this.initializationExecutionProfile = null;
        }
        if (this.model.getSupportedExecutionMode().equals((Object)ExecutionMode.AUTOMATE_NUIX) && this.model.getStatus().equals((Object)EngineStatus.STANDBY)) {
            NuixLicenseSourceModel currentNuixLicenceSource = null;
            Object licenceSource = null;
            if (this.serverApplication.getServerNuixLicenceSources() != null) {
                currentNuixLicenceSource = this.serverApplication.getServerNuixLicenceSources().get(this.model.getNuixLicenceSourceId());
            }
            if (currentNuixLicenceSource == null || this.runTimeNuixLicenceSource == null) {
                this.model.setStatus(EngineStatus.NOT_INITIALIZED);
            } else if (!currentNuixLicenceSource.getVersion().equals(this.runTimeNuixLicenceSource.getVersion())) {
                this.model.setStatus(EngineStatus.NOT_INITIALIZED);
            }
        }
    }

    private void handleEngineStandbyShutdownSessionEvent() {
        if (this.model.getLicenseSessionId() != null) {
            EventInfo engineSessionEndEventInfo = new EventInfo();
            engineSessionEndEventInfo.setDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            engineSessionEndEventInfo.setType(Type.SESSION_END);
            engineSessionEndEventInfo.setSessionId(this.model.getLicenseSessionId());
            SessionResource serverSessionResource = this.serverApplication.getSessionResource();
            if (serverSessionResource != null) {
                serverSessionResource.addEvent(engineSessionEndEventInfo);
            }
            this.model.setLicenseSessionId(null);
        }
    }

    @Override
    public synchronized void run() {
        try {
            this.enforceExecutionPrerequisites();
            this.handleEngineWork();
            if (this.model.getStatus() == EngineStatus.INITIALIZED) {
                LOGGER.info("Asking " + this.model + " to stand by");
                this.bootstrappableJob = null;
                if (this.engineStub != null) {
                    this.model = this.engineStub.standby();
                    this.handleEngineStandbyShutdownSessionEvent();
                } else {
                    this.model.setStatus(EngineStatus.STANDBY);
                }
                this.engineStub = null;
            }
            if (this.model.getStatus() == EngineStatus.ERROR || this.model.getStatus() == EngineStatus.WARNING || this.model.getStatus() == EngineStatus.NOT_INITIALIZED) {
                this.initializeEngineJob();
            }
        }
        catch (Throwable t) {
            LOGGER.warn("EngineWorker " + this.model + " error", t);
        }
    }

    @Override
    public synchronized void close() {
        LOGGER.info("Closing " + this.model);
        this.shutdown(true);
        this.cancel();
    }

    public JobModel getJobModel() {
        if (this.bootstrappableJob == null) {
            return null;
        }
        return this.bootstrappableJob.getJobModel();
    }

    public void pingEngine() throws RemoteException {
        if (this.engineStub != null) {
            this.engineStub.ping();
        }
    }

    public void runBootstrappedJob() throws RemoteException {
        try {
            EngineModel remoteModel = this.engineStub.runBootstrappedJob();
            if (remoteModel != null) {
                this.model = remoteModel;
            }
        }
        catch (NullPointerException e) {
            throw new RemoteException(this.iu.getString("EngineModel.NonResponsive"));
        }
    }

    public synchronized RunningLogEventsModel getRunningLog() {
        try {
            RunningLogEventsModel runningLog = this.engineStub.getRunningLog();
            return runningLog;
        }
        catch (NullPointerException | RemoteException e) {
            LOGGER.error("Cannot get job running log, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            return null;
        }
    }

    public synchronized List<OperationMimeTypeStats> getOperationMimeTypeStats() {
        try {
            List operationStats = this.engineStub.getOperationMimeTypeStats();
            return operationStats;
        }
        catch (NullPointerException | RemoteException e) {
            LOGGER.error("Cannot get job operations mime type stats, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acknowledgeFinishedStatus() throws RemoteException {
        EngineWorker engineWorker = this;
        synchronized (engineWorker) {
            try {
                this.finalHandleEngineWork();
                EngineModel remoteModel = this.engineStub.acknowledgeFinishedStatus();
                if (remoteModel != null) {
                    this.model = remoteModel;
                }
            }
            catch (InterruptedException | NullPointerException e) {
                LOGGER.error("Error acknowledgeFinishedStatus", (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RemoteException(this.iu.getString("EngineModel.NonResponsive"));
            }
            EngineWorker engineWorker2 = this;
            if (engineWorker2.configuration.getOsWindows()) {
                this.uninstallService(true);
                this.deleteServiceLogs(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acknowledgeWorkerAgentJobDone() throws RemoteException {
        EngineWorker engineWorker = this;
        synchronized (engineWorker) {
            try {
                this.handleSessionEvents();
                this.handleConsumption();
                EngineModel remoteModel = this.engineStub.acknowledgeWorkerAgentJobDone();
                if (remoteModel != null) {
                    this.model = remoteModel;
                }
            }
            catch (NullPointerException e) {
                throw new RemoteException(this.iu.getString("EngineModel.NonResponsive"));
            }
            EngineWorker engineWorker2 = this;
            if (engineWorker2.configuration.getOsWindows()) {
                this.uninstallService(true);
                this.deleteServiceLogs(true);
            }
        }
    }

    public synchronized void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean untrackRunningJob) {
        if (untrackRunningJob) {
            this.bootstrappableJob = null;
            this.model.setRunningJobId(null);
            this.model.setRunningJobId(null);
            this.model.setBootstrappingJobId(null);
            this.isShuttingDown = true;
        }
        this.logLocation = null;
        if (this.engineStub != null) {
            try {
                LOGGER.info("Shutting down " + this.model);
                this.engineStub.shutdown();
                this.handleEngineStandbyShutdownSessionEvent();
                this.handleSessionEvents();
                this.handleConsumption();
                this.engineStub = null;
            }
            catch (Exception e) {
                LOGGER.warn("Cannot ask " + this.model + " to shutdown", (Throwable)e);
            }
        }
        try {
            if (this.jvmProcess != null && this.jvmProcess.isAlive()) {
                try {
                    LOGGER.info("Waiting for process to shutdown");
                    this.jvmProcess.waitFor(this.configuration.getEngineShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Cannot wait for " + this.model + " to shutdown");
                    Thread.currentThread().interrupt();
                }
            }
            if (this.jvmProcess != null && this.jvmProcess.isAlive()) {
                LOGGER.warn("JVM " + this.model + " was alive, destroying");
                this.jvmProcess.destroyForcibly();
            } else {
                LOGGER.info("JVM " + this.model + " not running");
            }
            this.killJavaProcess();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot stop " + this.model + " Java process", (Throwable)e);
        }
        try {
            LOGGER.info("Attempting to unbind previous engine");
            this.serverApplication.getServerWorker().getRegistry().unbind(this.model.getId());
            this.engineStub = null;
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot unbind previous engine, " + ex.getMessage());
        }
    }

    public synchronized void abort() throws RemoteException {
        EngineModel remoteModel = null;
        try {
            remoteModel = this.engineStub.abort();
            this.handleSessionEvents();
            this.handleConsumption();
        }
        catch (NullPointerException | RemoteException e) {
            this.model.setError(this.iu.getString("EngineModel.NonResponsive"));
            this.model.setStatus(EngineStatus.ERROR);
            LOGGER.warn("Asked to abort " + this.model + ". Because it is in an Error state, cancelling entirely");
            this.shutdown(true);
            this.isShuttingDown = false;
            this.engineStub = null;
            this.model.setStatus(EngineStatus.NOT_INITIALIZED);
        }
        if (remoteModel != null) {
            this.model = remoteModel;
        }
    }

    public synchronized void skipOperation(int operationId) throws RemoteException {
        EngineModel remoteModel = null;
        try {
            remoteModel = this.engineStub.skipOperation(operationId);
        }
        catch (NullPointerException | RemoteException e) {
            this.model.setError(this.iu.getString("EngineModel.NonResponsive"));
            this.model.setStatus(EngineStatus.ERROR);
            LOGGER.warn("Asked to skip operation for " + this.model + ". Because it is in an Error state, cancelling entirely");
            this.shutdown(true);
            this.isShuttingDown = false;
            this.engineStub = null;
            this.model.setStatus(EngineStatus.NOT_INITIALIZED);
        }
        if (remoteModel != null) {
            this.model = remoteModel;
        }
    }

    public synchronized void stop() throws RemoteException {
        EngineModel remoteModel = null;
        try {
            remoteModel = this.engineStub.stop();
            this.handleSessionEvents();
            this.handleConsumption();
        }
        catch (NullPointerException | RemoteException e) {
            this.model.setError(this.iu.getString("EngineModel.NonResponsive"));
            this.model.setStatus(EngineStatus.ERROR);
            throw new RemoteException(this.iu.getString("EngineModel.NonResponsive"));
        }
        if (remoteModel != null) {
            this.model = remoteModel;
        }
    }

    public synchronized void pause() throws RemoteException {
        EngineModel remoteModel = null;
        try {
            remoteModel = this.engineStub.pauseJob();
            this.handleSessionEvents();
            this.handleConsumption();
            this.handleConsumption();
            if (this.bootstrappableJob != null && this.bootstrappableJob.getJobModel() != null) {
                this.bootstrappableJob.getJobModel().setResourcePoolId("");
            }
        }
        catch (NullPointerException | RemoteException e) {
            this.model.setError(this.iu.getString("EngineModel.NonResponsive"));
            this.model.setStatus(EngineStatus.ERROR);
            throw new RemoteException(this.iu.getString("EngineModel.NonResponsive"));
        }
        if (remoteModel != null) {
            this.model = remoteModel;
        }
    }

    synchronized void keepAliveCheck() {
        long lastPingAge = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.lastKeepAlivePing;
        if (lastPingAge > 5000L) {
            LOGGER.warn(this.model + " did not receive ping response in the last " + lastPingAge + " ms. Left " + (this.configuration.getEngineKeepAlive() - lastPingAge) + " ms. Last ping response at " + new DateTime(this.lastKeepAlivePing).toString("HH:mm:ss"));
        }
        if (lastPingAge > this.configuration.getEngineKeepAlive()) {
            LOGGER.error(this.model + " did not receive ping response in the last " + lastPingAge + " ms. Left " + (this.configuration.getEngineKeepAlive() - lastPingAge) + " ms. Last ping response at " + new DateTime(this.lastKeepAlivePing).toString("HH:mm:ss"));
            this.bootstrappableJob = null;
            this.model.setError(this.iu.getString("EngineModel.NonResponsive"));
            this.model.setStatus(EngineStatus.ERROR);
        }
    }

    public JobModel updateJobModel(JobModel newJobModel) throws RemoteException {
        try {
            if (this.bootstrappableJob != null) {
                this.bootstrappableJob.setJobModel(newJobModel);
            }
            return this.engineStub.updateJobModel(newJobModel);
        }
        catch (NullPointerException e) {
            throw new RemoteException(this.iu.getString("EngineModel.NonResponsive"));
        }
    }
}

