/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.workers;

import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.user.SystemApiKeyAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserSession;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.security.SecurityUtils;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.commons.lang.NotImplementedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class RegistrationWorker
extends TimerTask
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RegistrationWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private ServerApplication serverApplication;
    private ServerConfiguration configuration;
    private Client client;
    private String authToken;

    public RegistrationWorker(ServerApplication serverApplication) throws GeneralSecurityException {
        this.serverApplication = serverApplication;
        this.configuration = serverApplication.getConfiguration();
        HashSet<String> fingerprints = new HashSet<String>();
        if (this.configuration.getRegistrationSchedulerWhitelistedCertificateFingerprint() != null) {
            fingerprints.add(this.configuration.getRegistrationSchedulerWhitelistedCertificateFingerprint());
        }
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("Server" + UidUtils.getRandom()), fingerprints, (AutomateApplication)serverApplication, (AutomateConfiguration)serverApplication.getConfiguration());
        Timer timer = new Timer(true);
        timer.schedule((TimerTask)this, serverApplication.getConfiguration().getRegistrationBootstrapDelay(), serverApplication.getConfiguration().getRegistrationPingInterval());
    }

    @Override
    public synchronized void run() {
        try {
            DateTime lastPingDate = this.serverApplication.getConfigResource().getLastPingDateTime();
            long age = 0L;
            if (lastPingDate != null) {
                age = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - lastPingDate.getMillis();
            }
            if (lastPingDate == null || age > this.serverApplication.getConfiguration().getRegistrationPingInterval()) {
                this.registerWithScheduler();
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle registration", (Throwable)e);
        }
    }

    private void registerWithScheduler() {
        if (this.configuration.getAutoRegistrationSchedulerUrl() != null) {
            LOGGER.info("Attempting to register with Scheduler at " + this.configuration.getAutoRegistrationSchedulerUrl());
            Server server = new Server();
            server.setName(this.configuration.getAutoRegistrationServerName());
            server.setId(this.configuration.getServerInstanceId());
            server.setUrl(this.configuration.getAutoRegistrationServerUrl());
            try {
                this.refreshAuthToken();
                this.callApi("/v1/scheduler/resources/resourcePools/" + this.configuration.getAutoRegistrationSchedulerResourcePoolId() + "/selfRegistration", "POST", server, new GenericType<String>(){});
            }
            catch (ServerException e) {
                LOGGER.error("Cannot register server", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        LOGGER.warn("Hard closing Registration worker");
    }

    public <ResponseType, RequestType> ResponseType callApi(String location, String method, RequestType requestData, GenericType<ResponseType> entityType) throws ServerException {
        TreeMap<String, String> additionalHeaders = new TreeMap<String, String>();
        return this.callApi(location, method, requestData, additionalHeaders, entityType);
    }

    public <ResponseType, RequestType> ResponseType callApi(String location, String method, RequestType requestData, Map<String, String> additionalHeaders, GenericType<ResponseType> entityType) throws ServerException {
        try {
            Response response;
            WebTarget webTarget = this.client.target(this.serverApplication.getConfiguration().getAutoRegistrationSchedulerUrl() + "/api" + location);
            webTarget = webTarget.queryParam("roles", this.configuration.getAutoRegistrationRoles().toArray());
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            if (this.authToken != null) {
                invocationBuilder = invocationBuilder.header("Authorization", (Object)("Bearer " + this.authToken));
            }
            if (this.configuration.getAutoRegistrationSchedulerResourcePoolAccessKey() != null) {
                invocationBuilder = invocationBuilder.header("X-Resource-Pool-Access-Key", (Object)this.configuration.getAutoRegistrationSchedulerResourcePoolAccessKey());
            }
            for (String additionalHeader : additionalHeaders.keySet()) {
                invocationBuilder = invocationBuilder.header(additionalHeader, (Object)additionalHeaders.get(additionalHeader));
            }
            switch (method) {
                case "POST": {
                    response = invocationBuilder.post(Entity.json(requestData));
                    break;
                }
                case "PUT": {
                    response = invocationBuilder.put(Entity.json(requestData));
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                }
            }
            if (!response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                response.bufferEntity();
                String stringTitle = "";
                ResponseStatus responseStatus = new ResponseStatus();
                try {
                    responseStatus = (ResponseStatus)response.readEntity(ResponseStatus.class);
                    if (responseStatus.getMessage() == null || responseStatus.getCode() == 0) {
                        throw new IOException("Response is not ResponseStatusModel");
                    }
                    responseStatus.setRedirectUrl(null);
                }
                catch (Exception e) {
                    responseStatus.setMessage((String)response.readEntity(String.class));
                    responseStatus.setCode(500);
                }
                LOGGER.error(" /api" + location + " responded with HTTP/" + response.getStatus() + " " + responseStatus.getTitle() + " " + responseStatus.getMessage());
                throw new ServerException(responseStatus);
            }
            Object responseData = response.readEntity(entityType);
            return (ResponseType)responseData;
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Cannot query Scheduler, " + e.getMessage());
            throw new ServerException((ResponseStatus)new TranslationResponseStatus("cannotQueryModel", (Map)new HashMap<String, String>(){
                {
                    this.put("model", "proxy");
                    this.put("exception", e.getLocalizedMessage());
                }
            }));
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String location, String method, GenericType<ResponseType> entityType) throws ServerException {
        try {
            Response response;
            WebTarget webTarget = this.client.target(this.serverApplication.getConfiguration().getAutoRegistrationSchedulerUrl() + "/api" + location);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            if (this.authToken != null) {
                invocationBuilder = invocationBuilder.header("Authorization", (Object)("Bearer " + this.authToken));
            }
            if (this.configuration.getAutoRegistrationSchedulerResourcePoolAccessKey() != null) {
                invocationBuilder = invocationBuilder.header("X-Resource-Pool-Access-Key", (Object)this.configuration.getAutoRegistrationSchedulerResourcePoolAccessKey());
            }
            switch (method) {
                case "GET": {
                    response = invocationBuilder.get();
                    break;
                }
                case "DELETE": {
                    response = invocationBuilder.delete();
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                }
            }
            if (response.getStatus() == 401) {
                throw new ServerException((ResponseStatus)new TranslationResponseStatus("couldNotAuthenticateToEngineServer"));
            }
            if (response.getStatus() != 200) {
                response.bufferEntity();
                String stringTitle = "";
                ResponseStatus responseStatus = new ResponseStatus();
                try {
                    responseStatus = (ResponseStatus)response.readEntity(ResponseStatus.class);
                    if (responseStatus.getMessage() == null || responseStatus.getCode() == 0) {
                        throw new IOException("Response is not ResponseStatusModel");
                    }
                    responseStatus.setRedirectUrl(null);
                }
                catch (Exception e) {
                    responseStatus.setMessage((String)response.readEntity(String.class));
                    responseStatus.setCode(500);
                }
                LOGGER.error("proxy /api" + location + " responded with HTTP/" + response.getStatus() + " " + responseStatus.getTitle() + " " + responseStatus.getMessage());
                throw new ServerException(responseStatus);
            }
            Object responseData = response.readEntity(entityType);
            return (ResponseType)responseData;
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Cannot query Scheduler , " + e.getMessage());
            throw new ServerException((ResponseStatus)new TranslationResponseStatus("cannotQueryModel", (Map)new HashMap<String, String>(){
                {
                    this.put("model", "proxy");
                    this.put("exception", e.getLocalizedMessage());
                }
            }));
        }
    }

    private void refreshAuthToken() {
        this.authToken = null;
        SystemApiKeyAuthenticationSubmission systemApiKeyAuthenticationSubmission = new SystemApiKeyAuthenticationSubmission();
        systemApiKeyAuthenticationSubmission.setUsername("Engine Server");
        systemApiKeyAuthenticationSubmission.setNonce(SecurityUtils.getSecureRandomSecret());
        String code = SecurityUtils.getTokenFromApiSecret((String)this.serverApplication.getConfiguration().getApiSecret(), (String)systemApiKeyAuthenticationSubmission.getNonce());
        systemApiKeyAuthenticationSubmission.setCode(code);
        try {
            UserSession userSession = this.callApi("/v1/users/internalCode", "POST", systemApiKeyAuthenticationSubmission, new GenericType<UserSession>(){});
            this.authToken = userSession.getToken();
            LOGGER.info("Successfully authenticated to Scheduler as " + userSession.getName());
        }
        catch (ServerException e) {
            LOGGER.error("Cannot authenticate to Scheduler", (Throwable)e);
            this.authToken = null;
        }
    }
}

