/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.nuix.automate.dropwizard.utils.filter.AccessLogDataProcessor;
import com.nuix.automate.dropwizard.utils.filter.RestApiUsageBatch;
import com.nuix.automate.dropwizard.utils.filter.RestApiUsageServletFilter;
import com.nuix.automate.dropwizard.utils.filter.UriListener;
import com.nuix.automate.dropwizard.utils.resources.ErrorResource;
import com.nuix.automate.dropwizard.utils.resources.HealthResource;
import com.nuix.automate.dropwizard.utils.resources.ServicesResource;
import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.persistance.DaoManager;
import com.nuix.automate.scheduler.persistance.application.ApplicationDao;
import com.nuix.automate.scheduler.persistance.application.OfflineUtilizationPersistance;
import com.nuix.automate.scheduler.persistance.logging.LoggingDao;
import com.nuix.automate.scheduler.persistance.logging.LoggingDataSourceDetails;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.scheduler.resources.ApiKeyResource;
import com.nuix.automate.scheduler.resources.AuthMethodsResource;
import com.nuix.automate.scheduler.resources.AutomateLicenseResource;
import com.nuix.automate.scheduler.resources.ClientPoolResource;
import com.nuix.automate.scheduler.resources.ClientResource;
import com.nuix.automate.scheduler.resources.CommandResource;
import com.nuix.automate.scheduler.resources.ConfigurationResource;
import com.nuix.automate.scheduler.resources.DataRepositoryResource;
import com.nuix.automate.scheduler.resources.DatasetResource;
import com.nuix.automate.scheduler.resources.EnginesResource;
import com.nuix.automate.scheduler.resources.ExecutionProfileResource;
import com.nuix.automate.scheduler.resources.FileLibraryResource;
import com.nuix.automate.scheduler.resources.IncomingWebhookResource;
import com.nuix.automate.scheduler.resources.JobResource;
import com.nuix.automate.scheduler.resources.LegalHoldResource;
import com.nuix.automate.scheduler.resources.LibraryResource;
import com.nuix.automate.scheduler.resources.LockResource;
import com.nuix.automate.scheduler.resources.LogsResource;
import com.nuix.automate.scheduler.resources.MediaResources;
import com.nuix.automate.scheduler.resources.NetworkConfigurationResource;
import com.nuix.automate.scheduler.resources.NoticeResource;
import com.nuix.automate.scheduler.resources.NoticeTemplateResource;
import com.nuix.automate.scheduler.resources.NotificationRuleResource;
import com.nuix.automate.scheduler.resources.NuixLicenceSourceResource;
import com.nuix.automate.scheduler.resources.ODataV4UtilizationResource;
import com.nuix.automate.scheduler.resources.OutgoingWebhookResource;
import com.nuix.automate.scheduler.resources.PlatformResource;
import com.nuix.automate.scheduler.resources.ProxyResource;
import com.nuix.automate.scheduler.resources.ResourcePoolResource;
import com.nuix.automate.scheduler.resources.ScheduleResource;
import com.nuix.automate.scheduler.resources.SecurityResource;
import com.nuix.automate.scheduler.resources.ServerResource;
import com.nuix.automate.scheduler.resources.SettingsResource;
import com.nuix.automate.scheduler.resources.SoftWebhookResource;
import com.nuix.automate.scheduler.resources.StatusResource;
import com.nuix.automate.scheduler.resources.ThirdPartyServiceResource;
import com.nuix.automate.scheduler.resources.UserCommentResource;
import com.nuix.automate.scheduler.resources.UserDataDirResource;
import com.nuix.automate.scheduler.resources.UserResource;
import com.nuix.automate.scheduler.resources.UserServiceResource;
import com.nuix.automate.scheduler.resources.UserSettingsResource;
import com.nuix.automate.scheduler.resources.UtilResource;
import com.nuix.automate.scheduler.resources.UtilizationResource;
import com.nuix.automate.scheduler.security.AuthType;
import com.nuix.automate.scheduler.security.basic.BasicAuthUser;
import com.nuix.automate.scheduler.security.basic.BasicAuthUserAuthorizer;
import com.nuix.automate.scheduler.security.bearer.BearerAuthenticator;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.ums.PasswordBasicAuthenticator;
import com.nuix.automate.scheduler.transport.ConciseResponseFilter;
import com.nuix.automate.scheduler.utils.AesEncryptor;
import com.nuix.automate.scheduler.utils.AllowAllUtilizationSecurityPolicyUtil;
import com.nuix.automate.scheduler.utils.AuthenticationUtil;
import com.nuix.automate.scheduler.utils.AzureEnv;
import com.nuix.automate.scheduler.utils.AzureEnvironmentUtils;
import com.nuix.automate.scheduler.utils.LegalHoldUtils;
import com.nuix.automate.scheduler.utils.NmsUtils;
import com.nuix.automate.scheduler.utils.NoticeUtils;
import com.nuix.automate.scheduler.utils.NotificationsHandler;
import com.nuix.automate.scheduler.utils.OpenApiUtil;
import com.nuix.automate.scheduler.utils.SecurityPolicyUtil;
import com.nuix.automate.scheduler.utils.SessionUtils;
import com.nuix.automate.scheduler.utils.benchmark.JdbiTimingCollector;
import com.nuix.automate.scheduler.workers.MemgraphWorker;
import com.nuix.automate.scheduler.workers.ScheduleWorker;
import com.nuix.automate.scheduler.workers.WebhookWorker;
import com.nuix.automate.utils.api.OpenApiHelper;
import com.nuix.automate.utils.api.health.HealthInfo;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.configuration.ApiTrackingConfiguration;
import com.nuix.automate.utils.api.internal.configuration.CacheConfiguration;
import com.nuix.automate.utils.exceptions.AuthenticationResponseException;
import com.nuix.automate.utils.general.CertificateFingerprintException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.NameResolver;
import com.nuix.automate.utils.general.NetworkUtils;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.SystemResourcesUtils;
import com.nuix.automate.utils.general.ThreadPoolUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.logging.CentralizedLogInterceptor;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.service.ServiceInfo;
import com.nuix.automate.utils.models.api.workflowlibrary.AddWorkflowLibrariesResponse;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.Encryptor;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.utilization.AutomateModule;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionSubType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceSubType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.PolymorphicAuthDynamicFeature;
import io.dropwizard.auth.PolymorphicAuthValueFactoryProvider;
import io.dropwizard.auth.UnauthorizedHandler;
import io.dropwizard.auth.basic.BasicCredentialAuthFilter;
import io.dropwizard.auth.oauth.OAuthCredentialAuthFilter;
import io.dropwizard.core.Application;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.logging.common.LoggingUtil;
import io.dropwizard.web.WebBundle;
import io.dropwizard.web.conf.WebConfiguration;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.jdbi.v3.core.statement.StatementException;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SchedulerApplication
extends Application<SchedulerConfiguration>
implements AutomateApplication {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SchedulerApplication.class);
    private static SchedulerApplication instance;
    private SchedulerConfiguration configuration;
    private BearerAuthenticator bearerAuthenticator;
    private EnginesResource schedulerEnginesResource;
    private UserSettingsResource userSettingsResource;
    private SettingsResource settingsResource;
    private JobResource jobResource;
    private UserServiceResource userServiceResource;
    private UserResource userResource;
    private ServerResource serverResource;
    private NuixLicenceSourceResource nuixLicenceSourceResource;
    private AutomateLicenseResource automateLicenseResource;
    private NetworkConfigurationResource networkConfigurationResource;
    private UserDataDirResource userDataDirResource;
    private ResourcePoolResource resourcePoolResource;
    private ExecutionProfileResource executionProfileResource;
    private NotificationRuleResource notificationRuleResource;
    private ScheduleResource scheduleResource;
    private FileLibraryResource fileLibraryResource;
    private ClientPoolResource clientPoolResource;
    private DataRepositoryResource dataRepositoryResource;
    private MediaResources mediaResources;
    private PlatformResource platformResource;
    private LibraryResource libraryResource;
    private ClientResource clientResource;
    private SecurityResource securityResource;
    private DatasetResource datasetResource;
    private LogsResource logsResource;
    private UtilizationResource utilizationResource;
    private LegalHoldResource legalHoldResource;
    private NoticeTemplateResource noticeTemplateResource;
    private NoticeResource noticeResource;
    private UserCommentResource userCommentResource;
    private ThirdPartyServiceResource thirdPartyServiceResource;
    private CommandResource commandResource;
    private UtilResource utilResource;
    private StatusResource statusResource;
    private ApiKeyResource apiKeyResource;
    private LockResource lockResource;
    private OutgoingWebhookResource webhookResource;
    private AuthMethodsResource authMethodsResource;
    private SecurityPolicyUtil securityPolicyUtil;
    private String instanceId;
    private Map<String, NuixLicenseSourceModel> serverNuixLicenceSources;
    private AutomateLicenceModel serverRampivaLicence;
    private Map<String, ExecutionProfileModel> serverExecutionProfiles;
    private Encryptor encryptor;
    private Environment environment;
    private boolean closing;
    private NotificationsHandler notificationsHandler;
    private NmsUtils nmsUtils;
    private NoticeUtils noticeUtils;
    private LegalHoldUtils legalHoldUtils;
    private ScheduledThreadPoolExecutor scheduledExecutorService;
    private AesEncryptor aesEncryptor;
    private ScheduleWorker scheduleWorker;
    private WebhookWorker webhookWorker;
    private MemgraphWorker memgraphWorker;
    private LicenceUtils licenceUtils;
    private CentralizedLogInterceptor<ILoggingEvent> centralizedLoggingAppender;
    private LogHandler logHandler;
    private PasswordBasicAuthenticator passwordBasicAuthenticator;
    private AuthenticationUtil authenticationUtil;
    private SessionUtils sessionUtils;
    private boolean initializing;
    private Map<String, AuthType> authScopeTypes;
    private String runId;
    private String runNonce;
    private ProxyResource proxyResource;
    private JdbiTimingCollector timingCollector;
    private Random random = new Random();
    private DaoManager daoManager;
    private IncomingWebhookResource incomingWebhookResource;
    private NameResolver nameResolver;
    private boolean ignoreLicense;
    private int lastDayHeaderLogged;
    private boolean applicationStarted;

    public SchedulerApplication() {
        instance = this;
    }

    public static SchedulerApplication getInstance() {
        return instance;
    }

    public SchedulerConfiguration getConfiguration() {
        return this.configuration;
    }

    private void setConfiguration(SchedulerConfiguration schedulerConfiguration) {
        this.configuration = schedulerConfiguration;
    }

    private void logHeader(boolean force) {
        if (force) {
            this.lastDayHeaderLogged = 0;
        }
        this.logHeader();
    }

    private void logHeader() {
        int currentDay = DateTime.now().getDayOfYear();
        if (currentDay != this.lastDayHeaderLogged) {
            this.lastDayHeaderLogged = currentDay;
            LOGGER.info("################### " + ((Object)((Object)this)).getClass().getSimpleName() + " ###################");
            LOGGER.info("DateTime UTC: " + String.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC)));
            LOGGER.info("Automate Version: " + VersionResources.getVersion());
            LOGGER.info("JVM Version: " + System.getProperty("java.vendor") + " / " + System.getProperty("java.runtime.version") + " / " + System.getProperty("java.vm.name"));
            LOGGER.info("JVM Path: " + System.getProperty("java.home"));
            LOGGER.info("OS: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"));
            LOGGER.info("PATH: " + System.getenv("PATH"));
            if (this.configuration.getEngineCommandLine() != null) {
                LOGGER.info("Command-line: " + this.configuration.getEngineCommandLine());
            }
            LOGGER.info("Role: " + String.valueOf(this.configuration.getRole()));
            try {
                LOGGER.info("IP addresses: " + String.join((CharSequence)",", this.nameResolver.getLocalIpAddresses()));
            }
            catch (Exception e) {
                LOGGER.info("IP addresses: Unknown");
            }
        }
    }

    public void setServerNuixLicenceSources(Map<String, NuixLicenseSourceModel> serverNuixLicenceSources) {
        this.serverNuixLicenceSources = serverNuixLicenceSources;
    }

    public void setServerRampivaLicence(AutomateLicenceModel serverRampivaLicence) {
        this.serverRampivaLicence = serverRampivaLicence;
    }

    public AutomateLicenceModel getServerRampivaLicence() {
        return this.serverRampivaLicence;
    }

    public Map<String, NuixLicenseSourceModel> getServerNuixLicenceSources() {
        return this.serverNuixLicenceSources;
    }

    public void setServerExecutionProfiles(Map<String, ExecutionProfileModel> serverExecutionProfiles) {
        this.serverExecutionProfiles = serverExecutionProfiles;
    }

    public Map<String, ExecutionProfileModel> getServerExecutionProfiles() {
        if (this.serverExecutionProfiles == null) {
            this.serverExecutionProfiles = new HashMap<String, ExecutionProfileModel>();
        }
        return this.serverExecutionProfiles;
    }

    public static void main(String[] args) throws Exception {
        new SchedulerApplication().run(args);
    }

    public EnginesResource getSchedulerEnginesResource() {
        return this.schedulerEnginesResource;
    }

    public JobResource getJobResource() {
        return this.jobResource;
    }

    public ServerResource getServerResource() {
        return this.serverResource;
    }

    public NuixLicenceSourceResource getNuixLicenceSourceResource() {
        return this.nuixLicenceSourceResource;
    }

    public AutomateLicenseResource getAutomateLicenceResource() {
        return this.automateLicenseResource;
    }

    public NetworkConfigurationResource getNetworkConfigurationResource() {
        return this.networkConfigurationResource;
    }

    public void setNetworkConfigurationResource(NetworkConfigurationResource networkConfigurationResource) {
        this.networkConfigurationResource = networkConfigurationResource;
    }

    public UserDataDirResource getUserDataDirResource() {
        return this.userDataDirResource;
    }

    public UserSettingsResource getUserSettingsResource() {
        return this.userSettingsResource;
    }

    public SettingsResource getSettingsResource() {
        return this.settingsResource;
    }

    public ResourcePoolResource getResourcePoolResource() {
        return this.resourcePoolResource;
    }

    public ExecutionProfileResource getExecutionProfileResource() {
        return this.executionProfileResource;
    }

    public NotificationRuleResource getNotificationRuleResource() {
        return this.notificationRuleResource;
    }

    public DataRepositoryResource getDataRepositoryResource() {
        return this.dataRepositoryResource;
    }

    public DatasetResource getDatasetResource() {
        return this.datasetResource;
    }

    public ApiKeyResource getApiKeyResource() {
        return this.apiKeyResource;
    }

    public OutgoingWebhookResource getWebhookResource() {
        return this.webhookResource;
    }

    public ScheduleResource getScheduleResource() {
        return this.scheduleResource;
    }

    public FileLibraryResource getFileLibraryResource() {
        return this.fileLibraryResource;
    }

    public ClientPoolResource getClientPoolResource() {
        return this.clientPoolResource;
    }

    public LogsResource getLoggingResource() {
        return this.logsResource;
    }

    public LegalHoldResource getLegalHoldResource() {
        return this.legalHoldResource;
    }

    public NoticeTemplateResource getNoticeTemplateResource() {
        return this.noticeTemplateResource;
    }

    public NoticeResource getNoticeResource() {
        return this.noticeResource;
    }

    public UserCommentResource getUserCommentResource() {
        return this.userCommentResource;
    }

    public ThirdPartyServiceResource getThirdPartyServiceResource() {
        return this.thirdPartyServiceResource;
    }

    public String getName() {
        return "Automate Scheduler";
    }

    public void initialize(Bootstrap<SchedulerConfiguration> bootstrap) {
        final String[] styleSrcHashes = new String[]{"'sha256-Pt+3ApmjQaR1IA87F/r0Px4hIo3skUP3AMdXS+P1bTA='", "'sha256-47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU='", "'sha256-MeMkKJZSwNF64PwFnuEMs4RAXIGwpopUzI/ZnTwhps4='", "'sha256-hfTWg+rbklz2fpbmjBDtNnVqr5nZakk0hqhjPjtMfQ8='"};
        final String[] scriptSrcHashes = new String[]{"'sha256-Hp0z55+phJdz6m5gPxlWMuxtWai/ai8CFplEm3B29cU='"};
        bootstrap.addBundle((ConfiguredBundle)new AssetsBundle("/assets", "/", "index.html"));
        bootstrap.addBundle((ConfiguredBundle)new WebBundle<SchedulerConfiguration>(){

            public WebConfiguration getWebConfiguration(SchedulerConfiguration configuration) {
                WebConfiguration webConfiguration = configuration.getWebConfiguration();
                if (webConfiguration != null && webConfiguration.getCspHeaderFactory() != null) {
                    String csp = webConfiguration.getCspHeaderFactory().getPolicy();
                    CharSequence[] fields = csp.split(";");
                    int styleFieldIndex = -1;
                    int scriptFieldIndex = -1;
                    for (int i = 0; i < fields.length; ++i) {
                        String fieldName = fields[i].trim().split(" ")[0];
                        if (fieldName.trim().equalsIgnoreCase("style-src")) {
                            styleFieldIndex = i;
                            break;
                        }
                        if (!fieldName.trim().equalsIgnoreCase("script-src")) continue;
                        scriptFieldIndex = i;
                        break;
                    }
                    if (styleFieldIndex >= 0) {
                        String styleSrcField = fields[styleFieldIndex];
                        if (!styleSrcField.contains("'unsafe-inline'")) {
                            int n = styleFieldIndex;
                            fields[n] = (String)fields[n] + " " + String.join((CharSequence)" ", styleSrcHashes);
                        } else {
                            configuration.setUsesUnsafeInline(true);
                            ArrayList<String> filteredStyleSrc = new ArrayList<String>();
                            for (String src : styleSrcField.split(" ")) {
                                if (src.startsWith("'sha256-") || src.startsWith("'nonce-")) continue;
                                filteredStyleSrc.add(src);
                            }
                            fields[styleFieldIndex] = String.join((CharSequence)" ", filteredStyleSrc);
                        }
                    }
                    if (scriptFieldIndex >= 0) {
                        String scriptSrcField = fields[scriptFieldIndex];
                        if (!scriptSrcField.contains("'unsafe-inline'")) {
                            int n = scriptFieldIndex;
                            fields[n] = (String)fields[n] + " " + String.join((CharSequence)" ", scriptSrcHashes);
                        } else {
                            configuration.setUsesUnsafeInline(true);
                            ArrayList<String> filteredScriptSrc = new ArrayList<String>();
                            for (String src : scriptSrcField.split(" ")) {
                                if (src.startsWith("'sha256-") || src.startsWith("'nonce-")) continue;
                                filteredScriptSrc.add(src);
                            }
                            fields[scriptFieldIndex] = String.join((CharSequence)" ", filteredScriptSrc);
                        }
                    }
                    csp = String.join((CharSequence)";", fields);
                    webConfiguration.getCspHeaderFactory().setPolicy(csp);
                }
                return webConfiguration;
            }
        });
        bootstrap.getObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public BearerAuthenticator getBearerAuthenticator() {
        return this.bearerAuthenticator;
    }

    public PasswordBasicAuthenticator getPasswordBasicAuthenticator() {
        return this.passwordBasicAuthenticator;
    }

    public ApplicationDao getJobsArchiveDao() {
        return this.daoManager.getJobsArchiveDao();
    }

    public UtilizationDao forceGetUtilizationDaoV2() {
        return this.daoManager.getUtilizationDao();
    }

    public UtilizationDao getUtilizationDaoV2() {
        return this.getUtilizationDaoV2(this.ignoreLicense);
    }

    public UtilizationDao getUtilizationDaoV2(boolean ignoreLicense) {
        if (ignoreLicense) {
            return this.daoManager.getUtilizationDao();
        }
        try {
            this.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
            return this.daoManager.getUtilizationDao();
        }
        catch (Exception e) {
            return this.daoManager.getDummyUtilizationDao();
        }
    }

    public LogsResource getLogsResource() {
        return this.logsResource;
    }

    public String getJavaVersion() {
        return System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.version");
    }

    public SecurityPolicyUtil getSecurityPolicyUtil() {
        return this.securityPolicyUtil;
    }

    public LoggingDao getLoggingDao() {
        return this.daoManager.getLoggingDao();
    }

    private void initializeInstanceId() {
        if (this.instanceId != null) {
            LOGGER.info("Skipping initializing instanceID because it's already initialized");
            return;
        }
        LOGGER.info("Initializing instanceID");
        if (this.daoManager.getApplicationDao().getIds().size() == 0) {
            LOGGER.info("No instanceID found in the database, creating new random ID");
            this.instanceId = UidUtils.getRandom();
            try {
                this.daoManager.getApplicationDao().addId(this.instanceId);
            }
            catch (StatementException e) {
                LOGGER.error("Could not persist instanceID", (Throwable)e);
            }
        } else {
            LOGGER.info("Read instanceID from database");
            this.instanceId = this.daoManager.getApplicationDao().getIds().get(0);
        }
        this.logHandler.setComponentId(this.instanceId);
    }

    private void createDefaultPolicies() {
        if (this.securityPolicyUtil.getPolicies().size() == 0) {
            LOGGER.info("Creating default policies");
            SecurityPolicy securityPolicy = this.securityPolicyUtil.createDefaultPolicy();
            this.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), securityPolicy.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.SECURITY_POLICY_ADDED, this.securityPolicyUtil.policyToString(securityPolicy), "N/A"));
            SecurityPolicy jobViewerPolicy = this.securityPolicyUtil.createProcessingJobViewerPolicy();
            this.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobViewerPolicy.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.SECURITY_POLICY_ADDED, this.securityPolicyUtil.policyToString(jobViewerPolicy), "N/A"));
            SecurityPolicy jobSubmitterPolicy = this.securityPolicyUtil.createProcessingJobSubmitterPolicy();
            this.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobSubmitterPolicy.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.SECURITY_POLICY_ADDED, this.securityPolicyUtil.policyToString(jobSubmitterPolicy), "N/A"));
            SecurityPolicy administratorPolicy = this.securityPolicyUtil.createAdministratorPolicy();
            this.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), administratorPolicy.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.SECURITY_POLICY_ADDED, this.securityPolicyUtil.policyToString(administratorPolicy), "N/A"));
            SecurityPolicy securityAdministratorPolicy = this.securityPolicyUtil.createSecurityAdministratorPolicy();
            this.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), securityAdministratorPolicy.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.SECURITY_POLICY_ADDED, this.securityPolicyUtil.policyToString(securityAdministratorPolicy), "N/A"));
        }
    }

    public void run(final SchedulerConfiguration configuration, Environment environment) throws InterruptedException {
        NetworkUtils.startDebugShutdownSocket();
        this.initializing = true;
        this.environment = environment;
        this.configuration = configuration;
        configuration.initializeFromEnv();
        this.nameResolver = new NameResolver(configuration.getNameResolutionTimeout());
        environment.lifecycle().addServerLifecycleListener(server -> {
            String httpUri = null;
            String httpsUri = null;
            block10: for (Connector connector : server.getConnectors()) {
                String scheme;
                if (!(connector instanceof ServerConnector)) continue;
                ServerConnector serverConnector = (ServerConnector)connector;
                Object url = "http";
                if (serverConnector.getDefaultProtocol().equalsIgnoreCase("ssl")) {
                    url = (String)url + "s";
                }
                url = (String)url + "://" + serverConnector.getHost() + ":" + serverConnector.getPort();
                URI uri = URI.create((String)url);
                switch (scheme = uri.getScheme()) {
                    case "http": {
                        httpUri = uri.toString();
                        continue block10;
                    }
                    case "https": {
                        httpsUri = uri.toString();
                    }
                }
            }
            if (configuration.getLoopbackUrl() == null || configuration.getLoopbackUrl().trim().isEmpty()) {
                String normalizedUri = null;
                if (httpsUri != null) {
                    normalizedUri = httpsUri;
                }
                if (httpUri != null) {
                    normalizedUri = httpUri;
                }
                if (normalizedUri != null) {
                    normalizedUri = normalizedUri.replace("0.0.0.0", "127.0.0.1");
                    configuration.setLoopbackUrl(normalizedUri);
                }
            }
            if ((configuration.getLoopbackFingerprint() == null || configuration.getLoopbackFingerprint().trim().isEmpty()) && httpsUri != null) {
                String fingerprint;
                block19: {
                    fingerprint = null;
                    String normalizedUri = httpsUri.replace("0.0.0.0", "127.0.0.1");
                    HashSet<String> fingerprints = new HashSet<String>();
                    fingerprints.add("dummy-fingerprint");
                    try {
                        Client client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)"scheduler-loopback-configure", fingerprints, (boolean)false);
                        client.target(normalizedUri).request().get();
                    }
                    catch (Exception e) {
                        LOGGER.info("Cannot connect to loopback URI with dummy fingerprint" + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
                        Throwable cause = e.getCause();
                        if (cause != null) {
                            cause = cause.getCause();
                        }
                        if (!(cause instanceof CertificateFingerprintException)) break block19;
                        fingerprint = ((CertificateFingerprintException)cause).getFingerprint();
                    }
                }
                configuration.setLoopbackFingerprint(fingerprint);
            }
            LOGGER.info("Loopback URL: " + configuration.getLoopbackUrl());
            LOGGER.info("Loopback Fingerprint: " + configuration.getLoopbackFingerprint());
            if (this.executionProfileResource != null) {
                this.executionProfileResource.updateExecutionProfilesCertificateFingerprints();
            }
            this.applicationStarted = true;
        });
        environment.jersey().property("jersey.config.disableAutoDiscovery", (Object)Boolean.TRUE);
        LOGGER.info("\n\n");
        LOGGER.info("######################### INIT #########################");
        this.logHeader();
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SchedulerApplication.this.logHeader();
            }
        }, 0L, 60000L);
        this.runId = UidUtils.getRandom();
        this.runNonce = SecurityUtils.getSecureRandomSecret();
        ErrorPageErrorHandler errorPageErrorHandler = new ErrorPageErrorHandler();
        errorPageErrorHandler.addErrorPage(404, "/api/error/404");
        environment.getApplicationContext().setErrorHandler((ErrorHandler)errorPageErrorHandler);
        try {
            String openApiDescription;
            CacheConfiguration cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setGlobalResponseCacheMaxValidity(configuration.getGlobalResponseCacheMaxValidity());
            cacheConfiguration.setResponseCacheMaxValidity(configuration.getResponseCacheMaxValidity());
            cacheConfiguration.setDisableResponseCache(configuration.getDisableResponseCache());
            if (configuration.getRole().equals((Object)SchedulerComponent.SCHEDULER) || configuration.getRole().equals((Object)SchedulerComponent.OPENAPI_EXPORT)) {
                String jvmName = System.getProperty("java.vm.name");
                String arch = System.getProperty("os.arch");
                if (jvmName != null && jvmName.contains("OpenJDK") && arch != null && arch.equals("amd64")) {
                    LOGGER.info("Using OpenSSLProvider " + OpenSSLProvider.class.toString());
                    Security.insertProviderAt((Provider)new OpenSSLProvider(), 1);
                } else {
                    LOGGER.info("Using default security provider");
                }
                this.authScopeTypes = new LinkedHashMap<String, AuthType>();
                if (configuration.getInternalCredentials() != null) {
                    this.authScopeTypes.put(configuration.getInternalCredentials().getDisplayName(), AuthType.INTERNAL);
                }
            }
            ResponseCache.initialize((CacheConfiguration)cacheConfiguration);
            this.aesEncryptor = new AesEncryptor(this);
            this.sessionUtils = new SessionUtils(this);
            this.scheduledExecutorService = ThreadPoolUtils.createScheduledThreadPoolExecutor((String)"Common", (int)ThreadPoolUtils.RUNTIME_AVAILABLE_PROCESSORS);
            environment.lifecycle().addEventListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

                public void lifeCycleStopping(LifeCycle event) {
                    try {
                        if (SchedulerApplication.this.webhookWorker != null) {
                            SchedulerApplication.this.webhookWorker.triggerEvent(EventType.Type.SERVICE_SCHEDULER_STOPPED, new ServiceInfo(SchedulerApplication.this.runId));
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("Cannot trigger event");
                    }
                    if (SchedulerApplication.this.automateLicenseResource != null) {
                        try {
                            SchedulerApplication.this.automateLicenseResource.close();
                        }
                        catch (Throwable t) {
                            LOGGER.error("Cannot close Automate session");
                        }
                    }
                }
            });
            if (configuration.getEnableCentralizedLogging()) {
                LoggerContext context = LoggingUtil.getLoggerContext();
                Logger logger = context.getLogger("ROOT");
                this.centralizedLoggingAppender = new CentralizedLogInterceptor();
                this.centralizedLoggingAppender.setName("centralized-logging");
                this.centralizedLoggingAppender.setContext((Context)context);
                this.centralizedLoggingAppender.start();
                logger.addAppender(this.centralizedLoggingAppender);
            }
            environment.jersey().property("jersey.config.server.contentLength.buffer", (Object)0);
            environment.lifecycle().addEventListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

                public void lifeCycleStopping(LifeCycle event) {
                    if (configuration.getEnableCentralizedLogging() && SchedulerApplication.this.logsResource != null) {
                        try {
                            SchedulerApplication.this.logsResource.cleanup();
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to stop centralized logger");
                        }
                    }
                }
            });
            this.logHandler = LogHandler.getInstance();
            this.logHandler.configureInstance((AutomateApplication)this, (AutomateConfiguration)configuration);
            this.logHandler.updateLogHandlerComponent();
            if (configuration.getRestartAfterFinishedJob()) {
                LOGGER.warn("Using deprecated setting restartAfterFinishedJob. This setting will be ignored because engine contexts are refreshed when the job is started.");
            }
            if (configuration.getCorsAllowedOrigins() != null) {
                LOGGER.info("Setting CORS configuration");
                FilterRegistration.Dynamic cors = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
                cors.setInitParameter("allowedOrigins", configuration.getCorsAllowedOrigins());
                if (configuration.getCorsAllowedHeaders() != null) {
                    cors.setInitParameter("allowedHeaders", configuration.getCorsAllowedHeaders());
                }
                if (configuration.getCorsAllowedMethods() != null) {
                    cors.setInitParameter("allowedMethods", configuration.getCorsAllowedMethods());
                }
                cors.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
                cors.setInitParameter("chainPreflight", Boolean.FALSE.toString());
            }
            environment.servlets().addFilter("ConciseResponse", ConciseResponseFilter.class).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/api/*"});
            this.timingCollector = configuration.getDebugSqlLogsPath() != null ? null : null;
            environment.lifecycle().addEventListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

                public void lifeCycleStopping(LifeCycle event) {
                    if (configuration.getDebugSqlLogsPath() != null && SchedulerApplication.this.timingCollector != null) {
                        SchedulerApplication.this.timingCollector.cleanup();
                    }
                }
            });
            SystemResourcesUtils.getInstance().checkMemoryUsage("Init");
            this.noticeUtils = new NoticeUtils(this);
            this.legalHoldUtils = new LegalHoldUtils(this);
            this.nmsUtils = new NmsUtils(this);
            this.notificationsHandler = new NotificationsHandler(this);
            this.passwordBasicAuthenticator = new PasswordBasicAuthenticator(this, configuration);
            this.bearerAuthenticator = new BearerAuthenticator(this, configuration);
            UnauthorizedHandler unauthorizedHandler = new UnauthorizedHandler(){

                @Nullable
                public Response buildResponse(String prefix, String realm) {
                    String authHeader = null;
                    Collection<MicrosoftOidcUserServiceClient> microsoftOidcClients = SchedulerApplication.this.userServiceResource.getEnabledMicrosoftOidcClients();
                    if (microsoftOidcClients.size() > 0) {
                        MicrosoftOidcUserServiceClient firstMicrosoftOidcClient = microsoftOidcClients.iterator().next();
                        String clientId = firstMicrosoftOidcClient.getOidcUserService().getClientId().replace("\"", "");
                        MicrosoftUserService firstMicrosoftUserService = (MicrosoftUserService)firstMicrosoftOidcClient.getOidcUserService();
                        String tenantId = firstMicrosoftUserService.getTenant().replace("\"", "");
                        AzureEnv azureEnv = AzureEnvironmentUtils.resolveEnvironmentFromName(firstMicrosoftUserService.getEnvironment());
                        authHeader = "Bearer realm=\"" + tenantId + "\", error=\"invalid_token\", error_description=\"Access Token missing or malformed.\", authorization_uri=\"" + azureEnv.getAuthorityUrl() + "/" + tenantId + "/oauth2/v2.0/authorize\", client_id=\"" + clientId + "\"";
                    }
                    if (authHeader != null) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").header("WWW-Authenticate", authHeader).build();
                    }
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").build();
                }

                public RuntimeException buildException(String prefix, String realm) {
                    return super.buildException(prefix, realm);
                }
            };
            AuthFilter basicCredentialAuthFilter = new BasicCredentialAuthFilter.Builder().setAuthenticator((Authenticator)this.passwordBasicAuthenticator).setAuthorizer((Authorizer)new BasicAuthUserAuthorizer()).setPrefix("Basic").setUnauthorizedHandler(unauthorizedHandler).buildAuthFilter();
            AuthFilter oauthCredentialAuthFilter = new OAuthCredentialAuthFilter.Builder().setAuthenticator((Authenticator)this.bearerAuthenticator).setPrefix("Bearer").setUnauthorizedHandler(unauthorizedHandler).buildAuthFilter();
            PolymorphicAuthDynamicFeature feature = new PolymorphicAuthDynamicFeature((Map)ImmutableMap.of(BasicAuthUser.class, (Object)basicCredentialAuthFilter, BearerUser.class, (Object)oauthCredentialAuthFilter));
            PolymorphicAuthValueFactoryProvider.Binder binder = new PolymorphicAuthValueFactoryProvider.Binder((Set)ImmutableSet.of(BasicAuthUser.class, BearerUser.class));
            environment.jersey().register((Object)feature);
            environment.jersey().register((Object)binder);
            environment.jersey().register(RolesAllowedDynamicFeature.class);
            if (configuration.getDebugLogRequestResponse()) {
                LOGGER.info("Enabling verbose request/response logging");
                environment.jersey().register((Object)new LoggingFeature(java.util.logging.Logger.getLogger("inbound"), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(81920)));
            }
            this.authenticationUtil = new AuthenticationUtil(this);
            this.licenceUtils = new LicenceUtils();
            if (configuration.getNuixUserDataDir() == null) {
                configuration.setNuixUserDataDir(configuration.getNuixEnginePath() + "/user-data");
            }
            environment.jersey().setUrlPattern("/api/*");
            environment.jersey().register((Object)new ErrorResource());
            if (configuration.getRole().equals((Object)SchedulerComponent.SCHEDULER) || configuration.getRole().equals((Object)SchedulerComponent.OPENAPI_EXPORT)) {
                this.settingsResource = new SettingsResource(this);
                this.daoManager = new DaoManager(this);
                this.daoManager.initializeApplicationDaos();
                this.initializeInstanceId();
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.settingsResource);
                }
            }
            if ((openApiDescription = configuration.getOpenApiDescription()) == null) {
                openApiDescription = "## Introduction\nThe Automate API can be used to configure settings, resources such as libraries and clients, as well as to initiate legal holds, queue jobs, queue collections and monitor their progress.\n\n## Authentication\nThe Automate API uses the Bearer token authentication mechanism. The Bearer token can be obtained either by authenticating with an allowed method to the corresponding to the **/v1/users** endpoint, or by creating an API key in the application and using the API key ID and secret for the token value. The Bearer token must be submitted in all subsequent API calls in the **Authorization** header, for example\n\n    Authorization: Bearer 6e74dbcc-b59c-4228-8536-cb60330a0414:kUfbxN0KuNnkvccpJCxhJQ6p47saLQO5\n     \n## Error Codes\nThe API returns the following error codes:\n\n - HTTP/400 - The data supplied is invalid \n - HTTP/401 - The user is not authenticated (see *Authentication* section)\n - HTTP/403 - The user does not have the required privileges to perform this action\n - HTTP/500 - The server encountered an error executing the request.\n\n## Considerations\nIt's recommended to use the List methods to get a list of objects of a certain type instead of the Get methods, unless the full information of the objects is neededWhen updating objects, only the attributes which are updated have to be submitted.\n";
            }
            OpenAPI oas = new OpenAPI();
            License rampivaOpenApiLicense = new License();
            rampivaOpenApiLicense.setName("Agreements and Terms");
            rampivaOpenApiLicense.setUrl("https://www.nuix.com/legal");
            Info info = new Info().title("Automate API documentation").version(VersionResources.getVersion()).description(openApiDescription).license(rampivaOpenApiLicense).contact(new Contact().url("https://nuix.com"));
            oas.info(info);
            OpenApiHelper.addCustomComponents((OpenAPI)oas);
            Server server2 = new Server().url("../api");
            oas.addServersItem(server2);
            SwaggerConfiguration oasConfig = new SwaggerConfiguration().readAllResources(Boolean.valueOf(false)).openAPI(oas).prettyPrint(Boolean.valueOf(true)).resourcePackages(Stream.of("com.nuix.automate.scheduler.resources").collect(Collectors.toSet()));
            if (configuration.getRole().equals((Object)SchedulerComponent.SCHEDULER) || configuration.getRole().equals((Object)SchedulerComponent.OPENAPI_EXPORT)) {
                OfflineUtilizationPersistance offlineUtilizationPersistance;
                this.commandResource = new CommandResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.commandResource);
                }
                this.utilResource = new UtilResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.utilResource);
                }
                this.statusResource = new StatusResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.statusResource);
                }
                this.securityPolicyUtil = new SecurityPolicyUtil(this.daoManager.getSecurityDao(), this);
                this.createDefaultPolicies();
                LoggingDataSourceDetails managedLoggingStore = this.daoManager.initializeLoggingDao(configuration.getEffectiveLoggingStore(), "loggingStore", true);
                this.daoManager.initializeUtilizationDaos();
                this.networkConfigurationResource = new NetworkConfigurationResource(this);
                environment.jersey().register((Object)this.networkConfigurationResource);
                this.automateLicenseResource = new AutomateLicenseResource(this);
                this.userDataDirResource = new UserDataDirResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.userDataDirResource);
                }
                this.userResource = new UserResource(this, configuration);
                environment.jersey().register((Object)this.userResource);
                try {
                    offlineUtilizationPersistance = new OfflineUtilizationPersistance(this);
                    offlineUtilizationPersistance.loadOfflineUtilization();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot load offline utilization data", (Throwable)e);
                }
                this.noticeTemplateResource = new NoticeTemplateResource(this);
                if (this.daoManager.getInitNoticeTemplatesPersistenceCreated()) {
                    this.noticeTemplateResource.initializeDefaults();
                }
                this.webhookResource = new OutgoingWebhookResource(this);
                this.webhookResource.initializeFromStore();
                if (!configuration.getDisablePremiumEndpoints()) {
                    environment.jersey().register((Object)this.webhookResource);
                }
                environment.jersey().register((Object)new SoftWebhookResource(this));
                this.webhookWorker = new WebhookWorker(this);
                if (this.daoManager.getInitAuditLogPersistenceCreated()) {
                    this.webhookWorker.triggerEvent(EventType.Type.SERVICE_AUDIT_LOG_STARTED, new ServiceInfo(this.runId));
                }
                this.webhookWorker.triggerEvent(EventType.Type.SERVICE_SCHEDULER_STARTED, new ServiceInfo(this.runId));
                this.userServiceResource = new UserServiceResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.userServiceResource);
                }
                this.userServiceResource.initializeUserServicesFromConfiguration();
                this.userServiceResource.initializeUsersFromStore();
                this.userServiceResource.initializeUserServicesFromStore();
                this.securityResource = new SecurityResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.securityResource);
                }
                if (!this.settingsResource.getOidcMigrated()) {
                    this.userServiceResource.migrateUserServicesFromConfiguration();
                }
                this.noticeTemplateResource.initializeNoticeTemplatesFromStore();
                if (!configuration.getDisableCorporateEndpoints()) {
                    environment.jersey().register((Object)this.noticeTemplateResource);
                }
                this.legalHoldResource = new LegalHoldResource(this);
                this.legalHoldResource.initializeLegalHoldsFromStore();
                if (!configuration.getDisableCorporateEndpoints()) {
                    environment.jersey().register((Object)this.legalHoldResource);
                }
                this.utilizationResource = new UtilizationResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.utilizationResource);
                }
                try {
                    offlineUtilizationPersistance = new OfflineUtilizationPersistance(this);
                    offlineUtilizationPersistance.loadUtilizationRecords();
                    offlineUtilizationPersistance.handleUtilizationExclusions();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot load utilization records file", (Throwable)e);
                }
                this.notificationRuleResource = new NotificationRuleResource(this);
                this.notificationRuleResource.migrateDeprecatedEmailNotificationRules();
                this.notificationRuleResource.initializeNotificationRulesFromStore();
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.notificationRuleResource);
                }
                this.thirdPartyServiceResource = new ThirdPartyServiceResource(this);
                environment.jersey().register((Object)this.thirdPartyServiceResource);
                this.userSettingsResource = new UserSettingsResource(this);
                this.userSettingsResource.initializeJobQueueSortSettings();
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.userSettingsResource);
                }
                this.nuixLicenceSourceResource = new NuixLicenceSourceResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.nuixLicenceSourceResource);
                }
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.automateLicenseResource);
                }
                this.schedulerEnginesResource = new EnginesResource(this, configuration);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.schedulerEnginesResource);
                }
                this.fileLibraryResource = new FileLibraryResource(this);
                this.fileLibraryResource.initializeFileLibrariesFromStore();
                if (this.daoManager.getInitFileLibraryPersistenceCreated()) {
                    this.fileLibraryResource.createDefaultFileLibrary();
                }
                environment.jersey().register((Object)this.fileLibraryResource);
                this.executionProfileResource = new ExecutionProfileResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.executionProfileResource);
                }
                this.scheduleResource = new ScheduleResource(this);
                this.scheduleResource.initializeSchedulesFromStore();
                if (!configuration.getDisablePremiumEndpoints()) {
                    environment.jersey().register((Object)this.scheduleResource);
                }
                this.incomingWebhookResource = new IncomingWebhookResource(this);
                if (!configuration.getDisablePremiumEndpoints()) {
                    environment.jersey().register((Object)this.incomingWebhookResource);
                }
                this.clientPoolResource = new ClientPoolResource(this);
                this.clientPoolResource.initializeClientPoolsFromStore();
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.clientPoolResource);
                }
                this.mediaResources = new MediaResources(this, configuration);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.mediaResources);
                }
                this.platformResource = new PlatformResource(this, configuration);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.platformResource);
                }
                this.libraryResource = new LibraryResource(this);
                this.libraryResource.migrateWorkflows();
                if (this.daoManager.getInitLibraryPersistanceCreated()) {
                    try {
                        AddWorkflowLibrariesResponse result = this.libraryResource.loadLibrariesInternal(configuration.getEffectiveInitWorkflowLibraries());
                        LOGGER.info(result.toString());
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot load libraries", (Throwable)e);
                    }
                }
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.libraryResource);
                }
                this.clientResource = new ClientResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.clientResource);
                }
                this.serverResource = new ServerResource(this);
                this.serverResource.initializeServersFromStore();
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.serverResource);
                }
                this.resourcePoolResource = new ResourcePoolResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.resourcePoolResource);
                }
                this.dataRepositoryResource = new DataRepositoryResource(this);
                this.dataRepositoryResource.initializeDataRepositoriesFromStore();
                if (!configuration.getDisablePremiumEndpoints()) {
                    environment.jersey().register((Object)this.dataRepositoryResource);
                }
                this.datasetResource = new DatasetResource(this);
                this.datasetResource.initializeDatasetsFromStore();
                if (!configuration.getDisablePremiumEndpoints()) {
                    environment.jersey().register((Object)this.datasetResource);
                }
                this.dataRepositoryResource.initializeDataRepositoryHealthCheck();
                this.memgraphWorker = new MemgraphWorker();
                this.noticeResource = new NoticeResource(this);
                this.noticeResource.initializeNoticesFromStore();
                this.noticeResource.initializeNoticeRespondedCheckPolling();
                if (!configuration.getDisableCorporateEndpoints()) {
                    environment.jersey().register((Object)this.noticeResource);
                }
                this.userCommentResource = new UserCommentResource(this);
                environment.jersey().register((Object)this.userCommentResource);
                this.logsResource = new LogsResource(this, managedLoggingStore);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.logsResource);
                }
                this.apiKeyResource = new ApiKeyResource(this);
                this.apiKeyResource.initializeFromStore();
                if (!configuration.getDisablePremiumEndpoints()) {
                    environment.jersey().register((Object)this.apiKeyResource);
                }
                this.lockResource = new LockResource(this);
                this.lockResource.initializeFromStore();
                if (!configuration.getDisablePremiumEndpoints()) {
                    environment.jersey().register((Object)this.lockResource);
                }
                this.jobResource = new JobResource(this);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.jobResource);
                }
                if (!configuration.getDisableBusinessEndpoints() && configuration.getEnableUtilizationEndpoint()) {
                    environment.jersey().register((Object)new ODataV4UtilizationResource(this));
                }
                environment.jersey().register((Object)new OpenApiResource().openApiConfiguration((OpenAPIConfiguration)oasConfig));
                if (configuration.getResourcePool() != null) {
                    this.userSettingsResource.updateDefaultSettingInternal("defaultValues", "resourcePoolId", configuration.getResourcePool().getId());
                }
                if (configuration.getExecutionProfile() != null) {
                    this.userSettingsResource.updateDefaultSettingInternal("defaultValues", "executionProfileId", configuration.getExecutionProfile().getId());
                }
                this.scheduleWorker = new ScheduleWorker(this);
                try {
                    this.userServiceResource.setGoogleVaultServiceMissingWarningsToUserServices();
                }
                catch (Exception e) {
                    LOGGER.error("Error handling Google Vault service init");
                }
            }
            if (configuration.getRole().equals((Object)SchedulerComponent.SCHEDULER) || configuration.getRole().equals((Object)SchedulerComponent.OPENAPI_EXPORT)) {
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)new ServicesResource((AutomateApplication)this, (AutomateConfiguration)configuration));
                }
                this.authMethodsResource = new AuthMethodsResource(this, configuration);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.authMethodsResource);
                }
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)new VersionResources((AutomateApplication)this, (AutomateConfiguration)configuration));
                }
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)new ConfigurationResource(this, configuration));
                }
            }
            if (configuration.getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
                this.settingsResource = new SettingsResource(this);
                this.daoManager = new DaoManager(this);
                this.daoManager.initializeApplicationDaos();
                this.ignoreLicense = true;
                this.statusResource = new StatusResource(this);
                environment.jersey().register((Object)this.statusResource);
                this.daoManager.initializeUtilizationDaos();
                this.securityPolicyUtil = new AllowAllUtilizationSecurityPolicyUtil(this);
                this.userResource = new UserResource(this, configuration);
                environment.jersey().register((Object)this.userResource);
                environment.jersey().register((Object)new ODataV4UtilizationResource(this));
                this.userServiceResource = new UserServiceResource(this);
                environment.jersey().register((Object)this.userServiceResource);
                this.authMethodsResource = new AuthMethodsResource(this, configuration);
                if (!configuration.getDisableBusinessEndpoints()) {
                    environment.jersey().register((Object)this.authMethodsResource);
                }
            }
            if (configuration.getRole().equals((Object)SchedulerComponent.PROXY)) {
                this.bearerAuthenticator = new BearerAuthenticator(this, configuration);
                this.proxyResource = new ProxyResource(this);
                environment.jersey().register((Object)this.proxyResource);
            }
            SchedulerApplication application = this;
            if (configuration.getRole().equals((Object)SchedulerComponent.OPENAPI_EXPORT)) {
                Thread thread = new Thread(() -> {
                    OpenApiUtil openApiUtil = new OpenApiUtil();
                    openApiUtil.exportOpenApi();
                    application.closeWithDelay(100L, "Finished OpenAPI export");
                    System.exit(1);
                });
                thread.start();
            }
            final CountDownLatch clientBuilderCountDownLatch = new CountDownLatch(1);
            DropwizardRestClientFactory.setClientBuilderCountDownLatch((CountDownLatch)clientBuilderCountDownLatch);
            environment.lifecycle().addEventListener(new LifeCycle.Listener(){

                public void lifeCycleStarted(LifeCycle event) {
                    clientBuilderCountDownLatch.countDown();
                    DropwizardRestClientFactory.setClientBuilderCountDownLatch(null);
                }
            });
            if (configuration.getRole().equals((Object)SchedulerComponent.SCHEDULER)) {
                environment.jersey().register((Object)new HealthResource((AutomateApplication)this, (AutomateConfiguration)configuration));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error", (Throwable)e);
            System.err.println("Unexpected error, " + ExceptionUtils.getStackTrace((Throwable)e));
            this.closeWithDelay(1000L);
            System.exit(1);
        }
        if (configuration.getApiTracking() == null) {
            configuration.setApiTracking(new ApiTrackingConfiguration());
        }
        environment.jersey().register((Object)UriListener.getInstance());
        this.registerAPIUsageTracking(environment, configuration.getApiTracking().getBatchSize(), configuration.getApiTracking().getMaxBatchTimeMillis());
        this.initializing = false;
    }

    private void registerAPIUsageTracking(Environment environment, int batchSize, long maxBatchTimeMillis) {
        LOGGER.info("Registering apiUsageServletFilter...");
        Consumer<RestApiUsageBatch> apiUtilizationConsumer = batch -> {
            UtilizationRecords utilizationRecords = new UtilizationRecords();
            utilizationRecords.setId(UidUtils.getRandom());
            List restApiUsage = batch.getApiMethodCountMap().entrySet().stream().map(entry -> {
                ConsumptionEvent consumptionEvent = new ConsumptionEvent();
                consumptionEvent.setConsumptionEventId(UUID.randomUUID().toString());
                consumptionEvent.setLicenseId(Optional.ofNullable(this.automateLicenseResource.getLicenceSession()).map(licenceSession -> licenceSession.getLicenceInfo().getId()).orElse(""));
                consumptionEvent.setConsumptionStartEpoch(batch.getBatchStartedEpoch().longValue());
                consumptionEvent.setConsumptionEndEpoch(new Date().getTime());
                consumptionEvent.setPlatformType(ConsumptionPlatformType.NUIX_AUTOMATE);
                consumptionEvent.setPlatformId(AutomateModule.AUTOMATE_SCHEDULER_SERVICE.getValue());
                consumptionEvent.setConsumptionType(ConsumptionType.REST_API);
                consumptionEvent.setUnitType(UnitType.CALLS);
                consumptionEvent.setUnits((long)((AtomicInteger)entry.getValue()).get());
                String key = (String)entry.getKey();
                String origin = "";
                String method = "";
                String requestUri = "";
                if (key.contains(":")) {
                    String[] originAndMethodSpaceRequestUri = key.split(":");
                    origin = originAndMethodSpaceRequestUri[0];
                    String[] methodAndRequestUri = originAndMethodSpaceRequestUri[1].split(" ");
                    method = methodAndRequestUri[0];
                    requestUri = methodAndRequestUri[1];
                } else {
                    String[] methodAndRequestUri = ((String)entry.getKey()).split(" ");
                    method = methodAndRequestUri[0];
                    requestUri = methodAndRequestUri[1];
                }
                if (origin != null) {
                    consumptionEvent.setConsumptionSubType(ConsumptionSubType.AUTOMATE_INTERNAL_ACCESS);
                } else {
                    consumptionEvent.setConsumptionSubType(ConsumptionSubType.EXTERNAL_ACCESS);
                }
                consumptionEvent.setResourceType(ResourceType.REST_ENDPOINT);
                consumptionEvent.setResourceId(requestUri);
                consumptionEvent.setResourceSubType(ResourceSubType.HTTP_METHOD);
                consumptionEvent.setResourceSubId(method);
                return consumptionEvent;
            }).collect(Collectors.toList());
            Consumption restApiConsumption = new Consumption(restApiUsage);
            this.automateLicenseResource.getLicenceSession().tryTrackConsumption(restApiConsumption, true, false);
        };
        AccessLogDataProcessor accessLogDataProcessor = new AccessLogDataProcessor(batchSize, maxBatchTimeMillis, apiUtilizationConsumer);
        RestApiUsageServletFilter restApiUsageServletFilter = new RestApiUsageServletFilter(accessLogDataProcessor, s -> {
            try {
                return this.authenticationUtil.getUserFromHeader((HttpServletRequest)s) != null;
            }
            catch (AuthenticationResponseException e) {
                return false;
            }
        });
        environment.servlets().addFilter("apiUsageServletFilter", (Filter)restApiUsageServletFilter).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
    }

    public ApplicationDao getAuditLogDao() {
        return this.daoManager.getAuditDao();
    }

    public ApplicationDao getClientMatterDao() {
        return this.daoManager.getClientMatterDao();
    }

    public ApplicationDao getJobsDao() {
        return this.daoManager.getJobsDao();
    }

    public ApplicationDao getWorkflowLibraryDao() {
        return this.daoManager.getLibraryDao();
    }

    public ApplicationDao getSecurityDao() {
        return this.daoManager.getSecurityDao();
    }

    public ApplicationDao getUserSettingsDao() {
        return this.daoManager.getUserSettingsDao();
    }

    public ApplicationDao getSchedulerConfigurationDao() {
        return this.daoManager.getApplicationDao();
    }

    public ApplicationDao getUsersDao() {
        return this.daoManager.getUsersDao();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public UserResource getUserResource() {
        return this.userResource;
    }

    public synchronized Encryptor getEncryptor() {
        if (this.encryptor == null) {
            this.initializeEncryptor();
        }
        return this.encryptor;
    }

    public void closeWithDelay(long delay) {
        this.closeWithDelay(delay, null);
    }

    public void closeWithDelay(long delay, String reason) {
        LOGGER.info("Preparing to close application" + (String)(reason != null ? ", reason: " + reason : ""));
        Thread closingThread = new Thread(() -> {
            LOGGER.info("Cleaning up");
            try {
                if (delay > 0L) {
                    LOGGER.info("Waiting " + delay + " ms before stopping ...");
                    Thread.sleep(delay);
                    LOGGER.info("Finished waiting");
                }
                LOGGER.info("Closing application");
                this.close();
            }
            catch (Exception e) {
                LOGGER.error("Cannot close application", (Throwable)e);
            }
            finally {
                System.exit(0);
            }
        });
        closingThread.setName("Automate Engine Server - Close Thread");
        closingThread.start();
    }

    private void close() throws Exception {
        if (!this.closing) {
            try {
                throw new LicenseException("Closing Scheduler");
            }
            catch (LicenseException e) {
                LOGGER.info("Closing session", (Throwable)e);
                if (this.userResource != null) {
                    try {
                        this.userResource.handleUtilizationShutdown();
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Cannot handle user utilization shutdown", (Throwable)e2);
                    }
                }
                if (this.automateLicenseResource != null) {
                    this.automateLicenseResource.close();
                }
                this.closing = true;
                this.environment.getApplicationContext().getServer().stop();
                System.exit(0);
            }
        }
    }

    public CentralizedLogInterceptor<ILoggingEvent> getCentralizedLoggingAppender() {
        return this.centralizedLoggingAppender;
    }

    public void startCentralizedLoggingAdapter() {
        this.getCentralizedLoggingAppender().start();
    }

    public void stopCentralizedLoggingAdapter() {
        this.getCentralizedLoggingAppender().stop();
    }

    public HealthInfo getHealthInfo() {
        try {
            this.getAuditLogDao().getId("");
        }
        catch (Exception e) {
            LOGGER.error("Health check error", (Throwable)e);
            return new HealthInfo("DB error", (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
        }
        return new HealthInfo("OK", (Response.StatusType)Response.Status.OK);
    }

    public UserServiceResource getUserServiceResource() {
        return this.userServiceResource;
    }

    public MediaResources getMediaResources() {
        return this.mediaResources;
    }

    public LibraryResource getLibraryResource() {
        return this.libraryResource;
    }

    public ClientResource getClientResource() {
        return this.clientResource;
    }

    public SecurityResource getSecurityResource() {
        return this.securityResource;
    }

    public NotificationsHandler getNotificationsHandler() {
        return this.notificationsHandler;
    }

    public void setNotificationsHandler(NotificationsHandler notificationsHandler) {
        this.notificationsHandler = notificationsHandler;
    }

    public NmsUtils getNmsUtils() {
        return this.nmsUtils;
    }

    public ScheduleWorker getScheduleWorker() {
        return this.scheduleWorker;
    }

    public WebhookWorker getWebhookWorker() {
        return this.webhookWorker;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public AesEncryptor getAesEncryptor() {
        return this.aesEncryptor;
    }

    public void setAesEncryptor(AesEncryptor aesEncryptor) {
        this.aesEncryptor = aesEncryptor;
    }

    public synchronized Map<String, Object> getWorkerBrokerOptions() {
        Integer startPort;
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.configuration.getWorkerBrokerIP() != null && this.configuration.getWorkerBrokerIP().length() > 0) {
            options.put("bindAddress", this.configuration.getWorkerBrokerIP());
        }
        if ((startPort = this.configuration.getWorkerBrokerStartPort()) != null) {
            Integer endPort = this.configuration.getWorkerBrokerEndPort();
            if (endPort == null && endPort < startPort) {
                LOGGER.warn("Resetting workerBrokerEndPort from " + endPort + " to 65535");
                endPort = 65535;
            }
            int portRange = endPort - startPort;
            int port = startPort + this.random.nextInt(portRange + 1);
            options.put("port", port);
        }
        return options;
    }

    public LicenceUtils getLicenceUtils() {
        return this.licenceUtils;
    }

    public AuthenticationUtil getAuthenticationUtil() {
        return this.authenticationUtil;
    }

    public SessionUtils getSessionUtils() {
        return this.sessionUtils;
    }

    public boolean getInitializing() {
        return this.initializing;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public LegalHoldUtils getLegalHoldUtils() {
        return this.legalHoldUtils;
    }

    public NoticeUtils getNoticeUtils() {
        return this.noticeUtils;
    }

    public Map<String, AuthType> getAuthScopeTypes() {
        return this.authScopeTypes;
    }

    public String getRunId() {
        return this.runId;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public ProxyResource getProxyResource() {
        return this.proxyResource;
    }

    public void setProxyResource(ProxyResource proxyResource) {
        this.proxyResource = proxyResource;
    }

    public StatusResource getStatusResource() {
        return this.statusResource;
    }

    public UtilResource getUtilResource() {
        return this.utilResource;
    }

    public AuthMethodsResource getAuthMethodsResource() {
        return this.authMethodsResource;
    }

    /*
     * Unable to fully structure code
     */
    private void initializeEncryptor() {
        SchedulerApplication.LOGGER.info("Initializing application encryptor");
        if (!this.getConfiguration().getEnableWinDpapi()) ** GOTO lbl-1000
        this.getConfiguration();
        if (SchedulerConfiguration.getOsWindows()) {
            Encryptor.initializeWinDpapiEncryptor();
        } else lbl-1000:
        // 2 sources

        {
            if (this.instanceId == null) {
                this.initializeInstanceId();
            }
            Encryptor.initializeIdEncryptor((String)this.instanceId);
        }
        this.encryptor = Encryptor.getUserInstance();
    }

    public JdbiTimingCollector getTimingCollector() {
        return this.timingCollector;
    }

    public UtilizationResource getUtilizationResource() {
        return this.utilizationResource;
    }

    public String getRunNonce() {
        return this.runNonce;
    }

    public boolean getApplicationStarted() {
        return this.applicationStarted;
    }

    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public MemgraphWorker getMemgraphWorker() {
        return this.memgraphWorker;
    }

    public DaoManager getDaoManager() {
        return this.daoManager;
    }
}

