/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.reflect.TypeToken;
import com.nuix.automate.scheduler.security.internal.Credential;
import com.nuix.automate.scheduler.security.internal.InternalCredentialsConfiguration;
import com.nuix.automate.scheduler.security.ldap.LdapConfiguration;
import com.nuix.automate.scheduler.security.oidc.generic.OidcConfig;
import com.nuix.automate.scheduler.security.oidc.microsoft.OidcMicrosoftConfig;
import com.nuix.automate.scheduler.security.ums.UmsConfiguration;
import com.nuix.automate.scheduler.utils.AzureEnvironmentUtils;
import com.nuix.automate.scheduler.utils.proxy.ProxyConfiguration;
import com.nuix.automate.utils.api.automatelicense.Credentials;
import com.nuix.automate.utils.api.internal.configuration.ApiTrackingConfiguration;
import com.nuix.automate.utils.api.internal.configuration.BrandingConfiguration;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.dataset.DatasetPathFormat;
import com.nuix.automate.utils.models.api.executionprofile.JobProgressSettings;
import com.nuix.automate.utils.models.api.executionprofile.JobTimeoutSettings;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.thirdparty.DerbyControlService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.resourcepool.AutoRegistrationSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import io.dropwizard.core.Configuration;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.web.conf.WebConfiguration;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SchedulerConfiguration
extends Configuration
implements AutomateConfiguration {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SchedulerConfiguration.class);
    private boolean mockOptionsEnabled = false;
    private boolean mockOptionsChangingValues = false;
    private int mockOptionsCount = 50;
    private boolean debugLogRequestResponse = false;
    private String minWorkflowVersion = null;
    private String minEngineServerVersion = null;
    private final int refreshThirdPartyUserCredentialEveryNDays = 7;
    private BrandingConfiguration branding;
    private ApiTrackingConfiguration apiTracking;
    private String engineInitLogFolder = "C:\\Temp\\logs";
    private String engineCommandLine;
    private boolean usesUnsafeInline = false;
    private boolean awsInstanceConnectUsingPublicDns = true;
    private boolean awsInstanceConnectUsingPublicIp = true;
    private boolean awsInstanceConnectUsingPrivateDns = true;
    private boolean awsInstanceConnectUsingPrivateIp = true;
    private boolean azureVmConnectUsingPublicIp = true;
    private boolean azureVmConnectUsingPrivateIp = true;
    private String loopbackUrl;
    private String loopbackFingerprint;
    private long jobSchedulingLoopDetection = 10L;
    private long nameResolutionTimeout = 500L;
    private long apiClientConnectionTimeout = 5000L;
    private long apiClientReadTimeout = 45000L;
    private long enginePingInterval = 1000L;
    private long engineErrorDelay = 1000L;
    private long engineInitKeepAlive = 5000L;
    private long engineKeepAlive = 3600000L;
    private long engineTimeout = 300000L;
    private long engineShutdownTimeout = 10000L;
    private long engineInitRetryDelay = 30000L;
    private boolean enableEngineErrorJobWorker = true;
    private int engineErrorJobInitAbortThreshold = 2;
    private long engineErrorJobCheckInterval = 5000L;
    private long engineErrorJobKillDelay = 5000L;
    private long serverPingInterval = 1000L;
    private long serverTimeout = 30000L;
    private long proxyPingInterval = 5000L;
    private long cloudPingInterval = 10000L;
    private long cloudInitialErrorDelay = 10000L;
    private long updateDatabaseInterval = 60000L;
    private long jobDisconnectedTimeout = 60000L;
    private long jobWorkerInterval = 1000L;
    private long nuixLicenseSourceTimeout = 30000L;
    private long nuixLicensePingInterval = 30000L;
    private long automateLicensePingInterval = 300000L;
    private long automateLicenseTimeout = 30000L;
    private long resourcePoolBootstrapDelay = 5000L;
    private long resourcePoolInterval = 1000L;
    private long resourcePoolTimeout = 60000L;
    private long cloudResourcePoolTimeout = 300000L;
    private long oidcMinShelfLife = 60000L;
    private long schedulerTombstoneDuration = 60000L;
    private long userImageCacheKeepAlive = 86400000L;
    private long fileIconCacheKeepAlive = 86400000L;
    private long brandingCacheKeepAlive = 86400000L;
    private long apiClientMinLife = 60000L;
    private long allowedParameterValuesScriptTimeout = 60000L;
    private boolean deleteCookiesWhenInitializingEngine = false;
    private boolean enableWinDpapi = true;
    private boolean runScheduler = false;
    private boolean runServer = false;
    private boolean runEngine = false;
    private SchedulerComponent role;
    private int archiveJobsPastCount = 100;
    private long archiveJobsPastDuration = 1209600L;
    private boolean allowSimultaneousWorkflowsInSameCase = false;
    private boolean enableUserInterfaceDebugMode = false;
    private long userSessionTimeout = 900L;
    private long authServiceRefreshInterval = 60L;
    private long userServiceWorkerBootDelay = 6L;
    private boolean disableAuthTokenExpiration = false;
    private long authTokenTtl = 600L;
    private long expiredAuthTokenTombstone = 900L;
    private long expiredAuthTokenGracePeriod = 5000L;
    private boolean downgradeWebWorkerToken = false;
    private boolean enforceSingleUserSession = false;
    private int oidcAuthInitTimeout = 300;
    private int oidcAuthCompletionTimeout = 120;
    private String uploadHashAlgorithms = "MD5";
    private boolean restartAfterFinishedJob = false;
    private String apiSecret = null;
    private String nuixEnginePath = null;
    private String nuixUserDataDir = null;
    private long userDataDirScanInterval = 0L;
    private String nuixFlags = null;
    private String log4jConfigurationFile = "C:\\ProgramData\\Nuix\\Automate\\EngineServer\\config\\log4j.properties";
    private boolean trackUtilization = true;
    private boolean utilizationErrorsSoftFail = false;
    private String corsAllowedOrigins = null;
    private String corsAllowedHeaders = null;
    private String corsAllowedMethods = null;
    private String engineId = null;
    private String workerBrokerIP = null;
    private Integer workerBrokerStartPort = null;
    private Integer workerBrokerEndPort = null;
    private int workerBrokerInitAttempts = 100;
    private boolean enableEngineJavaMinidumps = false;
    private long libraryFileMaxSize = 10000000L;
    private boolean deleteCachedClsCredentials = true;
    private String utilizationExportOnStartUpFolderPath;
    private String jobId = null;
    private int legalHoldWorkerThreadCount = 4;
    private boolean returnUsersFromRelatedLegalHolds = false;
    private long userServiceObjectsCacheLifeTimeSeconds = 240L;
    private String purviewGraphApiVersion = "v1.0";
    private long thirdPartyServiceInitializeTimeoutMs = 30000L;
    private long thirdPartyServiceUserCredentialCacheLifeTimeSeconds = 90L;
    private int purviewServiceUserCredentialExpireWarningThreshold = 45;
    private int vaultServiceUserCredentialExpireWarningThreshold = 45;
    private int relativityServiceUserCredentialExpireWarningThreshold = 720;
    private int discoverServiceUserCredentialExpireWarningThreshold = 720;
    private int elasticsearchServiceUserCredentialExpireWarningThreshold = 720;
    private int eccServiceUserCredentialExpireWarningThreshold = 720;
    private int nlpUserCredentialExpireWarningThreshold = 720;
    private int vaultServiceApiRequestMaxAttempts = 3;
    private boolean enableCentralizedLogging = true;
    private int centralizedLoggingRetention = 30;
    private long centralizedLoggingMaxSize = 100000000L;
    private int centralizedLoggingSizeCheckInterval = 30;
    private int centralizedLoggingMaxActiveLines = 10000;
    private boolean enableCentralizedLoggingDownloadTimeout = false;
    private long centralizedLoggingDownloadTimeout = 180000L;
    private boolean enableRollingLoggingDatabases = false;
    private int maxRollingLoggingDatabases = 5;
    private long collectionWorkerTimeout = 60000L;
    private boolean excludeAutomatedOfflineUtilizationData = true;
    private boolean disableResponseCache = false;
    private long responseCacheMaxValidity = 300000L;
    private long globalResponseCacheMaxValidity = 3600000L;
    private long dataRepositoryResponseCacheMaxValidity = 60000L;
    private long dataRepositoryUsableSpaceInterval = 60000L;
    private long expireIdleUploadAfter = 3600000L;
    private long datasetTusFileUploadCleanupInterval = 600000L;
    private long datasetAutoExpireInterval = 60000L;
    private boolean uploadWithSeparateWriteThread = true;
    private boolean uploadWithNullWriter = false;
    private Integer uploadBufferMaxSize = 8192;
    private boolean inlineUserNoticeCss = true;
    private long noticeReminderEscalationPollInterval = 3600000L;
    private final int smtpServiceEmailRetryInterval = 12;
    private final int smtpServiceEmailMaxAttempts = 12;
    private final int smtpServiceMaxThreadCount = 8;
    private int workflowCacheSize = 512;
    private int workflowCacheLifetimeSeconds = 30;
    private boolean archivedJobCleanupEnabled = false;
    private int archivedJobCleanupInterval = 24;
    private long archivedJobRetentionDays = 548L;
    private InternalCredentialsConfiguration internalCredentials;
    private ProxyConfiguration proxy;
    private boolean disableUserIcons = false;
    private boolean sortAllowedParametersValues = false;
    private boolean synchronizeJobsOnAllMatters = false;
    private int engineInitTimeout = 120;
    private int maxWebhookEventsHistoryCount = 20;
    private long webhookInitialDelayOnFailure = 1000L;
    private int disableWebhookAfterFailedCallbacks = 16;
    private boolean pingNuixLicenseIfValid = false;
    private boolean pingNuixLicenseIfError = false;
    private String debugSqlLogsPath = null;
    private long debugSqlLogsFlushTime = 300000L;
    private long debugSqlLogsFlushLines = 100000L;
    private int jobRunningLogMaxSize = 20;
    private long azureVmDeleteAttemptsInterval = 30000L;
    private int azureVmMaxDeleteAttempts = 8;
    private String[] azureVmSizes = null;
    private String[] azureLocations = null;
    private boolean disableBusinessEndpoints = false;
    private boolean disablePremiumEndpoints = false;
    private boolean disableCorporateEndpoints = false;
    private String openApiDescription = null;
    private String openApiFileSuffix = null;
    private DatasetPathFormat datasetPathFormat = DatasetPathFormat.IDS_8CHAR;
    private String sqliteStoresPath;
    private boolean enableUtilizationEndpoint = true;
    private int maxScheduleRunsDisplay = 20;
    private long scheduleSystemErrorBackoff = 3600000L;
    private boolean loggingRedirectToApplicationStore = false;
    private boolean utilizationRedirectToApplicationStore = false;
    private boolean applicationDaoIsDefault = true;
    private long regexTimeout = 5000L;
    private boolean cacheLegalHoldParticipants = false;
    private boolean cacheDatasetFileInfos = false;
    private boolean enableDatabaseCallTracing = false;
    @JsonProperty
    private DataSourceFactory applicationStore;
    @JsonProperty
    private DataSourceFactory usersStore;
    private String[] allowedAuthenticationServices = null;
    private long ephemeralApiKeysValidity = 60000L;
    private SecurityPolicy securityPolicy;
    private Credentials automateLicenseCredentials;
    private NuixLicenseSourceModel nuixClsLicenseSource;
    private String initWorkflowLibraries;
    public static final String DEFAULT_NUIX_LICENSE_ID = "1000b202-0001-45ef-9ba7-24ad5deb779d";
    public static final String DEFAULT_EXECUTION_PROFILE_ID = "1000947c-0001-4825-8f3f-f1a071e1dcf8";
    public static final String DEFAULT_SECURITY_POLICY_ID = "100008a0-0001-49bc-a049-9ff82cf68d63";
    public static final String DEFAULT_OIDC_SERVICE_ID = "10009291-ab9b-4a4d-a6c7-356658be58c0";
    public static final String DEFAULT_RESOURCE_POOL_ID = "1000b196-09b3-4c2a-8b85-38863cf04aec";
    public static final double DEFAULT_UPDATE_OPERATIONS_PROGRESS_WEIGHT_LAST_RUN_WEIGHT_PERCENTAGE = 33.0;
    private ResourcePoolModel resourcePool;
    private ExecutionProfileModel executionProfile;
    private WebConfiguration webConfiguration = new WebConfiguration();
    @Deprecated
    private String nuixUserManagementServer = null;
    private UmsConfiguration ums;
    @JsonProperty
    private DataSourceFactory auditStore;
    @JsonProperty
    private DataSourceFactory applicationInitStore;
    @JsonProperty
    private DataSourceFactory libraryStore;
    @JsonProperty
    private DataSourceFactory clientMatterStore;
    @JsonProperty
    private DataSourceFactory securityStore;
    @JsonProperty
    private DataSourceFactory jobsStore;
    @JsonProperty
    private DataSourceFactory userSettingsStore;
    @JsonProperty
    private DataSourceFactory jobsArchiveStore;
    @JsonProperty
    private DataSourceFactory utilizationStore;
    @JsonProperty
    private DataSourceFactory noticeStore;
    @JsonProperty
    private DataSourceFactory legalHoldStore;
    @JsonProperty
    private DataSourceFactory loggingStore;
    @JsonProperty
    private DataSourceFactory schedulerConfigurationStore;
    private LdapConfiguration ldap;
    private OidcMicrosoftConfig oidcMicrosoft;
    private OidcConfig oidc;
    private DerbyControlService derbyControlServiceConfiguration;
    private boolean forceMicrosoftOidcUsernameFromMail = false;
    private Map<String, Map<String, Object>> defaultUserSettings;

    public void initializeFromEnv() {
        this.initializeStoresEnv();
        this.initializeApiKeyEnv();
        this.inializeInternalAuthEnv();
        this.initializeOidcAuthEnv();
        this.initializeDerbyControlEnv();
        this.initializeSecurityPolicyEnv();
        this.initializeCentralizedLoggingEnv();
        this.initializeAutomateLicenseEnv();
        this.initializeNuixLicenseEnv();
        this.initializeResourcePoolEnv();
        this.initializeExecutionProfileEnv();
        this.initializeGenericEnv();
    }

    private void initializeGenericEnv() {
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            String envCandidate = "AUTOMATE_" + FormattingUtils.camelCaseToSnakeCase((String)fieldName).toUpperCase();
            LOGGER.debug("Testing setting " + fieldName + " for ENV variable " + envCandidate);
            String envValue = System.getenv(envCandidate);
            if (envValue == null) continue;
            try {
                Object fieldValue = field.getType().equals(String.class) ? envValue : SerializationUtils.fromJson((String)envValue, field.getType());
                field.set((Object)this, fieldValue);
                LOGGER.info("Set " + fieldName + " of type " + String.valueOf(field.getType()) + " from ENV variable " + envCandidate + " value " + envValue);
            }
            catch (Exception e) {
                LOGGER.error("Error setting " + fieldName + " of type " + String.valueOf(field.getType()) + " from ENV variable " + envCandidate + " value " + envValue, (Throwable)e);
            }
        }
    }

    private void initializeStoresEnv() {
        String utilizationRedirectToApplicationStoreEnv;
        String loggingRedirectToApplicationStoreEnv;
        String enabledStore = System.getenv("AUTOMATE_STORE_APPLICATION_ENABLED");
        if (enabledStore != null) {
            LOGGER.info("Overwriting Application Store from ENV");
            boolean enabled = Boolean.parseBoolean(enabledStore);
            if (enabled) {
                String minConnections;
                String charset;
                String password;
                String driverClass = System.getenv("AUTOMATE_STORE_APPLICATION_DRIVER_CLASS");
                this.applicationStore = new DataSourceFactory();
                String url = System.getenv("AUTOMATE_STORE_APPLICATION_URL");
                LOGGER.info("Setting Application Store URL to " + url);
                this.applicationStore.setDriverClass(driverClass);
                this.applicationStore.setUrl(url);
                String username = System.getenv("AUTOMATE_STORE_APPLICATION_USERNAME");
                if (username != null) {
                    this.applicationStore.setUser(username);
                }
                if ((password = System.getenv("AUTOMATE_STORE_APPLICATION_PASSWORD")) != null) {
                    this.applicationStore.setPassword(password);
                }
                if ((charset = System.getenv("AUTOMATE_STORE_APPLICATION_CHARSET")) != null) {
                    this.applicationStore.getProperties().put("charset", charset);
                }
                if ((minConnections = System.getenv("AUTOMATE_STORE_APPLICATION_SCHEDULER_MIN_CONNECTIONS")) != null) {
                    this.applicationStore.setMinSize(Integer.parseInt(minConnections));
                    this.applicationStore.setInitialSize(Integer.parseInt(minConnections));
                }
                String maxConnections = System.getenv("AUTOMATE_STORE_APPLICATION_SCHEDULER_MAX_CONNECTIONS");
                if (minConnections != null) {
                    this.applicationStore.setMaxSize(Integer.parseInt(maxConnections));
                }
            }
        }
        if ((loggingRedirectToApplicationStoreEnv = System.getenv("AUTOMATE_STORE_LOGGING_REDIRECT_TO_APPLICATION")) != null) {
            LOGGER.info("Overwriting Logging Store redirect to Application Store from ENV");
            this.loggingRedirectToApplicationStore = Boolean.parseBoolean(loggingRedirectToApplicationStoreEnv);
        }
        if ((utilizationRedirectToApplicationStoreEnv = System.getenv("AUTOMATE_STORE_UTILIZATION_REDIRECT_TO_APPLICATION")) != null) {
            LOGGER.info("Overwriting Utilization Store redirect to Application Store from ENV");
            this.utilizationRedirectToApplicationStore = Boolean.parseBoolean(utilizationRedirectToApplicationStoreEnv);
        }
    }

    private void initializeApiKeyEnv() {
        String apiSecretEnv = System.getenv("AUTOMATE_API_KEY");
        if (apiSecretEnv != null) {
            LOGGER.info("Overwriting API Secret from ENV");
            this.apiSecret = apiSecretEnv;
        }
    }

    private void inializeInternalAuthEnv() {
        String enableInternalAuth = System.getenv("AUTOMATE_AUTH_INTERNAL_ENABLED");
        if (enableInternalAuth != null) {
            LOGGER.info("Overwriting Internal Auth from ENV");
            boolean enabled = Boolean.parseBoolean(enableInternalAuth);
            if (!enabled) {
                this.internalCredentials = null;
            } else {
                String username = System.getenv("AUTOMATE_AUTH_INTERNAL_USERNAME");
                if (username != null) {
                    LOGGER.info("Setting Internal Auth username from ENV");
                    if (this.internalCredentials == null) {
                        this.internalCredentials = new InternalCredentialsConfiguration();
                    }
                    this.internalCredentials.setDisplayName("Internal");
                    if (this.internalCredentials.getCredentials() == null) {
                        this.internalCredentials.setCredentials(new ArrayList<Credential>());
                    }
                    this.internalCredentials.setRestrictToLocalhost(false);
                    Credential credential = new Credential();
                    this.internalCredentials.getCredentials().add(credential);
                    credential.setUsername(username);
                    String email = System.getenv("AUTOMATE_AUTH_INTERNAL_EMAIL");
                    if (email != null) {
                        credential.setEmail(email);
                    } else {
                        credential.setEmail(username);
                    }
                    String password = System.getenv("AUTOMATE_AUTH_INTERNAL_PASSWORD");
                    if (password != null) {
                        credential.setPassword(password);
                    } else {
                        LOGGER.info("Adding Internal credential salt from ENV");
                        String salt = System.getenv("AUTOMATE_AUTH_INTERNAL_SALT");
                        String iterations = System.getenv("AUTOMATE_AUTH_INTERNAL_ITERATIONS");
                        String hash = System.getenv("AUTOMATE_AUTH_INTERNAL_HASH");
                        credential.setSalt(salt);
                        credential.setIterations(Integer.parseInt(iterations));
                        credential.setHash(hash);
                    }
                }
            }
        }
    }

    private void initializeSecurityPolicyEnv() {
        String enableSecurityPolicy = System.getenv("AUTOMATE_SECURITY_POLICY_ENABLED");
        if (enableSecurityPolicy != null) {
            LOGGER.info("Overwriting Security Policy from ENV");
            boolean enabled = Boolean.parseBoolean(enableSecurityPolicy);
            if (!enabled) {
                this.securityPolicy = null;
            } else {
                Set scopesBuiltInNames;
                this.securityPolicy = new SecurityPolicy();
                this.securityPolicy.setEnabled(Boolean.valueOf(true));
                this.securityPolicy.setReadOnly(true);
                this.securityPolicy.setId(DEFAULT_SECURITY_POLICY_ID);
                this.securityPolicy.setName(System.getenv("AUTOMATE_SECURITY_POLICY_NAME"));
                this.securityPolicy.setDescription(System.getenv("AUTOMATE_SECURITY_POLICY_DESCRIPTION"));
                Type permissionsType = new TypeToken<HashSet<Permission>>(){}.getType();
                Set permissions = (Set)SerializationUtils.fromJson((String)System.getenv("AUTOMATE_SECURITY_POLICY_PERMISSIONS"), (Type)permissionsType);
                this.securityPolicy.setPermissions(permissions);
                Type identifierSetType = new TypeToken<HashSet<Identifier>>(){}.getType();
                Set principals = (Set)SerializationUtils.fromJson((String)System.getenv("AUTOMATE_SECURITY_POLICY_PRINCIPALS"), (Type)identifierSetType);
                this.securityPolicy.setPrincipals(principals);
                HashSet<Identifier> effectiveScope = new HashSet<Identifier>();
                Set scope = (Set)SerializationUtils.fromJson((String)System.getenv("AUTOMATE_SECURITY_POLICY_SCOPE"), (Type)identifierSetType);
                if (scope != null) {
                    effectiveScope.addAll(scope);
                }
                if ((scopesBuiltInNames = (Set)SerializationUtils.fromJson((String)System.getenv("AUTOMATE_SECURITY_POLICY_SCOPE_BUILTIN"), Set.class)) != null) {
                    for (String scopesBuiltInName : scopesBuiltInNames) {
                        effectiveScope.add(new Identifier(IdentifierType.BUILTIN, scopesBuiltInName));
                    }
                }
                this.securityPolicy.setScope(effectiveScope);
            }
        }
    }

    private void initializeOidcAuthEnv() {
        String enableOidcAuth = System.getenv("AUTOMATE_AUTH_OIDC_ENABLED");
        if (enableOidcAuth != null) {
            LOGGER.info("Overwriting OIDC Auth from ENV");
            boolean enabled = Boolean.parseBoolean(enableOidcAuth);
            if (!enabled) {
                this.oidc = null;
            } else {
                this.oidc = new OidcConfig();
                this.oidc.setDisplayName(System.getenv("AUTOMATE_AUTH_OIDC_NAME"));
                this.oidc.setDescription(System.getenv("AUTOMATE_AUTH_OIDC_DESCRIPTION"));
                this.oidc.setWellKnownConfigurationUri(System.getenv("AUTOMATE_AUTH_OIDC_WELL_KNOWN_CONFIG_URI"));
                this.oidc.setScope(System.getenv("AUTOMATE_AUTH_OIDC_SCOPE"));
                this.oidc.setUsernameClaim(System.getenv("AUTOMATE_AUTH_OIDC_USERNAME_CLAIM"));
                this.oidc.setGroupClaim(System.getenv("AUTOMATE_AUTH_OIDC_GROUP_CLAIM"));
                this.oidc.setClientId(System.getenv("AUTOMATE_AUTH_OIDC_CLIENT_ID"));
                this.oidc.setClientSecret(System.getenv("AUTOMATE_AUTH_OIDC_CLIENT_SECRET"));
                String authCodeFlowEnv = System.getenv("AUTOMATE_AUTH_OIDC_AUTH_CODE_FLOW");
                if (authCodeFlowEnv != null) {
                    this.oidc.setEnableAuthorizationCodeFlow(Boolean.parseBoolean(authCodeFlowEnv));
                } else {
                    this.oidc.setEnableAuthorizationCodeFlow(true);
                }
                String jwtAccessToken = System.getenv("AUTOMATE_AUTH_OIDC_JWT_ACCESS_TOKEN");
                if (jwtAccessToken != null) {
                    this.oidc.setEnableJwtAccessToken(Boolean.parseBoolean(jwtAccessToken));
                } else {
                    this.oidc.setEnableJwtAccessToken(true);
                }
            }
        }
    }

    private void initializeDerbyControlEnv() {
        String enableDerbyControlService = System.getenv("AUTOMATE_DERBY_CONTROL_SERVICE_ENABLED");
        if (enableDerbyControlService != null) {
            LOGGER.info("Overwriting Derby Control Service from ENV");
            boolean enabled = Boolean.parseBoolean(enableDerbyControlService);
            if (!enabled) {
                this.derbyControlServiceConfiguration = null;
            } else {
                this.derbyControlServiceConfiguration = new DerbyControlService();
                this.derbyControlServiceConfiguration.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
                this.derbyControlServiceConfiguration.setAuthenticationMethod(ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS);
                this.derbyControlServiceConfiguration.setName(System.getenv("AUTOMATE_DERBY_CONTROL_SERVICE_NAME"));
                this.derbyControlServiceConfiguration.setDescription(System.getenv("AUTOMATE_DERBY_CONTROL_SERVICE_DESCRIPTION"));
                this.derbyControlServiceConfiguration.setUrl(System.getenv("AUTOMATE_DERBY_CONTROL_SERVICE_URL"));
                this.derbyControlServiceConfiguration.setEnabled(Boolean.valueOf(true));
                this.derbyControlServiceConfiguration.setAvailableByDefault(Boolean.valueOf(true));
                this.derbyControlServiceConfiguration.setAuthenticationServiceId(DEFAULT_OIDC_SERVICE_ID);
            }
        }
    }

    private void initializeCentralizedLoggingEnv() {
        String enableCentralizedLoggingEnv = System.getenv("response.getUserPermissions().remove(Permission.MODIFY);");
        if (enableCentralizedLoggingEnv != null) {
            LOGGER.info("Overwriting Centralized Logging from ENV");
            this.enableCentralizedLogging = Boolean.parseBoolean(enableCentralizedLoggingEnv);
            LOGGER.info("Setting Centralized Logging enabled: " + this.enableCentralizedLogging);
        }
    }

    private void initializeAutomateLicenseEnv() {
        String enabledAutomateLicense = System.getenv("AUTOMATE_LICENSE_ENABLED");
        if (enabledAutomateLicense != null) {
            LOGGER.info("Overwriting Automate License from ENV");
            boolean enabled = Boolean.parseBoolean(enabledAutomateLicense);
            if (!enabled) {
                this.automateLicenseCredentials = null;
            } else {
                this.automateLicenseCredentials = new Credentials();
                this.automateLicenseCredentials.setLicenseId(System.getenv("AUTOMATE_LICENSE_ID"));
                this.automateLicenseCredentials.setLicenseKey(System.getenv("AUTOMATE_LICENSE_KEY"));
                String diagnosticLevelString = System.getenv("AUTOMATE_LICENSE_DIAGNOSTIC_LEVEL");
                DiagnosticLevel diagnosticLevel = diagnosticLevelString != null ? DiagnosticLevel.valueOf((String)diagnosticLevelString) : DiagnosticLevel.ENHANCED;
                this.automateLicenseCredentials.setDiagnosticLevel(diagnosticLevel);
            }
        }
    }

    private void initializeNuixLicenseEnv() {
        String enableNuixLicense = System.getenv("AUTOMATE_NUIX_CLS_LICENSE_ENABLED");
        if (enableNuixLicense != null) {
            LOGGER.info("Overwriting Engine License from ENV");
            boolean enabled = Boolean.parseBoolean(enableNuixLicense);
            if (!enabled) {
                this.nuixClsLicenseSource = null;
            } else {
                this.nuixClsLicenseSource = new NuixLicenseSourceModel();
                this.nuixClsLicenseSource.setId(DEFAULT_NUIX_LICENSE_ID);
                this.nuixClsLicenseSource.setName(System.getenv("AUTOMATE_NUIX_CLS_LICENSE_NAME"));
                this.nuixClsLicenseSource.setPassword(System.getenv("AUTOMATE_NUIX_CLS_LICENSE_DESCRIPTION"));
                this.nuixClsLicenseSource.setUsername(System.getenv("AUTOMATE_NUIX_CLS_LICENSE_USERNAME"));
                this.nuixClsLicenseSource.setPassword(System.getenv("AUTOMATE_NUIX_CLS_LICENSE_PASSWORD"));
                this.nuixClsLicenseSource.setFilter(System.getenv("AUTOMATE_NUIX_CLS_LICENSE_FILTER"));
                this.nuixClsLicenseSource.setReadOnly(true);
                this.nuixClsLicenseSource.setSourceType(SourceType.CLS);
            }
        }
    }

    private void initializeResourcePoolEnv() {
        String enableResourcePool = System.getenv("AUTOMATE_RESOURCE_POOL_ENABLED");
        if (enableResourcePool != null) {
            LOGGER.info("Overwriting Resource Pool from ENV");
            boolean enabled = Boolean.parseBoolean(enableResourcePool);
            if (!enabled) {
                this.resourcePool = null;
            } else {
                this.resourcePool = new ResourcePoolModel();
                this.resourcePool.setName(System.getenv("AUTOMATE_RESOURCE_POOL_NAME"));
                this.resourcePool.setDescription(System.getenv("AUTOMATE_RESOURCE_POOL_DESCRIPTION"));
                this.resourcePool.setId(DEFAULT_RESOURCE_POOL_ID);
                this.resourcePool.setActive(Boolean.valueOf(true));
                this.resourcePool.setReadOnly(true);
                this.resourcePool.setType(com.nuix.automate.utils.models.api.resourcepool.Type.LOCAL);
                String enableAutoRegistration = System.getenv("AUTOMATE_RESOURCE_POOL_AUTO_REGISTRATION_ENABLED");
                if (enableAutoRegistration != null) {
                    this.resourcePool.setAutoRegistrationEnabled(Boolean.valueOf(Boolean.parseBoolean(enableAutoRegistration)));
                }
                if (this.resourcePool.getAutoRegistrationEnabled().booleanValue()) {
                    AutoRegistrationSettings autoRegistrationSettings = new AutoRegistrationSettings();
                    this.resourcePool.setAutoRegistrationSettings(autoRegistrationSettings);
                    autoRegistrationSettings.setNuixLicenceSourceId(DEFAULT_NUIX_LICENSE_ID);
                    autoRegistrationSettings.setExecutionProfileId(DEFAULT_EXECUTION_PROFILE_ID);
                    autoRegistrationSettings.setTargetNuixWorkers(Integer.valueOf(FormattingUtils.parseInt((String)System.getenv("AUTOMATE_RESOURCE_POOL_AUTO_REGISTRATION_TARGET_WORKERS"), (int)2)));
                    autoRegistrationSettings.setMinNuixWorkers(Integer.valueOf(FormattingUtils.parseInt((String)System.getenv("AUTOMATE_RESOURCE_POOL_AUTO_REGISTRATION_MIN_WORKERS"), (int)1)));
                    ExecutionMode executionMode = ExecutionMode.AUTOMATE_NUIX;
                    String executionModeEnv = System.getenv("AUTOMATE_RESOURCE_POOL_AUTO_REGISTRATION_EXECUTION_MODE");
                    if (executionModeEnv != null) {
                        executionMode = ExecutionMode.valueOf((String)executionModeEnv);
                    }
                    autoRegistrationSettings.setSupportedExecutionMode(executionMode);
                    autoRegistrationSettings.setAccessKey(System.getenv("AUTOMATE_RESOURCE_POOL_AUTO_REGISTRATION_ACCESS_KEY"));
                    String strictIp = System.getenv("AUTOMATE_RESOURCE_POOL_AUTO_REGISTRATION_STRICT_IP");
                    if (strictIp != null) {
                        autoRegistrationSettings.setStrictIp(Boolean.parseBoolean(strictIp));
                    }
                }
            }
        }
    }

    private void initializeExecutionProfileEnv() {
        String enableExecutionProfile = System.getenv("AUTOMATE_EXECUTION_PROFILE_ENABLED");
        if (enableExecutionProfile != null) {
            LOGGER.info("Overwriting Execution Profile from ENV");
            boolean enabled = Boolean.parseBoolean(enableExecutionProfile);
            if (!enabled) {
                this.executionProfile = null;
            } else {
                this.executionProfile = new ExecutionProfileModel();
                this.executionProfile.setName(System.getenv("AUTOMATE_EXECUTION_PROFILE_NAME"));
                this.executionProfile.setDescription(System.getenv("AUTOMATE_EXECUTION_PROFILE_DESCRIPTION"));
                this.executionProfile.setId(DEFAULT_EXECUTION_PROFILE_ID);
                this.executionProfile.setReadOnly(true);
                this.executionProfile.setEngineCommandLineParameters(System.getenv("AUTOMATE_EXECUTION_PROFILE_ENGINE_COMMAND_LINE_PARAMS"));
                if (this.executionProfile.getEngineCommandLineParameters() == null) {
                    this.executionProfile.setEngineCommandLineParameters("-Xmx16g -Dnuix.logdir=/var/log/nuix/automate -Duser.language=en -Duser.country=US");
                }
                this.executionProfile.setEngineLogFolder(System.getenv("AUTOMATE_EXECUTION_PROFILE_ENGINE_LOG_FOLDER"));
                if (this.executionProfile.getEngineLogFolder() == null) {
                    this.executionProfile.setEngineLogFolder("/var/log/nuix/automate");
                }
                this.executionProfile.setNuixEngineFolder(System.getenv("AUTOMATE_EXECUTION_PROFILE_NUIX_ENGINE_FOLDER"));
                if (this.executionProfile.getNuixEngineFolder() == null) {
                    this.executionProfile.setNuixEngineFolder("/opt/nuix/engine");
                }
                this.executionProfile.setJavaFolder(System.getenv("AUTOMATE_EXECUTION_PROFILE_JAVA_FOLDER"));
                if (this.executionProfile.getJavaFolder() == null) {
                    this.executionProfile.setJavaFolder("");
                }
                LinkedHashMap parameters = new LinkedHashMap();
                String parametersString = System.getenv("AUTOMATE_EXECUTION_PROFILE_PARAMETERS");
                if (parametersString != null) {
                    parameters = (LinkedHashMap)SerializationUtils.fromJson((String)parametersString, LinkedHashMap.class);
                }
                this.executionProfile.setWorkflowParameters(parameters);
                JobProgressSettings jobProgressSettings = new JobProgressSettings();
                jobProgressSettings.setUpdateOperationsProgressWeightLastRunWeightPercentage(Double.valueOf(FormattingUtils.parseDouble((String)System.getenv("AUTOMATE_EXECUTION_JOB_PROGRESS_UPDATE_OPERATIONS_WEIGHT"), (double)33.0)));
                this.executionProfile.setJobProgressSettings(jobProgressSettings);
                JobTimeoutSettings jobTimeoutSettings = new JobTimeoutSettings();
                jobTimeoutSettings.setJobProgressMinPercentage(Double.valueOf(FormattingUtils.parseDouble((String)System.getenv("AUTOMATE_EXECUTION_JOB_PROGRESS_MIN_PERCENTAGE"), (double)1.0)));
                jobTimeoutSettings.setJobProgressTimeoutHours(Double.valueOf(FormattingUtils.parseDouble((String)System.getenv("AUTOMATE_EXECUTION_JOB_PROGRESS_TIMEOUT_HOURS"), (double)48.0)));
                jobTimeoutSettings.setOperationProgressMinPercentage(Double.valueOf(FormattingUtils.parseDouble((String)System.getenv("AUTOMATE_EXECUTION_OPERATION_PROGRESS_MIN_PERCENTAGE"), (double)1.0)));
                jobTimeoutSettings.setOperationProgressTimeoutHours(Double.valueOf(FormattingUtils.parseDouble((String)System.getenv("AUTOMATE_EXECUTION_OPERATION_PROGRESS_TIMEOUT_HOURS"), (double)24.0)));
                jobTimeoutSettings.setSkipOperationProgressMinPercentage(Double.valueOf(FormattingUtils.parseDouble((String)System.getenv("AUTOMATE_EXECUTION_SKIP_OPERATION_PROGRESS_MIN_PERCENTAGE"), (double)1.0)));
                jobTimeoutSettings.setSkipOperationProgressMinPercentage(Double.valueOf(FormattingUtils.parseDouble((String)System.getenv("AUTOMATE_EXECUTION_SKIP_OPERATION_PROGRESS_TIMEOUT_HOURS"), (double)12.0)));
                this.executionProfile.setJobTimeoutSettings(jobTimeoutSettings);
                HashMap nuixProfiles = new HashMap();
                this.executionProfile.setNuixProfiles(nuixProfiles);
                HashMap additionalFiles = new HashMap();
                this.executionProfile.setAdditionalFiles(additionalFiles);
            }
        }
    }

    public long getApiClientMinLife() {
        return this.apiClientMinLife;
    }

    public void setApiClientMinLife(long apiClientMinLife) {
        this.apiClientMinLife = apiClientMinLife;
    }

    public WebConfiguration getWebConfiguration() {
        return this.webConfiguration;
    }

    public void setWebConfiguration(WebConfiguration webConfiguration) {
        this.webConfiguration = webConfiguration;
    }

    public long getNameResolutionTimeout() {
        return this.nameResolutionTimeout;
    }

    public void setNameResolutionTimeout(long nameResolutionTimeout) {
        this.nameResolutionTimeout = nameResolutionTimeout;
    }

    public String getCorsAllowedOrigins() {
        return this.corsAllowedOrigins;
    }

    public void setCorsAllowedOrigins(String corsAllowedOrigins) {
        this.corsAllowedOrigins = corsAllowedOrigins;
    }

    public String getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public void setCorsAllowedHeaders(String corsAllowedHeaders) {
        this.corsAllowedHeaders = corsAllowedHeaders;
    }

    public String getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public void setCorsAllowedMethods(String corsAllowedMethods) {
        this.corsAllowedMethods = corsAllowedMethods;
    }

    public boolean getTrackUtilization() {
        return this.trackUtilization;
    }

    public void setTrackUtilization(boolean trackUtilization) {
        this.trackUtilization = trackUtilization;
    }

    private void setRunServer(boolean runServer) {
        this.runServer = runServer;
    }

    private void setRunScheduler(boolean runScheduler) {
        this.runScheduler = runScheduler;
    }

    public int getArchiveJobsPastCount() {
        return this.archiveJobsPastCount;
    }

    public void setArchiveJobsPastCount(int archiveJobsPastCount) {
        this.archiveJobsPastCount = archiveJobsPastCount;
    }

    public long getArchiveJobsPastDuration() {
        return this.archiveJobsPastDuration;
    }

    public void setArchiveJobsPastDuration(long archiveJobsPastDuration) {
        this.archiveJobsPastDuration = archiveJobsPastDuration;
    }

    public boolean getAllowSimultaneousWorkflowsInSameCase() {
        return this.allowSimultaneousWorkflowsInSameCase;
    }

    public void setAllowSimultaneousWorkflowsInSameCase(boolean allowSimultaneousWorkflowsInSameCase) {
        this.allowSimultaneousWorkflowsInSameCase = allowSimultaneousWorkflowsInSameCase;
    }

    public boolean getEnableUserInterfaceDebugMode() {
        return this.enableUserInterfaceDebugMode;
    }

    public String getLog4jConfigurationFile() {
        return this.log4jConfigurationFile;
    }

    public void setLog4jConfigurationFile(String log4jConfigurationFile) {
        this.log4jConfigurationFile = log4jConfigurationFile;
    }

    public boolean getDeleteCookiesWhenInitializingEngine() {
        return this.deleteCookiesWhenInitializingEngine;
    }

    public void setDeleteCookiesWhenInitializingEngine(boolean deleteCookiesWhenInitializingEngine) {
        this.deleteCookiesWhenInitializingEngine = deleteCookiesWhenInitializingEngine;
    }

    @JsonProperty
    public void setNuixUserDataDir(String nuixUserDataDir) {
        this.nuixUserDataDir = nuixUserDataDir;
    }

    @JsonProperty
    public String getNuixUserDataDir() {
        List userDataDirPaths = this.getNuixUserDataDirPaths().stream().map(Path::toString).collect(Collectors.toList());
        if (OsUtils.getOsWindows()) {
            return String.join((CharSequence)";", userDataDirPaths);
        }
        return String.join((CharSequence)":", userDataDirPaths);
    }

    public List<Path> getNuixUserDataDirPaths() {
        ArrayList<Path> userDataDirPaths = new ArrayList<Path>();
        if (this.nuixUserDataDir != null) {
            userDataDirPaths.add(Paths.get(this.nuixUserDataDir, new String[0]).toAbsolutePath());
        }
        if (OsUtils.getOsWindows()) {
            userDataDirPaths.add(Paths.get(System.getenv("APPDATA"), "Nuix"));
            userDataDirPaths.add(Paths.get(System.getenv("PROGRAMDATA"), "Nuix"));
        } else {
            userDataDirPaths.add(Paths.get(System.getProperty("user.home") + "/.nuix", new String[0]));
        }
        userDataDirPaths.add(Paths.get(this.getNuixEnginePath() + "/user-data", new String[0]));
        return userDataDirPaths;
    }

    @JsonProperty
    public String getNuixEnginePath() {
        return this.nuixEnginePath;
    }

    @JsonProperty
    public void setNuixEnginePath(String nuixEnginePath) {
        this.nuixEnginePath = nuixEnginePath;
    }

    @JsonProperty
    public String getNuixFlags() {
        return this.nuixFlags;
    }

    @JsonProperty
    public void setNuixFlags(String nuixFlags) {
        this.nuixFlags = nuixFlags;
    }

    @JsonProperty
    @Deprecated
    public String getNuixUserManagementServer() {
        return this.nuixUserManagementServer;
    }

    @JsonProperty
    public void setNuixUserManagementServer(String nuixUserManagementServer) {
        this.nuixUserManagementServer = nuixUserManagementServer;
    }

    public long getAuthRefresh() {
        return this.authServiceRefreshInterval;
    }

    public long getAuthTokenTtl() {
        return this.authTokenTtl;
    }

    public void setAuthTokenTtl(long authTokenTtl) {
        this.authTokenTtl = authTokenTtl;
    }

    public long getExpiredAuthTokenTombstone() {
        return this.expiredAuthTokenTombstone;
    }

    public void setExpiredAuthTokenTombstone(long expiredAuthTokenTombstone) {
        this.expiredAuthTokenTombstone = expiredAuthTokenTombstone;
    }

    public long getExpiredAuthTokenGracePeriod() {
        return this.expiredAuthTokenGracePeriod;
    }

    public void setExpiredAuthTokenGracePeriod(long expiredAuthTokenGracePeriod) {
        this.expiredAuthTokenGracePeriod = expiredAuthTokenGracePeriod;
    }

    public boolean getDowngradeWebWorkerToken() {
        return this.downgradeWebWorkerToken;
    }

    public void setDowngradeWebWorkerToken(boolean downgradeWebWorkerToken) {
        this.downgradeWebWorkerToken = downgradeWebWorkerToken;
    }

    public boolean isEnforceSingleUserSession() {
        return this.enforceSingleUserSession;
    }

    public void setEnforceSingleUserSession(boolean enforceSingleUserSession) {
        this.enforceSingleUserSession = enforceSingleUserSession;
    }

    public boolean getDisableAuthTokenExpiration() {
        return this.disableAuthTokenExpiration;
    }

    public void setDisableAuthTokenExpiration(boolean disableAuthTokenExpiration) {
        this.disableAuthTokenExpiration = disableAuthTokenExpiration;
    }

    public long getUserSessionTimeout() {
        return this.userSessionTimeout;
    }

    public void setAuthRefresh(long authRefresh) {
        this.authServiceRefreshInterval = authRefresh;
    }

    public void setUserSessionTimeout(long userSessionTimeout) {
        this.userSessionTimeout = userSessionTimeout;
    }

    private String getInstallationPath(String product) {
        if (SchedulerConfiguration.getOsWindows()) {
            return "C:/ProgramData/Nuix/Automate/" + product;
        }
        return "/etc/nuix/automate/" + product.toLowerCase().replace(" ", "-").replace("engineserver", "engine-server");
    }

    private String getStoresPath(String product) {
        if (this.sqliteStoresPath != null && this.sqliteStoresPath.length() > 0) {
            return this.sqliteStoresPath;
        }
        return this.getInstallationPath(product) + "/stores";
    }

    public DataSourceFactory getEffectiveApplicationInitStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "applicationInit.db");
        if (Files.exists(filePath, new LinkOption[0])) {
            if (this.applicationInitStore == null) {
                this.applicationInitStore = new DataSourceFactory();
                this.applicationInitStore.setDriverClass("org.sqlite.JDBC");
                this.applicationInitStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
                this.applicationInitStore.setUser("automate-scheduler");
                this.applicationInitStore.asSingleConnectionPool();
            }
            return this.applicationInitStore;
        }
        return null;
    }

    public DataSourceFactory getEffectiveUsersStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "users.db");
        if (this.usersStore == null) {
            this.usersStore = new DataSourceFactory();
            this.usersStore.setDriverClass("org.sqlite.JDBC");
            this.usersStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.usersStore.setUser("automate-scheduler");
        }
        return this.usersStore;
    }

    public DataSourceFactory getEffectiveAuditStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "audit.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.auditStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.auditStore == null) {
            this.auditStore = new DataSourceFactory();
            this.auditStore.setDriverClass("org.sqlite.JDBC");
            this.auditStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.auditStore.setUser("automate-scheduler");
        }
        return this.auditStore;
    }

    public DataSourceFactory getEffectiveLibraryStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "library.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.libraryStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.libraryStore == null) {
            this.libraryStore = new DataSourceFactory();
            this.libraryStore.setDriverClass("org.sqlite.JDBC");
            this.libraryStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.libraryStore.setUser("automate-scheduler");
        }
        return this.libraryStore;
    }

    public DataSourceFactory getEffectiveClientMatterStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "clientMatter.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.clientMatterStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.clientMatterStore == null) {
            this.clientMatterStore = new DataSourceFactory();
            this.clientMatterStore.setDriverClass("org.sqlite.JDBC");
            this.clientMatterStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.clientMatterStore.setUser("automate-scheduler");
        }
        return this.clientMatterStore;
    }

    public DataSourceFactory getEffectiveSecurityStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "security.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.securityStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.securityStore == null) {
            this.securityStore = new DataSourceFactory();
            this.securityStore.setDriverClass("org.sqlite.JDBC");
            this.securityStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.securityStore.setUser("automate-scheduler");
        }
        return this.securityStore;
    }

    public DataSourceFactory getEffectiveJobsStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "jobs.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.jobsStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.jobsStore == null) {
            this.jobsStore = new DataSourceFactory();
            this.jobsStore.setDriverClass("org.sqlite.JDBC");
            this.jobsStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.jobsStore.setUser("automate-scheduler");
        }
        return this.jobsStore;
    }

    public DataSourceFactory getEffectiveUserSettingsStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "userSettings.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.userSettingsStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.userSettingsStore == null) {
            this.userSettingsStore = new DataSourceFactory();
            this.userSettingsStore.setDriverClass("org.sqlite.JDBC");
            this.userSettingsStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.userSettingsStore.setUser("automate-scheduler");
        }
        return this.userSettingsStore;
    }

    public DataSourceFactory getEffectiveJobsArchiveStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "jobsArchive.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.jobsArchiveStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.jobsArchiveStore == null) {
            this.jobsArchiveStore = new DataSourceFactory();
            this.jobsArchiveStore.setDriverClass("org.sqlite.JDBC");
            this.jobsArchiveStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.jobsArchiveStore.setUser("automate-scheduler");
        }
        return this.jobsArchiveStore;
    }

    public DataSourceFactory getEffectiveUtilizationStore() {
        if (this.applicationStore != null && this.utilizationRedirectToApplicationStore) {
            return this.applicationStore;
        }
        if (this.utilizationStore == null) {
            this.utilizationStore = new DataSourceFactory();
            this.utilizationStore.setDriverClass("org.sqlite.JDBC");
            this.utilizationStore.setUrl("jdbc:sqlite:" + this.getStoresPath("Scheduler") + "/utilization.db");
            this.utilizationStore.setUser("automate-scheduler");
        }
        return this.utilizationStore;
    }

    public DataSourceFactory getEffectiveNoticeStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "notice.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.noticeStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.noticeStore == null) {
            this.noticeStore = new DataSourceFactory();
            this.noticeStore.setDriverClass("org.sqlite.JDBC");
            this.noticeStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.noticeStore.setUser("automate-scheduler");
        }
        return this.noticeStore;
    }

    public DataSourceFactory getEffectiveLegalHoldStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "legalHold.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.legalHoldStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.legalHoldStore == null) {
            this.legalHoldStore = new DataSourceFactory();
            this.legalHoldStore.setDriverClass("org.sqlite.JDBC");
            this.legalHoldStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.legalHoldStore.setUser("automate-scheduler");
        }
        return this.legalHoldStore;
    }

    public DataSourceFactory getEffectiveLoggingStore() {
        if (this.applicationStore != null && this.loggingRedirectToApplicationStore) {
            return this.applicationStore;
        }
        if (this.loggingStore == null) {
            this.loggingStore = new DataSourceFactory();
            this.loggingStore.setDriverClass("org.sqlite.JDBC");
            this.loggingStore.setUrl("jdbc:sqlite:" + this.getStoresPath("Scheduler") + "/logging.db");
            this.loggingStore.setUser("automate-scheduler");
            this.loggingStore.asSingleConnectionPool();
        }
        return this.loggingStore;
    }

    private void initApplicationStore() {
        if (this.applicationStore == null) {
            File f = new File(this.getStoresPath("Scheduler"));
            if (!f.exists()) {
                f.mkdirs();
            }
            this.applicationStore = new DataSourceFactory();
            this.applicationStore.setDriverClass("org.sqlite.JDBC");
            this.applicationStore.setUrl("jdbc:sqlite:" + this.getStoresPath("Scheduler") + "/application.db");
            this.applicationStore.setUser("automate-scheduler");
        } else if (this.usersStore == null) {
            this.usersStore = this.applicationStore;
        }
    }

    public DataSourceFactory getEffectiveSchedulerConfigurationStore() {
        Path filePath = Paths.get(this.getStoresPath("Scheduler"), "configuration.db");
        if (!Files.exists(filePath, new LinkOption[0]) && this.schedulerConfigurationStore == null) {
            this.initApplicationStore();
            if (this.applicationStore != null) {
                return this.applicationStore;
            }
        }
        if (this.schedulerConfigurationStore == null) {
            File f = new File(this.getStoresPath("Scheduler"));
            if (!f.exists()) {
                f.mkdirs();
            }
            this.schedulerConfigurationStore = new DataSourceFactory();
            this.schedulerConfigurationStore.setDriverClass("org.sqlite.JDBC");
            this.schedulerConfigurationStore.setUrl("jdbc:sqlite:" + String.valueOf(filePath));
            this.schedulerConfigurationStore.setUser("automate-scheduler");
        } else if (this.usersStore == null) {
            this.usersStore = this.schedulerConfigurationStore;
        }
        return this.schedulerConfigurationStore;
    }

    public LdapConfiguration getLdap() {
        return this.ldap;
    }

    public void setLdap(LdapConfiguration ldap) {
        this.ldap = ldap;
    }

    public OidcConfig getOidc() {
        return this.oidc;
    }

    public OidcMicrosoftConfig getOidcMicrosoft() {
        return this.oidcMicrosoft;
    }

    public void setOidcMicrosoft(OidcMicrosoftConfig oidcMicrosoft) {
        this.oidcMicrosoft = oidcMicrosoft;
    }

    public String getApiSecret() {
        if (this.apiSecret.equals("changeme")) {
            LOGGER.error("Default apiSecret detected, API authentication is disabled");
            this.apiSecret = UidUtils.getRandom();
        }
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public boolean getEnableWinDpapi() {
        return this.enableWinDpapi;
    }

    public void setEnableWinDpapi(boolean enableWinDpapi) {
        this.enableWinDpapi = enableWinDpapi;
    }

    public static boolean getOsWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public boolean getRestartAfterFinishedJob() {
        return this.restartAfterFinishedJob;
    }

    public void setRestartAfterFinishedJob(boolean restartAfterFinishedJob) {
        this.restartAfterFinishedJob = restartAfterFinishedJob;
    }

    public Map<String, Map<String, Object>> getDefaultUserSettings() {
        if (this.defaultUserSettings == null) {
            this.defaultUserSettings = new HashMap<String, Map<String, Object>>();
        }
        return this.defaultUserSettings;
    }

    public void setDefaultUserSettings(Map<String, Map<String, Object>> defaultUserSettings) {
        this.defaultUserSettings = defaultUserSettings;
    }

    public long getEngineTimeout() {
        return this.engineTimeout;
    }

    public void setEngineTimeout(long engineTimeout) {
        this.engineTimeout = engineTimeout;
    }

    public long getEngineKeepAlive() {
        return this.engineKeepAlive;
    }

    public void setEngineKeepAlive(long engineKeepAlive) {
        this.engineKeepAlive = engineKeepAlive;
    }

    public long getServerTimeout() {
        return this.serverTimeout;
    }

    public void setServerTimeout(long serverTimeout) {
        this.serverTimeout = serverTimeout;
    }

    public long getServerPingInterval() {
        return this.serverPingInterval;
    }

    public void setServerPingInterval(long serverPingInterval) {
        this.serverPingInterval = serverPingInterval;
    }

    public long getJobDisconnectedTimeout() {
        return this.jobDisconnectedTimeout;
    }

    public void setJobDisconnectedTimeout(long jobDisconnectedTimeout) {
        this.jobDisconnectedTimeout = jobDisconnectedTimeout;
    }

    public long getUpdateDatabaseInterval() {
        return this.updateDatabaseInterval;
    }

    public void setUpdateDatabaseInterval(long updateDatabaseInterval) {
        this.updateDatabaseInterval = updateDatabaseInterval;
    }

    public long getOidcMinShelfLife() {
        return this.oidcMinShelfLife;
    }

    public void setOidcMinShelfLife(long oidcMinShelfLife) {
        this.oidcMinShelfLife = oidcMinShelfLife;
    }

    public long getResourcePoolTimeout() {
        return this.resourcePoolTimeout;
    }

    public void setResourcePoolTimeout(long resourcePoolTimeout) {
        this.resourcePoolTimeout = resourcePoolTimeout;
    }

    public long getCloudInitialErrorDelay() {
        return this.cloudInitialErrorDelay;
    }

    public void setCloudInitialErrorDelay(long cloudInitialErrorDelay) {
        this.cloudInitialErrorDelay = cloudInitialErrorDelay;
    }

    public boolean getUsesUnsafeInline() {
        return this.usesUnsafeInline;
    }

    public void setUsesUnsafeInline(boolean usesUnsafeInline) {
        this.usesUnsafeInline = usesUnsafeInline;
    }

    public long getApiClientConnectionTimeout() {
        return this.apiClientConnectionTimeout;
    }

    public void setApiClientConnectionTimeout(long apiClientConnectionTimeout) {
        this.apiClientConnectionTimeout = apiClientConnectionTimeout;
    }

    public long getApiClientReadTimeout() {
        return this.apiClientReadTimeout;
    }

    public void setApiClientReadTimeout(long apiClientReadTimeout) {
        this.apiClientReadTimeout = apiClientReadTimeout;
    }

    public long getEngineInitKeepAlive() {
        return this.engineInitKeepAlive;
    }

    public void setEngineInitKeepAlive(long engineInitKeepAlive) {
        this.engineInitKeepAlive = engineInitKeepAlive;
    }

    public long getNuixLicenseSourceTimeout() {
        return this.nuixLicenseSourceTimeout;
    }

    public void setNuixLicenseSourceTimeout(long nuixLicenseSourceTimeout) {
        this.nuixLicenseSourceTimeout = nuixLicenseSourceTimeout;
    }

    public long getSchedulerTombstoneDuration() {
        return this.schedulerTombstoneDuration;
    }

    public void setSchedulerTombstoneDuration(long schedulerTombstoneDuration) {
        this.schedulerTombstoneDuration = schedulerTombstoneDuration;
    }

    public long getCloudPingInterval() {
        return this.cloudPingInterval;
    }

    public void setCloudPingInterval(long cloudPingInterval) {
        this.cloudPingInterval = cloudPingInterval;
    }

    public long getEnginePingInterval() {
        return this.enginePingInterval;
    }

    public void setEnginePingInterval(long enginePingInterval) {
        this.enginePingInterval = enginePingInterval;
    }

    public long getResourcePoolBootstrapDelay() {
        return this.resourcePoolBootstrapDelay;
    }

    public void setResourcePoolBootstrapDelay(long resourcePoolBootstrapDelay) {
        this.resourcePoolBootstrapDelay = resourcePoolBootstrapDelay;
    }

    public long getResourcePoolInterval() {
        return this.resourcePoolInterval;
    }

    public void setResourcePoolInterval(long resourcePoolInterval) {
        this.resourcePoolInterval = resourcePoolInterval;
    }

    public long getJobWorkerInterval() {
        return this.jobWorkerInterval;
    }

    public void setJobWorkerInterval(long jobWorkerInterval) {
        this.jobWorkerInterval = jobWorkerInterval;
    }

    public boolean getAzureVmConnectUsingPublicIp() {
        return this.azureVmConnectUsingPublicIp;
    }

    public void setAzureVmConnectUsingPublicIp(boolean azureVmConnectUsingPublicIp) {
        this.azureVmConnectUsingPublicIp = azureVmConnectUsingPublicIp;
    }

    public boolean getAzureVmConnectUsingPrivateIp() {
        return this.azureVmConnectUsingPrivateIp;
    }

    public void setAzureVmConnectUsingPrivateIp(boolean azureVmConnectUsingPrivateIp) {
        this.azureVmConnectUsingPrivateIp = azureVmConnectUsingPrivateIp;
    }

    public long getUserImageCacheKeepAlive() {
        return this.userImageCacheKeepAlive;
    }

    public void setUserImageCacheKeepAlive(long userImageCacheKeepAlive) {
        this.userImageCacheKeepAlive = userImageCacheKeepAlive;
    }

    public long getFileIconCacheKeepAlive() {
        return this.fileIconCacheKeepAlive;
    }

    public void setFileIconCacheKeepAlive(long fileIconCacheKeepAlive) {
        this.fileIconCacheKeepAlive = fileIconCacheKeepAlive;
    }

    public String getLoopbackUrl() {
        return this.loopbackUrl;
    }

    public void setLoopbackUrl(String loopbackUrl) {
        this.loopbackUrl = loopbackUrl;
    }

    public String getLoopbackFingerprint() {
        return this.loopbackFingerprint;
    }

    public void setLoopbackFingerprint(String loopbackFingerprint) {
        this.loopbackFingerprint = loopbackFingerprint;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    @Deprecated
    private boolean getRunEngine() {
        return this.runEngine;
    }

    private void setRunEngine(boolean runEngine) {
        this.runEngine = runEngine;
    }

    public long getEngineErrorDelay() {
        return this.engineErrorDelay;
    }

    public void setEngineErrorDelay(long engineErrorDelay) {
        this.engineErrorDelay = engineErrorDelay;
    }

    public long getEngineShutdownTimeout() {
        return this.engineShutdownTimeout;
    }

    public void setEngineShutdownTimeout(long engineShutdownTimeout) {
        this.engineShutdownTimeout = engineShutdownTimeout;
    }

    public String getEngineInitLogFolder() {
        return this.engineInitLogFolder;
    }

    public String getUtilizationExportOnStartUpFolderPath() {
        return this.utilizationExportOnStartUpFolderPath;
    }

    public void setEngineInitLogFolder(String engineInitLogFolder) {
        this.engineInitLogFolder = engineInitLogFolder;
    }

    public String getMinWorkflowVersion() {
        return this.minWorkflowVersion;
    }

    public void setMinWorkflowVersion(String minWorkflowVersion) {
        this.minWorkflowVersion = minWorkflowVersion;
    }

    public boolean getDebugLogRequestResponse() {
        return this.debugLogRequestResponse;
    }

    public void setDebugLogRequestResponse(boolean debugLogRequestResponse) {
        this.debugLogRequestResponse = debugLogRequestResponse;
    }

    public void setOidc(OidcConfig oidc) {
        this.oidc = oidc;
    }

    public long getJobSchedulingLoopDetection() {
        return this.jobSchedulingLoopDetection;
    }

    public void setJobSchedulingLoopDetection(long jobSchedulingLoopDetection) {
        this.jobSchedulingLoopDetection = jobSchedulingLoopDetection;
    }

    public long getAllowedParameterValuesScriptTimeout() {
        return this.allowedParameterValuesScriptTimeout;
    }

    public void setAllowedParameterValuesScriptTimeout(long allowedParameterValuesScriptTimeout) {
        this.allowedParameterValuesScriptTimeout = allowedParameterValuesScriptTimeout;
    }

    public String getWorkerBrokerIP() {
        return this.workerBrokerIP;
    }

    public void setWorkerBrokerIP(String workerBrokerIP) {
        this.workerBrokerIP = workerBrokerIP;
    }

    public Integer getWorkerBrokerStartPort() {
        return this.workerBrokerStartPort;
    }

    public void setWorkerBrokerStartPort(Integer workerBrokerStartPort) {
        this.workerBrokerStartPort = workerBrokerStartPort;
    }

    public Integer getWorkerBrokerEndPort() {
        return this.workerBrokerEndPort;
    }

    public void setWorkerBrokerEndPort(Integer workerBrokerEndPort) {
        this.workerBrokerEndPort = workerBrokerEndPort;
    }

    public int getWorkerBrokerInitAttempts() {
        return this.workerBrokerInitAttempts;
    }

    public void setWorkerBrokerInitAttempts(int workerBrokerInitAttempts) {
        this.workerBrokerInitAttempts = workerBrokerInitAttempts;
    }

    public BrandingConfiguration getBranding() {
        return this.branding;
    }

    public void setBranding(BrandingConfiguration branding) {
        this.branding = branding;
    }

    public ApiTrackingConfiguration getApiTracking() {
        return this.apiTracking;
    }

    public void setApiTracking(ApiTrackingConfiguration apiTracking) {
        this.apiTracking = apiTracking;
    }

    public long getCloudResourcePoolTimeout() {
        return this.cloudResourcePoolTimeout;
    }

    public void setCloudResourcePoolTimeout(long cloudResourcePoolTimeout) {
        this.cloudResourcePoolTimeout = cloudResourcePoolTimeout;
    }

    public boolean getEnableEngineJavaMinidumps() {
        return this.enableEngineJavaMinidumps;
    }

    public void setEnableEngineJavaMinidumps(boolean enableEngineJavaMinidumps) {
        this.enableEngineJavaMinidumps = enableEngineJavaMinidumps;
    }

    public long getNuixLicensePingInterval() {
        return this.nuixLicensePingInterval;
    }

    public void setNuixLicensePingInterval(long nuixLicensePingInterval) {
        this.nuixLicensePingInterval = nuixLicensePingInterval;
    }

    public long getLibraryFileMaxSize() {
        return this.libraryFileMaxSize;
    }

    public void setLibraryFileMaxSize(long libraryFileMaxSize) {
        this.libraryFileMaxSize = libraryFileMaxSize;
    }

    public long getAutomateLicensePingInterval() {
        return this.automateLicensePingInterval;
    }

    public void setAutomateLicensePingInterval(long automateLicensePingInterval) {
        this.automateLicensePingInterval = automateLicensePingInterval;
    }

    public long getAutomateLicenseTimeout() {
        return this.automateLicenseTimeout;
    }

    public void setAutomateLicenseTimeout(long automateLicenseTimeout) {
        this.automateLicenseTimeout = automateLicenseTimeout;
    }

    public boolean shouldDeleteCachedClsCredentials() {
        return this.deleteCachedClsCredentials;
    }

    public void setDeleteCachedClsCredentials(boolean deleteCachedClsCredentials) {
        this.deleteCachedClsCredentials = deleteCachedClsCredentials;
    }

    public String getUploadHashAlgorithms() {
        return this.uploadHashAlgorithms;
    }

    public void setUploadHashAlgorithms(String uploadHashAlgorithms) {
        this.uploadHashAlgorithms = uploadHashAlgorithms;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public boolean getEnableCentralizedLogging() {
        return this.enableCentralizedLogging;
    }

    public void setEnableCentralizedLogging(boolean enableCentralizedLogging) {
        this.enableCentralizedLogging = enableCentralizedLogging;
    }

    public int getCentralizedLoggingRetention() {
        return this.centralizedLoggingRetention;
    }

    public void setCentralizedLoggingRetention(int centralizedLoggingRetention) {
        this.centralizedLoggingRetention = centralizedLoggingRetention;
    }

    public long getCentralizedLoggingMaxSize() {
        return this.centralizedLoggingMaxSize;
    }

    public void setCentralizedLoggingMaxSize(long centralizedLoggingMaxSize) {
        this.centralizedLoggingMaxSize = centralizedLoggingMaxSize;
    }

    public long getCollectionWorkerTimeout() {
        return this.collectionWorkerTimeout;
    }

    public void setCollectionWorkerTimeout(long collectionWorkerTimeout) {
        this.collectionWorkerTimeout = collectionWorkerTimeout;
    }

    public boolean getExcludeAutomatedOfflineUtilizationData() {
        return this.excludeAutomatedOfflineUtilizationData;
    }

    public InternalCredentialsConfiguration getInternalCredentials() {
        return this.internalCredentials;
    }

    public void setInternalCredentials(InternalCredentialsConfiguration internalCredentials) {
        this.internalCredentials = internalCredentials;
    }

    public UmsConfiguration getUms() {
        if (this.ums == null && this.nuixUserManagementServer != null) {
            this.ums = new UmsConfiguration();
            this.ums.setUrl(this.nuixUserManagementServer);
        }
        return this.ums;
    }

    public void setUms(UmsConfiguration ums) {
        this.ums = ums;
    }

    public boolean getDisableResponseCache() {
        return this.disableResponseCache;
    }

    public void setDisableResponseCache(boolean disableResponseCache) {
        this.disableResponseCache = disableResponseCache;
    }

    public long getResponseCacheMaxValidity() {
        return this.responseCacheMaxValidity;
    }

    public void setResponseCacheMaxValidity(long responseCacheMaxValidity) {
        this.responseCacheMaxValidity = responseCacheMaxValidity;
    }

    public long getGlobalResponseCacheMaxValidity() {
        return this.globalResponseCacheMaxValidity;
    }

    public void setGlobalResponseCacheMaxValidity(long globalResponseCacheMaxValidity) {
        this.globalResponseCacheMaxValidity = globalResponseCacheMaxValidity;
    }

    public long getDataRepositoryResponseCacheMaxValidity() {
        return this.dataRepositoryResponseCacheMaxValidity;
    }

    public void setDataRepositoryResponseCacheMaxValidity(long dataRepositoryResponseCacheMaxValidity) {
        this.dataRepositoryResponseCacheMaxValidity = dataRepositoryResponseCacheMaxValidity;
    }

    public long getDataRepositoryUsableSpaceInterval() {
        return this.dataRepositoryUsableSpaceInterval;
    }

    public void setDataRepositoryUsableSpaceInterval(long dataRepositoryUsableSpaceInterval) {
        this.dataRepositoryUsableSpaceInterval = dataRepositoryUsableSpaceInterval;
    }

    public long getExpireIdleUploadAfter() {
        return this.expireIdleUploadAfter;
    }

    public void setExpireIdleUploadAfter(long expireIdleUploadAfter) {
        this.expireIdleUploadAfter = expireIdleUploadAfter;
    }

    public long getDatasetTusFileUploadCleanupInterval() {
        return this.datasetTusFileUploadCleanupInterval;
    }

    public void setDatasetTusFileUploadCleanupInterval(long datasetTusFileUploadCleanupInterval) {
        this.datasetTusFileUploadCleanupInterval = datasetTusFileUploadCleanupInterval;
    }

    public long getDatasetAutoExpireInterval() {
        return this.datasetAutoExpireInterval;
    }

    public void setDatasetAutoExpireInterval(long datasetAutoExpireInterval) {
        this.datasetAutoExpireInterval = datasetAutoExpireInterval;
    }

    public Integer getUploadBufferMaxSize() {
        return this.uploadBufferMaxSize;
    }

    public void setUploadBufferMaxSize(Integer uploadBufferMaxSize) {
        this.uploadBufferMaxSize = uploadBufferMaxSize;
    }

    public boolean getUploadWithNullWriter() {
        return this.uploadWithNullWriter;
    }

    public void setUploadWithNullWriter(boolean uploadWithNullWriter) {
        this.uploadWithNullWriter = uploadWithNullWriter;
    }

    public boolean getUploadWithSeparateWriteThread() {
        return this.uploadWithSeparateWriteThread;
    }

    public void setUploadWithSeparateWriteThread(boolean uploadWithSeparateWriteThread) {
        this.uploadWithSeparateWriteThread = uploadWithSeparateWriteThread;
    }

    public long getNoticeReminderEscalationPollInterval() {
        return this.noticeReminderEscalationPollInterval;
    }

    public void setNoticeReminderEscalationPollInterval(long noticeReminderEscalationPollInterval) {
        this.noticeReminderEscalationPollInterval = noticeReminderEscalationPollInterval;
    }

    public long getBrandingCacheKeepAlive() {
        return this.brandingCacheKeepAlive;
    }

    public void setBrandingCacheKeepAlive(long brandingCacheKeepAlive) {
        this.brandingCacheKeepAlive = brandingCacheKeepAlive;
    }

    public SchedulerComponent getRole() {
        if (this.role == null) {
            if (this.runScheduler) {
                return SchedulerComponent.SCHEDULER;
            }
            if (this.runServer) {
                return SchedulerComponent.ENGINE_SERVER;
            }
            if (this.runEngine) {
                return SchedulerComponent.ENGINE;
            }
        }
        return this.role;
    }

    public void setRole(SchedulerComponent role) {
        this.role = role;
    }

    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    public void setProxy(ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    public long getProxyPingInterval() {
        return this.proxyPingInterval;
    }

    public void setProxyPingInterval(long proxyPingInterval) {
        this.proxyPingInterval = proxyPingInterval;
    }

    public boolean getDisableUserIcons() {
        return this.disableUserIcons;
    }

    public void setDisableUserIcons(boolean disableUserIcons) {
        this.disableUserIcons = disableUserIcons;
    }

    public boolean getSortAllowedParametersValues() {
        return this.sortAllowedParametersValues;
    }

    public void setSortAllowedParametersValues(boolean sortAllowedParametersValues) {
        this.sortAllowedParametersValues = sortAllowedParametersValues;
    }

    public boolean getSynchronizeJobsOnAllMatters() {
        return this.synchronizeJobsOnAllMatters;
    }

    public void setSynchronizeJobsOnAllMatters(boolean synchronizeJobsOnAllMatters) {
        this.synchronizeJobsOnAllMatters = synchronizeJobsOnAllMatters;
    }

    public long getEngineInitRetryDelay() {
        return this.engineInitRetryDelay;
    }

    public void setEngineInitRetryDelay(long engineInitRetryDelay) {
        this.engineInitRetryDelay = engineInitRetryDelay;
    }

    public int getMaxWebhookEventsHistoryCount() {
        return this.maxWebhookEventsHistoryCount;
    }

    public void setMaxWebhookEventsHistoryCount(int maxWebhookEventsHistoryCount) {
        this.maxWebhookEventsHistoryCount = maxWebhookEventsHistoryCount;
    }

    public long getWebhookInitialDelayOnFailure() {
        return this.webhookInitialDelayOnFailure;
    }

    public void setWebhookInitialDelayOnFailure(long webhookInitialDelayOnFailure) {
        this.webhookInitialDelayOnFailure = webhookInitialDelayOnFailure;
    }

    public int getDisableWebhookAfterFailedCallbacks() {
        return this.disableWebhookAfterFailedCallbacks;
    }

    public void setDisableWebhookAfterFailedCallbacks(int disableWebhookAfterFailedCallbacks) {
        this.disableWebhookAfterFailedCallbacks = disableWebhookAfterFailedCallbacks;
    }

    public boolean getAwsInstanceConnectUsingPublicDns() {
        return this.awsInstanceConnectUsingPublicDns;
    }

    public void setAwsInstanceConnectUsingPublicDns(boolean awsInstanceConnectUsingPublicDns) {
        this.awsInstanceConnectUsingPublicDns = awsInstanceConnectUsingPublicDns;
    }

    public boolean getAwsInstanceConnectUsingPublicIp() {
        return this.awsInstanceConnectUsingPublicIp;
    }

    public void setAwsInstanceConnectUsingPublicIp(boolean awsInstanceConnectUsingPublicIp) {
        this.awsInstanceConnectUsingPublicIp = awsInstanceConnectUsingPublicIp;
    }

    public boolean getAwsInstanceConnectUsingPrivateDns() {
        return this.awsInstanceConnectUsingPrivateDns;
    }

    public void setAwsInstanceConnectUsingPrivateDns(boolean awsInstanceConnectUsingPrivateDns) {
        this.awsInstanceConnectUsingPrivateDns = awsInstanceConnectUsingPrivateDns;
    }

    public boolean getAwsInstanceConnectUsingPrivateIp() {
        return this.awsInstanceConnectUsingPrivateIp;
    }

    public void setAwsInstanceConnectUsingPrivateIp(boolean awsInstanceConnectUsingPrivateIp) {
        this.awsInstanceConnectUsingPrivateIp = awsInstanceConnectUsingPrivateIp;
    }

    public boolean getMockOptionsEnabled() {
        return this.mockOptionsEnabled;
    }

    public boolean getMockOptionsChangingValues() {
        return this.mockOptionsChangingValues;
    }

    public void setMockOptionsChangingValues(boolean mockOptionsChangingValues) {
        this.mockOptionsChangingValues = mockOptionsChangingValues;
    }

    public void setMockOptionsEnabled(boolean mockOptionsEnabled) {
        this.mockOptionsEnabled = mockOptionsEnabled;
    }

    public String getMinEngineServerVersion() {
        return this.minEngineServerVersion;
    }

    public void setMinEngineServerVersion(String minEngineServerVersion) {
        this.minEngineServerVersion = minEngineServerVersion;
    }

    public String[] getAzureLocations() {
        if (this.azureLocations == null) {
            return AzureEnvironmentUtils.getAzureLocations();
        }
        return this.azureLocations;
    }

    public void setAzureLocations(String[] azureLocations) {
        this.azureLocations = azureLocations;
    }

    public String[] getAzureVmSizes() {
        if (this.azureVmSizes == null) {
            return AzureEnvironmentUtils.getAzureVmSizes();
        }
        return this.azureVmSizes;
    }

    public void setAzureVmSizes(String[] azureVmSizes) {
        this.azureVmSizes = azureVmSizes;
    }

    public int getAzureVmMaxDeleteAttempts() {
        return this.azureVmMaxDeleteAttempts;
    }

    public void setAzureVmMaxDeleteAttempts(int azureVmMaxDeleteAttempts) {
        this.azureVmMaxDeleteAttempts = azureVmMaxDeleteAttempts;
    }

    public long getAzureVmDeleteAttemptsInterval() {
        return this.azureVmDeleteAttemptsInterval;
    }

    public void setAzureVmDeleteAttemptsInterval(long azureVmDeleteAttemptsInterval) {
        this.azureVmDeleteAttemptsInterval = azureVmDeleteAttemptsInterval;
    }

    public boolean getPingNuixLicenseIfValid() {
        return this.pingNuixLicenseIfValid;
    }

    public void setPingNuixLicenseIfValid(boolean pingNuixLicenseIfValid) {
        this.pingNuixLicenseIfValid = pingNuixLicenseIfValid;
    }

    public boolean getPingNuixLicenseIfError() {
        return this.pingNuixLicenseIfError;
    }

    public void setPingNuixLicenseIfError(boolean pingNuixLicenseIfError) {
        this.pingNuixLicenseIfError = pingNuixLicenseIfError;
    }

    public boolean getDisableBusinessEndpoints() {
        return this.disableBusinessEndpoints;
    }

    public void setDisableBusinessEndpoints(boolean disableBusinessEndpoints) {
        this.disableBusinessEndpoints = disableBusinessEndpoints;
    }

    public boolean getDisableCorporateEndpoints() {
        return this.disableCorporateEndpoints;
    }

    public void setDisableCorporateEndpoints(boolean disableCorporateEndpoints) {
        this.disableCorporateEndpoints = disableCorporateEndpoints;
    }

    public boolean getDisablePremiumEndpoints() {
        return this.disablePremiumEndpoints;
    }

    public void setDisablePremiumEndpoints(boolean disablePremiumEndpoints) {
        this.disablePremiumEndpoints = disablePremiumEndpoints;
    }

    public int getLegalHoldWorkerThreadCount() {
        return this.legalHoldWorkerThreadCount;
    }

    public void setLegalHoldWorkerThreadCount(int legalHoldWorkerThreadCount) {
        this.legalHoldWorkerThreadCount = legalHoldWorkerThreadCount;
    }

    public String getPurviewGraphApiVersion() {
        return this.purviewGraphApiVersion;
    }

    public void setPurviewGraphApiVersion(String purviewGraphApiVersion) {
        this.purviewGraphApiVersion = purviewGraphApiVersion;
    }

    public int getPurviewServiceUserCredentialExpireWarningThreshold() {
        return this.purviewServiceUserCredentialExpireWarningThreshold;
    }

    public void setPurviewServiceUserCredentialExpireWarningThreshold(int purviewServiceUserCredentialExpireWarningThreshold) {
        this.purviewServiceUserCredentialExpireWarningThreshold = purviewServiceUserCredentialExpireWarningThreshold;
    }

    public int getVaultServiceUserCredentialExpireWarningThreshold() {
        return this.vaultServiceUserCredentialExpireWarningThreshold;
    }

    public void setVaultServiceUserCredentialExpireWarningThreshold(int vaultServiceUserCredentialExpireWarningThreshold) {
        this.vaultServiceUserCredentialExpireWarningThreshold = vaultServiceUserCredentialExpireWarningThreshold;
    }

    public int getVaultServiceApiRequestMaxAttempts() {
        return this.vaultServiceApiRequestMaxAttempts;
    }

    public void setVaultServiceApiRequestMaxAttempts(int vaultServiceApiRequestMaxAttempts) {
        this.vaultServiceApiRequestMaxAttempts = vaultServiceApiRequestMaxAttempts;
    }

    public int getRelativityServiceUserCredentialExpireWarningThreshold() {
        return this.relativityServiceUserCredentialExpireWarningThreshold;
    }

    public void setRelativityServiceUserCredentialExpireWarningThreshold(int relativityServiceUserCredentialExpireWarningThreshold) {
        this.relativityServiceUserCredentialExpireWarningThreshold = relativityServiceUserCredentialExpireWarningThreshold;
    }

    public int getDiscoverServiceUserCredentialExpireWarningThreshold() {
        return this.discoverServiceUserCredentialExpireWarningThreshold;
    }

    public void setDiscoverServiceUserCredentialExpireWarningThreshold(int discoverServiceUserCredentialExpireWarningThreshold) {
        this.discoverServiceUserCredentialExpireWarningThreshold = discoverServiceUserCredentialExpireWarningThreshold;
    }

    public int getElasticsearchServiceUserCredentialExpireWarningThreshold() {
        return this.elasticsearchServiceUserCredentialExpireWarningThreshold;
    }

    public void setElasticsearchServiceUserCredentialExpireWarningThreshold(int elasticsearchServiceUserCredentialExpireWarningThreshold) {
        this.elasticsearchServiceUserCredentialExpireWarningThreshold = elasticsearchServiceUserCredentialExpireWarningThreshold;
    }

    public int getEccServiceUserCredentialExpireWarningThreshold() {
        return this.eccServiceUserCredentialExpireWarningThreshold;
    }

    public void setEccServiceUserCredentialExpireWarningThreshold(int eccServiceUserCredentialExpireWarningThreshold) {
        this.eccServiceUserCredentialExpireWarningThreshold = eccServiceUserCredentialExpireWarningThreshold;
    }

    public int getNlpUserCredentialExpireWarningThreshold() {
        return this.nlpUserCredentialExpireWarningThreshold;
    }

    public void setNlpUserCredentialExpireWarningThreshold(int nlpUserCredentialExpireWarningThreshold) {
        this.nlpUserCredentialExpireWarningThreshold = nlpUserCredentialExpireWarningThreshold;
    }

    public long getThirdPartyServiceUserCredentialCacheLifeTimeSeconds() {
        return this.thirdPartyServiceUserCredentialCacheLifeTimeSeconds;
    }

    public long getUserServiceObjectsCacheLifeTimeSeconds() {
        return this.userServiceObjectsCacheLifeTimeSeconds;
    }

    public void setUserServiceObjectsCacheLifeTimeSeconds(long userServiceObjectsCacheLifeTimeSeconds) {
        this.userServiceObjectsCacheLifeTimeSeconds = userServiceObjectsCacheLifeTimeSeconds;
    }

    public String getOpenApiDescription() {
        return this.openApiDescription;
    }

    public void setOpenApiDescription(String openApiDescription) {
        this.openApiDescription = openApiDescription;
    }

    public String getOpenApiFileSuffix() {
        return this.openApiFileSuffix;
    }

    public void setOpenApiFileSuffix(String openApiFileSuffix) {
        this.openApiFileSuffix = openApiFileSuffix;
    }

    public String getEngineCommandLine() {
        return this.engineCommandLine;
    }

    public void setEngineCommandLine(String engineCommandLine) {
        this.engineCommandLine = engineCommandLine;
    }

    public int getEngineInitTimeout() {
        return this.engineInitTimeout;
    }

    public void setEngineInitTimeout(int engineInitTimeout) {
        this.engineInitTimeout = engineInitTimeout;
    }

    public DatasetPathFormat getDatasetPathFormat() {
        return this.datasetPathFormat;
    }

    public void setDatasetPathFormat(DatasetPathFormat datasetPathFormat) {
        this.datasetPathFormat = datasetPathFormat;
    }

    public String getSqliteStoresPath() {
        return this.sqliteStoresPath;
    }

    public void setSqliteStoresPath(String sqliteStoresPath) {
        this.sqliteStoresPath = sqliteStoresPath;
    }

    public String getDebugSqlLogsPath() {
        return this.debugSqlLogsPath;
    }

    public void setDebugSqlLogsPath(String debugSqlLogsPath) {
        this.debugSqlLogsPath = debugSqlLogsPath;
    }

    public long getDebugSqlLogsFlushTime() {
        return this.debugSqlLogsFlushTime;
    }

    public void setDebugSqlLogsFlushTime(long debugSqlLogsFlushTime) {
        this.debugSqlLogsFlushTime = debugSqlLogsFlushTime;
    }

    public long getDebugSqlLogsFlushLines() {
        return this.debugSqlLogsFlushLines;
    }

    public void setDebugSqlLogsFlushLines(long debugSqlLogsFlushLines) {
        this.debugSqlLogsFlushLines = debugSqlLogsFlushLines;
    }

    public int getJobRunningLogMaxSize() {
        return this.jobRunningLogMaxSize;
    }

    public void setJobRunningLogMaxSize(int jobRunningLogMaxSize) {
        this.jobRunningLogMaxSize = jobRunningLogMaxSize;
    }

    public boolean getInlineUserNoticeCss() {
        return this.inlineUserNoticeCss;
    }

    public void setInlineUserNoticeCss(boolean inlineUserNoticeCss) {
        this.inlineUserNoticeCss = inlineUserNoticeCss;
    }

    public int getCentralizedLoggingMaxActiveLines() {
        return this.centralizedLoggingMaxActiveLines;
    }

    public void setCentralizedLoggingMaxActiveLines(int centralizedLoggingMaxActiveLines) {
        this.centralizedLoggingMaxActiveLines = centralizedLoggingMaxActiveLines;
    }

    public boolean isEnableRollingLoggingDatabases() {
        return this.enableRollingLoggingDatabases;
    }

    public void setEnableRollingLoggingDatabases(boolean enableRollingLoggingDatabases) {
        this.enableRollingLoggingDatabases = enableRollingLoggingDatabases;
    }

    public int getCentralizedLoggingSizeCheckInterval() {
        return this.centralizedLoggingSizeCheckInterval;
    }

    public void setCentralizedLoggingSizeCheckInterval(int centralizedLoggingSizeCheckInterval) {
        this.centralizedLoggingSizeCheckInterval = centralizedLoggingSizeCheckInterval;
    }

    public boolean getEnableUtilizationEndpoint() {
        return this.enableUtilizationEndpoint;
    }

    public void setEnableUtilizationEndpoint(boolean enableUtilizationEndpoint) {
        this.enableUtilizationEndpoint = enableUtilizationEndpoint;
    }

    public int getMaxScheduleRunsDisplay() {
        return this.maxScheduleRunsDisplay;
    }

    public void setMaxScheduleRunsDisplay(int maxScheduleRunsDisplay) {
        this.maxScheduleRunsDisplay = maxScheduleRunsDisplay;
    }

    public long getScheduleSystemErrorBackoff() {
        return this.scheduleSystemErrorBackoff;
    }

    public void setScheduleSystemErrorBackoff(long scheduleSystemErrorBackoff) {
        this.scheduleSystemErrorBackoff = scheduleSystemErrorBackoff;
    }

    public int getWorkflowCacheSize() {
        return this.workflowCacheSize;
    }

    public int getWorkflowCacheLifetimeSeconds() {
        return this.workflowCacheLifetimeSeconds;
    }

    public DataSourceFactory getAuditStore() {
        return this.auditStore;
    }

    public DataSourceFactory getLibraryStore() {
        return this.libraryStore;
    }

    public DataSourceFactory getClientMatterStore() {
        return this.clientMatterStore;
    }

    public DataSourceFactory getSecurityStore() {
        return this.securityStore;
    }

    public DataSourceFactory getJobsStore() {
        return this.jobsStore;
    }

    public DataSourceFactory getUserSettingsStore() {
        return this.userSettingsStore;
    }

    public DataSourceFactory getJobsArchiveStore() {
        return this.jobsArchiveStore;
    }

    public DataSourceFactory getUtilizationStore() {
        return this.utilizationStore;
    }

    public DataSourceFactory getNoticeStore() {
        return this.noticeStore;
    }

    public DataSourceFactory getLegalHoldStore() {
        return this.legalHoldStore;
    }

    public DataSourceFactory getLoggingStore() {
        return this.loggingStore;
    }

    public DataSourceFactory getSchedulerConfigurationStore() {
        return this.schedulerConfigurationStore;
    }

    public DataSourceFactory getApplicationStore() {
        return this.applicationStore;
    }

    public String[] getAllowedAuthenticationServices() {
        return this.allowedAuthenticationServices;
    }

    public void setAllowedAuthenticationServices(String[] allowedAuthenticationServices) {
        this.allowedAuthenticationServices = allowedAuthenticationServices;
    }

    public long getEphemeralApiKeysValidity() {
        return this.ephemeralApiKeysValidity;
    }

    public void setEphemeralApiKeysValidity(long ephemeralApiKeysValidity) {
        this.ephemeralApiKeysValidity = ephemeralApiKeysValidity;
    }

    public int getOidcAuthCompletionTimeout() {
        return this.oidcAuthCompletionTimeout;
    }

    public void setOidcAuthCompletionTimeout(int oidcAuthCompletionTimeout) {
        this.oidcAuthCompletionTimeout = oidcAuthCompletionTimeout;
    }

    public int getOidcAuthInitTimeout() {
        return this.oidcAuthInitTimeout;
    }

    public void setOidcAuthInitTimeout(int oidcAuthInitTimeout) {
        this.oidcAuthInitTimeout = oidcAuthInitTimeout;
    }

    public boolean getForceMicrosoftOidcUsernameFromMail() {
        return this.forceMicrosoftOidcUsernameFromMail;
    }

    public void setForceMicrosoftOidcUsernameFromMail(boolean forceMicrosoftOidcUsernameFromMail) {
        this.forceMicrosoftOidcUsernameFromMail = forceMicrosoftOidcUsernameFromMail;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public Credentials getAutomateLicenseCredentials() {
        return this.automateLicenseCredentials;
    }

    public void setAutomateLicenseCredentials(Credentials automateLicenseCredentials) {
        this.automateLicenseCredentials = automateLicenseCredentials;
    }

    public NuixLicenseSourceModel getNuixClsLicenseSource() {
        return this.nuixClsLicenseSource;
    }

    public void setNuixClsLicenseSource(NuixLicenseSourceModel nuixClsLicenseSource) {
        this.nuixClsLicenseSource = nuixClsLicenseSource;
    }

    public ResourcePoolModel getResourcePool() {
        return this.resourcePool;
    }

    public void setResourcePool(ResourcePoolModel resourcePool) {
        this.resourcePool = resourcePool;
    }

    public ExecutionProfileModel getExecutionProfile() {
        return this.executionProfile;
    }

    public void setExecutionProfile(ExecutionProfileModel executionProfile) {
        this.executionProfile = executionProfile;
    }

    public boolean getUtilizationErrorsSoftFail() {
        return this.utilizationErrorsSoftFail;
    }

    public void setUtilizationErrorsSoftFail(boolean utilizationErrorsSoftFail) {
        this.utilizationErrorsSoftFail = utilizationErrorsSoftFail;
    }

    public long getUserServiceWorkerBootDelay() {
        return this.userServiceWorkerBootDelay;
    }

    public void setUserServiceWorkerBootDelay(long userServiceWorkerBootDelay) {
        this.userServiceWorkerBootDelay = userServiceWorkerBootDelay;
    }

    public int getMockOptionsCount() {
        return this.mockOptionsCount;
    }

    public void setMockOptionsCount(int mockOptionsCount) {
        this.mockOptionsCount = mockOptionsCount;
    }

    public boolean getReturnUsersFromRelatedLegalHolds() {
        return this.returnUsersFromRelatedLegalHolds;
    }

    public void setReturnUsersFromRelatedLegalHolds(boolean returnUsersFromRelatedLegalHolds) {
        this.returnUsersFromRelatedLegalHolds = returnUsersFromRelatedLegalHolds;
    }

    public DerbyControlService getDerbyControlServiceConfiguration() {
        return this.derbyControlServiceConfiguration;
    }

    public void setDerbyControlServiceConfiguration(DerbyControlService derbyControlServiceConfiguration) {
        this.derbyControlServiceConfiguration = derbyControlServiceConfiguration;
    }

    public long getRegexTimeout() {
        return this.regexTimeout;
    }

    public void setRegexTimeout(long regexTimeout) {
        this.regexTimeout = regexTimeout;
    }

    public String getInitWorkflowLibraries() {
        return this.initWorkflowLibraries;
    }

    public void setInitWorkflowLibraries(String initWorkflowLibraries) {
        this.initWorkflowLibraries = initWorkflowLibraries;
    }

    public String getEffectiveInitWorkflowLibraries() {
        if (this.initWorkflowLibraries != null) {
            return this.initWorkflowLibraries;
        }
        return this.getInstallationPath("Scheduler") + "/workflows";
    }

    public long getUserDataDirScanInterval() {
        return this.userDataDirScanInterval;
    }

    public void setUserDataDirScanInterval(long userDataDirScanInterval) {
        this.userDataDirScanInterval = userDataDirScanInterval;
    }

    public long getCentralizedLoggingDownloadTimeout() {
        return this.centralizedLoggingDownloadTimeout;
    }

    public void setCentralizedLoggingDownloadTimeout(long centralizedLoggingDownloadTimeout) {
        this.centralizedLoggingDownloadTimeout = centralizedLoggingDownloadTimeout;
    }

    public boolean isEnableCentralizedLoggingDownloadTimeout() {
        return this.enableCentralizedLoggingDownloadTimeout;
    }

    public void setEnableCentralizedLoggingDownloadTimeout(boolean enableCentralizedLoggingDownloadTimeout) {
        this.enableCentralizedLoggingDownloadTimeout = enableCentralizedLoggingDownloadTimeout;
    }

    public long getThirdPartyServiceInitializeTimeoutMs() {
        return this.thirdPartyServiceInitializeTimeoutMs;
    }

    public void setThirdPartyServiceInitializeTimeoutMs(long thirdPartyServiceInitializeTimeoutMs) {
        this.thirdPartyServiceInitializeTimeoutMs = thirdPartyServiceInitializeTimeoutMs;
    }

    public boolean isArchivedJobCleanupEnabled() {
        return this.archivedJobCleanupEnabled;
    }

    public void setArchivedJobCleanupEnabled(boolean archivedJobCleanupEnabled) {
        this.archivedJobCleanupEnabled = archivedJobCleanupEnabled;
    }

    public int getArchivedJobCleanupInterval() {
        return this.archivedJobCleanupInterval;
    }

    public void setArchivedJobCleanupInterval(int archivedJobCleanupInterval) {
        this.archivedJobCleanupInterval = archivedJobCleanupInterval;
    }

    public long getArchivedJobRetentionDays() {
        return this.archivedJobRetentionDays;
    }

    public void setArchivedJobRetentionDays(int archivedJobRetentionDays) {
        this.archivedJobRetentionDays = archivedJobRetentionDays;
    }

    public boolean isCacheDatasetFileInfos() {
        return this.cacheDatasetFileInfos;
    }

    public void setCacheDatasetFileInfos(boolean cacheDatasetFileInfos) {
        this.cacheDatasetFileInfos = cacheDatasetFileInfos;
    }

    public boolean isCacheLegalHoldParticipants() {
        return this.cacheLegalHoldParticipants;
    }

    public void setCacheLegalHoldParticipants(boolean cacheLegalHoldParticipants) {
        this.cacheLegalHoldParticipants = cacheLegalHoldParticipants;
    }

    public boolean isEnableDatabaseCallTracing() {
        return this.enableDatabaseCallTracing;
    }

    public void setEnableDatabaseCallTracing(boolean enableDatabaseCallTracing) {
        this.enableDatabaseCallTracing = enableDatabaseCallTracing;
    }

    public long getEngineErrorJobCheckInterval() {
        return this.engineErrorJobCheckInterval;
    }

    public void setEngineErrorJobCheckInterval(long engineErrorJobCheckInterval) {
        this.engineErrorJobCheckInterval = engineErrorJobCheckInterval;
    }

    public boolean isEnableEngineErrorJobWorker() {
        return this.enableEngineErrorJobWorker;
    }

    public void setEnableEngineErrorJobWorker(boolean enableEngineErrorJobWorker) {
        this.enableEngineErrorJobWorker = enableEngineErrorJobWorker;
    }

    public long getEngineErrorJobKillDelay() {
        return this.engineErrorJobKillDelay;
    }

    public void setEngineErrorJobKillDelay(long engineErrorJobKillDelay) {
        this.engineErrorJobKillDelay = engineErrorJobKillDelay;
    }

    public int getEngineErrorJobInitAbortThreshold() {
        return this.engineErrorJobInitAbortThreshold;
    }

    public void setEngineErrorJobInitAbortThreshold(int engineErrorJobInitAbortThreshold) {
        this.engineErrorJobInitAbortThreshold = engineErrorJobInitAbortThreshold;
    }

    public int getRefreshThirdPartyUserCredentialEveryNDays() {
        return this.refreshThirdPartyUserCredentialEveryNDays;
    }

    public boolean isRunScheduler() {
        return this.runScheduler;
    }

    public boolean isRunServer() {
        return this.runServer;
    }

    public long getAuthServiceRefreshInterval() {
        return this.authServiceRefreshInterval;
    }

    public boolean isDeleteCachedClsCredentials() {
        return this.deleteCachedClsCredentials;
    }

    public int getMaxRollingLoggingDatabases() {
        return this.maxRollingLoggingDatabases;
    }

    public int getSmtpServiceEmailRetryInterval() {
        Objects.requireNonNull(this);
        return 12;
    }

    public int getSmtpServiceEmailMaxAttempts() {
        Objects.requireNonNull(this);
        return 12;
    }

    public int getSmtpServiceMaxThreadCount() {
        return this.smtpServiceMaxThreadCount;
    }

    public boolean isLoggingRedirectToApplicationStore() {
        return this.loggingRedirectToApplicationStore;
    }

    public boolean isUtilizationRedirectToApplicationStore() {
        return this.utilizationRedirectToApplicationStore;
    }

    public boolean isApplicationDaoIsDefault() {
        return this.applicationDaoIsDefault;
    }

    public DataSourceFactory getUsersStore() {
        return this.usersStore;
    }

    public DataSourceFactory getApplicationInitStore() {
        return this.applicationInitStore;
    }
}

