/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance;

import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.persistance.SqlUtils;
import com.nuix.automate.scheduler.persistance.application.ApplicationDao;
import com.nuix.automate.scheduler.persistance.logging.LoggingDao;
import com.nuix.automate.scheduler.persistance.logging.LoggingDataSourceDetails;
import com.nuix.automate.scheduler.persistance.utilization.DummyUtilizationDao;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.utils.api.internal.configuration.SettingModel;
import com.nuix.automate.utils.api.internal.configuration.UserSettingLineModel;
import com.nuix.automate.utils.exceptions.VersionMismatchException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.utilization.Activity;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.Job;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.ManagedPooledDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi3.JdbiFactory;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DaoManager {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DaoManager.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration configuration;
    private Environment environment;
    private ApplicationDao applicationDao;
    private ApplicationDao applicationInitDao;
    private ApplicationDao auditDao;
    private ApplicationDao clientMatterDao;
    private ApplicationDao jobsDao;
    private ApplicationDao jobsArchiveDao;
    private ApplicationDao libraryDao;
    private ApplicationDao usersDao;
    private LoggingDao loggingDao;
    private ApplicationDao securityDao;
    private ApplicationDao userSettingsDao;
    private UtilizationDao utilizationDao;
    private UtilizationDao dummyUtilizationDao;
    private boolean initAuditLogPersistenceCreated;
    private boolean initNoticeTemplatesPersistenceCreated;
    private boolean initFileLibraryPersistenceCreated;
    private boolean initExecutionProfilePersistenceCreated;
    private boolean initSettingsPersistenceCreated;
    private boolean smtpEmailsTableCreated;
    private boolean initLibraryPersistanceCreated;
    private boolean initClientsPersistanceCreated;
    Version databaseVersion;
    private double upgradeFromVersion;

    public DaoManager(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.configuration = schedulerApplication.getConfiguration();
        this.environment = schedulerApplication.getEnvironment();
    }

    private void initializeAuditTables(ApplicationDao applicationDao) {
        try {
            applicationDao.getId("");
            this.initAuditLogPersistenceCreated = false;
        }
        catch (Exception e) {
            LOGGER.info("Creating new Audit table");
            applicationDao.createAuditLogTable();
            applicationDao.createAffectedIdIndex();
            applicationDao.createPerformedByIndex();
            applicationDao.createDateIndex();
            applicationDao.addAuditEvent(new AuditEvent(UidUtils.getRandom(), "N/A", Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.SERVICE_AUDIT_LOG_STARTED, "", "N/A"));
            this.initAuditLogPersistenceCreated = true;
        }
        this.upgradeAudit_72();
        applicationDao.addAuditEvent(new AuditEvent(UidUtils.getRandom(), "N/A", Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.SERVICE_SCHEDULER_STARTED, "", "N/A"));
        try {
            applicationDao.getWebhookEventIds();
        }
        catch (Exception e) {
            LOGGER.info("Creating new WebhookEvents table");
            applicationDao.createWebhookEventTable();
        }
    }

    private void initializeJobsTables(ApplicationDao jobsDao, boolean archive) {
        try {
            jobsDao.getJobIds();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Jobs table");
            jobsDao.createJobsTable();
            jobsDao.createStateIndex();
            jobsDao.createLastStateChangedIndex();
            jobsDao.createLibraryWorkflowIdIndex();
            jobsDao.createSubmittedByIndex();
            jobsDao.createSubmittedDateIndex();
        }
        this.upgradeJobs_72();
        try {
            jobsDao.getJobExecutionLogJobId("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new JobExecutionLog table");
            jobsDao.createJobExecutionLogTable();
            jobsDao.createJobExecutionLogJobIdIndex();
            jobsDao.createJobExecutionLogJobIdRowIdIndex();
            jobsDao.createJobExecutionLogJobIdRowIdDateIndex();
        }
        try {
            jobsDao.getOperationMimeTypeStatsJobId("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new JobOperationMimeTypeStats table");
            jobsDao.createJobOperationMimeTypeStats();
        }
        if (!archive) {
            try {
                jobsDao.getScheduleIds();
            }
            catch (StatementException e) {
                LOGGER.info("Creating new Schedules table");
                jobsDao.createSchedulesTable();
            }
            try {
                jobsDao.getScheduleRunsIds();
            }
            catch (StatementException e) {
                LOGGER.info("Creating new ScheduleRuns table");
                jobsDao.createScheduleRunsTable();
            }
        }
    }

    private void initializeSecurityTables(ApplicationDao applicationDao) {
        try {
            applicationDao.getPoliciesInfos();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new PolicyInfo table");
            applicationDao.createPolicyInfoTable();
        }
        try {
            applicationDao.getPolicyPrincipals("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new PolicyPrincipal table");
            applicationDao.createPolicyPrincipalTable();
        }
        try {
            applicationDao.getPolicyScope("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new PolicyScope table");
            applicationDao.createPolicyScopeTable();
        }
        try {
            applicationDao.getPolicyPermissions("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new PolicyPermission table");
            applicationDao.createPolicyPermissionTable();
        }
        try {
            applicationDao.getOfflineUser("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new OfflineUser table");
            applicationDao.createOfflineUsersTable();
        }
    }

    private void initializeLibraryTables(ApplicationDao applicationDao) {
        this.initLibraryPersistanceCreated = false;
        try {
            applicationDao.testLibraryTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Libraries table");
            applicationDao.createLibrariesTable();
            this.initLibraryPersistanceCreated = true;
        }
        try {
            applicationDao.testWorkflowTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Workflows table");
            applicationDao.createLibraryWorkflowsTable();
        }
        if (this.initLibraryPersistanceCreated && this.applicationInitDao != null) {
            this.applyLibraryWorkflowInitSettings(applicationDao);
        }
        try {
            applicationDao.testWorkflowHistoryTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Workflows History table");
            applicationDao.createWorkflowHistory();
        }
        this.upgradeWorkflow_72();
    }

    private void initializeClientTables(ApplicationDao applicationDao) {
        this.initClientsPersistanceCreated = false;
        try {
            applicationDao.testClientsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Clients table");
            applicationDao.createClientsTable();
            this.initClientsPersistanceCreated = true;
        }
        try {
            applicationDao.getMatterIds();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Matters table");
            applicationDao.createMattersTable();
        }
        if (this.initClientsPersistanceCreated && this.applicationInitDao != null) {
            this.applyClientMatterInitSettings(applicationDao);
        }
        try {
            applicationDao.testClientPoolsTable("");
        }
        catch (StatementException e2) {
            LOGGER.info("Creating new ClientPool table");
            applicationDao.createClientPoolsTable();
        }
        try {
            applicationDao.getClientPoolIdsWithClientId("");
        }
        catch (StatementException e2) {
            LOGGER.info("Creating new ClientPoolClient table");
            applicationDao.createClientPoolsClientsTable();
            applicationDao.createClientPoolsClientsIndex();
        }
        try {
            applicationDao.testFileInfosTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new FileInfos table");
            applicationDao.createFileInfosTable();
            applicationDao.createFileInfosDatasetIdRootFileIdIndex();
        }
        this.upgradeClients_72();
        this.upgradeMatters_72();
        this.upgradeClientPools_72();
        this.upgradeClients_82();
        this.upgradeMatters_82();
        this.upgradeClientPools_82();
    }

    private void upgradeLogs_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.loggingDao.updateLogs_72();
                LOGGER.info("Updated Logs table 72 1");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
        }
    }

    private void upgradeAudit_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.auditDao.updateAuditTable_72_1();
                LOGGER.info("Updated Audit table 72 1");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
        }
    }

    private void upgradeParameters_814() {
        if (this.databaseVersion != null && this.databaseVersion.compareTo(new Version(8, 1, "4")) <= 0) {
            try {
                this.utilizationDao.deleteAllParameters();
                LOGGER.info("Updated Parameters table 81");
            }
            catch (Exception ex2) {
                throw new RuntimeException("Cannot update Parameters table", ex2);
            }
        }
    }

    private void upgradeConfiguration_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.applicationDao.updateNuixLicenceSourcesTable_72_1();
                LOGGER.info("Updated NuixLicenseSource table 72 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateEnginesTable_72_1();
                LOGGER.info("Updated Engines table 72 1");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.applicationDao.updateEnginesTable_72_2();
                LOGGER.info("Updated Engines table 72 2");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.applicationDao.updateEnginesTable_72_3();
                LOGGER.info("Updated Engines table 72 3");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.applicationDao.getResourcePools_72_LegacyTest("invalid");
                try {
                    this.applicationDao.updateResourcePoolsTable_72_1();
                    LOGGER.info("Updated ResourcePool table 72 1");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_2();
                    LOGGER.info("Updated ResourcePool table 72 2");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_3();
                    LOGGER.info("Updated Clients table 72 3");
                }
                catch (Exception ex) {
                    LOGGER.warn("Cannot update table, " + ex.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_4();
                    LOGGER.info("Updated Clients table 72 4");
                }
                catch (Exception ex) {
                    LOGGER.warn("Cannot update table, " + ex.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_5();
                    LOGGER.info("Updated Clients table 72 5");
                }
                catch (Exception ex) {
                    LOGGER.warn("Cannot update table, " + ex.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_6();
                    LOGGER.info("Updated ResourcePool table 72 6");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_7();
                    LOGGER.info("Updated ResourcePool table 72 7");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_8();
                    LOGGER.info("Updated ResourcePool table 72 8");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_9();
                    LOGGER.info("Updated ResourcePool table 72 9");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_10();
                    LOGGER.info("Updated ResourcePool table 72 10");
                }
                catch (Exception ex) {
                    LOGGER.warn("Cannot update table, " + ex.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_12();
                    LOGGER.info("Updated ResourcePool table 72 12");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_13();
                    LOGGER.info("Updated ResourcePool table 72 13");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_14();
                    LOGGER.info("Updated ResourcePool table 72 14");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_15();
                    LOGGER.info("Updated ResourcePool table 72 15");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_16();
                    LOGGER.info("Updated ResourcePool table 72 16");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_17();
                    LOGGER.info("Updated ResourcePool table 72 17");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_18a();
                    LOGGER.info("Updated ResourcePool table 72 18a");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_18b();
                    LOGGER.info("Updated ResourcePool table 72 18b");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_19a();
                    LOGGER.info("Updated ResourcePool table 72 19a");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_19b();
                    LOGGER.info("Updated ResourcePool table 72 19b");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_20();
                    LOGGER.info("Updated ResourcePool table 72 20");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_21();
                    LOGGER.info("Updated ResourcePool table 72 21");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                try {
                    this.applicationDao.updateResourcePoolsTable_72_22();
                    LOGGER.info("Updated ResourcePool table 72 22");
                }
                catch (Exception ex2) {
                    LOGGER.warn("Cannot update table, " + ex2.getMessage());
                }
                LOGGER.info("Migrating Resource Pools from V1");
                List<ResourcePoolModel> resourcePools = this.applicationDao.getResourcePools_72_Legacy();
                LOGGER.info("Migrating " + resourcePools.size() + " Resource Pools from V1");
                this.applicationDao.dropResourcePoolsTable();
                LOGGER.info("Creating V2 Resource Pools table");
                this.applicationDao.createResourcePoolsTable();
                LOGGER.info("Adding V1 Resource Pools");
                for (ResourcePoolModel resourcePoolModel : resourcePools) {
                    try {
                        this.applicationDao.addResourcePool(resourcePoolModel);
                    }
                    catch (StatementException e) {
                        LOGGER.error("Cannot migrate Resource Pool", (Throwable)e);
                        LOGGER.info(SerializationUtils.toJson((Object)resourcePoolModel));
                    }
                }
            }
            catch (Exception resourcePools) {
                // empty catch block
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_1();
                LOGGER.info("Updated ExecutionProfile table 72 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_2();
                LOGGER.info("Updated ExecutionProfile table 72 2");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_3();
                LOGGER.info("Updated ExecutionProfile table 72 3");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_4();
                LOGGER.info("Updated ExecutionProfile table 72 4");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_5();
                LOGGER.info("Updated ExecutionProfile table 72 5");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_6();
                LOGGER.info("Updated ExecutionProfile table 72 6");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_7();
                LOGGER.info("Updated ExecutionProfile table 72 7");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateExecutionProfileTable_72_8();
                LOGGER.info("Updated ExecutionProfile table 72 8");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateAutomateSessionTable_72_1();
                LOGGER.info("Updated RampivaSession table 72 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.updateAutomateUtilizationTable_72_1();
                LOGGER.info("Updated AutomateUtilization table 72 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeConfiguration_74() {
        if (this.upgradeFromVersion < 7.04) {
            try {
                this.applicationDao.updateExecutionProfileTable_74_1();
                LOGGER.info("Updated ExecutionProfile table 74 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeConfiguration_82() {
        if (this.upgradeFromVersion < 8.02) {
            try {
                this.applicationDao.updateResourcePools_82_1();
                LOGGER.info("Updated ResourcePools table 82 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeConfiguration_84() {
        if (!this.smtpEmailsTableCreated && this.upgradeFromVersion < 8.04) {
            try {
                this.applicationDao.updateSmtpEmails_84_1();
                LOGGER.info("Updated SmtpEmails table 84 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.applicationDao.createSmtpEmailsSmtpServerIdInitiatorIdIndex();
                LOGGER.info("Created SmtpEmails smtpServerIdInitiatorId index 84 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot create index, " + ex.getMessage());
            }
        }
    }

    private void upgradeConfiguration_90() {
        try {
            this.applicationDao.updateExecutionProfileTable_90_1();
            LOGGER.info("Updated ExecutionProfile table 90 1");
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot update table, " + ex.getMessage());
        }
        try {
            this.applicationDao.updateExecutionProfileTable_90_2();
            LOGGER.info("Updated ExecutionProfile table 90 2");
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot update table, " + ex.getMessage());
        }
    }

    private void upgradeJobs_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.jobsDao.updateJobsTable_72_1();
                LOGGER.info("Updated Jobs table 72 1");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.jobsDao.updateJobsTable_72_2();
                LOGGER.info("Updated Jobs table 72 2");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
        }
    }

    private void upgradeClients_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.clientMatterDao.updateClients_72_1();
                LOGGER.info("Updated Clients table 72 1");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.clientMatterDao.updateClients_72_2();
                LOGGER.info("Updated Clients table 72 2");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.clientMatterDao.updateClients_72_3();
                LOGGER.info("Updated Clients table 72 3");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.clientMatterDao.updateClients_72_4();
                LOGGER.info("Updated Clients table 72 4");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.clientMatterDao.updateClients_72_5();
                LOGGER.info("Updated Clients table 72 5");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeClients_82() {
        if (this.upgradeFromVersion < 8.02) {
            try {
                this.clientMatterDao.updateClients_82_1();
                LOGGER.info("Updated Clients table 82 1");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
        }
    }

    private void upgradeMatters_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.clientMatterDao.updateMatters_72_1();
                LOGGER.info("Updated Matters table 72 1");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.clientMatterDao.updateMatters_72_2();
                LOGGER.info("Updated Matters table 72 2");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.clientMatterDao.updateMatters_72_3();
                LOGGER.info("Updated Matters table 72 3");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.clientMatterDao.updateMatters_72_4();
                LOGGER.info("Updated Matters table 72 4");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
            try {
                this.clientMatterDao.updateMatters_72_5();
                LOGGER.info("Updated Matters table 72 5");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.clientMatterDao.updateMatters_72_6();
                LOGGER.info("Updated Matters table 72 6");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.clientMatterDao.updateMatters_72_7();
                LOGGER.info("Updated Matters table 72 7");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeMatters_82() {
        if (this.upgradeFromVersion < 8.02) {
            try {
                this.clientMatterDao.updateMatters_82_1();
                LOGGER.info("Updated Matters table 82 1");
            }
            catch (Exception ex2) {
                LOGGER.warn("Cannot update table, " + ex2.getMessage());
            }
        }
    }

    private void upgradeClientPools_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.clientMatterDao.updateClientPools_72_1();
                LOGGER.info("Updated ClientPools table 72 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.clientMatterDao.updateClientPools_72_2();
                LOGGER.info("Updated ClientPools table 72 2");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeClientPools_82() {
        if (this.upgradeFromVersion < 8.02) {
            try {
                this.clientMatterDao.updateClientPools_82_1();
                LOGGER.info("Updated ClientPools table 82 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeWorkflow_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.libraryDao.updateWorkflow_72_1();
                LOGGER.info("Updated Workflow table 72 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
            try {
                this.libraryDao.updateWorkflow_72_2();
                LOGGER.info("Updated Workflow table 72 2");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void applyLibraryWorkflowInitSettings(ApplicationDao applicationDao) {
        LOGGER.info("Applying initLibraries");
        List<WorkflowLibrary> initLibraries = this.applicationInitDao.getLibraries();
        LOGGER.info("Read " + initLibraries.size() + " records");
        applicationDao.addLibraries(initLibraries);
        LOGGER.info("Applying initWorkflows");
        List<Workflow> initWorkflows = this.applicationInitDao.getWorkflows();
        LOGGER.info("Read " + initWorkflows.size() + " records");
        applicationDao.addLibraryWorkflows(initWorkflows);
    }

    private void applyClientMatterInitSettings(ApplicationDao applicationDao) {
        LOGGER.info("Applying initClients");
        List<Client> initClients = this.applicationInitDao.getClients();
        LOGGER.info("Read " + initClients.size() + " records");
        applicationDao.addClients(initClients);
        LOGGER.info("Applying initMatters");
        List<Matter> initMatters = this.applicationInitDao.getMatters();
        LOGGER.info("Read " + initMatters.size() + " records");
        applicationDao.addMatters(initMatters);
    }

    private void applyUserSettingsInitSettings(ApplicationDao applicationDao) {
        LOGGER.info("Applying initUserSettings");
        List<UserSettingLineModel> initUserSettings = this.applicationInitDao.getUsersSettings();
        LOGGER.info("Read " + initUserSettings.size() + " records");
        applicationDao.addUserSettings(initUserSettings);
    }

    private void applyConfigurationInitSettings(ApplicationDao applicationDao) {
        LOGGER.info("Applying initSettings");
        List<SettingModel> initSettings = this.applicationInitDao.getUserSettings();
        LOGGER.info("Read " + initSettings.size() + " records");
        applicationDao.addSettings(initSettings);
        LOGGER.info("Applying initExecutionProfiles");
        List<ExecutionProfileModel> initExecutionProfiles = this.applicationInitDao.getExecutionProfilesNoSchedulerUrl();
        LOGGER.info("Read " + initExecutionProfiles.size() + " records");
        applicationDao.addExecutionProfiles(initExecutionProfiles);
        if (initExecutionProfiles.size() > 0) {
            this.initExecutionProfilePersistenceCreated = false;
        }
        LOGGER.info("Applying initResourcePools");
        List<ResourcePoolModel> initResourcePools = this.applicationInitDao.getResourcePools();
        LOGGER.info("Read " + initResourcePools.size() + " records");
        applicationDao.addResourcePools(initResourcePools);
        for (ResourcePoolModel initResourcePool : initResourcePools) {
            Set<String> engineIds = this.applicationInitDao.getEnginesIdsWithResourcePoolId(initResourcePool.getId());
            LOGGER.info("Read " + engineIds.size() + " engine records");
            for (String engineId : engineIds) {
                if (engineId == null) continue;
                applicationDao.addResourcePoolIdEngineId(initResourcePool.getId(), engineId);
            }
        }
        LOGGER.info("Applying initResourcePools");
        List<Server> initServers = this.applicationInitDao.getServers();
        LOGGER.info("Read " + initServers.size() + " records");
        applicationDao.addServers(initServers);
    }

    private void initializeConfigurationTables(ApplicationDao applicationDao) throws VersionMismatchException {
        this.initSettingsPersistenceCreated = false;
        try {
            applicationDao.getUserSettings();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Settings table");
            applicationDao.createSettingsTable();
            String databaseVersionString = VersionResources.getVersion();
            this.databaseVersion = new Version(databaseVersionString);
            this.schedulerApplication.getSettingsResource().setDatabaseVersion(VersionResources.getVersion());
            this.initSettingsPersistenceCreated = true;
            this.upgradeFromVersion = Double.POSITIVE_INFINITY;
            LOGGER.info("Setting upgrade version " + this.upgradeFromVersion + " due to database being created");
        }
        if (!this.initSettingsPersistenceCreated) {
            String databaseVersionString = null;
            try {
                databaseVersionString = this.schedulerApplication.getSettingsResource().getDatabaseVersion();
                LOGGER.info("Database version is " + databaseVersionString);
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot get database version");
            }
            if (databaseVersionString == null) {
                databaseVersionString = "1.0.0";
                LOGGER.info("Implying default database version " + databaseVersionString);
            }
            this.databaseVersion = new Version(databaseVersionString);
            Version automateVersion = new Version(VersionResources.getVersion());
            this.upgradeFromVersion = (double)this.databaseVersion.getMajor() + (double)this.databaseVersion.getMinor() / 100.0;
            LOGGER.info("Setting upgrade version " + this.upgradeFromVersion + " from database version " + String.valueOf(this.databaseVersion));
            if (this.databaseVersion.getMajor() != 0 && !this.databaseVersion.getRevision().equals("default") && this.databaseVersion.getMajor() < 6) {
                String automateVersionString = automateVersion.getMajor() + "." + automateVersion.getMinor() + "." + automateVersion.getRevision();
                InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
                throw new VersionMismatchException(iu.getFormattedString("Product.DatabaseVersionTooOld.Error", new Object[]{databaseVersionString, "7.2.0", automateVersionString}));
            }
            if (automateVersion.getMajor() != 0 && !automateVersion.getRevision().equals("default") && (this.databaseVersion.getMajor() > automateVersion.getMajor() || this.databaseVersion.getMajor() == automateVersion.getMajor() && this.databaseVersion.getMinor() > automateVersion.getMinor())) {
                String databaseMajorMinorVersion = this.databaseVersion.getMajor() + "." + this.databaseVersion.getMinor();
                InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
                throw new VersionMismatchException(iu.getFormattedString("Product.DatabaseVersionTooNew.Error", new Object[]{databaseVersionString, databaseMajorMinorVersion + ".x"}));
            }
        }
        try {
            applicationDao.getIds();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Services table");
            applicationDao.createServicesTable();
        }
        try {
            applicationDao.testServersTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Servers table");
            applicationDao.createServersTable();
        }
        try {
            applicationDao.testResourcePoolTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ResourcePools table");
            applicationDao.createResourcePoolsTable();
        }
        try {
            applicationDao.getEnginesIdsWithResourcePoolId("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ResourcePoolsEngines table");
            applicationDao.createResourcePoolsEnginesTable();
            applicationDao.createResourcePoolsEnginesEngineIdIndex();
        }
        try {
            applicationDao.getRemoteEnginesIdsWithResourcePoolId("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ResourcePoolsRemoteEngines table");
            applicationDao.createResourcePoolsRemoteEnginesTable();
            applicationDao.createResourcePoolsRemoteEnginesEngineIdIndex();
        }
        try {
            applicationDao.testNuixLicenceSourceTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NuixLicenceSource table");
            applicationDao.createNuixLicenceSourcesTable();
        }
        this.initFileLibraryPersistenceCreated = false;
        try {
            applicationDao.testFileLibrariesTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new FileLibraries table");
            applicationDao.createFileLibraryTable();
            applicationDao.createFileLibraryIdIndex();
            this.initFileLibraryPersistenceCreated = true;
        }
        try {
            applicationDao.testFileLibraryFilesTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new FileLibrariesFiles table");
            applicationDao.createFileLibraryFilesTable();
            applicationDao.createLibraryFileIdIndex();
            applicationDao.createLibraryFileLibraryIdIndex();
        }
        this.initExecutionProfilePersistenceCreated = false;
        try {
            applicationDao.testExecutionProfileTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ExecutionProfiles table");
            applicationDao.createExecutionProfilesTable();
            this.initExecutionProfilePersistenceCreated = true;
        }
        try {
            applicationDao.testNotificationRulesTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NotificationRules table");
            applicationDao.createNotificationRulesTable();
        }
        try {
            applicationDao.testUserDataDirTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new UserDataDir table");
            applicationDao.createUserDataDirTable();
        }
        try {
            applicationDao.testNetworkConfigurationTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NetworkConfiguration table");
            applicationDao.createNetworkConfigurationTable();
        }
        try {
            applicationDao.testRampivaLicenceTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new RampivaLicence table");
            applicationDao.createRampivaLicenceTable();
        }
        try {
            applicationDao.testRampivaSessionEventsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new RampivaSession table");
            applicationDao.createAutomateSessionTable();
            applicationDao.createRampivaSessionTableTimestampIndex();
        }
        try {
            applicationDao.testAutomateUtilizationRecordTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new AutomateUtilization table");
            applicationDao.createAutomateUtilizationTable();
            applicationDao.createAutomateUtilizationTableTimestampIndex();
        }
        try {
            applicationDao.testAutomateConsumptionRecordTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new AutomateCache table");
            applicationDao.createAutomateConsumptionTable();
        }
        try {
            applicationDao.testDataRepositoriesTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new DataRepositories table");
            applicationDao.createDataRepositoriesTable();
        }
        try {
            applicationDao.testDatasetTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Datasets table");
            applicationDao.createDatasetsTable();
            applicationDao.createDatasetsMatterIdIndex();
        }
        try {
            applicationDao.testUserServicesTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new UserServices table");
            applicationDao.createUserServicesTable();
        }
        try {
            applicationDao.testSmtpEmailsTable("");
            this.smtpEmailsTableCreated = false;
        }
        catch (StatementException e) {
            LOGGER.info("Creating new SmtpEmails table");
            applicationDao.createSmtpEmailTable();
            applicationDao.createSmtpEmailsSmtpServerIdInitiatorIdIndex();
            this.smtpEmailsTableCreated = true;
        }
        try {
            applicationDao.testLocksTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Lock table");
            applicationDao.createLockTable();
        }
        try {
            applicationDao.testApiKeysTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ApiKeys table");
            applicationDao.createApiKeyTable();
        }
        try {
            applicationDao.testWebhookRegistrationsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new WebhookRegistrations table");
            applicationDao.createWebhookRegistrationTable();
        }
        try {
            applicationDao.testNoticeTemplatesTable("");
            this.initNoticeTemplatesPersistenceCreated = false;
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NoticeTemplates table");
            applicationDao.createNoticeTemplatesTable();
            this.initNoticeTemplatesPersistenceCreated = true;
        }
        try {
            applicationDao.testNoticesTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Notices table");
            applicationDao.createNoticesTable();
            applicationDao.createNoticesLegalHoldIdIndex();
        }
        try {
            applicationDao.testNoticeEventsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NoticeEvents table");
            applicationDao.createNoticeEventsTable();
            applicationDao.createNoticeEventsNoticeIdUserIdIndex();
            applicationDao.createNoticeEventsUserIdIndex();
        }
        try {
            applicationDao.testNoticeCommentsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NoticeComments table");
            applicationDao.createNoticeCommentsTable();
            applicationDao.createNoticeCommentsNoticeEventIdIndex();
        }
        try {
            applicationDao.testLegalHoldsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new LegalHolds table");
            applicationDao.createLegalHoldsTable();
        }
        try {
            applicationDao.testLegalHoldParticipationsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new LegalHoldParticipations table");
            applicationDao.createLegalHoldParticipationsTable();
            applicationDao.createLegalHoldParticipationsLegalHoldIdRoleIndex();
            applicationDao.createLegalHoldParticipationsUserIdRoleIndex();
        }
        try {
            applicationDao.testCollectionEventsTable("");
            LOGGER.info("Dropping CollectionEvents table");
            applicationDao.dropCollectionEventsTable();
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            applicationDao.testTriggerConfigurationEvents("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Legal Hold Trigger Job Events table");
            applicationDao.createTriggerConfigurationEventsTable();
            applicationDao.createTriggerConfigurationEventIdIndex();
            applicationDao.createTriggerConfigurationEventLegalHoldIdIndex();
            applicationDao.createTriggerConfigurationEventTriggerConfigurationIdIndex();
        }
        try {
            applicationDao.testUserCommentsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new UserComments table");
            applicationDao.createUserCommentsTable();
            applicationDao.createUserCommentsObjectIdIndex();
        }
        try {
            applicationDao.testThirdPartyServicesTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ThirdPartyServices table");
            applicationDao.createThirdPartyServicesTable();
        }
        try {
            applicationDao.testThirdPartyUserCredentialsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ThirdPartyUserCredentials table");
            applicationDao.createThirdPartyUserCredentialsTable();
            applicationDao.createThirdPartyUserCredentialsServiceIdUserIdIndex();
        }
        if (this.initSettingsPersistenceCreated && this.applicationInitDao != null) {
            this.applyConfigurationInitSettings(applicationDao);
        }
    }

    private void initializeUsersTables(ApplicationDao usersDao, ApplicationDao applicationDao) {
        try {
            usersDao.testUsersTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Users table");
            usersDao.createUsersTable();
            usersDao.createUserUserServiceIdIndex();
        }
        try {
            usersDao.testComputersTable("");
            LOGGER.info("Dropping computers table");
            usersDao.dropComputersTable();
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            usersDao.testUserServiceObjectsTable("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new UserServiceObjects table");
            usersDao.createUserServiceObjectsTable();
            usersDao.createUserServiceObjectUserServiceIdTypeIndex();
        }
    }

    private void upgradeUsersComputers_72() {
        if (this.upgradeFromVersion <= 7.02) {
            try {
                this.usersDao.updateUsersTable_72_1();
                LOGGER.info("Updated Users table 72 1");
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot update table, " + ex.getMessage());
            }
        }
    }

    private void upgradeUsers_815() {
        if (this.databaseVersion != null && this.databaseVersion.compareTo(new Version(8, 1, "5")) <= 0) {
            try {
                if (this.applicationDao != this.usersDao) {
                    boolean applicationsTableExists = false;
                    try {
                        this.applicationDao.testUsersTable("");
                        applicationsTableExists = true;
                    }
                    catch (StatementException statementException) {
                        // empty catch block
                    }
                    if (applicationsTableExists) {
                        List<UserAccount> existingUsers = this.applicationDao.getUsers();
                        this.usersDao.addOrUpdateUsers(existingUsers);
                    }
                }
                LOGGER.info("Migrated users table 81");
            }
            catch (Exception ex2) {
                throw new RuntimeException("Cannot migrate Users table", ex2);
            }
        }
    }

    private void initializeUserSettingsTables(ApplicationDao applicationDao) {
        try {
            applicationDao.getUserSettings("");
        }
        catch (StatementException e) {
            LOGGER.info("Creating new UserSettings table");
            applicationDao.createUserSettingsTable();
        }
        if (this.initSettingsPersistenceCreated && this.applicationInitDao != null) {
            this.applyUserSettingsInitSettings(applicationDao);
        }
    }

    public void initializeApplicationDaos() throws VersionMismatchException {
        JdbiFactory factory = new JdbiFactory();
        DataSourceFactory applicationInitStore = this.configuration.getEffectiveApplicationInitStore();
        if (applicationInitStore != null) {
            Jdbi jdbiApplicationInit = factory.build(this.environment, (PooledDataSourceFactory)applicationInitStore, "applicationInitStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiApplicationInit);
            SqlUtils.getInstance().buildCallTracing(jdbiApplicationInit);
            LOGGER.info("Initializing Application Init store " + applicationInitStore.getUrl());
            this.applicationInitDao = (ApplicationDao)jdbiApplicationInit.onDemand(ApplicationDao.class);
        }
        DataSourceFactory applicationConfigurationStore = this.configuration.getEffectiveSchedulerConfigurationStore();
        Jdbi jdbiApplication = factory.build(this.environment, (PooledDataSourceFactory)applicationConfigurationStore, "applicationStore");
        SqlUtils.getInstance().buildSqlLocator(jdbiApplication);
        SqlUtils.getInstance().buildCallTracing(jdbiApplication);
        LOGGER.info("Initializing Application store " + applicationConfigurationStore.getUrl());
        this.applicationDao = (ApplicationDao)jdbiApplication.onDemand(ApplicationDao.class);
        this.initializeConfigurationTables(this.applicationDao);
        this.upgradeConfiguration_72();
        this.upgradeConfiguration_74();
        this.upgradeConfiguration_82();
        this.upgradeConfiguration_84();
        this.upgradeConfiguration_90();
        DataSourceFactory usersStore = this.configuration.getEffectiveUsersStore();
        if (usersStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using Users store unified with Application store");
            this.usersDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing Users store " + usersStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)usersStore, "usersStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.usersDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeUsersTables(this.usersDao, this.applicationDao);
        this.upgradeUsersComputers_72();
        this.upgradeUsers_815();
        DataSourceFactory jobsStore = this.configuration.getEffectiveJobsStore();
        if (jobsStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using Jobs store unified with Application store");
            this.jobsDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing Jobs store " + jobsStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)jobsStore, "jobsStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.jobsDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeJobsTables(this.jobsDao, false);
        DataSourceFactory jobsArchiveStore = this.configuration.getEffectiveJobsArchiveStore();
        if (jobsArchiveStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using JobsArchive store unified with Application store");
            this.jobsArchiveDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing JobsArchive store " + jobsArchiveStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)jobsArchiveStore, "jobsArchiveStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.jobsArchiveDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeJobsTables(this.jobsArchiveDao, true);
        DataSourceFactory userSettingsStore = this.configuration.getEffectiveUserSettingsStore();
        if (userSettingsStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using Audit store unified with UserSettings store");
            this.userSettingsDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing UserSettings store " + userSettingsStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)userSettingsStore, "userSettingsStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.userSettingsDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeUserSettingsTables(this.userSettingsDao);
        DataSourceFactory auditStore = this.configuration.getEffectiveAuditStore();
        if (auditStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using Audit store unified with Application store");
            this.auditDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing Audit store " + auditStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)auditStore, "auditStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.auditDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeAuditTables(this.auditDao);
        DataSourceFactory securityStore = this.configuration.getEffectiveSecurityStore();
        if (securityStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using Security store unified with Application store");
            this.securityDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing Security store " + securityStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)securityStore, "securityStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.securityDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeSecurityTables(this.securityDao);
        DataSourceFactory libraryStore = this.configuration.getEffectiveLibraryStore();
        if (libraryStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using Library store unified with Application store");
            this.libraryDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing Library store " + libraryStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)libraryStore, "libraryStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.libraryDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeLibraryTables(this.libraryDao);
        DataSourceFactory clientStore = this.configuration.getEffectiveClientMatterStore();
        if (clientStore.getUrl().equals(applicationConfigurationStore.getUrl())) {
            LOGGER.info("Using Client store unified with Application store");
            this.clientMatterDao = this.applicationDao;
        } else {
            LOGGER.info("Initializing Client store " + clientStore.getUrl());
            Jdbi jdbiStandalone = factory.build(this.environment, (PooledDataSourceFactory)clientStore, "clientStore");
            SqlUtils.getInstance().buildSqlLocator(jdbiStandalone);
            SqlUtils.getInstance().buildCallTracing(jdbiStandalone);
            this.clientMatterDao = (ApplicationDao)jdbiStandalone.onDemand(ApplicationDao.class);
        }
        this.initializeClientTables(this.clientMatterDao);
        this.updateDabaseVersion();
    }

    private void updateDabaseVersion() {
        Version automateVersion = new Version(VersionResources.getVersion());
        if (automateVersion.compareTo(this.databaseVersion) > 0) {
            LOGGER.info("Tracking updated database version " + String.valueOf(automateVersion));
            this.schedulerApplication.getSettingsResource().setDatabaseVersion(automateVersion.toString());
        } else {
            LOGGER.info("Running Automate " + String.valueOf(automateVersion) + " on same database version " + String.valueOf(this.databaseVersion));
        }
    }

    public LoggingDataSourceDetails initializeLoggingDao(DataSourceFactory loggingStore, String name, boolean activeDao) throws SQLException {
        ManagedPooledDataSource managedDataSource = (ManagedPooledDataSource)loggingStore.build(this.environment.metrics(), name);
        Jdbi jdbiLogging = Jdbi.create((DataSource)managedDataSource);
        jdbiLogging.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        SqlUtils.getInstance().buildSqlLocator(jdbiLogging);
        LOGGER.info("Initializing Logging store " + loggingStore.getUrl());
        LoggingDao loggingDao = (LoggingDao)jdbiLogging.onDemand(LoggingDao.class);
        loggingDao.checkConnection();
        try {
            loggingDao.checkLogsTable();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Logging table");
            loggingDao.createLogsTable();
            loggingDao.createLogIdDateIndex();
            loggingDao.createLogDateIndex();
            loggingDao.createLogIdComponentIndex();
        }
        this.upgradeLogs_72();
        try {
            loggingDao.getComponentHistoryIds();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ComponentHistory table");
            loggingDao.createComponentHistoryTable();
            loggingDao.createComponentHistoryIdIndex();
            loggingDao.createComponentHistoryIdTypeIndex();
            loggingDao.createComponentHistoryIdVersionIndex();
        }
        try {
            loggingDao.getJobHistoryIds();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new JobHistory table");
            loggingDao.createJobHistoryTable();
            loggingDao.createJobHistoryIdIndex();
        }
        if (activeDao) {
            this.loggingDao = loggingDao;
        }
        return new LoggingDataSourceDetails(managedDataSource, loggingDao);
    }

    public void initializeUtilizationDaos() {
        JdbiFactory factory = new JdbiFactory();
        DataSourceFactory utilizationStore = this.configuration.getEffectiveUtilizationStore();
        Jdbi jdbiUtilization = factory.build(this.environment, (PooledDataSourceFactory)utilizationStore, "utilizationStore");
        SqlUtils.getInstance().buildSqlLocator(jdbiUtilization);
        SqlUtils.getInstance().buildCallTracing(jdbiUtilization);
        LOGGER.info("Initializing Utilization store " + utilizationStore.getUrl());
        this.utilizationDao = (UtilizationDao)jdbiUtilization.onDemand(UtilizationDao.class);
        this.dummyUtilizationDao = new DummyUtilizationDao();
        this.utilizationDao.checkConnection();
        try {
            this.utilizationDao.testConsumption();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Consumptions table");
            this.utilizationDao.createConsumptionTable();
        }
        try {
            this.utilizationDao.getFirstOrganizationId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Organization table");
            this.utilizationDao.createOrganizationTable();
        }
        try {
            this.utilizationDao.getFirstLicenseId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new License table");
            this.utilizationDao.createLicenseTable();
        }
        try {
            this.utilizationDao.getFirstClientId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Client table");
            this.utilizationDao.createClientTable();
        }
        try {
            this.utilizationDao.getFirstUserName();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new User table");
            this.utilizationDao.createUserTable();
        }
        try {
            this.utilizationDao.getFirstDataSetId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new DataSet table");
            this.utilizationDao.createDataSetTable();
        }
        try {
            this.utilizationDao.updateDataSetTable1();
            LOGGER.info("Updated DataSet table schema 1");
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            this.utilizationDao.getFirstTransferId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Transfer table");
            this.utilizationDao.createTransferTable();
        }
        try {
            this.utilizationDao.updateTransferTable1();
            LOGGER.info("Updated Transfer table schema 1");
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            this.utilizationDao.getFirstTransferVolumeId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new TransferVolume table");
            this.utilizationDao.createTransferVolumeTable();
        }
        try {
            this.utilizationDao.getFirstDataRepositoryId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new DataRepository table");
            this.utilizationDao.createDataRepositoryTable();
        }
        try {
            this.utilizationDao.getFirstEngineId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Engine table");
            this.utilizationDao.createEngineTable();
        }
        try {
            this.utilizationDao.getFirstExecutionProfileId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ExecutionProfile table");
            this.utilizationDao.createExecutionProfileTable();
        }
        try {
            this.utilizationDao.getFirstActivityUserId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Activity table");
            this.utilizationDao.createActivityTable();
        }
        try {
            this.utilizationDao.testActivityTable1();
        }
        catch (StatementException e) {
            LOGGER.info("Updating Activities table schema");
            this.utilizationDao.updateActivityTable1();
            LOGGER.info("Updated Activity table schema 1");
            this.utilizationDao.updateActivityTable2();
            LOGGER.info("Updated Activity table schema 2");
            List<Activity> activities = this.utilizationDao.getActivites();
            for (Activity activity : activities) {
                activity.setLicenseId(this.schedulerApplication.getLicenceUtils().getLicenceInfo().getId());
            }
            this.utilizationDao.renameActivityTableTo2_0();
            this.utilizationDao.createActivityTable();
            this.utilizationDao.addActivities(activities);
            LOGGER.info("Updated Activity table key");
            for (Job job : this.utilizationDao.getJobs()) {
                ActivityDetails jobSetupActivity = new ActivityDetails();
                jobSetupActivity.setStartEpoch(job.getJobSubmissionEpoch().longValue());
                jobSetupActivity.setLastEpoch(job.getJobSubmissionEpoch() + 1L);
                jobSetupActivity.setMatterId(job.getMatterId());
                jobSetupActivity.setActivityType(ActivityType.JOB_SETUP);
                jobSetupActivity.setUserId(job.getJobSubmittedByUserId());
                jobSetupActivity.setActivityKey(job.getJobId());
                this.schedulerApplication.getUserResource().trackFinishedActivity(jobSetupActivity, true);
            }
            this.utilizationDao.dropActivity2_0Table();
            LOGGER.info("Created placeholder activities for Job setup");
        }
        try {
            this.utilizationDao.getFirstJobId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Job table");
            this.utilizationDao.createJobTable();
        }
        try {
            this.utilizationDao.getFirstCollectionId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Collection table");
            this.utilizationDao.createCollectionTable();
        }
        try {
            this.utilizationDao.getFirstCollectionTargetId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new CollectionTarget table");
            this.utilizationDao.createCollectionTargetTable();
        }
        try {
            this.utilizationDao.getFirstLegalHoldId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new LegalHold table");
            this.utilizationDao.createLegalHoldTable();
        }
        try {
            this.utilizationDao.getFirstNoticeId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Notice table");
            this.utilizationDao.createNoticeTable();
        }
        try {
            this.utilizationDao.getFirstCustodianNoticeId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new CustodianNotice table");
            this.utilizationDao.createCustodianNoticeTable();
        }
        try {
            this.utilizationDao.getFirstCustodianActivityId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new CustodianActivity table");
            this.utilizationDao.createCustodianActivityTable();
        }
        try {
            this.utilizationDao.getFirstLibraryId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Library table");
            this.utilizationDao.createLibraryTable();
        }
        try {
            this.utilizationDao.getFirstMatterId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Matter table");
            this.utilizationDao.createMatterTable();
        }
        try {
            this.utilizationDao.getFirstMimeTypeId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new MimeType table");
            this.utilizationDao.createMimeTypeTable();
        }
        try {
            this.utilizationDao.getFirstMimeTypeVolumeId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new MimeTypeVolume table");
            this.utilizationDao.createMimeTypeVolumeTable();
        }
        try {
            this.utilizationDao.updateMimeTypeVolume1();
            LOGGER.info("Updated MimeTypeVolume table schema 1");
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            this.utilizationDao.getFirstOperationSettingName();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new OperationSettings table");
            this.utilizationDao.createOperationSettingTable();
        }
        try {
            this.utilizationDao.getFirstNuixCaseId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NuixCase table");
            this.utilizationDao.createNuixCaseTable();
        }
        try {
            this.utilizationDao.getFirstRelativityWorkspaceId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new RelativityWorkspace table");
            this.utilizationDao.createRelativityWorkspaceTable();
        }
        try {
            this.utilizationDao.updateNuixCaseTable1();
            LOGGER.info("Updated NuixCase table schema 1");
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            this.utilizationDao.getFirstNuixStatsCaseId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new NuixCaseStat table");
            this.utilizationDao.createNuixCaseStatsTable();
        }
        try {
            this.utilizationDao.updateNuixCaseStats1();
            LOGGER.info("Updated NuixCaseStat table schema 1");
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            this.utilizationDao.getFirstOperationId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Operation table");
            this.utilizationDao.createOperationTable();
        }
        try {
            this.utilizationDao.updateOperationsTableV1();
            LOGGER.info("Updated Operation table schema 1");
        }
        catch (StatementException e) {
            // empty catch block
        }
        try {
            this.utilizationDao.getFirstParameterId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Parameter table");
            this.utilizationDao.createParameterTable();
        }
        try {
            this.utilizationDao.getFirstResourcePoolId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new ResourcePool table");
            this.utilizationDao.createResourcePoolTable();
        }
        try {
            this.utilizationDao.getFirstServerId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Server table");
            this.utilizationDao.createServerTable();
        }
        try {
            this.utilizationDao.getFirstSessionId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Session table");
            this.utilizationDao.createSessionTable();
        }
        try {
            this.utilizationDao.testSessionsTable1();
        }
        catch (StatementException e) {
            LOGGER.info("Update Session1");
            this.utilizationDao.updateSessionsTable1();
        }
        try {
            this.utilizationDao.testSessionsTable2();
        }
        catch (StatementException e) {
            LOGGER.info("Update Session2");
            this.utilizationDao.updateSessionsTable2();
        }
        try {
            this.utilizationDao.testSessionsTable3();
        }
        catch (StatementException e) {
            LOGGER.info("Updating Session3");
            this.utilizationDao.updateSessionsTable3a();
            this.utilizationDao.updateSessionsTable3b();
            this.utilizationDao.updateSessionsTable3c();
        }
        try {
            this.utilizationDao.testSessionsTable4();
        }
        catch (StatementException e) {
            LOGGER.info("Update Session4");
            this.utilizationDao.updateSessionsTable4();
        }
        try {
            this.utilizationDao.getFirstWorkflowId();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Workflow table");
            this.utilizationDao.createWorkflowTable();
        }
        this.upgradeParameters_814();
    }

    public ApplicationDao getApplicationDao() {
        return this.applicationDao;
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.applicationDao = applicationDao;
    }

    public ApplicationDao getJobsArchiveDao() {
        return this.jobsArchiveDao;
    }

    public void setJobsArchiveDao(ApplicationDao jobsArchiveDao) {
        this.jobsArchiveDao = jobsArchiveDao;
    }

    public LoggingDao getLoggingDao() {
        return this.loggingDao;
    }

    public void setLoggingDao(LoggingDao loggingDao) {
        this.loggingDao = loggingDao;
    }

    public UtilizationDao getUtilizationDao() {
        return this.utilizationDao;
    }

    public void setUtilizationDao(UtilizationDao utilizationDao) {
        this.utilizationDao = utilizationDao;
    }

    public UtilizationDao getDummyUtilizationDao() {
        return this.dummyUtilizationDao;
    }

    public void setDummyUtilizationDao(UtilizationDao dummyUtilizationDao) {
        this.dummyUtilizationDao = dummyUtilizationDao;
    }

    public boolean getInitAuditLogPersistenceCreated() {
        return this.initAuditLogPersistenceCreated;
    }

    public boolean getInitNoticeTemplatesPersistenceCreated() {
        return this.initNoticeTemplatesPersistenceCreated;
    }

    public boolean getInitFileLibraryPersistenceCreated() {
        return this.initFileLibraryPersistenceCreated;
    }

    public boolean getInitExecutionProfilePersistenceCreated() {
        return this.initExecutionProfilePersistenceCreated;
    }

    public boolean getInitSettingsPersistenceCreated() {
        return this.initSettingsPersistenceCreated;
    }

    public ApplicationDao getAuditDao() {
        return this.auditDao;
    }

    public ApplicationDao getClientMatterDao() {
        return this.clientMatterDao;
    }

    public ApplicationDao getJobsDao() {
        return this.jobsDao;
    }

    public ApplicationDao getLibraryDao() {
        return this.libraryDao;
    }

    public ApplicationDao getSecurityDao() {
        return this.securityDao;
    }

    public ApplicationDao getUserSettingsDao() {
        return this.userSettingsDao;
    }

    public ApplicationDao getUsersDao() {
        return this.usersDao;
    }

    public boolean getInitLibraryPersistanceCreated() {
        return this.initLibraryPersistanceCreated;
    }

    public boolean getInitClientsPersistanceCreated() {
        return this.initClientsPersistanceCreated;
    }
}

