/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.internal.event.EventType;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class AuditEventMapper
implements RowMapper<AuditEvent> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AuditEventMapper.class);

    public AuditEvent map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        AuditEvent auditEvent = new AuditEvent();
        auditEvent.setId(resultSet.getString("id"));
        auditEvent.setAffectedId(resultSet.getString("affectedId"));
        auditEvent.setDate(Long.valueOf(resultSet.getLong("date")));
        auditEvent.setPerformedBy(resultSet.getString("performedBy"));
        auditEvent.setDetails(resultSet.getString("details"));
        auditEvent.setIpAddress(resultSet.getString("ipAddress"));
        String eventType = "N/A";
        try {
            eventType = resultSet.getString("eventType");
            EventType parsedEventType = EventType.fromString((String)eventType);
            auditEvent.setEventType(parsedEventType.getType());
            if (parsedEventType.getKind().equals((Object)EventType.Kind.LEGACY)) {
                auditEvent.setLegacyEventType(parsedEventType.toString());
            } else {
                auditEvent.setLegacyEventType(parsedEventType.getType().name());
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse event type " + eventType, (Throwable)e);
        }
        return auditEvent;
    }
}

