/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.workflow.StaticParameter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=ClientPoolBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindClientPool {

    public static class ClientPoolBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ClientPoolBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                ClientPool arg = (ClientPool)obj;
                LinkedHashMap<String, String> encryptedWorkflowParameters = new LinkedHashMap<String, String>();
                if (arg.getWorkflowParameters() != null) {
                    for (String parameterName : arg.getWorkflowParameters().keySet()) {
                        StaticParameter staticParameter = new StaticParameter(parameterName, "");
                        String parameterValue = (String)arg.getWorkflowParameters().get(parameterName);
                        if (staticParameter.isEffectiveTypeMaskedOrProtected()) {
                            try {
                                parameterValue = SchedulerApplication.getInstance().getEncryptor().encrypt(parameterValue);
                            }
                            catch (IOException e) {
                                LOGGER.error("Cannot encrypt parameter " + parameterName, (Throwable)e);
                            }
                        }
                        encryptedWorkflowParameters.put(parameterName, parameterValue);
                    }
                }
                q.bind("id", arg.getId());
                q.bind("name", arg.getName());
                q.bind("description", arg.getDescription());
                q.bind("allowedParameterValues", SerializationUtils.toDbJson((Object)arg.getAllowedParameterValues()));
                q.bind("requiredMetadataHeaders", SerializationUtils.toDbJson((Object)arg.getRequiredMetadataHeaders()));
                q.bind("workflowParameters", SerializationUtils.toDbJson(encryptedWorkflowParameters));
            };
        }
    }
}

