/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.workflow.StaticParameter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=ExecutionProfileBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindExecutionProfile {

    public static class ExecutionProfileBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExecutionProfileBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                ExecutionProfileModel arg = (ExecutionProfileModel)obj;
                String encryptedPassword = "";
                try {
                    encryptedPassword = SchedulerApplication.getInstance().getEncryptor().encrypt(arg.getEngineAccountPassword());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot encrypt Execution Profile password", (Throwable)e);
                }
                HashMap<String, String> encryptedWorkflowParameters = new HashMap<String, String>();
                for (String parameterName : arg.getWorkflowParameters().keySet()) {
                    StaticParameter staticParameter = new StaticParameter(parameterName, "");
                    String parameterValue = (String)arg.getWorkflowParameters().get(parameterName);
                    if (staticParameter.isEffectiveTypeMaskedOrProtected()) {
                        try {
                            parameterValue = SchedulerApplication.getInstance().getEncryptor().encrypt(parameterValue);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt parameter " + parameterName, (Throwable)e);
                        }
                    }
                    encryptedWorkflowParameters.put(parameterName, parameterValue);
                }
                q.bind("id", arg.getId());
                q.bind("name", arg.getName());
                q.bind("description", arg.getDescription());
                q.bind("engineAccountPassword", encryptedPassword);
                q.bind("engineAccountUsername", arg.getEngineAccountUsername());
                q.bind("engineCommandLineParameters", arg.getEngineCommandLineParameters());
                q.bind("workflowParameters", SerializationUtils.toDbJson(encryptedWorkflowParameters));
                q.bind("engineLogFolder", arg.getEngineLogFolder());
                q.bind("notificationRules", SerializationUtils.toDbJson((Object)arg.getNotificationRuleIds()));
                q.bind("nuixEngineFolder", arg.getNuixEngineFolder());
                q.bind("javaFolder", arg.getJavaFolder());
                q.bind("jobProgressSettings", SerializationUtils.toDbJson((Object)arg.getJobProgressSettings()));
                q.bind("jobTimeoutSettings", SerializationUtils.toDbJson((Object)arg.getJobTimeoutSettings()));
                q.bind("nuixProfiles", SerializationUtils.toDbJson((Object)arg.getNuixProfiles()));
                q.bind("additionalFiles", SerializationUtils.toDbJson((Object)arg.getAdditionalFiles()));
                q.bind("reference", arg.getReference());
                q.bind("referenceVersion", arg.getReferenceVersion());
                q.bind("schedulerUrl", arg.getSchedulerUrl());
                q.bind("workerTempFolder", arg.getWorkerTempFolder());
            };
        }
    }
}

