/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=JobDetailsBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindJobDetails {

    public static class JobDetailsBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobDetailsBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                JobDetailsModel arg = (JobDetailsModel)obj;
                arg = new JobDetailsModel(arg);
                q.bind("id", arg.getSettings().getId());
                q.bind("libraryWorkflowId", arg.getSettings().getLibraryWorkflowId());
                q.bind("priority", arg.getSettings().getPriority().toString());
                q.bind("submittedBy", arg.getSettings().getSubmittedBy());
                q.bind("submittedDate", arg.getSettings().getSubmittedDate());
                q.bind("lastStateChangedDate", arg.getSettings().getLastStateChangedDate());
                q.bind("name", arg.getSettings().getName());
                q.bind("notes", arg.getSettings().getNotes());
                q.bind("clientId", arg.getSettings().getClientId());
                q.bind("matterId", arg.getSettings().getMatterId());
                List sessionParameters = arg.getSettings().getSessionParameters();
                for (com.nuix.automate.utils.models.api.job.Parameter parameterModel : sessionParameters) {
                    if (!parameterModel.isProtected() && !parameterModel.isMasked()) continue;
                    try {
                        parameterModel.setValue(SchedulerApplication.getInstance().getEncryptor().encrypt(parameterModel.getValue()));
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot encrypt parameter " + parameterModel.getName(), (Throwable)e);
                    }
                }
                String xml = SerializationUtils.toDbJson((Object)arg);
                q.bind("xml", xml);
            };
        }
    }
}

