/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=LicenceSourceBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindNuixLicenceSource {

    public static class LicenceSourceBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LicenceSourceBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                NuixLicenseSourceModel arg = (NuixLicenseSourceModel)obj;
                q.bind("id", arg.getId());
                q.bind("name", arg.getName());
                q.bind("description", arg.getDescription());
                q.bind("sourceType", (Object)arg.getSourceType());
                q.bind("relayType", (Object)arg.getRelayType());
                q.bind("serverName", arg.getServerName());
                q.bind("serverPort", arg.getServerPort());
                q.bind("username", arg.getUsername());
                try {
                    q.bind("password", SchedulerApplication.getInstance().getEncryptor().encrypt(arg.getPassword()));
                }
                catch (IOException e) {
                    q.bind("password", "");
                }
                q.bind("filter", arg.getFilter());
                q.bind("whitelistedCertFingerprints", SerializationUtils.toDbJson((Object)arg.getWhitelistedCertFingerprints()));
            };
        }
    }
}

