/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.RelativityUserImpersonationService;
import com.nuix.automate.utils.models.internal.user.UmsUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=UserServiceBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindUserService {

    public static class UserServiceBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SqlStatementCustomizerFactory.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                String encryptedServiceAccountPassword;
                String serviceAccountPassword;
                String encryptedClientSecret;
                String clientSecret;
                UserService arg = (UserService)obj;
                q.bind("id", arg.getId());
                q.bind("userServiceType", (Object)arg.getUserServiceType());
                UserService copyConfig = arg.clone();
                copyConfig.setId(null);
                copyConfig.setUserServiceType(null);
                copyConfig.setStatus(null);
                if (copyConfig instanceof OidcUserService) {
                    OidcUserService copyOidcConfig = (OidcUserService)copyConfig;
                    clientSecret = copyOidcConfig.getClientSecret();
                    encryptedClientSecret = null;
                    if (clientSecret != null && !clientSecret.trim().equals("")) {
                        try {
                            encryptedClientSecret = SchedulerApplication.getInstance().getEncryptor().encrypt(clientSecret);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt OIDC Authentication Service clientSecret for: " + copyConfig.getName(), (Throwable)e);
                        }
                    }
                    copyOidcConfig.setClientSecret(encryptedClientSecret);
                }
                if (copyConfig instanceof RelativityUserImpersonationService) {
                    RelativityUserImpersonationService copyRelativityUserImpersonationConfig = (RelativityUserImpersonationService)copyConfig;
                    clientSecret = copyRelativityUserImpersonationConfig.getSecret();
                    encryptedClientSecret = null;
                    if (clientSecret != null && !clientSecret.trim().equals("")) {
                        try {
                            encryptedClientSecret = SchedulerApplication.getInstance().getEncryptor().encrypt(clientSecret);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt secret for: " + copyConfig.getName(), (Throwable)e);
                        }
                    }
                    copyRelativityUserImpersonationConfig.setSecret(encryptedClientSecret);
                }
                if (copyConfig instanceof MicrosoftUserService) {
                    MicrosoftUserService copyMicrosoftConfig = (MicrosoftUserService)copyConfig;
                    String refreshToken = copyMicrosoftConfig.getRefreshToken();
                    String encryptedRefreshToken = null;
                    if (refreshToken != null && !refreshToken.trim().equals("")) {
                        try {
                            encryptedRefreshToken = SchedulerApplication.getInstance().getEncryptor().encrypt(refreshToken);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt Microsoft Authentication Service refreshToken for: " + copyConfig.getName(), (Throwable)e);
                        }
                    }
                    copyMicrosoftConfig.setRefreshToken(encryptedRefreshToken);
                }
                if (copyConfig instanceof UmsUserService) {
                    UmsUserService copyUmsUserService = (UmsUserService)copyConfig;
                    serviceAccountPassword = copyUmsUserService.getServiceAccountPassword();
                    encryptedServiceAccountPassword = null;
                    if (serviceAccountPassword != null && !serviceAccountPassword.trim().equals("")) {
                        try {
                            encryptedServiceAccountPassword = SchedulerApplication.getInstance().getEncryptor().encrypt(serviceAccountPassword);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt Authentication Service serviceAccountPassword for: " + copyConfig.getName(), (Throwable)e);
                        }
                    }
                    copyUmsUserService.setServiceAccountPassword(encryptedServiceAccountPassword);
                }
                if (copyConfig instanceof LdapUserService) {
                    LdapUserService copyLdapUserService = (LdapUserService)copyConfig;
                    serviceAccountPassword = copyLdapUserService.getServiceAccountPassword();
                    encryptedServiceAccountPassword = null;
                    if (serviceAccountPassword != null && !serviceAccountPassword.trim().equals("")) {
                        try {
                            encryptedServiceAccountPassword = SchedulerApplication.getInstance().getEncryptor().encrypt(serviceAccountPassword);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt Authentication Service serviceAccountPassword for: " + copyConfig.getName(), (Throwable)e);
                        }
                    }
                    copyLdapUserService.setServiceAccountPassword(encryptedServiceAccountPassword);
                }
                q.bind("config", SerializationUtils.toDbJson((Object)copyConfig));
            };
        }
    }
}

