/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.webhook.Webhook;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=WebhookRegistrationBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindWebhookRegistration {

    public static class WebhookRegistrationBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SqlStatementCustomizerFactory.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                Webhook arg = (Webhook)obj;
                q.bind("id", arg.getId());
                Webhook copyWebhookRegistration = arg.clone();
                copyWebhookRegistration.setId(null);
                copyWebhookRegistration.setAuditLog(null);
                String secret = copyWebhookRegistration.getSignatureKey();
                String encryptedSecret = "";
                try {
                    encryptedSecret = SchedulerApplication.getInstance().getEncryptor().encrypt(secret);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot encrypt Webhook signature key", (Throwable)e);
                }
                copyWebhookRegistration.setSignatureKey(encryptedSecret);
                q.bind("data", SerializationUtils.toDbJson((Object)copyWebhookRegistration));
            };
        }
    }
}

