/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.google.gson.JsonObject;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.application.NotificationRuleMapper;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.notificationrule.DeprecatedEmailNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.RuleType;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class DeprecatedNotificationRuleMapper
implements RowMapper<DeprecatedEmailNotificationRule> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NotificationRuleMapper.class);

    public DeprecatedEmailNotificationRule map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        try {
            String ruleText = resultSet.getString("rule");
            JsonObject ruleJson = (JsonObject)SerializationUtils.fromJson((String)ruleText, JsonObject.class);
            if (ruleJson.has("smtpServiceId")) {
                return null;
            }
            DeprecatedEmailNotificationRule deprecatedEmailRule = (DeprecatedEmailNotificationRule)SerializationUtils.fromJson((String)ruleText, DeprecatedEmailNotificationRule.class);
            String encryptedPassword = deprecatedEmailRule.getSmtpPassword();
            if (encryptedPassword != null) {
                try {
                    String decryptedPassword = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedPassword);
                    deprecatedEmailRule.setSmtpPassword(decryptedPassword);
                }
                catch (IOException e) {
                    deprecatedEmailRule.setSmtpPassword(null);
                    LOGGER.error("Cannot decrypt notification rule password", (Throwable)e);
                }
            }
            deprecatedEmailRule.setId(resultSet.getString("id"));
            deprecatedEmailRule.setRuleType(RuleType.valueOf((String)resultSet.getString("ruleType")));
            return deprecatedEmailRule;
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse notification rule " + resultSet.getString("id"), (Throwable)e);
            return null;
        }
    }
}

