/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class DeprecatedRelativityServiceMapper
implements RowMapper<ThirdPartyService> {
    public ThirdPartyService map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        JsonElement userServiceIdElement;
        JsonObject relativityServiceObject = (JsonObject)SerializationUtils.fromJson((String)resultSet.getString("relativityService"), JsonObject.class);
        relativityServiceObject.addProperty("authenticationScope", ThirdPartyAuthenticationScope.USER.name());
        JsonElement authenticationMethodElement = relativityServiceObject.get("authenticationMethod");
        if (authenticationMethodElement == null || authenticationMethodElement.getAsString().equals("OAUTH2_CLIENT")) {
            relativityServiceObject.addProperty("authenticationMethod", "OIDC_SERVICE");
        }
        if ((userServiceIdElement = relativityServiceObject.get("relativityUserServiceId")) != null) {
            relativityServiceObject.addProperty("authenticationServiceId", userServiceIdElement.getAsString());
        }
        relativityServiceObject.addProperty("type", RelativityService.class.getSimpleName());
        ThirdPartyService thirdPartyService = (ThirdPartyService)SerializationUtils.fromJson((String)relativityServiceObject.toString(), ThirdPartyService.class);
        thirdPartyService.setId(resultSet.getString("id"));
        thirdPartyService.setUserCredential(null);
        return thirdPartyService;
    }
}

