/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class DeprecatedRelativityServiceUserCredentialMapper
implements RowMapper<ThirdPartyUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DeprecatedRelativityServiceUserCredentialMapper.class);

    public ThirdPartyUserCredential map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        JsonElement tokenElement;
        JsonObject relativityCredentialObject = (JsonObject)SerializationUtils.fromJson((String)resultSet.getString("credential"), JsonObject.class);
        JsonElement passwordElement = relativityCredentialObject.get("password");
        if (passwordElement != null) {
            relativityCredentialObject.addProperty("password", this.decrypt(passwordElement.getAsString()));
        }
        if ((tokenElement = relativityCredentialObject.get("token")) != null) {
            relativityCredentialObject.addProperty("token", this.decrypt(tokenElement.getAsString()));
        }
        relativityCredentialObject.addProperty("type", RelativityUserCredential.class.getSimpleName());
        ThirdPartyUserCredential userCredential = (ThirdPartyUserCredential)SerializationUtils.fromJson((String)relativityCredentialObject.toString(), ThirdPartyUserCredential.class);
        userCredential.setThirdPartyServiceId(resultSet.getString("relativityServiceId"));
        userCredential.setAuthenticationScope(ThirdPartyAuthenticationScope.USER);
        userCredential.setUserId(resultSet.getString("userId"));
        userCredential.setStale(resultSet.getBoolean("stale"));
        return userCredential;
    }

    private String decrypt(String encryptedValue) {
        try {
            if (encryptedValue != null && !encryptedValue.trim().isEmpty()) {
                return SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedValue);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error during decryption", (Throwable)e);
        }
        return null;
    }
}

