/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.google.gson.reflect.TypeToken;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class FileInfoMapper
implements RowMapper<FileInfo> {
    public FileInfo map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        FileInfo fileInfo = (FileInfo)SerializationUtils.fromJson((String)resultSet.getString("fileInfo"), FileInfo.class);
        long addedDate = resultSet.getLong("addedDate");
        fileInfo.setAddedDate(Long.valueOf(addedDate));
        if (fileInfo.getAddedDate() == 0L) {
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map oldFileInfo = (Map)SerializationUtils.gsonWithNulls.fromJson(resultSet.getString("fileInfo"), mapType);
            if (oldFileInfo.containsKey("ownerKey")) {
                fileInfo.setAddedBy((String)oldFileInfo.get("ownerKey"));
            }
            if (oldFileInfo.containsKey("uploadFinishTime")) {
                fileInfo.setAddedDate(Long.valueOf(((Double)oldFileInfo.get("uploadFinishTime")).longValue()));
            }
        }
        String id = resultSet.getString("id");
        fileInfo.setId(id);
        String datasetId = resultSet.getString("datasetId");
        fileInfo.setDatasetId(datasetId);
        String rootFileId = resultSet.getString("rootFileId");
        if (fileInfo.getRootFileId() == null) {
            fileInfo.setRootFileId(rootFileId);
        }
        Boolean directory = resultSet.getBoolean("directory");
        if (fileInfo.getDirectory() == null) {
            fileInfo.setDirectory(directory);
        }
        return fileInfo;
    }
}

