/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.application.JobDetailsSerializerFactory;
import com.nuix.automate.scheduler.persistance.application.MapperUtils;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.StaticParameter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class JobDetailsMapper
implements RowMapper<JobDetailsModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobDetailsMapper.class);

    public JobDetailsModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        JobDetailsModel jobDetailsModel;
        String xml = resultSet.getString("xml");
        if (xml.startsWith("<?xml")) {
            try {
                jobDetailsModel = (JobDetailsModel)JobDetailsSerializerFactory.getSerializer().deserialize(MapperUtils.updateClassNames(xml));
            }
            catch (Exception e) {
                LOGGER.error("Cannot deserialize job details", (Throwable)e);
                JobDetailsModel dummyJobModel = new JobDetailsModel();
                dummyJobModel.setSettings(new JobModel());
                dummyJobModel.setOperations(new ArrayList());
                dummyJobModel.getSettings().setName("Error");
                dummyJobModel.getSettings().setExecutionState(ExecutionState.ERROR);
                dummyJobModel.getSettings().setId(resultSet.getString("id"));
                dummyJobModel.getSettings().setSubmittedBy("N/A");
                dummyJobModel.getSettings().setNotes(ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                dummyJobModel.setOperations(new LinkedList());
                return dummyJobModel;
            }
        } else {
            jobDetailsModel = (JobDetailsModel)SerializationUtils.fromJson((String)xml, JobDetailsModel.class);
        }
        List sessionParameters = jobDetailsModel.getSettings().getSessionParameters();
        for (Parameter parameterModel : sessionParameters) {
            if (parameterModel.getParameterType() == null) {
                parameterModel.setParameterType(new StaticParameter(parameterModel.getName(), "").getEffectiveParameterType());
            }
            if (!parameterModel.isProtected() && !parameterModel.isMasked()) continue;
            try {
                parameterModel.setValue(SchedulerApplication.getInstance().getEncryptor().decrypt(parameterModel.getValue()));
            }
            catch (IOException e) {
                LOGGER.error("Cannot decrypt parameter " + parameterModel.getName(), (Throwable)e);
            }
        }
        return jobDetailsModel;
    }
}

