/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.google.gson.JsonObject;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import com.nuix.automate.utils.workflow.LogLevel;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LegacyJobExecutionLogMigrationMapper
implements RowMapper<List<LogEventModel>> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LegacyJobExecutionLogMigrationMapper.class);

    public List<LogEventModel> map(ResultSet rs, StatementContext ctx) throws SQLException {
        String jobId = rs.getString("id");
        String executionLog = null;
        String xml = rs.getString("xml");
        try {
            if (xml.startsWith("<?xml")) {
                int startTag = xml.indexOf("<executionLog>");
                int endTag = xml.indexOf("</executionLog>");
                if (startTag != -1 && endTag != -1) {
                    executionLog = StringEscapeUtils.unescapeXml((String)xml.substring(startTag + 14, endTag));
                }
            } else {
                JsonObject jsonJobDetails = (JsonObject)SerializationUtils.fromJson((String)xml, JsonObject.class);
                if (jsonJobDetails.has("executionLog")) {
                    executionLog = jsonJobDetails.get("executionLog").getAsString();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot deserialize legacy job details", (Throwable)e);
        }
        ArrayList<LogEventModel> executionLogs = new ArrayList<LogEventModel>();
        if (executionLog != null) {
            String[] lines;
            for (String line : lines = executionLog.split("\r\n")) {
                LogEventModel executionLogEventModel = new LogEventModel(jobId, LogLevel.EXECUTION.name(), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis(), line.getBytes(StandardCharsets.UTF_8));
                executionLogs.add(executionLogEventModel);
            }
        }
        return executionLogs;
    }
}

