/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class LibraryWorfklowMapper
implements RowMapper<Workflow> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LibraryWorfklowMapper.class);

    public Workflow map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        Workflow model = null;
        String dataString = resultSet.getString("data");
        if (dataString != null) {
            model = (Workflow)SerializationUtils.fromJson((String)dataString, Workflow.class);
        }
        if (model == null) {
            model = new Workflow();
        }
        model.setId(resultSet.getString("id"));
        model.setName(resultSet.getString("name"));
        model.setDescription(resultSet.getString("description"));
        model.setLibraryId(resultSet.getString("libraryId"));
        model.setEnabled(Boolean.valueOf(resultSet.getBoolean("enabled")));
        try {
            model.setOperationsXml(resultSet.getString("xml"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Map parsedAllowedParameterValues = (Map)SerializationUtils.fromJson((String)resultSet.getString("allowedParameterValues"), Map.class);
        if (parsedAllowedParameterValues != null) {
            TreeMap allowedParameters = new TreeMap();
            for (String parameterName : parsedAllowedParameterValues.keySet()) {
                ArrayList allowedValues = new ArrayList();
                allowedValues.addAll((Collection)parsedAllowedParameterValues.get(parameterName));
                allowedParameters.put(parameterName, allowedValues);
            }
            model.setAllowedParameterValues(allowedParameters);
        }
        return model;
    }
}

