/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ThirdPartyServiceMapper
implements RowMapper<ThirdPartyService> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ThirdPartyServiceMapper.class);

    public ThirdPartyService map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        String serviceJson = resultSet.getString("service");
        serviceJson = serviceJson.replace("OIDC_SERVICE", "OIDC_AUTHORIZATION_CODE");
        serviceJson = serviceJson.replace("\"type\":\"MemgraphService\"", "\"type\":\"GraphService\"");
        try {
            ThirdPartyService thirdPartyService = (ThirdPartyService)SerializationUtils.fromDbJson((String)serviceJson, ThirdPartyService.class);
            thirdPartyService.setId(resultSet.getString("id"));
            thirdPartyService.setUserCredential(null);
            return thirdPartyService;
        }
        catch (Exception e) {
            LOGGER.error("Cannot deserialize service", (Throwable)e);
            return null;
        }
    }
}

