/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.logging;

import com.nuix.automate.scheduler.persistance.application.HistoryComponentMapper;
import com.nuix.automate.utils.general.SqlType;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import com.nuix.automate.utils.models.internal.logging.LogInfoModel;
import com.nuix.automate.utils.models.internal.logging.history.HistoryComponent;
import com.nuix.automate.utils.models.internal.logging.history.HistoryComponentType;
import com.nuix.automate.utils.sql.Query;
import com.nuix.automate.utils.sql.UseDriverSqlLocator;
import java.util.List;
import java.util.Set;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface LoggingDao {
    @SqlQuery(value="select 1")
    public int checkConnection();

    @SqlQuery(value="select id from logs where id=''")
    public String checkLogsTable();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="create table logs (id varchar(128), component varchar(128), date BIGINT, message varbinary(max), jobId varchar(128), logLine INT, primary key (id, component, date, logLine))"), @Query(type=SqlType.SQL_LITE, query="create table logs (id varchar(128), component varchar(128), date BIGINT, message blob, jobId varchar(128), logLine INT, primary key (id, component, date, logLine))"), @Query(type=SqlType.POSTGRES, query="create table logs (id varchar(128), component varchar(128), date BIGINT, message BYTEA, jobId varchar(128), logLine INT, primary key (id, component, date, logLine))")})
    @SqlUpdate
    public void createLogsTable();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="ALTER TABLE logs ADD message2 varbinary(max);"), @Query(type=SqlType.SQL_LITE, query="create table sqlb_temp_table_logs (id varchar(128), component varchar(128), date BIGINT, message BLOB, jobId varchar(128), logLine INT);"), @Query(type=SqlType.POSTGRES, query="create table sqlb_temp_table_logs (id varchar(128), component varchar(128), date BIGINT, message BYTEA, jobId varchar(128), logLine INT);")})
    @SqlUpdate
    public void createTempV2();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="UPDATE logs SET message2 = CONVERT(varbinary(max), \"message\");"), @Query(type=SqlType.SQL_LITE, query="insert into sqlb_temp_table_logs select id, component, date, message, jobId, logLine from logs;"), @Query(type=SqlType.POSTGRES, query="insert into sqlb_temp_table_logs select id, component, date, message, jobId, logLine from logs;")})
    @SqlUpdate
    public void insertTempV2();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="ALTER TABLE logs DROP COLUMN \"message\";"), @Query(type=SqlType.SQL_LITE, query="drop table logs;"), @Query(type=SqlType.POSTGRES, query="drop table logs;")})
    @SqlUpdate
    public void dropValues();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="sp_rename \"logs.message2\", \"message\", \"COLUMN\";"), @Query(type=SqlType.SQL_LITE, query="alter table sqlb_temp_table_logs rename to logs;"), @Query(type=SqlType.POSTGRES, query="alter table sqlb_temp_table_logs rename to logs;")})
    @SqlUpdate
    public void alterTempV2();

    default public void updateLogs_72() {
        this.createTempV2();
        this.insertTempV2();
        this.dropValues();
        this.alterTempV2();
    }

    @SqlUpdate(value="create index logIdDateIndex ON logs (id, jobId, date)")
    public void createLogIdDateIndex();

    @SqlUpdate(value="create index logDateIndex ON logs (date)")
    public void createLogDateIndex();

    @SqlUpdate(value="create index logIdComponentIndex ON logs (id ASC, jobId, date, component)")
    public void createLogIdComponentIndex();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="select distinct id, jobId, component from logs where date >= :after and date < :before order by id"), @Query(type=SqlType.SQL_LITE, query="select id, jobId, component from logs indexed by logIdComponentIndex where date >= :after and date < :before group by id, jobId"), @Query(type=SqlType.POSTGRES, query="select id, jobId, component from logs indexed by logIdComponentIndex where date >= :after and date < :before group by id, jobId")})
    @SqlQuery
    @RegisterBeanMapper(value=LogInfoModel.class)
    public List<LogInfoModel> getLogsForRange(@Bind(value="after") long var1, @Bind(value="before") long var3);

    @SqlQuery(value="select id, jobId, component from logs where jobId = :jobId group by id, jobId, component order by id")
    @RegisterBeanMapper(value=LogInfoModel.class)
    public List<LogInfoModel> getLogsForJobId(@Bind(value="jobId") String var1);

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="select top(8192) message, date, logLine from logs where date >=:after and date < :before and id=:id and jobId is null order by date asc"), @Query(type=SqlType.SQL_LITE, query="select message, date, logLine from logs where date >=:after and date < :before and id=:id and jobId is null order by date asc limit 8192"), @Query(type=SqlType.POSTGRES, query="select message, date, logLine from logs where date >=:after and date < :before and id=:id and jobId is null order by date asc limit 8192")})
    @SqlQuery
    @RegisterBeanMapper(value=LogEventModel.class)
    public List<LogEventModel> getSystemLogs(@Bind(value="id") String var1, @Bind(value="after") long var2, @Bind(value="before") long var4);

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="select top(8192) message, date, logLine from logs where id=:id and jobId=:jobId and date >= :after order by date asc"), @Query(type=SqlType.SQL_LITE, query="select message, date, logLine from logs where id=:id and jobId=:jobId and date >= :after order by date asc limit 8192"), @Query(type=SqlType.POSTGRES, query="select message, date, logLine from logs where id=:id and jobId=:jobId and date >= :after order by date asc limit 8192")})
    @SqlQuery
    @RegisterBeanMapper(value=LogEventModel.class)
    public List<LogEventModel> getJobLogs(@Bind(value="id") String var1, @Bind(value="jobId") String var2, @Bind(value="after") long var3);

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="select top(1) date from logs order by date asc"), @Query(type=SqlType.SQL_LITE, query="select date from logs order by date asc limit 1"), @Query(type=SqlType.POSTGRES, query="select date from logs order by date asc limit 1")})
    @SqlQuery
    public Long getEarliestLogs();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="delete T from (select top(16384) row_number() over(order by \"date\" asc) as rowid from logs) T where T.rowid <= 16384"), @Query(type=SqlType.SQL_LITE, query="delete from logs where \"ROWID\" in (select ROWID from logs order by date asc limit 16384)"), @Query(type=SqlType.POSTGRES, query="delete from logs where ctid in (select ctid  from logs order by date asc limit 16384)")})
    @SqlUpdate
    public void deleteEarliestLogs();

    @SqlUpdate(value="VACUUM logs")
    public void vacuumLogsPostgresql();

    @SqlUpdate(value="delete from logs where date < :after")
    public int deleteLogs(@Bind(value="after") long var1);

    @SqlUpdate(value="delete from logs where id = :id AND component = :component")
    public int deleteLogs(@Bind(value="id") String var1, @Bind(value="component") String var2);

    @SqlBatch(value="insert into logs (id, component, date, message, jobId, logLine) VALUES (:id, :component, :date, :message, :jobId, :logLine)")
    public int[] insertLogEvents(@BindBean List<LogEventModel> var1);

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="SELECT SUM(a.used_pages) * 8192 AS 'size' FROM sys.tables t INNER JOIN sys.schemas s ON s.schema_id = t.schema_id INNER JOIN sys.indexes i ON t.OBJECT_ID = i.object_id INNER JOIN sys.partitions p ON i.object_id = p.OBJECT_ID AND i.index_id = p.index_id INNER JOIN sys.allocation_units a ON p.partition_id = a.container_id WHERE t.NAME = 'logs' and t.is_ms_shipped = 0"), @Query(type=SqlType.SQL_LITE, query="select (page_count - freelist_count) * page_size as size from pragma_page_count(), pragma_page_size(), pragma_freelist_count()"), @Query(type=SqlType.POSTGRES, query="select pg_relation_size('logs')")})
    @SqlQuery
    public Long getDatabaseSize();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="create table componentHistory (id nvarchar(256), version bigint not null, type nvarchar(256) not null, data nvarchar(max), dateLastUsed bigint not null, primary key(id, version, type))"), @Query(type=SqlType.SQL_LITE, query="create table componentHistory (id varchar(128) not null, version bigint not null, type varchar(128) not null, data TEXT, dateLastUsed bigint not null, primary key(id, version, type))"), @Query(type=SqlType.POSTGRES, query="create table componentHistory (id varchar(128) not null, version bigint not null, type varchar(128) not null, data TEXT, dateLastUsed bigint not null, primary key(id, version, type))")})
    @SqlUpdate
    public void createComponentHistoryTable();

    @SqlQuery(value="select id from componentHistory")
    public Set<String> getComponentHistoryIds();

    @SqlQuery(value="select id, version, type, data from componentHistory where id = :id")
    @RegisterRowMapper(value=HistoryComponentMapper.class)
    public List<HistoryComponent> getHistoryComponentsForId(@Bind(value="id") String var1);

    @SqlQuery(value="select id, version, type, data from componentHistory where id = :id and type = :type")
    @RegisterRowMapper(value=HistoryComponentMapper.class)
    public List<HistoryComponent> getHistoryComponentsForType(@Bind(value="id") String var1, @Bind(value="Ntype") String var2);

    @SqlQuery(value="select id, version, type, data from componentHistory where id = :id and version = :version")
    @RegisterRowMapper(value=HistoryComponentMapper.class)
    public HistoryComponent getHistoryComponentForVersion(@Bind(value="id") String var1, @Bind(value="version") long var2);

    default public boolean getComponentHistoryExistsForVersion(String id, long version) {
        return this.getHistoryComponentForVersion(id, version) != null;
    }

    @SqlUpdate(value="insert into componentHistory (id, version, type, data, dateLastUsed) values (:id, :version, :type, :data, :dateLastUsed)")
    public void addComponentHistory(@Bind(value="id") String var1, @Bind(value="version") long var2, @Bind(value="type") HistoryComponentType var4, @Bind(value="data") String var5, @Bind(value="dateLastUsed") long var6);

    @SqlUpdate(value="update componentHistory set dateLastUsed = :dateLastUsed where id = :id and version = :version")
    public void updateComponentHistory(@Bind(value="id") String var1, @Bind(value="version") long var2, @Bind(value="type") HistoryComponentType var4, @Bind(value="dateLastUsed") long var5);

    @SqlUpdate(value="update componentHistory set dateLastUsed = :dateLastUsed, data = :data where id = :id and version = :version and dateLastUsed < :dateLastUsed")
    public void updateComponentHistoryIfNewer(@Bind(value="id") String var1, @Bind(value="version") long var2, @Bind(value="type") HistoryComponentType var4, @Bind(value="data") String var5, @Bind(value="dateLastUsed") long var6);

    @SqlUpdate(value="delete from componentHistory where id = :id")
    public void deleteComponentHistory(@Bind(value="id") String var1);

    @SqlUpdate(value="delete from componentHistory where dateLastUsed < :after")
    public int deleteComponentHistoryAfter(@Bind(value="after") long var1);

    @SqlUpdate(value="create index componentHistoryIdIndex on componentHistory (id)")
    public void createComponentHistoryIdIndex();

    @SqlUpdate(value="create index componentHistoryIdVersionIndex on componentHistory (id, version)")
    public void createComponentHistoryIdVersionIndex();

    @SqlUpdate(value="create index componentHistoryIdTypeIndex on componentHistory (id, type)")
    public void createComponentHistoryIdTypeIndex();

    @UseDriverSqlLocator
    @Query.List(value={@Query(type=SqlType.MSSQL, query="create table jobHistory (jobId nvarchar(256) not null, componentId nvarchar(256) not null, componentVersion bigint not null, dateLastUsed bigint not null, primary key(jobId, componentId, componentVersion))"), @Query(type=SqlType.SQL_LITE, query="create table jobHistory (jobId varchar(128) not null, componentId varchar(128) not null, componentVersion bigint not null, dateLastUsed bigint not null, primary key(jobId, componentId, componentVersion))"), @Query(type=SqlType.POSTGRES, query="create table jobHistory (jobId varchar(128) not null, componentId varchar(128) not null, componentVersion bigint not null, dateLastUsed bigint not null, primary key(jobId, componentId, componentVersion))")})
    @SqlUpdate
    public void createJobHistoryTable();

    @SqlQuery(value="select jobId from jobHistory")
    public Set<String> getJobHistoryIds();

    @SqlQuery(value="select id, version, type, data from componentHistory inner join jobHistory on id = componentId and version = componentVersion where jobId = :jobId")
    @RegisterRowMapper(value=HistoryComponentMapper.class)
    public List<HistoryComponent> getJobHistoryComponents(@Bind(value="jobId") String var1);

    @SqlUpdate(value="insert into jobHistory (jobId, componentId, componentVersion, dateLastUsed) values (:jobId, :componentId, :componentVersion, :dateLastUsed)")
    public void addJobHistory(@Bind(value="jobId") String var1, @Bind(value="componentId") String var2, @Bind(value="componentVersion") long var3, @Bind(value="dateLastUsed") long var5);

    @SqlUpdate(value="update jobHistory set dateLastUsed = :dateLastUsed where jobId = :jobId")
    public void updateJobHistory(@Bind(value="jobId") String var1, @Bind(value="dateLastUsed") long var2);

    @SqlUpdate(value="delete from jobHistory where jobId = :jobId")
    public void deleteJobHistory(@Bind(value="jobId") String var1);

    @SqlUpdate(value="delete from jobHistory where dateLastUsed < :after")
    public int deleteJobHistoryAfter(@Bind(value="after") long var1);

    @SqlUpdate(value="create index jobHistoryIdIndex on jobHistory (jobId)")
    public void createJobHistoryIdIndex();
}

